# MCP Adapter Documentation

Documentation for the WordPress MCP Adapter - transform WordPress abilities into AI-accessible tools, resources, and prompts.

## Getting Started

- **[Quick Start Guide](getting-started/README.md)** - Get running in minutes with working examples
- **[Installation Guide](getting-started/installation.md)** - Installation methods (Composer recommended)
- **[Basic Examples](getting-started/basic-examples.md)** - Complete examples for tools, resources, and prompts

## Implementation Guides

- **[Default Server](guides/default-server.md)** - Understanding the built-in MCP server and core abilities
- **[Creating Abilities](guides/creating-abilities.md)** - Build tools, resources, and prompts with annotations
- **[Transport Permissions](guides/transport-permissions.md)** - Custom authentication and access control
- **[Custom Transports](guides/custom-transports.md)** - Specialized communication protocols
- **[Error Handling](guides/error-handling.md)** - Custom error logging and monitoring
- **[Observability](guides/observability.md)** - Metrics tracking and monitoring integration
- **[CLI Usage](guides/cli-usage.md)** - WP-CLI commands for STDIO transport

## System Design

- **[Architecture Overview](architecture/overview.md)** - System design and performance considerations

## Troubleshooting

- **[Common Issues](troubleshooting/common-issues.md)** - Quick fixes and debugging techniques

## Contributing

- **[Contributing Guide](../CONTRIBUTING.md)** - Development setup, coding standards, and contribution workflow
- **[Testing Guide](guides/testing.md)** - Running and writing tests with wp-env

## Quick Navigation

### New to MCP Adapter
1. [Quick Start Guide](getting-started/README.md)
2. [Default Server](guides/default-server.md)
3. [Basic Examples](getting-started/basic-examples.md)
4. [Architecture Overview](architecture/overview.md)

### Build Custom Tools
1. [Creating Abilities](guides/creating-abilities.md)
2. [Basic Examples](getting-started/basic-examples.md)

### Custom Authentication
1. [Transport Permissions](guides/transport-permissions.md) (recommended)
2. [Custom Transports](guides/custom-transports.md) (advanced)

### Troubleshooting
1. [Common Issues](troubleshooting/common-issues.md)
2. [Installation Guide](getting-started/installation.md)

---

**Ready to get started?** Jump into the [Quick Start Guide](getting-started/README.md) and have your first MCP server running in minutes!
